/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <errno.h>

#include "gtkacl.h"
#include "gtkacl-callbacks.h"


#define MESSAGE_BOX(format, error)	\
	{GtkWidget *message_box;\
	message_box = gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL, \
			GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, format, error); \
		gtk_dialog_run (GTK_DIALOG (message_box)); \
 		gtk_widget_destroy (message_box);}
		
#define MESSAGE_BOX_ERROR() MESSAGE_BOX("%s", g_strerror(errno))


/***** CALLBACKS *****/

//
void gtk_acl_on_add_acl(GtkWidget *button, gpointer *data)
{
	GtkAcl *gtk_acl;
	
	gtk_acl = GTK_ACL(data);
	gtk_widget_show(GTK_WIDGET(gtk_acl->win_usergroup));
}


//
void gtk_acl_on_del_acl(GtkWidget *button, gpointer *data)
{
	GtkAcl *gtk_acl;
	GtkTreeModel *tree_store;
	GtkTreePath *path;
	GtkTreeViewColumn *column;
	gint *indices;
	gint depth;
	
	gtk_acl= GTK_ACL(data);

	gtk_tree_view_get_cursor(GTK_TREE_VIEW(gtk_acl->acl_view), &path, &column);
	if (path == NULL)
		return;
	
	indices = gtk_tree_path_get_indices(path);
	depth   = gtk_tree_path_get_depth(path);

	//User	
	if ((indices[0] == 0) && (depth == 2)) {
		GtkTreeSelection *selection;
		GtkTreeIter iter;
		gchar *id;
		uid_t uid;

		selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(gtk_acl->acl_view));
		if (!gtk_tree_selection_get_selected(GTK_TREE_SELECTION(selection), 
							&tree_store, &iter)) {
			return;
		}
		
		gtk_tree_model_get(GTK_TREE_MODEL(gtk_acl->acl_data), &iter, COL_ID, &id, -1);
	
		uid = (uid_t) atoi(id);
		gtk_acl_del_user(gtk_acl, (uid_t) uid);
		
	}
	
	//Group
	if ((indices[0] == 1) && (depth == 2)) {
		GtkTreeSelection *selection;
		GtkTreeIter iter;
		gchar *id;
		uid_t uid;

		selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(gtk_acl->acl_view));
		if (!gtk_tree_selection_get_selected(GTK_TREE_SELECTION(selection), 
							&tree_store, &iter)) {
			return;
		}
		
		gtk_tree_model_get(GTK_TREE_MODEL(gtk_acl->acl_data), &iter, COL_ID, &id, -1);

		uid = (uid_t) atoi(id);
		gtk_acl_del_group(gtk_acl, (uid_t) uid);
		
	}
	
	

	
}


//
void gtk_acl_on_set_owner(GtkWidget *button, gpointer *data) 
{
	GtkAcl *gtk_acl;
	
	gtk_acl = GTK_ACL(data);
	gtk_widget_show(GTK_WIDGET(gtk_acl->win_usergroup_owner));
}

//
void gtk_acl_on_toggle_read(GtkCellRendererToggle *cell, gchar *path_str,
	gpointer data)
{
	GtkAcl *gtk_acl;
	GtkTreeIter iter;
	GtkTreePath *path;
	
	gchar    *id;
	gboolean  state, update_perm;	
	gint *indices;
	
	
	gtk_acl = GTK_ACL(data);
	
	path = gtk_tree_path_new_from_string(path_str);
	gtk_tree_model_get_iter(GTK_TREE_MODEL(gtk_acl->acl_data), &iter, path);
	
	gtk_tree_model_get(GTK_TREE_MODEL(gtk_acl->acl_data), &iter, 
		COL_ID, &id, 
		COL_READ, &state, -1);
	
	indices = gtk_tree_path_get_indices(path);
	
	
	//For unix user
	if (indices[0] == 0)
		update_perm = g_perms_set_perm(gtk_acl->perms, P_USER, (uid_t) atoi(id),
			P_READ, !state);
				
	//For Groups
	if (indices[0] == 1)
		update_perm = g_perms_set_perm(gtk_acl->perms, P_GROUP, (uid_t) atoi(id), 
			P_READ, !state);

	//For Others
	if (indices[0] == 2)
		update_perm = g_perms_set_perm(gtk_acl->perms, P_OTHER, 0, P_READ, !state);
		
	//For Mask
	if (indices[0] == 3)
		update_perm = g_perms_set_perm(gtk_acl->perms, P_MASK, 0, P_READ, !state);
			
	
	if (update_perm)
		gtk_tree_store_set(GTK_TREE_STORE(gtk_acl->acl_data), &iter, COL_READ, !state, -1);
	
	//gtk_acl_load(gtk_acl);
}


//
void gtk_acl_on_toggle_write(GtkCellRendererToggle *cell, gchar *path_str,
	gpointer data)
{
	GtkAcl *gtk_acl;
	GtkTreeIter iter;
	GtkTreePath *path;
	
	gchar    *id;
	gboolean  state, update_perm;	
	gint *indices;
	
	
	gtk_acl = GTK_ACL(data);
	
	path = gtk_tree_path_new_from_string(path_str);
	gtk_tree_model_get_iter(GTK_TREE_MODEL(gtk_acl->acl_data), &iter, path);
	
	gtk_tree_model_get(GTK_TREE_MODEL(gtk_acl->acl_data), &iter, 
		COL_ID, &id, 
		COL_WRITE, &state, -1);
	
	indices = gtk_tree_path_get_indices(path);
	
	
	//For unix user
	if (indices[0] == 0)
		update_perm = g_perms_set_perm(gtk_acl->perms, P_USER, (uid_t) atoi(id),
			P_WRITE, !state);
		
	//For Groups
	if (indices[0] == 1)
		update_perm = g_perms_set_perm(gtk_acl->perms, P_GROUP, (uid_t) atoi(id), 
			P_WRITE, !state);

	//For Others
	if (indices[0] == 2)
		update_perm = g_perms_set_perm(gtk_acl->perms, P_OTHER, 0, P_WRITE, !state);
		
	//For Mask
	if (indices[0] == 3)
		update_perm = g_perms_set_perm(gtk_acl->perms, P_MASK, 0, P_WRITE, !state);
			
	
	if (update_perm)
		gtk_tree_store_set(GTK_TREE_STORE(gtk_acl->acl_data), &iter, COL_WRITE, 
			!state, -1);
}


//
void gtk_acl_on_toggle_execute(GtkCellRendererToggle *cell, gchar *path_str,
	gpointer data)
{
	GtkAcl *gtk_acl;
	GtkTreeIter iter;
	GtkTreePath *path;
	
	gchar    *id;
	gboolean  state, update_perm;	
	gint *indices;
	
	
	gtk_acl = GTK_ACL(data);
	
	path = gtk_tree_path_new_from_string(path_str);
	gtk_tree_model_get_iter(GTK_TREE_MODEL(gtk_acl->acl_data), &iter, path);
	
	gtk_tree_model_get(GTK_TREE_MODEL(gtk_acl->acl_data), &iter, 
		COL_ID, &id, 
		COL_EXECUTE, &state, -1);
	
	indices = gtk_tree_path_get_indices(path);
	
	
	//For unix user
	if (indices[0] == 0)
		update_perm = g_perms_set_perm(gtk_acl->perms, P_USER, (uid_t) atoi(id),
			P_EXECUTE, !state);
		
	//For Groups
	if (indices[0] == 1)
		update_perm = g_perms_set_perm(gtk_acl->perms, P_GROUP, (uid_t) atoi(id), 
			P_EXECUTE, !state);

	//For Others
	if (indices[0] == 2)
		update_perm = g_perms_set_perm(gtk_acl->perms, P_OTHER, 0, P_EXECUTE, !state);
		
	//For Mask
	if (indices[0] == 3)
		update_perm = g_perms_set_perm(gtk_acl->perms, P_MASK, 0, P_EXECUTE, !state);
			
	
	if (update_perm)
		gtk_tree_store_set(GTK_TREE_STORE(gtk_acl->acl_data), &iter, COL_EXECUTE, 
			!state, -1);
}


//
void gtk_acl_on_toggle_suid(GtkToggleButton *togglebutton, gpointer user_data)
{
	GtkAcl   *gtk_acl;
	gboolean  state;
	struct _special_entry_perms *special_entry_perms;
	
	gtk_acl = GTK_ACL(user_data);
	
	state = gtk_toggle_button_get_active(togglebutton);
	g_perms_set_special_perms(gtk_acl->perms, P_SUID, state);
	
	special_entry_perms = g_perms_get_special_perms(gtk_acl->perms);
	gtk_toggle_button_set_active(togglebutton, special_entry_perms->suid);
}

//
void gtk_acl_on_toggle_sgid(GtkToggleButton *togglebutton, gpointer user_data)
{
	GtkAcl   *gtk_acl;
	gboolean  state;
	struct _special_entry_perms *special_entry_perms;
	
	gtk_acl = GTK_ACL(user_data);
	
	state = gtk_toggle_button_get_active(togglebutton);
	g_perms_set_special_perms(gtk_acl->perms, P_SGID, state);
	
	special_entry_perms = g_perms_get_special_perms(gtk_acl->perms);
	gtk_toggle_button_set_active(togglebutton, special_entry_perms->sgid);
}

//
void gtk_acl_on_toggle_sticky(GtkToggleButton *togglebutton, gpointer user_data)
{
	GtkAcl   *gtk_acl;
	gboolean  state;
	struct _special_entry_perms *special_entry_perms;
	
	gtk_acl = GTK_ACL(user_data);
	
	state = gtk_toggle_button_get_active(togglebutton);
	g_perms_set_special_perms(gtk_acl->perms, P_STICKY, state);
	
	special_entry_perms = g_perms_get_special_perms(gtk_acl->perms);
	gtk_toggle_button_set_active(togglebutton, special_entry_perms->sticky);
	
}


//
void gtk_acl_on_avanced_toggled(GtkToggleButton *togglebutton, gpointer user_data)
{
	GtkWidget *gtk_acl;
	
	gtk_acl = GTK_WIDGET(user_data);
	
	gtk_acl_set_advanced_mode(GTK_ACL(gtk_acl), gtk_toggle_button_get_active(togglebutton))	;
	
}


//
void gtk_acl_on_show_access(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkAcl *gtk_acl;
	
	gtk_acl = GTK_ACL(user_data);
	
	gtk_acl_load_file(GTK_ACL(gtk_acl), gtk_acl->perms->filename, TYPE_ACCESS);	
	gtk_widget_set_sensitive(GTK_WIDGET(gtk_acl->frame_default), FALSE);
}

//
void gtk_acl_on_show_default(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkAcl *gtk_acl;
	
	gtk_acl = GTK_ACL(user_data);
	
	gtk_acl_load_file(GTK_ACL(gtk_acl), gtk_acl->perms->filename, TYPE_DEFAULT);
	gtk_widget_set_sensitive(GTK_WIDGET(gtk_acl->frame_default), TRUE);
	
}

//
void gtk_acl_on_clear(GtkButton *button, gpointer user_data)
{
	GtkAcl *gtk_acl;
	//GPerms *g_perms;
	
	gtk_acl = GTK_ACL(user_data);
	//g_perms = gtk_acl->perms;
	
	g_perms_clear(gtk_acl->perms);
	
	gtk_acl_load(gtk_acl);
	
	/*
	struct _entry_perms *entry_perms;

	entry_perms = g_perms_get_entry(gtk_acl->perms, FIRST_ENTRY);
	while(entry_perms)
	{
		
		entry_perms = g_perms_get_entry(gtk_acl->perms, NEXT_ENTRY);
		
		acl_entry_t acl_entry;
		acl_tag_t e_type;
		gint ret;
	
		acl_entry = g_perms_found_entry(g_perms, entry_perms->type, (guint) uid);
	if (acl_entry == NULL)
		return -1;
	
	acl_delete_entry(g_perms->acl, acl_entry);
	acl_set_file(g_perms->filename, g_perms->acl_type, g_perms->acl);
	}
	
	*/

}


//
void gtk_acl_on_init_default(GtkButton *button, gpointer user_data)
{
	GtkAcl *gtk_acl;
	
	gtk_acl = GTK_ACL(user_data);
	
	g_perms_init_default(gtk_acl->perms);
	gtk_acl_load(gtk_acl);
		//MESSAGE_BOX_ERROR();
	
	//g_print("*** test **** \n");
}
