/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "gtkacl.h"


#ifndef _GTK_ACL_CALLBACKS_H_
#define _GTK_ACL_CALLBACKS_H_


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void gtk_acl_on_set_owner(GtkWidget *button, gpointer *data);

void gtk_acl_on_toggle_read(GtkCellRendererToggle *cell, gchar *path_str,
	gpointer data);
void gtk_acl_on_toggle_write(GtkCellRendererToggle *cell, gchar *path_str,
	gpointer data);
void gtk_acl_on_toggle_execute(GtkCellRendererToggle *cell, gchar *path_str,
	gpointer data);
void gtk_acl_on_toggle_suid(GtkToggleButton *togglebutton, gpointer user_data);
void gtk_acl_on_toggle_sgid(GtkToggleButton *togglebutton, gpointer user_data);
void gtk_acl_on_toggle_sticky(GtkToggleButton *togglebutton, gpointer user_data);

void gtk_acl_on_avanced_toggled(GtkToggleButton *togglebutton, gpointer user_data);

void gtk_acl_on_show_access(GtkMenuItem *menuitem, gpointer user_data);
void gtk_acl_on_show_default(GtkMenuItem *menuitem, gpointer user_data);

void gtk_acl_on_add_acl(GtkWidget *button, gpointer *data);
void gtk_acl_on_del_acl(GtkWidget *button, gpointer *data);

void gtk_acl_on_init_default(GtkButton *button, gpointer user_data);
void gtk_acl_on_clear(GtkButton *button, gpointer user_data);

	
	
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
