/*  GTKtalog.
 *  Copyright (C) 1999-2000  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <stdlib.h>
#include <dirent.h>
#include <unistd.h>
#include <time.h>
#include <stdio.h>
#include <fnmatch.h>
#include <string.h>
#include <pthread.h>
#include <signal.h>

#include "loadcat.h"
#include "addisk.h"
#include "config_common.h"
#include "folder.h"
#include "interface.h"
#include "compare.h"

#ifdef LIBC5
#define SIGUSR1 SIGSTKFLT
#define SIGUSR2 SIGUNUSED
#endif

#define READ   0
#define WRITE 1

char *local_foldername;
char *local_diskname;

pthread_t thread1;

gchar *
read_information (CONFIG * my_config, gchar * file)
{
  char buff[250];
  int fd[2];
  int b;
  gint pid;
  gint status;
  GString *information;
  gchar *ret;
  EXTENSIONS *e;

  g_hash_table_insert (my_config->stuff, "_interface: filename", file);
  g_hash_table_insert (my_config->stuff, "_interface: extensions", NULL);

  g_tree_traverse (my_config->extensions, find_viewer,
		   G_PRE_ORDER, my_config);

  if ((e = g_hash_table_lookup (my_config->stuff, "_interface: extensions")))
    {
      /* Launch the viewer */
      if (compare ("^[ \t]*$", e->prog->str, TRUE, FALSE))
	{
	  if (pipe (fd) == -1)
	    {
	      g_error ("Couldn't create a pipe");
	      return (NULL);
	    }
	  switch (pid = fork ())
	    {
	    case 0:		/*fils1 */
	      close (fd[READ]);
	      close (1);
	      dup (fd[WRITE]);
	      close (fd[WRITE]);
	      if (compare ("^[ \t]*$", e->viewerarg->str, TRUE, FALSE))
		{
		  execlp (e->prog->str, e->prog->str, e->arg, file, NULL);
		}
	      else
		{
		  execlp (e->prog->str, e->prog->str, file, NULL);
		}
	    case -1:		/*erreur */
	      g_error (_("Could not fork\n"));
	      exit (3);
	    default:
	      close (fd[WRITE]);
	      close (0);
	      dup (fd[READ]);
	      close (fd[READ]);
	      information = g_string_new ("");
	      b = read (0, buff, 249 * sizeof (char));
	      while (b != 0)
		{
		  buff[b] = '\0';
		  information = g_string_append (information, buff);
		  b = read (0, buff, 249 * sizeof (char));
		}
	      wait4 (pid, &status, 0, NULL);
	      ret = g_strdup (information->str);
	      g_string_free (information, TRUE);
	      return (ret);

	    }
	}
      else
	{
	  return (NULL);
	}
    }
  else
    {

      return (g_strdup (gnome_mime_type (file)));
    }
  g_hash_table_remove (my_config->stuff, "_interface: filename");
  g_hash_table_remove (my_config->stuff, "_interface: extensions");
}

void
create_folder_tree (CONFIG * my_config, GNode * parent, const gchar * path,
		    gboolean getInformation)
/* Stocks the directory (ans subdirs) into a FOLDER structure
 * folder is the FOLDER directory where the directory should be stored
 *   WARNING: folder should not be NULL!!!
 * path is the full path of the directory
 */
{
  DIR *dir;
  struct dirent *fichier;
  struct stat fileinfo;
  gchar *file;
  GList *gl;
  GList *new_dirs = NULL;
  GNode *gn;
  FOLDER *folder;
  GString *my_path;
  gchar *infostring;

  my_path = g_string_new (path);

  folder = my_config->racine;

  my_path = g_string_append_c (my_path, '/');

  /*  kill (my_config->current_pid, SIGUSR2); */

  if ((dir = opendir (my_path->str)) == NULL)
    {
      printf ("ne peut lister le repertoire courant: %s", my_path->str);
      return;
    }

  while ((fichier = readdir (dir)) != NULL)
    {
      file = g_strconcat (my_path->str, fichier->d_name, NULL);
      if ((strcmp (fichier->d_name, ".") != 0)
	  && (strcmp (fichier->d_name, "..") != 0))
	{

	  if (lstat (file, &fileinfo) == -1)
	    {
	      printf ("file not found: %s\n", fichier->d_name);
	    }
	  /* This is a directory */
	  if (S_ISLNK (fileinfo.st_mode))
	    {
	      char tmp[1024];
	      char tmp2[2048];

	      memset (tmp, 0, 1024);

	      if (readlink (file, tmp, 1023) == -1)
		{
		  printf
		    ("Problem with symbolic link %s, we forget it!\n", file);
		}
	      else
		{
		  sprintf (tmp2, "%s -> %s", fichier->d_name, tmp);
		  folder_add_link (folder, parent, tmp, tmp2, NULL,
				   fileinfo.st_size, fileinfo.st_ctime, 0, 0);
		}
	    }
	  else if (S_ISDIR (fileinfo.st_mode))
	    {

	      gn =
		folder_add (folder, parent, fichier->d_name, NULL,
			    IS_DIR, fileinfo.st_size,
			    fileinfo.st_ctime, 0, 0);
	      new_dirs = g_list_append (new_dirs, gn);
	    }

	  else
	    {
	      /* This is a file */
	      if (getInformation)
		{
		  /* use a plugin to get informations about the file */
		  infostring = read_information (my_config, file);
		}
	      else
		{
		  infostring = NULL;
		}
	      folder_add (folder, parent, fichier->d_name, infostring,
			  IS_FILE, fileinfo.st_size, fileinfo.st_ctime, 0, 0);
	      if (infostring)
		g_free (infostring);
	    }
	}
      free (file);
    }
  closedir (dir);

  while (new_dirs)
    {
      gn = (GNode *) new_dirs->data;
      file =
	g_strconcat (path, "/", folder_get_name (my_config->racine, gn),
		     NULL);
      create_folder_tree (my_config, gn, file, getInformation);
      free (file);
      gl = new_dirs;
      new_dirs = g_list_remove_link (new_dirs, new_dirs);
      g_list_free_1 (gl);
    }

}


void *
start_thread_scan (void *arg)
{
  CONFIG *my_config = arg;
  GNode *gn;

  gn =
    folder_add (my_config->racine, my_config->racine->tree,
		local_diskname, local_foldername, IS_DISK, 0, 0, 0, 0);

  create_folder_tree (my_config, gn, local_foldername,
		      my_config->getInformation);
  /*  kill (my_config->current_pid, SIGUSR1); */

  my_config->is_modified = TRUE;
  update_tree (my_config);
  pthread_exit (0);
  exit (0);
}

void
finish_normal_scan (int sig)
{
  void *ret;

  if (pthread_join (thread1, &ret) == 28)
    printf ("pouet\n");
  /*  close_waitbox (); */
}

int
start_add_disk (char *foldername, char *diskname, CONFIG * my_config)
{

  while (foldername[strlen (foldername) - 1] == '/')
    foldername[strlen (foldername) - 1] = '\0';

  local_foldername = foldername;
  local_diskname = diskname;

  /*  signal (SIGUSR2, update_waitbox); */
  if (pthread_create (&thread1, NULL, start_thread_scan, my_config) < 0)
    {
      ERROR_DIALOG ("Thread failed.\nCheck your number of threads.",
		    my_config->window);

      return (0);
    }
  signal (SIGUSR1, finish_normal_scan);
  /*  open_waitbox (); */
  finish_normal_scan (0);
  return (0);
}
