/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fnmatch.h>

#include "savecat.h"
#include "loadcat.h"
#include "report.h"
#include "search.h"
#include "interface.h"
#include "categories.h"
#include "selectdir.h"
#include "addisk.h"
#include "setup.h"
#include "fastaddisk.h"
#include "io.h"
#include "config_common.h"
#include "buttonbar.h"

void
enable_gnome_button_bar (GtkWidget * window, CONFIG * my_config)
{
  GnomeUIInfo *toolbar;
  GnomeUIInfo general_toolbar[] = {
    GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_ITEM_STOCK (N_("New"), N_("New catalog"),
			    new_file, GNOME_STOCK_PIXMAP_NEW),
    GNOMEUIINFO_ITEM_STOCK (N_("Open"), N_("Open catalog"),
			    open_cat, GNOME_STOCK_PIXMAP_OPEN),
    GNOMEUIINFO_ITEM_STOCK (N_("Save"), N_("Save catalog"),
			    fast_save, GNOME_STOCK_PIXMAP_SAVE),
    GNOMEUIINFO_ITEM_STOCK (N_("Save as..."), N_("Save catalog as..."),
			    save_cat, GNOME_STOCK_PIXMAP_SAVE_AS),
    GNOMEUIINFO_ITEM_STOCK (N_("Edit categories"), N_("Edit categories"),
			    edit_categories, GNOME_STOCK_PIXMAP_PROPERTIES),
    GNOMEUIINFO_ITEM_NONE (N_("Clean descriptions"), N_("Clean descriptions"),
			   clean_description),
    GNOMEUIINFO_ITEM_STOCK (N_("Preferences"), N_("Preferences"),
			    run_setup, GNOME_STOCK_PIXMAP_PREFERENCES),
    GNOMEUIINFO_ITEM_STOCK (N_("Find file"), N_("Find file"),
			    create_search_dialog, GNOME_STOCK_PIXMAP_SEARCH),
    GNOMEUIINFO_ITEM_NONE (N_("Create Report"), N_("Create Report"),
			   open_report_dialog),
    GNOMEUIINFO_ITEM_STOCK (N_("Fast Add"), N_("Fast Add"),
			    fast_add_disk, GNOME_STOCK_PIXMAP_CDROM),
    GNOMEUIINFO_ITEM_STOCK (N_("Add disk"), N_("Add disk"),
			    show_select_dir_win, GNOME_STOCK_PIXMAP_CDROM),
    GNOMEUIINFO_ITEM_STOCK (N_("Exit"), N_("Quit Gtktalog"),
			    quit_prog, GNOME_STOCK_PIXMAP_EXIT),
    GNOMEUIINFO_END
  };


  toolbar = (GnomeUIInfo *) g_malloc (14 * sizeof (GnomeUIInfo));
  /* Copy the items from the general toolbar to the toolbar.
   * toolbar is the toolbar that will be displayed.
   * This way makes it easy to program customization later as it
   *              was the case in the old enable_button_bar.
   */
  memcpy (&(toolbar[0]), &(general_toolbar[1]), sizeof (GnomeUIInfo));
  memcpy (&(toolbar[1]), &(general_toolbar[2]), sizeof (GnomeUIInfo));
  memcpy (&(toolbar[2]), &(general_toolbar[3]), sizeof (GnomeUIInfo));

  memcpy (&(toolbar[3]), &(general_toolbar[0]), sizeof (GnomeUIInfo));

  memcpy (&(toolbar[4]), &(general_toolbar[11]), sizeof (GnomeUIInfo));
  memcpy (&(toolbar[5]), &(general_toolbar[8]), sizeof (GnomeUIInfo));
  memcpy (&(toolbar[6]), &(general_toolbar[0]), sizeof (GnomeUIInfo));
  memcpy (&(toolbar[7]), &(general_toolbar[12]), sizeof (GnomeUIInfo));
  memcpy (&(toolbar[8]), &(general_toolbar[13]), sizeof (GnomeUIInfo));

  gnome_app_create_toolbar_with_data (GNOME_APP (window), toolbar, my_config);


}
