/*  GTKtalog.
 *  Copyright (C) 1999-2000  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <stdlib.h>
#include <stdio.h>

#include "edit.h"
#include "interface.h"
#include "config_common.h"
#include "categories.h"
#include "folder.h"
#include "io.h"
#include "exit.h"
#include "categories.h"

static void
cancel_clicked (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  CATEGORY_WIDGETS *cw = my_config->category_widgets;
  gtk_widget_destroy (cw->cat_window);
  g_free (cw);
  if (my_config->update_edit_window == TRUE)
    update_category_combo (my_config);
  return;
}

static void destroy_window(GtkWidget * w, GdkEventKey *event, gpointer data)
{
  cancel_clicked(w, data);
}

void
_set_category_name (gchar * string, gpointer data)
{
  CATEGORY_WIDGETS *cw = data;
  if (string)
    cw->tmpdata = g_string_new (string);
  else
    cw->tmpdata = NULL;
  return;
}

void
add_the_categorie (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  CATEGORY_WIDGETS *cw = my_config->category_widgets;
  char *tmp[2] = { "", "0" };

  gnome_dialog_run_and_close (GNOME_DIALOG (gnome_request_dialog
					    (FALSE,
					     _("New category name"),
					     "",
					     CATEGORY_MAX_LENGTH,
					     _set_category_name,
					     cw,
					     GTK_WINDOW (cw->cat_window))));



  if (cw->tmpdata)
    {
      g_ptr_array_add (my_config->categories, cw->tmpdata);
      tmp[0] = ((GString *) cw->tmpdata)->str;
      gtk_clist_append ((GtkCList *) cw->cat_clist, tmp);
      my_config->is_modified = TRUE;
    }
  return;
}

void
edit_the_categorie (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  CATEGORY_WIDGETS *cw = my_config->category_widgets;
  gint i;
  char *tmp[2] = { "", "0" };

  if (cw->selected_row >= 0)
    {
      gtk_clist_get_text ((GtkCList *) cw->cat_clist, cw->selected_row, 0,
			  &(tmp[0]));
      i = string_to_index (my_config->categories, tmp[0]) - 1;

      gnome_dialog_run_and_close (GNOME_DIALOG (gnome_request_dialog
						(FALSE,
						 _("New category name"),
						 tmp[0],
						 CATEGORY_MAX_LENGTH,
						 _set_category_name,
						 cw,
						 GTK_WINDOW
						 (cw->cat_window))));



      if (cw->tmpdata)
	{
	  g_string_free (g_ptr_array_index (my_config->categories, i), TRUE);
	  tmp[0] = ((GString *) cw->tmpdata)->str;
	  g_ptr_array_index (my_config->categories, i) =
	    g_string_new (tmp[0]);
	  gtk_clist_set_text ((GtkCList *) cw->cat_clist, cw->selected_row, 0,
			      tmp[0]);
	  my_config->is_modified = TRUE;
	}
      else
	{
	  WARNING_DIALOG ("Empty string. No change", cw->cat_window);
	}
    }
  return;
}

void
del_the_categorie (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  CATEGORY_WIDGETS *cw = my_config->category_widgets;
  gint id_cat, i;
  char *tmp[2] = { "", "0" };
  FILE_DATA *fd;

  if (cw->selected_row >= 0)
    {
      if (yes_no_cancel_dialog
	  (_("Delete confirmation"),
	   _("Do you really want to delete this category ?")) == 0)
	{
	  gtk_clist_get_text ((GtkCList *) cw->cat_clist, cw->selected_row, 0,
			      &(tmp[0]));
	  id_cat = string_to_index (my_config->categories, tmp[0]) - 1;

	  g_string_free (g_ptr_array_index (my_config->categories, id_cat),
			 TRUE);
	  g_ptr_array_remove_index (my_config->categories, id_cat);
	  gtk_clist_remove ((GtkCList *) cw->cat_clist, cw->selected_row);
	  for (i = 0; i < my_config->racine->datas->len; i++)
	    {
	      fd = g_ptr_array_index (my_config->racine->datas, i);
	      if (fd->categorie == id_cat + 1)
		fd->categorie = 0;
	      if (fd->categorie > id_cat + 1)
		fd->categorie--;
	    }
	  list_folder (my_config->racine->tree, my_config);
	  my_config->is_modified = TRUE;
	}
    }
  return;
}

void
cat_selected (GtkWidget * clist, gint row, gint column,
	      GdkEventButton * event, gpointer data)
{
  CATEGORY_WIDGETS *cw = data;
  cw->selected_row = row;
  return;
}


void
cat_unselected (GtkWidget * clist, gint row, gint column,
		GdkEventButton * event, gpointer data)
{
  CATEGORY_WIDGETS *cw = data;
  cw->selected_row = -1;
  return;
}

gboolean
category_count (GNode * gn, gpointer data)
{
  CONFIG *my_config = data;
  CATEGORY_WIDGETS *cw = my_config->category_widgets;
  FILE_DATA *fd;

  if (G_NODE_IS_ROOT (gn))
    return (FALSE);
  fd =
    g_ptr_array_index (my_config->racine->datas, GPOINTER_TO_UINT (gn->data));
  if (fd->categorie == cw->cat_id)
    cw->tmpcount++;
  return (FALSE);
}

GList *
make_categories_list (CONFIG * my_config)
{
  GList *cat_list = NULL;
  gint i;

  for (i = 0; i < my_config->categories->len; i++)
    cat_list =
      g_list_append (cat_list,
		     ((GString *)
		      g_ptr_array_index (my_config->categories, i))->str);
  return (cat_list);
}

void
edit_categories (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  GtkWidget *scrolled_window;
  GtkWidget *vbox, *hbox;
  GtkWidget *button_add, *button_edit, *button_delete, *button_exit;
  gchar *titles[2] = { N_("Name"), N_("Use") };
  gchar count[] = "      ";
  gint i;
  CATEGORY_WIDGETS *cw;

  cw = (CATEGORY_WIDGETS *) g_malloc (sizeof (CATEGORY_WIDGETS));
  my_config->category_widgets = cw;

  cw->cat_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_position (GTK_WINDOW (cw->cat_window), GTK_WIN_POS_MOUSE);
  gtk_widget_set_usize (GTK_WIDGET (cw->cat_window), 300, 150);

  gtk_window_set_title (GTK_WINDOW (cw->cat_window), _("Category editor"));
  gtk_signal_connect (GTK_OBJECT (cw->cat_window),
		      "delete_event", destroy_window, my_config);
  gtk_window_set_policy (GTK_WINDOW (cw->cat_window), FALSE, FALSE, TRUE);
  gtk_grab_add (cw->cat_window);


  vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
  gtk_container_add (GTK_CONTAINER (cw->cat_window), vbox);
  gtk_widget_show (vbox);

  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (vbox), scrolled_window, TRUE, TRUE, 0);
  gtk_widget_show (scrolled_window);

  cw->cat_clist = gtk_clist_new_with_titles (2, titles);

  gtk_clist_set_selection_mode ((GtkCList *) cw->cat_clist,
				GTK_SELECTION_SINGLE);

  gtk_signal_connect (GTK_OBJECT (cw->cat_clist), "select_row",
		      GTK_SIGNAL_FUNC (cat_selected), cw);

  gtk_signal_connect (GTK_OBJECT (cw->cat_clist), "unselect_row",
		      GTK_SIGNAL_FUNC (cat_unselected), cw);

  gtk_clist_set_shadow_type (GTK_CLIST (cw->cat_clist), GTK_SHADOW_OUT);

  gtk_clist_set_column_width (GTK_CLIST (cw->cat_clist), 0, 150);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW
					 (scrolled_window), cw->cat_clist);

  for (i = 0; i < my_config->categories->len; i++)
    {
      titles[0] = g_strdup (get_categorie (my_config, i + 1));
      cw->cat_id = i + 1;
      cw->tmpcount = 0;
      g_node_traverse (my_config->racine->tree, G_PRE_ORDER, G_TRAVERSE_ALL,
		       -1, category_count, my_config);
      strcpy (count, "      ");
      snprintf (count, 6, "%d", cw->tmpcount);
      titles[1] = count;
      gtk_clist_append ((GtkCList *) cw->cat_clist, (gchar **) titles);
      g_free (titles[0]);

    }

  gtk_widget_show (cw->cat_clist);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show (hbox);

  button_add = gtk_button_new_with_label (_("Add"));
  button_edit = gtk_button_new_with_label (_("Edit"));
  button_delete = gtk_button_new_with_label (_("Delete"));
  button_exit = gtk_button_new_with_label (_("Exit"));

  gtk_box_pack_start (GTK_BOX (hbox), button_add, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), button_edit, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), button_delete, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), button_exit, TRUE, TRUE, 0);


  gtk_signal_connect (GTK_OBJECT (button_add), "clicked",
		      GTK_SIGNAL_FUNC (add_the_categorie), my_config);

  gtk_signal_connect (GTK_OBJECT (button_edit), "clicked",
		      GTK_SIGNAL_FUNC (edit_the_categorie), my_config);

  gtk_signal_connect (GTK_OBJECT (button_delete), "clicked",
		      GTK_SIGNAL_FUNC (del_the_categorie), my_config);

  gtk_signal_connect (GTK_OBJECT (button_exit), "clicked",
		      GTK_SIGNAL_FUNC (cancel_clicked), my_config);


  gtk_widget_show (button_add);
  gtk_widget_show (button_edit);
  gtk_widget_show (button_delete);
  gtk_widget_show (button_exit);

  gtk_widget_show (cw->cat_window);
}
