%option nounput
%{
#include <gnome.h>
#include "config_common.h"
#include "config_parse.h"
%}

separator	[\t ]+

%%
{separator}			;

	/* not used yet
{separator}\-{separator}	{return TO;}
	*/

^[#;].*$			;

^\ *[Aa]dd[Ii]con		{yylval.string = yytext; return ADDICON;}
^\ *[Dd]efault[Ff]ile[Ii]con	{yylval.string = yytext; return DEFAULTFILEICON;}
^\ *[Dd]efault[Dd]ir[Ii]con	{yylval.string = yytext; return DEFAULTDIRICON;}
^\ *[Dd]efault[Dd]isk[Ii]con	{yylval.string = yytext; return DEFAULTDISKICON;}

^\ *[Mm]ount[Pp]rogram		{yylval.string = yytext; return MOUNTPROGRAM;}
^\ *[Uu]mount[Pp]rogram		{yylval.string = yytext; return UMOUNTPROGRAM;}
^\ *[Ee]ject[Pp]rogram		{yylval.string = yytext; return EJECTPROGRAM;}
^\ *[Mm]ount[Pp]oint		{yylval.string = yytext; return MOUNTPOINT;}

^\ *[Aa]dd[Ee]xtension		{yylval.string = yytext; return EXTENSION;}

[0-9]+				{ yylval.val = atoi(yytext); return INTEGER; }
	/* not used yet
[^ \t\n]+@[^ \t\n]+\.[^ \t\n]{2,3} { yylval.string = yytext; return EMAIL; }
	*/
\"[^"]*\"			{ yylval.string = yytext; return QSTRING;}
'[^']*'				{ yylval.string = yytext; return QSTRING;}
[^'" \t\n]+			{ yylval.string = yytext; return STRING;}

^{separator}*\n			;
{separator}*\n			{ return EOL; }
<<EOF>>				{ return 0 ; }
%%
