/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <regex.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/mtio.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <pthread.h>
#include <sys/mtio.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>

#include "addisk.h"
#include "config_common.h"
#include "folder.h"
#include "interface.h"
#include "fastaddisk.h"

#ifdef LIBC5
#define SIGUSR1 SIGSTKFLT
#define SIGUSR2 SIGUNUSED
#endif

GtkWidget *name_entry;

FOLDER temp_racine;
pthread_t thread2;
int fast_scan_error;

gint thread_is_running;

CONFIG *local_config;

gboolean
eject_disk (CONFIG * my_config)
{
  int status, pid;
  char *args[2];

  seteuid (getuid ());
  args[0] = my_config->eject_prog->str;
  args[1] = my_config->mount_point->str;
  pid = gnome_execute_async (NULL, 2, args);
  wait4 (pid, &status, 0, NULL);
  if (WIFEXITED (status) == 0)
    {
      ERROR_DIALOG ("Eject did not exit normally", my_config->window);
      return (FALSE);
    }
  if (WEXITSTATUS (status) != 0)
    {
      ERROR_DIALOG ("Eject failed! Disk in use?", my_config->window);
      return (FALSE);
    }
  return (TRUE);
}

gboolean
mount_disk (CONFIG * my_config)
{
  int status, pid;
  char *args[2];

  seteuid (getuid ());
  args[0] = my_config->mount->str;
  args[1] = my_config->mount_point->str;
  pid = gnome_execute_async (NULL, 2, args);
  wait4 (pid, &status, 0, NULL);
  if (WIFEXITED (status) == 0)
    {
      ERROR_DIALOG ("Mount did not exit normally", my_config->window);
      return (FALSE);
    }
  if (WEXITSTATUS (status) != 0)
    {
      ERROR_DIALOG ("Mount failed! Disk in use?", my_config->window);
      return (FALSE);
    }
  return (TRUE);
}

gboolean
umount_disk (CONFIG * my_config)
{
  int status, pid;
  char *args[2];

  seteuid (getuid ());
  args[0] = my_config->umount->str;
  args[1] = my_config->mount_point->str;
  pid = gnome_execute_async (NULL, 2, args);
  wait4 (pid, &status, 0, NULL);
  if (WIFEXITED (status) == 0)
    {
      ERROR_DIALOG ("Umount did not exit normally", my_config->window);
      return (FALSE);
    }
  if (WEXITSTATUS (status) != 0)
    {
      ERROR_DIALOG ("Umount failed! Disk in use?", my_config->window);
      return (FALSE);
    }
  return (TRUE);
}


gboolean
check_supermount (CONFIG * my_config)
{
  FILE *fp;
  char line[1024];
  char s1[1024];
  char s2[1024];
  char s3[1024];
  int rc;

  fp = fopen ("/proc/mounts", "r");
  if (fp == NULL)
    {
      printf ("Unable to open /proc/mounts: %s\n", strerror (errno));
    }

  while (fgets (line, sizeof (line), fp) != 0)
    {
      rc = sscanf (line, "%1023s %1023s %1023s", s1, s2, s3);
      if ((rc >= 3) && (strcmp (s2, my_config->mount_point->str) == 0)
	  && (strcmp (s3, "supermount") == 0))
	{
	  fclose (fp);
	  return TRUE;
	}
    }
  fclose (fp);
  return FALSE;
}

void *
start_fast_add_disk (void *arg)
{
  CONFIG *my_config = arg;
  gboolean supermount;
  GNode *gn;

  supermount = check_supermount (my_config);

  if ((supermount == FALSE) && (mount_disk (my_config) == FALSE))
    {
      thread_is_running = FAD_ERROR;
      pthread_exit (0);
    }

  /* Read the disk */
  thread_is_running = FAD_SCAN;
  gn =
    folder_add (my_config->racine, my_config->racine->tree,
		my_config->mount_point->str, NULL, IS_DISK, 0, 0, 0, 0);
  create_folder_tree (my_config, gn, my_config->mount_point->str,
		      my_config->getInformation);

  /* Umount the disk */
  thread_is_running = FAD_UMOUNT;
  if ((supermount == FALSE) && (umount_disk (my_config) == FALSE))
    {
      thread_is_running = FAD_ERROR;
      pthread_exit (0);
    }

  eject_disk (my_config);


  /* Things to do before leaving the thread */
  my_config->is_modified = TRUE;

  change_name (my_config->racine, gn, my_config->fast_name);

  /* Done */
  thread_is_running = FAD_DONE;

  pthread_exit (0);
  exit (0);
}


void
get_name (GtkWidget * w, gpointer data)
{
  char *temp;
  CONFIG *my_config = data;

  temp = gtk_entry_get_text (GTK_ENTRY (name_entry));

  free (my_config->fast_name);
  my_config->fast_name = (char *) malloc (strlen (temp + 1) * sizeof (char));
  strcpy (my_config->fast_name, temp);
  gtk_widget_destroy (g_hash_table_lookup
		      (my_config->stuff, "_fastaddisk: name_window"));
  g_hash_table_remove (my_config->stuff, "_fastaddisk: name_window");
}

static void
fad_kill_window (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  gnome_dialog_run_and_close (GNOME_DIALOG
			      (gnome_warning_dialog_parented
			       (_
				("You should really give a disk name. Yes, really."),
				GTK_WINDOW (my_config->window))));
}

void
fad_create_window (CONFIG * my_config)
{
  GtkWidget *name_window;
  GtkWidget *frame;
  GtkWidget *ok;
  GtkWidget *hbox;

  name_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy (GTK_WINDOW (name_window), TRUE, TRUE, FALSE);
  gtk_window_set_title (GTK_WINDOW (name_window), "Set disk name");
  gtk_container_border_width (GTK_CONTAINER (name_window), 10);
  gtk_window_set_position (GTK_WINDOW (name_window), GTK_WIN_POS_MOUSE);
  gtk_widget_show (name_window);
  g_hash_table_insert (my_config->stuff, "_fastaddisk: name_window",
		       name_window);
  gtk_signal_connect (GTK_OBJECT (name_window), "delete_event",
		      GTK_SIGNAL_FUNC (fad_kill_window), my_config);

  frame = gtk_frame_new ("Disk Label");
  gtk_container_add (GTK_CONTAINER (name_window), frame);
  gtk_widget_show (frame);

  hbox = gtk_hbox_new (FALSE, 10);
  gtk_container_add (GTK_CONTAINER (frame), hbox);
  gtk_widget_show (hbox);

  name_entry = gtk_entry_new_with_max_length (50);
  if (my_config->fast_name == NULL)
    gtk_entry_set_text (GTK_ENTRY (name_entry), "");
  else
    gtk_entry_set_text (GTK_ENTRY (name_entry), my_config->fast_name);
  gtk_entry_select_region (GTK_ENTRY (name_entry), 0,
			   GTK_ENTRY (name_entry)->text_length);
  gtk_signal_connect (GTK_OBJECT (name_entry), "activate",
		      GTK_SIGNAL_FUNC (get_name), my_config);
  gtk_box_pack_start (GTK_BOX (hbox), name_entry, TRUE, TRUE, 0);
  gtk_widget_show (name_entry);

  ok = gtk_button_new_with_label ("   Ok   ");
  gtk_object_set_user_data (GTK_OBJECT (ok), name_window);
  GTK_WIDGET_SET_FLAGS (ok, GTK_CAN_DEFAULT);
  gtk_window_set_default (GTK_WINDOW (name_window), ok);
  gtk_box_pack_start (GTK_BOX (hbox), ok, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok), "clicked",
		      GTK_SIGNAL_FUNC (get_name), name_window);
  gtk_widget_show (ok);

}




void
fast_add_disk (GtkWidget * w, CONFIG * my_config)
{

  fast_scan_error = 0;

  local_config = my_config;
  thread_is_running = FAD_MOUNT;
  if (pthread_create
      (&thread2, NULL, start_fast_add_disk, (void *) my_config) < 0)
    {
      ERROR_DIALOG ("Thread failed.\nCheck your number of threads.",
		    my_config->window);
      return;
    }
  while (thread_is_running == FAD_MOUNT);
  if (thread_is_running == FAD_ERROR)
    {
      ERROR_DIALOG ("Disk already mounted or bad argument in setup",
		    my_config->window);
    }
  else
    {

/*	signal (SIGUSR2, update_waitbox);
	signal (SIGALRM, close_waitbox);
*/
      fad_create_window (my_config);
      while ((thread_is_running != FAD_DONE)
	     && (thread_is_running != FAD_ERROR));

      if (thread_is_running == FAD_ERROR)
	{
	  ERROR_DIALOG ("Can't umount disk.\nCheck if it's not in use",
			my_config->window);
	}
      else
	{

	  if (pthread_join (thread2, NULL) == 28)
	    printf ("pouet\n");
	  update_tree (my_config);
/*			close_waitbox ();*/
	}
    }

}
