/*  GTKtalog.
 *  Copyright (C) 1999-2000  Mathieu VILLEGAS & Yves METTIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <unistd.h>
#include "folder.h"


const gchar *
get_disk_from_node (GNode * gn, FOLDER * f)
{
  FILE_DATA *fd;
  GNode *tmp;

  tmp = gn;
  while (g_node_depth (tmp) > 2)
    tmp = tmp->parent;
  fd = g_ptr_array_index (f->datas, GPOINTER_TO_UINT (tmp->data));

  return (fd->name->str);
}

GString *
get_real_path_from_node (GNode * gn, FOLDER * f)
{
  FILE_DATA *fd;
  GNode *tmp = gn;
  GString *rp;

  rp = g_string_new ("");
  while (g_node_depth (tmp) >= 3)
    {
      fd = g_ptr_array_index (f->datas, GPOINTER_TO_UINT (tmp->data));
      rp = g_string_prepend (rp, fd->name->str);
      rp = g_string_prepend_c (rp, '/');
      tmp = tmp->parent;
    }
  fd = g_ptr_array_index (f->datas, GPOINTER_TO_UINT (tmp->data));
  rp = g_string_prepend (rp, fd->information->str);
  rp = g_string_prepend_c (rp, '/');

  return (rp);
}

GString *
get_path_from_node (GNode * gn, FOLDER * f)
{
  FILE_DATA *fd;
  GNode *tmp = gn;
  GString *gs = g_string_new ("/");
  while (g_node_depth (tmp) > 3)
    {
      tmp = tmp->parent;
      fd = g_ptr_array_index (f->datas, GPOINTER_TO_UINT (tmp->data));
      gs = g_string_prepend (gs, fd->name->str);
      gs = g_string_prepend_c (gs, '/');
    }
  return (gs);
}

FILE_DATA *
folder_make_data (char *name, char *information, guint type,
		  guint32 taille, time_t date,
		  guint32 categorie, guint32 description)
{
  FILE_DATA *data;
  data = (FILE_DATA *) g_malloc (sizeof (FILE_DATA));

  data->name = g_string_new (name);
  data->taille = taille;
  data->type = type;
  data->date = date;
  data->categorie = categorie;
  data->description = description;

  if ((information != NULL) && (strlen (information) != 0))
    data->information = g_string_new (information);
  else
    data->information = NULL;

  return (data);

}

/* Add a file to the FOLDER structure */
GNode *
folder_add (FOLDER * fd, GNode * parent, char *name,
	    char *information, guint type, guint32 taille,
	    time_t date, guint32 categorie, guint32 description)
{

  FILE_DATA *data;
  GNode *gn;
/************
printf("folder_add : name = '%s' parent = %d\n", name, GPOINTER_TO_UINT(parent->data));
if(parent->data) {
data = g_ptr_array_index(fd->datas, GPOINTER_TO_UINT(parent->data));
printf(" parent name = '%s'\n\n", data->name->str);
}
************/

  data =
    folder_make_data (name, information, type, taille, date,
		      categorie, description);

  g_ptr_array_add (fd->datas, data);
  gn = g_node_new (GUINT_TO_POINTER (fd->datas->len - 1));
  data->node = gn;
  g_node_insert (parent, -1, gn);


  return (gn);
}

GNode *
folder_add_link (FOLDER * fd, GNode * parent,	/* parent that contains the link */
		 char *linkname,
		 char *destname,
		 char *information, guint32 taille,
		 time_t date, guint32 categorie, guint32 description)
{
  GNode *gn;
  gn =
    folder_add (fd, parent, linkname, information, IS_LINK,
		0, date, categorie, description);
  folder_add (fd, gn, destname, NULL, 0, 0, date, categorie, description);
  return (gn);
}

void
change_name (FOLDER * f, GNode * gn, char *name)
{
  FILE_DATA *fd;

  fd = g_ptr_array_index (f->datas, GPOINTER_TO_UINT (gn->data));
  g_string_free (fd->name, TRUE);
  fd->name = g_string_new (name);
}

void
change_description (FOLDER * f, GNode * gn, guint i)
{
  FILE_DATA *fd;

  fd = g_ptr_array_index (f->datas, GPOINTER_TO_UINT (gn->data));
  fd->description = i;
}

void
change_category (FOLDER * f, GNode * gn, guint i)
{
  FILE_DATA *fd;

  fd = g_ptr_array_index (f->datas, GPOINTER_TO_UINT (gn->data));
  fd->categorie = i;
}


/* traitement des infos sur la date, la taille et le type. */

const char *
folder_get_name (FOLDER * f, GNode * gn)
{
  FILE_DATA *fd;

  fd = g_ptr_array_index (f->datas, GPOINTER_TO_UINT (gn->data));
  return (fd->name->str);
}

const char *
folder_get_informations (FOLDER * f, GNode * gn)
{
  FILE_DATA *fd;

  fd = g_ptr_array_index (f->datas, GPOINTER_TO_UINT (gn->data));
  if (fd->information)
    return (fd->information->str);
  else
    return (NULL);
}

char *
get_time (time_t nb_sec)
{
  struct tm *time;
  char *mydate;

  if (nb_sec)
    {
      time = localtime (&nb_sec);
      mydate = (char *) g_malloc (sizeof (char) * 25);
      sprintf (mydate, "%.2d/%.2d/%.4d %.2d:%.2d:%.2d", time->tm_mday,
	       time->tm_mon + 1, 1900 + time->tm_year, time->tm_sec,
	       time->tm_min, time->tm_hour);
    }
  else
    {
      mydate = g_strdup ("-");
    }
  return (mydate);
}


char *
get_size (guint32 nb_octs)
{
  char *mytaille;

  mytaille = (char *) g_malloc (sizeof (char) * 15);
  sprintf (mytaille, "%lu", (long unsigned int) nb_octs);
  return (mytaille);
}

int
get_type (guint type_info)
{
  //int temp;

  // temp = type_info>>30;
  // return(temp);
  return (type_info);
}


const char *
get_categorie (CONFIG * my_config, guint16 i)
{
  if ((i <= my_config->categories->len) && (i > 0))
    {
      return (((GString *) g_ptr_array_index (my_config->categories, i - 1))->
	      str);
    }
  else
    {
      return (NULL);
    }
}

const char *
get_description (CONFIG * my_config, guint16 i)
{
  if ((i <= my_config->descriptions->len) && (i > 0))
    {
      return (
	      ((GString *)
	       g_ptr_array_index (my_config->descriptions, i - 1))->str);
    }
  else
    {
      return (NULL);
    }
}


gboolean
is_file (FOLDER * folder, GNode * gn)
{
  FILE_DATA *fd;

  fd = g_ptr_array_index (folder->datas, GPOINTER_TO_UINT (gn->data));
  if (fd->type == IS_FILE)
    return (TRUE);
  return (FALSE);
}

gboolean
is_dir (FOLDER * folder, GNode * gn)
{
  FILE_DATA *fd;

  fd = g_ptr_array_index (folder->datas, GPOINTER_TO_UINT (gn->data));
  if (fd->type == IS_DIR)
    return (TRUE);
  return (FALSE);
}

gboolean
is_link (FOLDER * folder, GNode * gn)
{
  FILE_DATA *fd;

  fd = g_ptr_array_index (folder->datas, GPOINTER_TO_UINT (gn->data));
  if (fd->type == IS_LINK)
    return (TRUE);
  return (FALSE);
}



gboolean
is_disk (FOLDER * folder, GNode * gn)
{
  FILE_DATA *fd;

  fd = g_ptr_array_index (folder->datas, GPOINTER_TO_UINT (gn->data));
  if (fd->type == IS_DISK)
    return (TRUE);
  return (FALSE);
}

/* Find a FOLDER structure f with (f->name == name).
 * already_found sould be NULL
 * recursive is a flqg to make a recursive search or only a one-level search
 */
GArray *
folder_search_name_in_array (FOLDER * folder, GNode * gn, gchar * name)
{
  GPtrArray *a;
  FILE_DATA *fd;
  guint i;
  GArray *already_found;

  already_found = g_array_new (FALSE, FALSE, sizeof (guint));

  a = folder->datas;
  for (i = 0; i < a->len; i++)
    {
      fd = g_ptr_array_index (a, i);
      if (strcmp ((fd->name)->str, name) == 0)
	{
	  already_found = g_array_append_val (already_found, i);
	}
    }

  return (already_found);
}


gboolean
_gnode_clear_data (GNode * gn, gpointer data)
{
  FOLDER *f = data;
  FILE_DATA *fd;

  fd = g_ptr_array_index (f->datas, GPOINTER_TO_UINT (gn->data));
  if (fd->name)
    g_string_free (fd->name, TRUE);
  if (fd->information)
    g_string_free (fd->information, TRUE);

  g_free (fd);
/* warning: the FILE_DATA entry in the GPtrArray is just set to NULL. It is not suppressed here. */
  g_ptr_array_index (f->datas, GPOINTER_TO_UINT (gn->data)) = NULL;
  gn->data = NULL;

  return (FALSE);
}

/* empty the main FOLDER structure */
void
folder_free (CONFIG * my_config)
{
  FOLDER *f = my_config->racine;
  g_node_traverse (f->tree, G_IN_ORDER, G_TRAVERSE_ALL, -1, _gnode_clear_data,
		   f);
  g_node_destroy (f->tree);

  g_ptr_array_free (f->datas, FALSE);

  f->tree = NULL;
  f->datas = NULL;
}

gboolean
_gnode_clear_ctree_data (GNode * gn, gpointer data)
{
  CONFIG *my_config = data;
  FILE_DATA *fd;

  if ((is_dir (my_config->racine, gn) == TRUE)
      || (is_disk (my_config->racine, gn) == TRUE))
    {
      fd =
	g_ptr_array_index (my_config->racine->datas,
			   GPOINTER_TO_UINT (gn->data));
      gtk_ctree_node_set_row_data (GTK_CTREE (my_config->ctree),
				   fd->ctree_node, NULL);
    }
  return (FALSE);
}

void
suppress_dir (GNode * dir, CONFIG * my_config)
{
  GPtrArray *gpa;
  FILE_DATA *fd;
  GNode *gn;
  gint i;

  gpa = my_config->racine->datas;
  fd = g_ptr_array_index (gpa, GPOINTER_TO_UINT (dir->data));
  if ((is_dir (my_config->racine, dir) == TRUE)
      || (is_disk (my_config->racine, dir) == TRUE))
    {
      g_node_traverse (dir, G_PRE_ORDER, G_TRAVERSE_ALL, -1,
		       _gnode_clear_ctree_data, my_config);
      gtk_ctree_remove_node (GTK_CTREE (my_config->ctree), fd->ctree_node);
    }
  g_node_traverse (dir, G_PRE_ORDER, G_TRAVERSE_ALL, -1, _gnode_clear_data,
		   my_config->racine);
  g_node_unlink (dir);
  g_node_destroy (dir);

  /* Garbage collector for the FOLDER data structure */
  while (g_ptr_array_remove_fast (gpa, NULL));
  for (i = 0; i < gpa->len; i++)
    {
      fd = g_ptr_array_index (gpa, i);
      gn = fd->node;
      gn->data = GUINT_TO_POINTER (i);
    }
  my_config->selected_folder = NULL;
  my_config->is_modified = TRUE;
}

void
_make_disk_list (GNode * gn, gpointer data)
{
  CONFIG *my_config = data;
  GList *disk_list =
    g_hash_table_lookup (my_config->stuff, "_build disk list");
  FILE_DATA *fd;

  fd =
    g_ptr_array_index (my_config->racine->datas, GPOINTER_TO_UINT (gn->data));

  disk_list = g_list_append (disk_list, fd->name->str);
  g_hash_table_insert (my_config->stuff, "_build disk list", disk_list);
  return;
}

GList *
make_disk_list (CONFIG * my_config)
{
  GList *disk_list = NULL;
  g_hash_table_insert (my_config->stuff, "_build disk list", disk_list);
  g_node_children_foreach (my_config->racine->tree, G_TRAVERSE_ALL,
			   _make_disk_list, my_config);
  disk_list = g_hash_table_lookup (my_config->stuff, "_build disk list");
  g_hash_table_remove (my_config->stuff, "_build disk list");
  return (disk_list);
}
