/*  GTKtalog.
 *  Copyright (C) 1999-2000  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __FOLDER_H__
#define __FOLDER_H__

#include <config.h>
#include <gnome.h>
#include "config_common.h"


#define IS_DISK        1
#define IS_DIR         2
#define IS_FILE        3
#define IS_LINK        4
#define IS_ENDOFDIR    12

const gchar *get_disk_from_node(GNode *gn, FOLDER *f);
GString *get_real_path_from_node(GNode *gn, FOLDER *f);
GString *get_path_from_node(GNode *gn, FOLDER *f);
FILE_DATA *folder_make_data(char *name, char *information, guint type, guint32 taille, time_t date, guint32 categorie, guint32 description);
GNode *folder_add(FOLDER *fd, GNode *parent, char *name, char *information, guint type, guint32 taille, time_t date, guint32 categorie, guint32 description);
GNode *folder_add_link(FOLDER *fd, GNode *parent, char *linkname, char *destname, char *information, guint32 taille, time_t date, guint32 categorie, guint32 description);
void change_name(FOLDER *f, GNode *gn, char *name);
void change_description(FOLDER *f, GNode *gn, guint i);
void change_category(FOLDER *f, GNode *gn, guint i);
const char *folder_get_name(FOLDER *f, GNode *gn);
const char *folder_get_informations(FOLDER *f, GNode *gn);
char *get_time(time_t nb_sec);
char *get_size(guint32 nb_octs);
int get_type(guint type_info);
const char *get_categorie(CONFIG *my_config, guint16 i);
const char *get_description(CONFIG *my_config, guint16 i);
gboolean is_file(FOLDER *folder, GNode *gn);
gboolean is_dir(FOLDER *folder, GNode *gn);
gboolean is_link(FOLDER *folder, GNode *gn);
gboolean is_disk(FOLDER *folder, GNode *gn);
GArray *folder_search_name_in_array(FOLDER *folder, GNode *gn, gchar *name);
gboolean _gnode_clear_data(GNode *gn, gpointer data);
void folder_free(CONFIG *my_config);
gboolean _gnode_clear_ctree_data(GNode *gn, gpointer data);
void suppress_dir(GNode *dir, CONFIG *my_config);
void _make_disk_list(GNode *gn, gpointer data);
GList *make_disk_list(CONFIG *my_config);

#endif
