/*  GTKtalog.
 *  Copyright (C) 1999-2000  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <strings.h>
#include <fnmatch.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <signal.h>
#include <unistd.h>
#include <wait.h>

#include "interface.h"
#include "edit.h"
#include "folder.h"
#include "exit.h"
#include "compare.h"
#include "fastaddisk.h"
#include "config_common.h"

void
traverse_add_dir_to_clist (GNode * gn, gpointer data)
{
  const gchar *temp[6] = { " ", " ", " ", " ", " ", " " };
  gchar *nothing = " ";
  CONFIG *my_config = data;
  FILE_DATA *fd = NULL;
  gint i;
  PIX *pix;

  if ((is_dir (my_config->racine, gn) == TRUE)
      || (is_disk (my_config->racine, gn) == TRUE))
    {
      fd =
	g_ptr_array_index (my_config->racine->datas,
			   GPOINTER_TO_UINT (gn->data));


      temp[1] = g_strdup ("0");
      temp[2] = g_strdup (get_time (fd->date));
      temp[3] = get_categorie (my_config, fd->categorie);
      if (!temp[3])
	temp[3] = nothing;
      temp[4] = get_description (my_config, fd->description);
      if (!temp[4])
	temp[4] = nothing;
      temp[5] = folder_get_informations (my_config->racine, gn);
      if (!temp[5])
	temp[5] = nothing;

      i = gtk_clist_append ((GtkCList *) my_config->clist, (gchar **) temp);
      if (is_dir (my_config->racine, gn) == TRUE)
	pix = my_config->default_dir_pix;
      else
	pix = my_config->default_disk_pix;
      gtk_clist_set_pixtext ((GtkCList *) my_config->clist, i, 0,
			     fd->name->str, 3, pix->pixmap, *(pix->mask));
      gtk_clist_set_row_data ((GtkCList *) my_config->clist, i, gn);
    }
}

void
traverse_add_file_to_clist (GNode * gn, gpointer data)
{
  const gchar *temp[6] = { " ", " ", " ", " ", " ", " " };
  gchar *nothing = " ";
  CONFIG *my_config = data;
  FILE_DATA *fd, *fdl;
  char *extension;
  PIX *pix;
  gint i;
  GString *filename;

  if ((is_file (my_config->racine, gn) == TRUE)
      || (is_link (my_config->racine, gn) == TRUE))
    {
      fd =
	g_ptr_array_index (my_config->racine->datas,
			   GPOINTER_TO_UINT (gn->data));
      filename = fd->name;

      if (is_link (my_config->racine, gn) == TRUE)
	{
	  fdl = g_ptr_array_index (my_config->racine->datas,
				   GPOINTER_TO_UINT (g_node_first_child
						     (gn)->data));
	  filename = fdl->name;
	}

      temp[1] = get_size (fd->taille);
      temp[2] = get_time (fd->date);
      temp[3] = get_categorie (my_config, fd->categorie);
      if (!temp[3])
	temp[3] = nothing;
      temp[4] = get_description (my_config, fd->description);
      if (!temp[4])
	temp[4] = nothing;
      temp[5] = folder_get_informations (my_config->racine, gn);
      if (!temp[5])
	temp[5] = nothing;

      i = gtk_clist_append ((GtkCList *) my_config->clist, (gchar **) temp);

      /* pixmap depending on the extension */

      extension = fd->name->str;
      while (extension[0])
	extension++;
      while ((extension > fd->name->str) && (extension[0] != '.'))
	extension--;

      pix = ((PIX *) g_tree_lookup (my_config->icons, extension));
      if (!pix)
	{
	  pix = my_config->default_file_pix;
	}
      gtk_clist_set_pixtext ((GtkCList *) my_config->clist, i, 0,
			     filename->str, 3, pix->pixmap, *(pix->mask));


      gtk_clist_set_row_data ((GtkCList *) my_config->clist, i, gn);

    }
}

/* affiche dans la fenetre de droite, les repertoires et fichiers avec les icons */
void
list_folder (GNode * parent, CONFIG * my_config)
{
  const gchar *temp[6] = { " ", " ", " ", " ", " ", " " };
  gchar *nothing = " ";
  FOLDER *folder;
  FILE_DATA *fd;
  PIX *pix;
  int i;

  folder = my_config->racine;

  /*  selected_clist_folder = NULL; */

  gtk_clist_freeze ((GtkCList *) my_config->clist);
  gtk_clist_clear ((GtkCList *) my_config->clist);

  if (g_node_depth (parent) > 1)
    {
      fd =
	g_ptr_array_index (my_config->racine->datas,
			   GPOINTER_TO_UINT (parent->parent->data));

      temp[0] = g_strdup ("..");
      temp[1] = g_strdup ("0");
      temp[2] = g_strdup (get_time (fd->date));
      temp[3] = get_categorie (my_config, fd->categorie);
      if (!temp[3])
	temp[3] = nothing;
      temp[4] = get_description (my_config, fd->description);
      if (!temp[4])
	temp[4] = nothing;
      if (fd->information)
	{
	  temp[5] = fd->information->str;
	}
      else
	{
	  temp[5] = nothing;
	}

      i = gtk_clist_append ((GtkCList *) my_config->clist, (gchar **) temp);
      if (g_node_depth (parent) == 2)
	pix = my_config->default_disk_pix;
      else
	pix = my_config->default_dir_pix;

      gtk_clist_set_pixtext ((GtkCList *) my_config->clist, i, 0,
			     temp[0], 3, pix->pixmap, *(pix->mask));
      gtk_clist_set_row_data ((GtkCList *) my_config->clist, i, parent);

    }

  g_node_children_foreach (parent, G_TRAVERSE_ALL, traverse_add_dir_to_clist,
			   my_config);
  if (g_node_depth (parent) > 1)
    g_node_children_foreach (parent, G_TRAVERSE_ALL,
			     traverse_add_file_to_clist, my_config);


  gtk_clist_thaw ((GtkCList *) my_config->clist);
  my_config->currently_displayed_gnode = parent;

  /*  total_size = total_size / 1024;
   * sprintf (info, _("%d folders  %d files  total size %lu ko"),
   * folder->nb_folders, folder->nb_files, total_size);
   * 
   * gtk_statusbar_pop ((GtkStatusbar *) status_bar2, status_context2);
   * gtk_statusbar_push ((GtkStatusbar *) status_bar2, status_context2, info);
   */
}





/*affiche la liste des fichiers quand un repertoire est selectionn */
static void
cb_itemsignal (GtkWidget * widget, GtkCTreeNode * node, gint z,
	       CONFIG * my_config)
{
  GString *tmp;
  FILE_DATA *fd, *tmpfd;
  GNode *gnode_data, *gntmp;

  gnode_data = gtk_ctree_node_get_row_data (GTK_CTREE (widget), node);
  if (G_NODE_IS_ROOT (gnode_data) != TRUE)
    {
      my_config->selected_folder = gnode_data;

      fd =
	g_ptr_array_index (my_config->racine->datas,
			   GPOINTER_TO_UINT (gnode_data->data));
      if (g_node_depth (gnode_data) > 2)
	{
	  tmp = g_string_new (fd->name->str);
	  g_string_append_c (tmp, '/');
	  gntmp = gnode_data->parent;
	  while (g_node_depth (gntmp) > 2)
	    {
	      g_string_prepend_c (tmp, '/');
	      tmpfd =
		g_ptr_array_index (my_config->racine->datas,
				   GPOINTER_TO_UINT (gntmp->data));
	      g_string_prepend (tmp, tmpfd->name->str);
	      gntmp = gntmp->parent;
	    }

	  g_string_prepend (tmp, "] /");
	  tmpfd =
	    g_ptr_array_index (my_config->racine->datas,
			       GPOINTER_TO_UINT (gntmp->data));
	  g_string_prepend (tmp, tmpfd->name->str);
	  g_string_prepend_c (tmp, '[');
	}
      else if (g_node_depth (gnode_data) == 2)
	{
	  tmp = g_string_new (fd->name->str);
	}
      else
	{
	  tmp = g_string_new (my_config->catalog_filename->str);
	}
      gtk_entry_set_text (GTK_ENTRY (my_config->path_entry), tmp->str);
      g_string_free (tmp, TRUE);
      if (is_link (my_config->racine, my_config->selected_folder) == FALSE)
	{
	  list_folder (gnode_data, my_config);
	}
    }
}

/* quand un repertoire est deselectionne dans l'arbre */
static void
cb_itemsignal2 (GtkWidget * widget, GtkCTreeNode * node, gint i,
		CONFIG * my_config)
{
  my_config->selected_folder = NULL;
}



static void
expand_cb (GtkWidget * widget, GtkCTreeNode * parent_node, CONFIG * my_config)
{
  GNode *parent_gn;
  gboolean is_expanded = FALSE;

  parent_gn = gtk_ctree_node_get_row_data (GTK_CTREE (widget), parent_node);

  gtk_ctree_get_node_info (GTK_CTREE (widget), parent_node,
			   NULL,
			   NULL, NULL, NULL, NULL, NULL, NULL, &is_expanded);
  if (is_expanded == TRUE)
    {
      list_folder (parent_gn, my_config);
    }
}


////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////

void
quit_prog (GtkWidget * w, CONFIG * my_config)
{
  char *tmp;
  gboolean quit_anyway = TRUE;

  if (my_config->is_modified == TRUE)
    {
      if (yes_no_cancel_dialog (_("Exit dialog"),
				_
				("The catalog has not been saved. Leave anyway ?"))
	  != 0)
	{

	  quit_anyway = FALSE;
	}
    }
  if (quit_anyway == TRUE)
    {
      if ((tmp = getenv ("HOME")) == NULL)
	{
	  return;
	}
      if (tmp[strlen (tmp) - 1] != '/')
	tmp = g_strconcat (tmp, "/", NULL);
      tmp = g_strconcat (tmp, ".gtktalog/temp/", NULL);


      switch (fork ())
	{
	case 0:		/* child */
	  seteuid (getuid ());	/* reduce likelyhood of security holes when running setuid */
	  execlp ("rm", "rm", "-rf", tmp, NULL);
	  exit (1);
	  break;
	case -1:
	  fprintf (stderr, "unable to fork: \n");
	  fflush (stdout);
	  break;
	default:		/* parent */
	  wait (NULL);
	}

      gtk_main_quit ();
    }
}

gboolean
add_disk_to_ctree (GNode * gn, gpointer data)
{
  CONFIG *my_config = data;
  FILE_DATA *fd, *parent_fd, *child_fd;
  GtkCTreeNode *gtkparentnode;
  gboolean is_leaf, is_expanded;
  GNode *gn_child;
  PIX *pix;

  fd =
    g_ptr_array_index (my_config->racine->datas, GPOINTER_TO_UINT (gn->data));
  if (g_node_depth (gn) == 1)
    {
      /*      fd->ctree_node =
       * gtk_ctree_insert_node (GTK_CTREE (my_config->ctree), NULL, NULL,
       * &(my_config->catalog_filename->str), 4, NULL,
       * NULL, NULL, NULL, FALSE, TRUE);
       * gtk_ctree_node_set_row_data (GTK_CTREE (my_config->ctree),
       * fd->ctree_node, gn);
       */ }
  else
    {
      gn_child = g_node_first_child (gn);
      is_leaf = TRUE;
      while ((gn_child) && (is_leaf == TRUE))
	{
	  child_fd = g_ptr_array_index (my_config->racine->datas,
					GPOINTER_TO_UINT (gn_child->data));
	  if (child_fd->type == IS_DIR)
	    is_leaf = FALSE;
	  gn_child = g_node_next_sibling (gn_child);
	}
      if ((my_config->racine->tree == gn))
	is_expanded = TRUE;
      else
	is_expanded = FALSE;

      if ((is_disk (my_config->racine, gn) == TRUE)
	  || (is_dir (my_config->racine, gn) == TRUE))
	{
	  parent_fd =
	    g_ptr_array_index (my_config->racine->datas,
			       GPOINTER_TO_UINT (gn->parent->data));
	  gtkparentnode = parent_fd->ctree_node;
	  if (g_node_depth (gn) == 2)
	    pix = my_config->default_disk_pix;
	  else
	    pix = my_config->default_dir_pix;
	  fd->ctree_node =
	    gtk_ctree_insert_node (GTK_CTREE (my_config->ctree),
				   gtkparentnode, NULL, &(fd->name->str), 4,
				   pix->pixmap, *(pix->mask), pix->pixmap,
				   *(pix->mask), is_leaf, is_expanded);
	  gtk_ctree_node_set_row_data (GTK_CTREE (my_config->ctree),
				       fd->ctree_node, gn);

	}
    }
  return (FALSE);
}

gint
find_viewer (gpointer key, gpointer value, gpointer data)
{
  EXTENSIONS *e = value;
  GString *extstr;
  CONFIG *my_config = data;

  if (e->state == FALSE)
    return (FALSE);

  extstr = g_string_new (e->extension->str);
  extstr = g_string_prepend_c (extstr, '*');
  if (fnmatch
      (extstr->str,
       g_hash_table_lookup (my_config->stuff, "_interface: filename"), 0))
    return (FALSE);
  g_hash_table_insert (my_config->stuff, "_interface: extensions", e);
  return (TRUE);
}

void
fin_fils (int sig)
{
  wait (NULL);
  signal (SIGCHLD, SIG_DFL);
  signal (SIGCHLD, fin_fils);
}

static void
selection_made (GtkWidget * clist, gint row, gint column,
		GdkEventButton * event, CONFIG * my_config)
{
  GNode *gn, *gntmp;
  gchar *name;
  GString *tmpstr;
  gint8 tmp;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  FILE_DATA *fd, *tmpfd;
  gboolean less;
  EXTENSIONS *e;


  gtk_widget_grab_focus (GTK_WIDGET (clist));

  if ((event != NULL) && (event->button == 1)
      && (event->type == GDK_2BUTTON_PRESS))
    {

      gtk_clist_get_pixtext ((GtkCList *) clist, row, 0, &name, &tmp,
			     &pixmap, &mask);

      gn = gtk_clist_get_row_data ((GtkCList *) clist, row);
      fd =
	g_ptr_array_index (my_config->racine->datas,
			   GPOINTER_TO_UINT (gn->data));

      if (is_link (my_config->racine, gn) == TRUE)
	{

	}
      else if (is_file (my_config->racine, gn) == FALSE)
	{
	  if ((row <= 0) && (strcmp (name, "..") == 0))
	    {
	      gn = gn->parent;
	      fd =
		g_ptr_array_index (my_config->racine->datas,
				   GPOINTER_TO_UINT (gn->data));

	    }
	  if (g_node_depth (gn) > 2)
	    {
	      tmpstr = g_string_new (fd->name->str);
	      g_string_append_c (tmpstr, '/');
	      gntmp = gn->parent;
	      while (g_node_depth (gntmp) > 2)
		{
		  g_string_prepend_c (tmpstr, '/');
		  tmpfd =
		    g_ptr_array_index (my_config->racine->datas,
				       GPOINTER_TO_UINT (gntmp->data));
		  g_string_prepend (tmpstr, tmpfd->name->str);
		  gntmp = gntmp->parent;
		}

	      g_string_prepend (tmpstr, "] /");
	      tmpfd =
		g_ptr_array_index (my_config->racine->datas,
				   GPOINTER_TO_UINT (gntmp->data));
	      g_string_prepend (tmpstr, tmpfd->name->str);
	      g_string_prepend_c (tmpstr, '[');
	    }
	  else if (g_node_depth (gn) == 2)
	    {
	      tmpstr = g_string_new (fd->name->str);
	    }
	  else
	    {
	      tmpstr = g_string_new (my_config->catalog_filename->str);
	    }
	  gtk_entry_set_text (GTK_ENTRY (my_config->path_entry), tmpstr->str);
	  g_string_free (tmpstr, TRUE);
	  if (is_link (my_config->racine, gn) == FALSE)
	    {
	      list_folder (gn, my_config);
	    }


	}
      else
	{
	  /* Find the program that will browse the file */

	  gn = gtk_clist_get_row_data (GTK_CLIST (clist), row);
	  fd =
	    g_ptr_array_index (my_config->racine->datas,
			       GPOINTER_TO_UINT (gn->data));

	  tmpstr = get_real_path_from_node (gn, my_config->racine);
	  if (g_file_exists (tmpstr->str) == FALSE)
	    {
	      ERROR_DIALOG
		("The file does not exist.\nMaybe it was removed or it is on a CD.\nIn this case, load the CD, mount it and try again",
		 my_config->window);
	    }
	  else
	    {
	      g_hash_table_insert (my_config->stuff, "_interface: filename",
				   fd->name->str);
	      g_hash_table_insert (my_config->stuff, "_interface: extensions",
				   NULL);
	      g_tree_traverse (my_config->extensions, find_viewer,
			       G_PRE_ORDER, my_config);
	      less = TRUE;
	      if (
		  (e =
		   g_hash_table_lookup (my_config->stuff,
					"_interface: extensions")))
		{
		  /* Launch the viewer */
		  char *args[3];
		  char *s1, *s2;
		  gint nb_args;
		  if (compare ("^[ \t]*$", e->viewer->str, TRUE, FALSE))
		    {
		      s1 = g_strdup (tmpstr->str);
		      s2 = s1;
		      while (s2[0])
			s2++;
		      while (s2[0] != '/')
			s2--;
		      s2[0] = 0;
		      args[0] = e->viewer->str;
		      nb_args = 1;
		      if (compare
			  ("^[ \t]*$", e->viewerarg->str, TRUE, FALSE))
			{
			  args[1] = e->viewerarg->str;
			  nb_args++;
			}
		      args[nb_args++] = tmpstr->str;

		      gnome_execute_async (s1, nb_args, args);
		      g_free (s1);
		      less = FALSE;
		    }
		}
	      g_hash_table_remove (my_config->stuff, "_interface: filename");
	      g_hash_table_remove (my_config->stuff, "_interface: extensions");
	      if (less == TRUE)
		{
		  if (g_file_test (tmpstr->str, G_FILE_TEST_ISFILE) == TRUE)
		    {
		      GtkWidget *dialog, *gl;

		      dialog =
			gnome_dialog_new (fd->name->str,
					  GNOME_STOCK_BUTTON_CLOSE, NULL);
		      gnome_dialog_set_parent (GNOME_DIALOG (dialog),
					       GTK_WINDOW
					       (my_config->window));
		      gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE,
					     FALSE);
		      gtk_widget_set_usize (dialog, 500, 350);
		      gl = gnome_less_new ();
		      gtk_box_pack_start (GTK_BOX
					  (GNOME_DIALOG (dialog)->vbox),
					  gl, TRUE, TRUE, 0);
		      gnome_less_show_file (GNOME_LESS (gl), tmpstr->str);
		      gtk_widget_show (gl);
		      gnome_dialog_run_and_close (GNOME_DIALOG (dialog));
		    }
		  else
		    {
		      ERROR_DIALOG
			("The file is not a regular file.\nCan not display it",
			 my_config->window);
		    }
		}

	    }
	  g_string_free (tmpstr, TRUE);
	}
    }
  else if ((event != NULL) && (event->button == 1))
    {
      fd = g_ptr_array_index (my_config->racine->datas, 0);
      gtk_ctree_unselect_recursive (GTK_CTREE (my_config->ctree),
				    fd->ctree_node);
      gn = gtk_clist_get_row_data ((GtkCList *) clist, row);
      my_config->selected_folder = gn;
    }

}


static void
unselection_made (GtkWidget * clist, gint row, gint column,
		  GdkEventButton * event, CONFIG * my_config)
{
  my_config->selected_folder = NULL;
}

GnomeUIInfo tree_pressed_menu_dir[] = {
  GNOMEUIINFO_ITEM_NONE (N_("Edit directory"), NULL, edit_folder),
  GNOMEUIINFO_ITEM_NONE (N_("Delete directory"), NULL, delete_folder),
  GNOMEUIINFO_END
};

GnomeUIInfo tree_pressed_menu_link[] = {
  GNOMEUIINFO_ITEM_NONE (N_("Edit link"), NULL, edit_folder),
  GNOMEUIINFO_END
};

GnomeUIInfo tree_pressed_menu_disk[] = {
  GNOMEUIINFO_ITEM_NONE (N_("Edit disk"), NULL, edit_folder),
  GNOMEUIINFO_ITEM_NONE (N_("Update disk"), NULL, update_disk),
  GNOMEUIINFO_ITEM_NONE (N_("Delete disk"), NULL, delete_folder),
  GNOMEUIINFO_END
};


GnomeUIInfo clist_pressed_menu_file[] = {
  GNOMEUIINFO_ITEM_NONE (N_("Edit file"), NULL, edit_folder),
  /*  GNOMEUIINFO_ITEM_NONE (N_("Edit informations"), NULL,
   * edit_file_informations), */
  GNOMEUIINFO_ITEM_NONE (N_("Delete file"), NULL, delete_folder),
  GNOMEUIINFO_END
};




void
clist_pressed (GtkWidget * wid, GdkEventButton * event, gpointer data)
{
  GtkWidget *list_menu;
  CONFIG *my_config = data;

  /*
   * if ((event->button == 2) && (selected_clist_folder != NULL)) {
   * selected_folder = selected_clist_folder;
   * edit_folder (wid, my_config->selected_folder);
   * }
   * else
   */
  if (event->button == 3)
    {


      if (my_config->selected_folder != NULL)
	{
	  if (is_dir (my_config->racine, my_config->selected_folder) == TRUE)
	    {
	      list_menu = gnome_popup_menu_new (tree_pressed_menu_dir);

	    }
	  else if (is_link (my_config->racine, my_config->selected_folder)
		   == TRUE)
	    {
	      list_menu = gnome_popup_menu_new (tree_pressed_menu_link);
	    }
	  else if (is_file (my_config->racine, my_config->selected_folder)
		   == TRUE)
	    {
	      list_menu = gnome_popup_menu_new (clist_pressed_menu_file);
	    }
	  else
	    {
	      list_menu = gnome_popup_menu_new (tree_pressed_menu_disk);
	    }
	  gnome_popup_menu_do_popup (list_menu, NULL, NULL, event, my_config);
	}
    }
}





GtkWidget *
create_list (CONFIG * my_config)
{

  GtkWidget *scrolled_window;
  gchar *titles[6] = { N_("Filename"), N_("Size"), N_("Date"), N_("Category"),
    N_("Description"), N_("Information")
  };

  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);


  my_config->clist = gtk_clist_new_with_titles (6, titles);
  gtk_signal_connect (GTK_OBJECT (my_config->clist), "select_row",
		      GTK_SIGNAL_FUNC (selection_made), my_config);
  gtk_signal_connect (GTK_OBJECT (my_config->clist), "unselect_row",
		      GTK_SIGNAL_FUNC (unselection_made), my_config);

  gtk_clist_set_shadow_type (GTK_CLIST (my_config->clist), GTK_SHADOW_OUT);
  gtk_clist_set_column_width (GTK_CLIST (my_config->clist), 0, 135);
  gtk_clist_set_column_width (GTK_CLIST (my_config->clist), 1, 60);
  gtk_clist_set_column_width (GTK_CLIST (my_config->clist), 2, 56);
  gtk_clist_set_column_width (GTK_CLIST (my_config->clist), 3, 60);
  gtk_clist_set_column_width (GTK_CLIST (my_config->clist), 4, 60);
  gtk_container_add (GTK_CONTAINER (scrolled_window), my_config->clist);
  gtk_signal_connect (GTK_OBJECT (my_config->clist), "button_press_event",
		      GTK_SIGNAL_FUNC (clist_pressed), my_config);
  gtk_clist_set_column_auto_resize (GTK_CLIST (my_config->clist), 4, TRUE);
  gtk_widget_show (my_config->clist);

  return scrolled_window;
}

void
tree_pressed (GtkWidget * wid, GdkEventButton * event, gpointer data)
{
  GtkWidget *list_menu;
  CONFIG *my_config = data;


  /*
   * if ((event->button == 2) && (selected_tree_folder != NULL)) {
   * selected_folder = selected_tree_folder;
   * edit_folder (wid, my_config->selected_folder);
   * }
   * else 
   */
  if (event->button == 3)
    {
      if (my_config->selected_folder != NULL)
	{
	  if (is_dir (my_config->racine, my_config->selected_folder) == TRUE)
	    {
	      list_menu = gnome_popup_menu_new (tree_pressed_menu_dir);

	    }
	  else if (is_link (my_config->racine, my_config->selected_folder) ==
		   1)
	    {
	      list_menu = gnome_popup_menu_new (tree_pressed_menu_link);
	    }
	  else
	    {
	      list_menu = gnome_popup_menu_new (tree_pressed_menu_disk);
	    }
	  gnome_popup_menu_do_popup (list_menu, NULL, NULL, event, my_config);
	}

    }

}



/* Create the folder tree */
GtkWidget *
create_tree (CONFIG * my_config)
{
  GtkWidget *scroll_win;
  /* Initialized handler. 20-06-00 YM */
  void (*handler) (gchar *) = NULL;

  scroll_win = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll_win),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize (scroll_win, 150, 150);
  gtk_widget_show (scroll_win);

  my_config->ctree = gtk_ctree_new (1, 0);
  gtk_clist_set_column_auto_resize (GTK_CLIST (my_config->ctree), 0, TRUE);
  gtk_clist_set_selection_mode (GTK_CLIST (my_config->ctree),
				GTK_SELECTION_SINGLE);
  gtk_ctree_set_line_style (GTK_CTREE (my_config->ctree),
			    GTK_CTREE_LINES_DOTTED);
  gtk_signal_connect (GTK_OBJECT (my_config->ctree), "tree_expand",
		      GTK_SIGNAL_FUNC (expand_cb), my_config);
  gtk_signal_connect (GTK_OBJECT (my_config->ctree), "tree_select_row",
		      GTK_SIGNAL_FUNC (cb_itemsignal), my_config);
  gtk_signal_connect (GTK_OBJECT (my_config->ctree), "tree_unselect_row",
		      GTK_SIGNAL_FUNC (cb_itemsignal2), my_config);

  gtk_signal_connect (GTK_OBJECT (my_config->ctree), "button_press_event",
		      GTK_SIGNAL_FUNC (tree_pressed), my_config);

  gtk_container_add (GTK_CONTAINER (scroll_win), my_config->ctree);
  gtk_object_set_user_data (GTK_OBJECT (my_config->ctree),
			    (gpointer) handler);
  gtk_widget_show (my_config->ctree);

  return scroll_win;
}


void
update_tree (CONFIG * my_config)
{
  gtk_widget_destroy (my_config->ctree_window);
  my_config->ctree_window = create_tree (my_config);
  gtk_paned_add1 (GTK_PANED (my_config->hpaned), my_config->ctree_window);

  g_node_traverse (my_config->racine->tree, G_PRE_ORDER, G_TRAVERSE_ALL, -1,
		   add_disk_to_ctree, my_config);
  my_config->selected_folder = NULL;
  gtk_widget_show (my_config->ctree_window);
}

void
clean_description (GtkWidget * w, gpointer data)
{
  FILE_DATA *fd;
  CONFIG *my_config = data;
  gint i;

  for (i = 0; i < my_config->racine->datas->len; i++)
    {
      fd = g_ptr_array_index (my_config->racine->datas, i);
      fd->description = 0;
    }
  for (i = 0; i < my_config->descriptions->len; i++)
    {
      g_string_free (g_ptr_array_index (my_config->descriptions, i), TRUE);
      g_ptr_array_index (my_config->descriptions, i) = NULL;
    }
  g_ptr_array_free (my_config->descriptions, FALSE);
  my_config->descriptions = g_ptr_array_new ();
  list_folder (my_config->currently_displayed_gnode, my_config);
}
