/*
 * GTKtalog. *  Copyright (C) 1999-2000  Mathieu VILLEGAS * *  This program
 * is free software; you can redistribute it and/or modify *  it under the
 * terms of the GNU General Public License as published by *  the Free
 * Software Foundation; either version 2 of the License, or *  (at your
 * option) any later version. * *  This program is distributed in the hope
 * that it will be useful, *  but WITHOUT ANY WARRANTY; without even the
 * implied warranty of *  MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the *  GNU General Public License for more details. * *  You 
 * should have received a copy of the GNU General Public License *  along
 * with this program; if not, write to the Free Software *  Foundation, Inc., 
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 */

#include <config.h>
#include <gnome.h>

#include "config_common.h"
#include "interface.h"
#include "loadcat.h"
#include "savecat.h"
#include "exit.h"
#include "io.h"
#include "folder.h"

/*
 * ouverture d'un catalogue 
 */
void
open_cat_ok_sel (GtkWidget * w, CONFIG * my_config)
{
  GtkFileSelection *fs;

  fs = g_hash_table_lookup (my_config->stuff, "_io: open fs");

  if (my_config->racine->datas->len > 1)
    {
      clear_all (w, my_config);
      if (my_config->racine)
	folder_free (my_config);
      my_config->racine = (FOLDER *) g_malloc (sizeof (FOLDER));
    }

  /*
   * gtk_statusbar_pop ((GtkStatusbar *) status_bar1, status_context1);
   * gtk_statusbar_push ((GtkStatusbar *) status_bar1, status_context1, ""); 
   */

  if (load_cat_from_file
      (gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)),
       my_config) == -1)
    {
      return;
    }
  gtk_widget_destroy (GTK_WIDGET (fs));
  g_hash_table_remove (my_config->stuff, "_io: open fs");
  update_tree (my_config);

  gtk_window_set_title (GTK_WINDOW (my_config->window),
			my_config->catalog_filename->str);
}



void
open_cat (GtkWidget * w, gpointer data)
{
  GtkWidget *fs;
  CONFIG *my_config = (CONFIG *) data;
  if (my_config->is_modified == TRUE)
    {
      if (yes_no_cancel_dialog (_("Open dialog"),
				_
				("The catalog has not been saved. Lose it anyway ?"))
	  != 0)
	{
	  return;
	}
    }

  fs = gtk_file_selection_new ("File selection");
  g_hash_table_insert (my_config->stuff, "_io: open fs", fs);
  gtk_signal_connect (GTK_OBJECT (fs), "destroy",
		      (GtkSignalFunc) gtk_widget_destroy, &(fs));
  gtk_signal_connect (GTK_OBJECT
		      (GTK_FILE_SELECTION
		       (fs)->ok_button), "clicked",
		      (GtkSignalFunc) open_cat_ok_sel, my_config);
  gtk_signal_connect_object (GTK_OBJECT
			     (GTK_FILE_SELECTION
			      (fs)->cancel_button), "clicked",
			     (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (fs));
  gtk_widget_show (fs);

}

void
init_file (CONFIG * my_config)
{
  FILE_DATA *fd;
  gint i;

  if (my_config->racine)
    {
      folder_free (my_config);
    }
  my_config->racine = (FOLDER *) g_malloc (sizeof (FOLDER));
  my_config->racine->datas = g_ptr_array_new ();
  fd = (FILE_DATA *) g_malloc (sizeof (FILE_DATA));
  g_ptr_array_add (my_config->racine->datas, fd);
  my_config->racine->tree = g_node_new (GUINT_TO_POINTER (0));
  fd->name = NULL;
  fd->taille = 0;
  fd->type = 0;
  fd->date = 0;
  fd->categorie = 0;
  fd->description = 0;
  fd->information = NULL;
  fd->node = my_config->racine->tree;
  fd->ctree_node = NULL;

  for (i = 0; i < my_config->categories->len; i++)
    g_string_free (g_ptr_array_index (my_config->categories, i), TRUE);
  g_ptr_array_free (my_config->categories, FALSE);
  my_config->categories = g_ptr_array_new ();

  for (i = 0; i < my_config->descriptions->len; i++)
    g_string_free (g_ptr_array_index (my_config->descriptions, i), TRUE);
  g_ptr_array_free (my_config->descriptions, FALSE);
  my_config->descriptions = g_ptr_array_new ();
}

void
new_file (GtkWidget * w, CONFIG * my_config)
{
  gboolean new_anyway = TRUE;

  if (my_config->is_modified == TRUE)
    {
      if (yes_no_cancel_dialog
	  (_("New dialog"),
	   _("The catalog has not been saved. Lose it anyway ?")) != 0)
	{

	  new_anyway = FALSE;
	}
    }
  if (new_anyway == TRUE)
    {
      clear_all (w, my_config);
      init_file (my_config);
      g_string_free (my_config->catalog_filename, TRUE);
      my_config->catalog_filename = g_string_new (_("No_name"));
      my_config->catalog_filename_is_valid = FALSE;
    }
  /*
   * gtk_statusbar_pop ((GtkStatusbar *) status_bar1, status_context1);
   * gtk_statusbar_push ((GtkStatusbar *) status_bar1, status_context1, ""); 
   */

  update_tree (my_config);
}

void
clear_all (GtkWidget * w, CONFIG * my_config)
{
  gtk_clist_clear ((GtkCList *) my_config->clist);
  gtk_ctree_remove_node ((GtkCTree *) my_config->ctree,
			 ((FILE_DATA
			   *) (g_ptr_array_index (my_config->racine->datas,
						  0)))->ctree_node);

  gtk_entry_set_text (GTK_ENTRY (my_config->path_entry), "");
}



/*
 * permet d'enregistrer le catalogue courant dans un fichier 
 */
void
save_cat_ok_sel (GtkWidget * w, CONFIG * my_config)
{
  GtkFileSelection *fs =
    g_hash_table_lookup (my_config->stuff, "_io: save fs");
  if (save_cat_to_file
      (gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)),
       my_config) == 0)
    {
      gtk_window_set_title (GTK_WINDOW (my_config->window),
			    my_config->catalog_filename->str);
      /*
       * gtk_statusbar_push ((GtkStatusbar *) status_bar1, status_context1, my_config->catalog_filename->str); 
       */
    }
  gtk_widget_destroy (GTK_WIDGET (fs));
  g_hash_table_remove (my_config->stuff, "_io: save fs");
}




void
save_cat (GtkWidget * w, CONFIG * my_config)
{
  GtkWidget *fs;
  fs = gtk_file_selection_new ("Save catalog to file");
  g_hash_table_insert (my_config->stuff, "_io: save fs", fs);
  gtk_signal_connect (GTK_OBJECT (fs), "destroy",
		      (GtkSignalFunc) gtk_widget_destroy, &(fs));
  gtk_signal_connect (GTK_OBJECT
		      (GTK_FILE_SELECTION (fs)->ok_button),
		      "clicked", (GtkSignalFunc) save_cat_ok_sel, my_config);
  gtk_signal_connect_object (GTK_OBJECT
			     (GTK_FILE_SELECTION (fs)->cancel_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (fs));
  gtk_widget_show (fs);
}


void
fast_save (GtkWidget * w, CONFIG * my_config)
{
  if (my_config->catalog_filename_is_valid == FALSE)
    {
      save_cat (w, my_config);
    }
  else
    {
      if (save_cat_to_file (my_config->catalog_filename->str, my_config)
	  == -1)
	{
	  /*
	   * canceled = 1; 
	   */
	  ERROR_DIALOG ("Can't write file", my_config->window);
	}
    }
}

const gint
string_to_index (GPtrArray * a, gchar * s)
{
  gint i;
  gint result = 0;
  i = a->len;

  while (i > 0)
    {
      i--;
      if (strcmp (((GString *) (g_ptr_array_index (a, i)))->str, s) == 0)
	{
	  result = i + 1;
	  break;
	}
    }
  return (result);
}
