/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <config.h>
#include <gnome.h>
#include <fnmatch.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include "search.xpm"
#include "search.h"
#include "categories.h"
#include "date.h"
#include "config_common.h"
#include "compare.h"
#include "folder.h"
#include "io.h"
#include "interface.h"

static gchar ALL_CATEGORIES[] = N_("All");

GNode *
find_node_with_parent (GNode * parent, gchar * name,
		       gboolean case_sensitive, CONFIG * my_config)
{
  GNode *gntmp;
  GNode *result;
  FILE_DATA *fd;

  gntmp = g_node_first_sibling (parent);
  result = NULL;
  while ((result == NULL) && (gntmp))
    {
      fd =
	g_ptr_array_index (my_config->racine->datas,
			   GPOINTER_TO_UINT (gntmp->data));
      if (is_dir (my_config->racine, gntmp))
	{
	  if (compare (name, fd->name->str, TRUE, case_sensitive) == 0)
	    {
	      result = gntmp;
	    }
	  else
	    {
	      gntmp = g_node_next_sibling (gntmp);
	    }
	}
      else
	{
	  gntmp = g_node_next_sibling (gntmp);
	}
    }
  return (result);
}

gboolean
find_files (GNode * gn, gpointer data)
{
  CONFIG *my_config = data;
  SEARCH_WIDGETS *sw = my_config->search_widgets;
  SEARCH_OPTIONS *so =
    g_hash_table_lookup (my_config->stuff, "_search: SEARCH OPTIONS");

  const gchar *result[7];
  gint row;
  char *extension;
  PIX *pix;
  const gchar *tmpstr;
  gchar *nothing = " ";

  FILE_DATA *fd;
  if ((is_dir (my_config->racine, gn) && so->search_dirs) ||
      ((is_file (my_config->racine, gn) || (is_link (my_config->racine, gn)))
       && so->search_files))
    {
      fd =
	g_ptr_array_index (my_config->racine->datas,
			   GPOINTER_TO_UINT (gn->data));
      /* Compare names */
      if (compare
	  (so->filename, fd->name->str, so->regex,
	   so->case_sensitive)) return (FALSE);
      /* Compare categories */
      tmpstr = get_categorie (my_config, fd->categorie);
      if (strcmp (so->category, ALL_CATEGORIES))
	{
	  if (tmpstr)
	    {
	      if (compare (so->category, tmpstr, FALSE, FALSE))
		return (FALSE);
	    }
	  else
	    return (FALSE);
	}
      /* Compare descriptions */
      tmpstr = get_description (my_config, fd->description);
      if (strcmp (so->description, ".*"))
	{
	  if (tmpstr)
	    {
	      if (compare
		  (so->description, tmpstr,
		   so->regex, so->case_sensitive)) return (FALSE);
	    }
	  else
	    return (FALSE);
	}
      /* Compare information */
      if (fd->information)
	if (strcmp (so->infostring, ".*"))
	  if (compare
	      (so->infostring, fd->information->str, so->regex,
	       so->case_sensitive)) return (FALSE);

      /* Compare date */
      if (so->size1)
	if (fd->taille < so->size_val1)
	  return (FALSE);
      if (so->size2)
	if (fd->taille > so->size_val2)
	  return (FALSE);

      /* Compare size */
      if (so->date1)
	if (fd->date < sw->date_val1)
	  return (FALSE);
      if (so->date2)
	if (fd->date > sw->date_val2)
	  return (FALSE);



      result[0] = fd->name->str;
      result[1] = get_disk_from_node (gn, my_config->racine);
      result[2] = get_path_from_node (gn, my_config->racine)->str;
      result[3] = get_size (fd->taille);
      result[4] = get_time (fd->date);
      result[5] = get_categorie (my_config, fd->categorie);
      if (!result[5])
	result[5] = nothing;
      result[6] = get_description (my_config, fd->description);
      if (!result[6])
	result[6] = nothing;

      row = gtk_clist_append (GTK_CLIST (sw->search_list), (gchar **) result);
      /* pixmap depending on the extension */

      extension = fd->name->str;
      while (extension[0])
	extension++;
      while ((extension > fd->name->str) && (extension[0] != '.'))
	extension--;

      pix = ((PIX *) g_tree_lookup (my_config->icons, extension));
      if (!pix)
	{
	  pix = my_config->default_file_pix;
	}
      gtk_clist_set_pixtext (GTK_CLIST (sw->search_list), row, 0,
			     fd->name->str, 3, pix->pixmap, *(pix->mask));

      gtk_clist_set_row_data (GTK_CLIST (sw->search_list), row, gn);

    }
  return (FALSE);
}

void
start_search (SEARCH_WIDGETS * sw, SEARCH_OPTIONS * so, CONFIG * my_config)
{
  gtk_clist_clear (GTK_CLIST (sw->search_list));
  gtk_clist_freeze (GTK_CLIST (sw->search_list));

  g_node_traverse (so->search_root, G_PRE_ORDER, G_TRAVERSE_ALL, -1,
		   find_files, my_config);

  gtk_clist_sort (GTK_CLIST (sw->search_list));
  gtk_clist_thaw (GTK_CLIST (sw->search_list));
  gtk_notebook_set_page (GTK_NOTEBOOK (sw->notebook), 2);

}


void
start_extended_search (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  SEARCH_WIDGETS *sw = my_config->search_widgets;
  SEARCH_OPTIONS *so;
  gchar *disk;
  gchar *s_path, *spt, *spte, c;
  GNode *gntmp;

  /* read what the user entered */
  so = (SEARCH_OPTIONS *) g_malloc (sizeof (SEARCH_OPTIONS));
  so->filename = gtk_entry_get_text (GTK_ENTRY (sw->extended_search_entry));
  so->infostring = gtk_entry_get_text (GTK_ENTRY (sw->information_entry));
  disk = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (sw->disk_combo)->entry));
  s_path = gtk_entry_get_text (GTK_ENTRY (sw->s_path_entry));
  so->search_files = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON
						   (sw->check_search_file));
  so->search_dirs = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON
						  (sw->check_search_dir));
  so->case_sensitive =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON
				  (sw->check_case_sensitive));
  so->regex = TRUE;

  so->size1 =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (sw->checksize1));
  so->size2 =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (sw->checksize2));
  so->size_val1 =
    gtk_spin_button_get_value_as_int ((GtkSpinButton *) sw->size1);
  so->size_val2 =
    gtk_spin_button_get_value_as_int ((GtkSpinButton *) sw->size2);

  so->date1 =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (sw->checkdate1));
  so->date2 =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (sw->checkdate2));

  so->category =
    gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (sw->cat_combo)->entry));
  so->description = gtk_entry_get_text (GTK_ENTRY (sw->desc_entry));
  /* find root */

  so->search_root = NULL;
  if (strcmp (disk, ".*"))
    {
      so->search_root =
	find_node_with_parent (my_config->racine->tree, disk,
			       so->case_sensitive, my_config);
    }
  if (so->search_root == NULL)
    so->search_root = my_config->racine->tree;

  /* Find subdir */
  gntmp = NULL;
  if (strcmp (s_path, "/.*"))
    {
      spt = s_path;
      if (spt[0] == '/')
	{
	  gntmp = so->search_root;
	  while (gntmp && spt[0])
	    {
	      while (spt[0] == '/')
		spt++;
	      spte = spt;
	      while ((spte[0] != '/') && (spte[0]))
		spte++;
	      c = spte[0];
	      spte[0] = 0;
	      gntmp =
		find_node_with_parent (gntmp, spt, so->case_sensitive,
				       my_config);
	      spte[0] = c;
	      spt = spte;
	    }
	}
    }
  else
    {
      gntmp = my_config->racine->tree;
    }
  if (gntmp == NULL)
    {
      WARNING_DIALOG ("Invalid path.\nRoot directory will be used instead",
		      sw->search_dialog_window);
    }
  else
    {
      so->search_root = gntmp;
    }

  g_hash_table_insert (my_config->stuff, "_search: SEARCH OPTIONS", so);

  start_search (sw, so, my_config);
  g_hash_table_remove (my_config->stuff, "_search: SEARCH OPTIONS");
}


void
start_simple_search (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  SEARCH_WIDGETS *sw = my_config->search_widgets;
  SEARCH_OPTIONS *so;
  gchar *disk;
  gchar *s_path;

  /* read what the user entered */
  so = (SEARCH_OPTIONS *) g_malloc (sizeof (SEARCH_OPTIONS));
  so->filename = gtk_entry_get_text (GTK_ENTRY (sw->simple_search_entry));
  so->infostring = g_strdup (".*");
  disk = g_strdup (".*");
  s_path = g_strdup (".*");
  so->search_files = TRUE;
  so->search_dirs = TRUE;
  so->case_sensitive = FALSE;
  so->regex = TRUE;

  so->size1 = FALSE;
  so->size2 = FALSE;
  so->size_val1 = 0;
  so->size_val2 = 0;

  so->date1 = FALSE;
  so->date2 = FALSE;

  so->category = g_strdup (ALL_CATEGORIES);
  so->description = g_strdup (".*");
  /* find root */

  so->search_root = my_config->racine->tree;

  g_hash_table_insert (my_config->stuff, "_search: SEARCH OPTIONS", so);

  start_search (sw, so, my_config);

  g_hash_table_remove (my_config->stuff, "_search: SEARCH OPTIONS");
  g_free (so->infostring);
  g_free (disk);
  g_free (s_path);
  g_free (so->category);
  g_free (so->description);
}

static void
cancel_clicked (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  SEARCH_WIDGETS *sw = my_config->search_widgets;
  gtk_widget_destroy (sw->search_dialog_window);
  g_free (sw);
  return;
}

static void destroy_window(GtkWidget * w, GdkEventKey *event, gpointer data)
{
  cancel_clicked(w, data);
}

void
use_calendar1 (GtkWidget * w, gpointer data)
{
  struct tm *d;
  char buffer[256];
  SEARCH_WIDGETS *sw = data;
  d = open_calendar (GTK_WINDOW (sw->search_dialog_window));
  if (d)
    {
      sprintf (buffer, "%d.%d.%d", d->tm_mday, d->tm_mon + 1, d->tm_year);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (GTK_CHECK_BUTTON (sw->checkdate1)),
				    TRUE);


      sw->date_val1 = mktime (d);
      gtk_label_set (GTK_LABEL (sw->date1), buffer);
      g_free (d);
    }
}

void
use_calendar2 (GtkWidget * w, gpointer data)
{
  struct tm *d;
  char buffer[256];
  SEARCH_WIDGETS *sw = data;
  d = open_calendar (GTK_WINDOW (sw->search_dialog_window));
  if (d)
    {
      sprintf (buffer, "%d.%d.%d", d->tm_mday, d->tm_mon + 1, d->tm_year);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (GTK_CHECK_BUTTON (sw->checkdate2)),
				    TRUE);


      sw->date_val2 = mktime (d);
      gtk_label_set (GTK_LABEL (sw->date2), buffer);
      g_free (d);
    }
}

static void
selection_made (GtkWidget * clist, gint row, gint column,
		GdkEventButton * event, gpointer data)
{
  CONFIG *my_config = data;
  SEARCH_WIDGETS *sw = my_config->search_widgets;
  GNode *gn;
  gchar *rep;
  gchar *path;
  gchar *datas;
  gchar *name;
  gint8 pouet;
  GdkPixmap *da_pix;
  GdkBitmap *da_mask;



  if (event != NULL && event->button == 1 && event->type == GDK_2BUTTON_PRESS)
    {
      gtk_clist_get_pixtext (GTK_CLIST (clist), row, 0, &name, &pouet,
			     &da_pix, &da_mask);
      gn = gtk_clist_get_row_data ((GtkCList *) clist, row);

      gtk_clist_get_text (GTK_CLIST (sw->search_list), row, 1, &rep);
      gtk_clist_get_text (GTK_CLIST (sw->search_list), row, 2, &path);
      if (is_dir (my_config->racine, gn) == TRUE)
	{
	  datas =
	    (char *)
	    g_malloc ((strlen (rep) + strlen (path) + 5 + strlen (name)) *
		      sizeof (char));
	  sprintf (datas, "[%s]->%s%s/", rep, path, name);
	}
      else
	{
	  datas =
	    (char *) g_malloc ((strlen (rep) + strlen (path) + 5) *
			       sizeof (char));
	  sprintf (datas, "[%s]->%s", rep, path);
	}
      gtk_entry_set_text (GTK_ENTRY (my_config->path_entry), datas);
      g_free (datas);
      if (is_file (my_config->racine, gn) == FALSE)
	{
	  list_folder (gn, my_config);
	}
      else
	{
	  list_folder (gn->parent, my_config);
	}
    }
  else
    {
      gn = gtk_clist_get_row_data ((GtkCList *) clist, row);
      my_config->selected_folder = gn;
    }
}


static void
unselection_made (GtkWidget * clist, gint row, gint column,
		  GdkEventButton * event, CONFIG * my_config)
{
  my_config->selected_folder = NULL;
}


void
sort_list (GtkWidget * wid, gint column, gpointer data)
{
  CONFIG *my_config = data;
  SEARCH_WIDGETS *sw = my_config->search_widgets;

  my_config->selected_folder = NULL;
  /* FIXME: column 3 is numeric, and column 4 is a date. Sorting method is different!!! */
  gtk_clist_set_sort_column (GTK_CLIST (sw->search_list), (gint) column);
  gtk_clist_sort (GTK_CLIST (sw->search_list));
}


void
create_search_dialog (GtkWidget * w, gpointer data)
{
  GtkWidget *frame, *frame2;
  GtkWidget *ok_button;
  GtkWidget *cancel_button;
  GtkWidget *image;
  GtkWidget *vbox;
  GtkWidget *hbox, *hbox2, *hbox3;
  GtkWidget *button;
  GtkAdjustment *adj;
  static GtkStyle *style;
  static GdkPixmap *logo_pixmap;
  static GdkBitmap *logo_mask;
  GList *disk_list, *cat_list;
  SEARCH_WIDGETS *sw;
  gchar *titles[7] =
    { N_("File"), N_("Disk"), N_("Path"), N_("Size"), N_("Date"),
    N_("Category"), N_("Description")
  };
  CONFIG *my_config = data;

  sw = (SEARCH_WIDGETS *) g_malloc (sizeof (SEARCH_WIDGETS));
  my_config->search_widgets = sw;

  sw->search_dialog_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize (GTK_WIDGET (sw->search_dialog_window), 650, 330);
  gtk_window_set_position (GTK_WINDOW (sw->search_dialog_window),
			   GTK_WIN_POS_MOUSE);
  gtk_window_set_title (GTK_WINDOW (sw->search_dialog_window), "Search");
  gtk_window_set_policy (GTK_WINDOW (sw->search_dialog_window), FALSE, FALSE,
			 TRUE);
  gtk_container_border_width (GTK_CONTAINER (sw->search_dialog_window), 10);
  gtk_signal_connect (GTK_OBJECT (sw->search_dialog_window), "delete_event",
		      destroy_window, my_config);
  gtk_grab_add (sw->search_dialog_window);

  sw->notebook = gtk_notebook_new ();
  gtk_container_add (GTK_CONTAINER (sw->search_dialog_window), sw->notebook);

  if (logo_pixmap == NULL)
    {
      gtk_widget_realize (sw->search_dialog_window);
      style = gtk_widget_get_style (sw->search_dialog_window);
      logo_pixmap =
	gdk_pixmap_create_from_xpm_d (sw->search_dialog_window->window,
				      &logo_mask,
				      &style->bg[GTK_STATE_NORMAL],
				      (gchar **) search_xpm);
      gtk_widget_unrealize (sw->search_dialog_window);
    }

  vbox = gtk_vbox_new (TRUE, 5);
  gtk_notebook_append_page (GTK_NOTEBOOK (sw->notebook), vbox,
			    gtk_label_new (_("Search")));
  gtk_widget_show (vbox);


  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);

  frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame), _("Search file"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  hbox3 = gtk_hbox_new (TRUE, 5);
  gtk_container_add (GTK_CONTAINER (frame), hbox3);
  gtk_widget_show (hbox3);


  frame2 = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame2), "File name");
  gtk_frame_set_label_align (GTK_FRAME (frame2), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame2), GTK_SHADOW_ETCHED_OUT);

  gtk_box_pack_start (GTK_BOX (hbox3), frame2, TRUE, TRUE, 0);
  gtk_widget_show (frame2);

  sw->simple_search_entry = gtk_entry_new_with_max_length (100);
  gtk_signal_connect (GTK_OBJECT (sw->simple_search_entry), "activate",
		      GTK_SIGNAL_FUNC (start_simple_search), my_config);
  gtk_entry_set_text (GTK_ENTRY (sw->simple_search_entry), ".*");
  gtk_container_add (GTK_CONTAINER (frame2), sw->simple_search_entry);
  gtk_widget_show (sw->simple_search_entry);


  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  ok_button = gtk_button_new_with_label (_("Ok"));
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
		      start_simple_search, my_config);
  gtk_box_pack_start (GTK_BOX (hbox), ok_button, TRUE, TRUE, 0);
  gtk_widget_show (ok_button);

  cancel_button = gtk_button_new_with_label (_("Cancel"));
  gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
		      cancel_clicked, my_config);
  gtk_box_pack_start (GTK_BOX (hbox), cancel_button, TRUE, TRUE, 0);
  gtk_widget_show (cancel_button);








  vbox = gtk_vbox_new (TRUE, 5);
  gtk_notebook_append_page (GTK_NOTEBOOK (sw->notebook), vbox,
			    gtk_label_new (_("Extended search")));
  gtk_widget_show (vbox);


  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);

  frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame), _("Search file"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  hbox3 = gtk_hbox_new (TRUE, 5);
  gtk_container_add (GTK_CONTAINER (frame), hbox3);
  gtk_widget_show (hbox3);


  frame2 = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame2), "File name");
  gtk_frame_set_label_align (GTK_FRAME (frame2), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame2), GTK_SHADOW_ETCHED_OUT);

  gtk_box_pack_start (GTK_BOX (hbox3), frame2, TRUE, TRUE, 0);
  gtk_widget_show (frame2);

  sw->extended_search_entry = gtk_entry_new_with_max_length (100);
  gtk_signal_connect (GTK_OBJECT (sw->extended_search_entry), "activate",
		      GTK_SIGNAL_FUNC (start_extended_search), my_config);
  gtk_entry_set_text (GTK_ENTRY (sw->extended_search_entry), ".*");
  gtk_container_add (GTK_CONTAINER (frame2), sw->extended_search_entry);
  gtk_widget_show (sw->extended_search_entry);


  frame2 = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame2), _("Disk"));
  gtk_frame_set_label_align (GTK_FRAME (frame2), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame2), GTK_SHADOW_ETCHED_OUT);

  gtk_box_pack_start (GTK_BOX (hbox3), frame2, TRUE, TRUE, 0);
  gtk_widget_show (frame2);

  sw->disk_combo = gtk_combo_new ();
  gtk_combo_set_value_in_list (GTK_COMBO (sw->disk_combo), FALSE, TRUE);
  gtk_combo_set_use_arrows_always (GTK_COMBO (sw->disk_combo), TRUE);
  gtk_combo_disable_activate (GTK_COMBO (sw->disk_combo));


  disk_list = make_disk_list (my_config);
  disk_list = g_list_prepend (disk_list, ".*");

  gtk_combo_set_popdown_strings (GTK_COMBO (sw->disk_combo), disk_list);
  g_list_free (disk_list);
  gtk_container_add (GTK_CONTAINER (frame2), sw->disk_combo);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (sw->disk_combo)->entry), ".*");
  gtk_signal_connect (GTK_OBJECT (GTK_COMBO (sw->disk_combo)->entry),
		      "activate", GTK_SIGNAL_FUNC (start_extended_search),
		      my_config);
  gtk_widget_show (sw->disk_combo);

  frame2 = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame2), "Path");
  gtk_frame_set_label_align (GTK_FRAME (frame2), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame2), GTK_SHADOW_ETCHED_OUT);

  gtk_box_pack_start (GTK_BOX (hbox3), frame2, TRUE, TRUE, 0);
  gtk_widget_show (frame2);

  sw->s_path_entry = gtk_entry_new_with_max_length (100);
  gtk_signal_connect (GTK_OBJECT (sw->s_path_entry), "activate",
		      GTK_SIGNAL_FUNC (start_extended_search), my_config);
  gtk_entry_set_text (GTK_ENTRY (sw->s_path_entry), "/.*");

  gtk_container_add (GTK_CONTAINER (frame2), sw->s_path_entry);
  gtk_widget_show (sw->s_path_entry);


  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);

  frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame), _("Category"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  sw->cat_combo = gtk_combo_new ();
  gtk_combo_set_value_in_list (GTK_COMBO (sw->cat_combo), FALSE, TRUE);
  gtk_combo_set_use_arrows_always (GTK_COMBO (sw->cat_combo), TRUE);
  gtk_combo_disable_activate (GTK_COMBO (sw->cat_combo));
  cat_list = make_categories_list (my_config);
  cat_list = g_list_append (cat_list, ALL_CATEGORIES);
  gtk_combo_set_popdown_strings (GTK_COMBO (sw->cat_combo), cat_list);
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (sw->cat_combo)->entry),
			  FALSE);
  gtk_container_add (GTK_CONTAINER (frame), sw->cat_combo);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (sw->cat_combo)->entry), _("All"));
  gtk_signal_connect (GTK_OBJECT (GTK_COMBO (sw->cat_combo)->entry),
		      "activate", start_extended_search, my_config);
  gtk_widget_show (sw->cat_combo);



  frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame), _("Description"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);


  sw->desc_entry = gtk_entry_new_with_max_length (DEFINITION_MAX_LENGTH);
  gtk_signal_connect (GTK_OBJECT (sw->desc_entry), "activate",
		      GTK_SIGNAL_FUNC (start_extended_search), my_config);
  gtk_entry_set_text (GTK_ENTRY (sw->desc_entry), ".*");
  gtk_container_add (GTK_CONTAINER (frame), sw->desc_entry);
  gtk_widget_show (sw->desc_entry);


  frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame), _("Information"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  sw->information_entry =
    gtk_entry_new_with_max_length (INFORMATION_MAX_LENGTH);
  gtk_signal_connect (GTK_OBJECT (sw->information_entry), "activate",
		      GTK_SIGNAL_FUNC (start_extended_search), my_config);
  gtk_entry_set_text (GTK_ENTRY (sw->information_entry), ".*");
  gtk_container_add (GTK_CONTAINER (frame), sw->information_entry);
  gtk_widget_show (sw->information_entry);




  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);


  frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame), _("Date"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  hbox2 = gtk_hbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (frame), hbox2);
  gtk_widget_show (hbox2);

  sw->checkdate1 = gtk_check_button_new_with_label (_("From:"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sw->checkdate1), FALSE);
  gtk_box_pack_start (GTK_BOX (hbox2), sw->checkdate1, FALSE, FALSE, 0);
  gtk_widget_show (sw->checkdate1);


  button = gtk_button_new ();
  gtk_signal_connect (GTK_OBJECT (button), "clicked", use_calendar1, sw);
  gtk_box_pack_start (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
  gtk_widget_show (button);


  sw->date1 = gtk_label_new ("--.--.----");
  gtk_container_add (GTK_CONTAINER (button), sw->date1);
  gtk_widget_show (sw->date1);
  sw->date_val1 = 0;


  sw->checkdate2 = gtk_check_button_new_with_label (_("To:"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sw->checkdate2), FALSE);
  gtk_box_pack_start (GTK_BOX (hbox2), sw->checkdate2, FALSE, FALSE, 0);
  gtk_widget_show (sw->checkdate2);


  button = gtk_button_new ();
  gtk_signal_connect (GTK_OBJECT (button), "clicked", use_calendar2, sw);
  gtk_box_pack_start (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
  gtk_widget_show (button);

  sw->date2 = gtk_label_new ("--.--.----");
  gtk_container_add (GTK_CONTAINER (button), sw->date2);
  gtk_widget_show (sw->date2);
  sw->date_val2 = 0;



  frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame), _("Size (in Byte)"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  hbox2 = gtk_hbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (frame), hbox2);
  gtk_widget_show (hbox2);

  sw->checksize1 = gtk_check_button_new_with_label (_("From:"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sw->checksize1), FALSE);
  gtk_box_pack_start (GTK_BOX (hbox2), sw->checksize1, FALSE, FALSE, 0);
  gtk_widget_show (sw->checksize1);

  adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, 1000000000, 10, 100, 0);

  sw->size1 = gtk_spin_button_new (adj, 1.0, 2);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (sw->size1), TRUE);
  gtk_widget_set_usize (sw->size1, 100, 0);
  gtk_box_pack_start (GTK_BOX (hbox2), sw->size1, FALSE, TRUE, 0);
  gtk_spin_button_set_numeric ((GtkSpinButton *) sw->size1, TRUE);
  gtk_spin_button_set_digits (GTK_SPIN_BUTTON (sw->size1), 0);
  gtk_widget_show (sw->size1);


  sw->checksize2 = gtk_check_button_new_with_label (_("To:"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sw->checksize2), FALSE);
  gtk_box_pack_start (GTK_BOX (hbox2), sw->checksize2, FALSE, FALSE, 0);
  gtk_widget_show (sw->checksize2);

  adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, 1000000000, 5, 100, 0);

  sw->size2 = gtk_spin_button_new (adj, 1.0, 2);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (sw->size2), TRUE);
  gtk_widget_set_usize (sw->size2, 100, 0);
  gtk_box_pack_start (GTK_BOX (hbox2), sw->size2, FALSE, TRUE, 0);
  gtk_spin_button_set_numeric ((GtkSpinButton *) sw->size2, TRUE);
  gtk_spin_button_set_digits (GTK_SPIN_BUTTON (sw->size2), 0);
  gtk_widget_show (sw->size2);


  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);


  image = gtk_pixmap_new (logo_pixmap, logo_mask);
  gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);
  gtk_widget_show (image);

  sw->check_search_file = gtk_check_button_new_with_label (_("Search File"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sw->check_search_file),
				TRUE);
  gtk_box_pack_start (GTK_BOX (hbox), sw->check_search_file, FALSE, FALSE, 0);
  gtk_widget_show (sw->check_search_file);

  sw->check_search_dir = gtk_check_button_new_with_label (_("Search Folder"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sw->check_search_dir),
				TRUE);
  gtk_box_pack_start (GTK_BOX (hbox), sw->check_search_dir, FALSE, FALSE, 0);
  gtk_widget_show (sw->check_search_dir);

  sw->check_case_sensitive =
    gtk_check_button_new_with_label (_("Case sensitive"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sw->check_case_sensitive),
				FALSE);
  gtk_box_pack_start (GTK_BOX (hbox), sw->check_case_sensitive, FALSE, FALSE,
		      0);
  gtk_widget_show (sw->check_case_sensitive);

  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  ok_button = gtk_button_new_with_label (_("Ok"));
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
		      start_extended_search, my_config);
  gtk_box_pack_start (GTK_BOX (hbox), ok_button, TRUE, TRUE, 0);
  gtk_widget_show (ok_button);

  cancel_button = gtk_button_new_with_label (_("Cancel"));
  gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
		      cancel_clicked, my_config);
  gtk_box_pack_start (GTK_BOX (hbox), cancel_button, TRUE, TRUE, 0);
  gtk_widget_show (cancel_button);

  /* Result part (empty at the beginning) */
  vbox = gtk_vbox_new (FALSE, 5);
  gtk_widget_show (vbox);
  gtk_notebook_append_page (GTK_NOTEBOOK (sw->notebook), vbox,
			    gtk_label_new (_("Results")));

  sw->scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw->scrolled_window),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (vbox), sw->scrolled_window, TRUE, TRUE, 0);
  gtk_widget_show (sw->scrolled_window);

  sw->search_list = gtk_clist_new_with_titles (7, titles);
  gtk_signal_connect (GTK_OBJECT (sw->search_list), "select_row",
		      GTK_SIGNAL_FUNC (selection_made), my_config);
  gtk_signal_connect (GTK_OBJECT (sw->search_list), "unselect_row",
		      GTK_SIGNAL_FUNC (unselection_made), my_config);

  gtk_clist_set_shadow_type (GTK_CLIST (sw->search_list), GTK_SHADOW_OUT);
  gtk_clist_set_column_width (GTK_CLIST (sw->search_list), 0, 165);
  gtk_clist_set_column_width (GTK_CLIST (sw->search_list), 1, 50);
  gtk_clist_set_column_width (GTK_CLIST (sw->search_list), 2, 150);
  gtk_clist_set_column_width (GTK_CLIST (sw->search_list), 3, 50);
  gtk_clist_set_column_width (GTK_CLIST (sw->search_list), 4, 50);
  gtk_clist_set_column_width (GTK_CLIST (sw->search_list), 5, 75);
  gtk_clist_set_column_auto_resize (GTK_CLIST (sw->search_list), 6, TRUE);
  gtk_container_add (GTK_CONTAINER (sw->scrolled_window), sw->search_list);

  gtk_signal_connect (GTK_OBJECT (sw->search_list), "button_press_event",
		      GTK_SIGNAL_FUNC (clist_pressed), my_config);
  gtk_signal_connect (GTK_OBJECT (sw->search_list), "click_column",
		      GTK_SIGNAL_FUNC (sort_list), my_config);

  cancel_button = gtk_button_new_with_label (_("Cancel"));
  gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
		      cancel_clicked, my_config);
  gtk_box_pack_start (GTK_BOX (vbox), cancel_button, FALSE, TRUE, 0);
  gtk_widget_show (cancel_button);

  gtk_widget_show (sw->search_list);

  gtk_widget_show (sw->notebook);
  gtk_widget_show (sw->search_dialog_window);
  gtk_notebook_set_page (GTK_NOTEBOOK (sw->notebook), 0);
}
