/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __SEARCH_H__
#define __SEARCH_H__

#include <config.h>
#include <gnome.h>
#include <time.h>
/*#include "data.h"*/
#include "config_common.h"

typedef struct
{
  unsigned char val;
  FOLDER *folder;
  char *data[7];		//cotient toutes les infos de Folder en char
}
search_info;

typedef struct
{
  GtkWidget *search_dialog_window;
  GtkWidget *notebook;
  GtkWidget *simple_search_entry;
  GtkWidget *extended_search_entry;
  GtkWidget *cat_combo;
  GtkWidget *information_entry;
  GtkWidget *desc_entry;
  GtkWidget *disk_combo;
  GtkWidget *s_path_entry;
  GtkWidget *checkdate1;
  GtkWidget *checkdate2;
  GtkWidget *date1;
  GtkWidget *date2;
  time_t date_val1;
  time_t date_val2;
  GtkWidget *checksize1;
  GtkWidget *checksize2;
  GtkWidget *size1;
  GtkWidget *size2;
  GtkWidget *check_search_file;
  GtkWidget *check_search_dir;
  GtkWidget *check_case_sensitive;
  GtkWidget *scrolled_window;
  GtkWidget *search_list;
}
SEARCH_WIDGETS;

typedef struct
{
  gboolean case_sensitive;
  gchar *filename;
  GNode *search_root;
  gboolean regex;
  gchar *infostring;
  gchar *description;
  gchar *category;
  gboolean search_files;
  gboolean search_dirs;
  gboolean size1;
  gboolean size2;
  gint size_val1;
  gint size_val2;
  gboolean date1;
  gboolean date2;
  gint date_val1;
  gint date_val2;
}
SEARCH_OPTIONS;

GNode *find_node_with_parent(GNode *parent, gchar *name, gboolean case_sensitive, CONFIG *my_config);
gboolean find_files(GNode *gn, gpointer data);
void start_search(SEARCH_WIDGETS *sw, SEARCH_OPTIONS *so, CONFIG *my_config);
void start_extended_search(GtkWidget *w, gpointer data);
void start_simple_search(GtkWidget *w, gpointer data);
void use_calendar1(GtkWidget *w, gpointer data);
void use_calendar2(GtkWidget *w, gpointer data);
void sort_list(GtkWidget *wid, gint column, gpointer data);
void create_search_dialog(GtkWidget *w, gpointer data);

#endif
