/*  NCatalog , the GTKtalog ncurses GUI.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "searchbox.h"
#include "search.h"
#include "text.h"
#include "data.h"
#include "test.priv.h"
#include <ctype.h>
#include <term.h>
#include <string.h>


extern int hauteur;
extern int largeur;
extern char *help;

WINDOW *file_pad;
WINDOW *size_pad;
WINDOW *date_pad;
WINDOW *cat_pad;
WINDOW *desc_pad;

Folder *curent_folder;
int file_pad_size;
int size_pad_size;
int date_pad_size;
int cat_pad_size;
int desc_pad_size;
int selected;
int last_selected;
int decalage;
char *path;

char *blanck_line;

char resize_pad;

int is_racine(Folder *folder)
{
  if(folder->nb_folders > 0)
    {
      if(folder->folders[0].type == 1) return(0);
      else return -1;
    }
  return -1;
}

char *mycopy(char *dest,char *source,int size)
{
  strncpy(dest,source,size);
  dest[size] = '\0';
  return(dest);
}

void put_line(WINDOW *pad, int pos)
{
  wvline( pad, ACS_VLINE,  pos);
  wbkgd(pad, A_REVERSE);
  prefresh(pad,3,0,3,pos,3,pos);
  wbkgd(pad, A_NORMAL);
  prefresh(pad,4,0,4,pos,hauteur-3,pos);
}


void blanck_pad(WINDOW *pad)
{
  int i;
  
  for(i=0;i<(hauteur -6);i++) mvwaddstr(pad,i , 0, blanck_line);  
}


void update_browser_description(WINDOW *parent_pad,Folder *folder,int update)
{
 // WINDOW *pad;
  int i;
  int back;//donne la valeur du decalage si 1, on est a la racine, si 2, on est au moins dans un disque
  int old_decalage; 
  char *data;

 // cat_pad = subpad(parent_pad,hauteur -5,cat_pad_size,3,file_pad_size+3+size_pad_size+date_pad_size);
  data = (char *)malloc((desc_pad_size+1)*sizeof(char));
  old_decalage = decalage;
 
  if(is_racine(folder) != 0)
    {
      back = 2;
      while(selected -decalage +back> hauteur -6) decalage = decalage +5;
      while(selected -decalage <0) decalage = decalage -5; 
      if((decalage + hauteur -6) > (folder->nb_files +folder->nb_folders)) decalage = folder->nb_files +folder->nb_folders -hauteur +6; 
     if(decalage < -1) decalage = -1; 
    }
  else
    {
      back = 1;
      while(selected -decalage +back> hauteur -6) decalage = decalage +5;
      while(selected -decalage <0) decalage = decalage -5; 
      if((decalage + hauteur -6) > (folder->nb_files +folder->nb_folders)) decalage = folder->nb_files +folder->nb_folders -hauteur +6;
      if(decalage < 0) decalage = 0;
    }

  if ((decalage != old_decalage)||(update == 1))
    {
     // wclear (desc_pad);// a faire que quand decalage change. 
      blanck_pad(desc_pad);
      wbkgd(desc_pad, A_REVERSE);
      mvwaddstr(desc_pad,0 , 0, " Decsription");
      prefresh(desc_pad,0,0,3,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size,3,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size+desc_pad_size);
      wbkgd(desc_pad, A_NORMAL);

      for(i=(1 -back);i<hauteur -6;i++)
	{
	  if((i == -1)&&(decalage == -1))
	    {
	      mvwaddstr(desc_pad,i +back, 0, " ");
	      prefresh(desc_pad,i+back,0,i+3+back,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size,i+3+back+hauteur -6,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size+desc_pad_size);
	    }
	  else if((i+decalage) < (folder->nb_folders +1-back))
	    mvwaddstr(desc_pad,i +back, 0, mycopy(data,descriptions[folder->folders[i+decalage+back -1].description],desc_pad_size));
	  else if((i+decalage) < (folder->nb_folders +folder->nb_files -1))
	    {
	      if((folder->files[i+decalage-folder->nb_folders +back -1].description == 0)&&(folder->files[i+decalage-folder->nb_folders +back -1].information != NULL))
		mvwaddstr(desc_pad,i +back, 0,mycopy(data,folder->files[i+decalage-folder->nb_folders +back -1].information,desc_pad_size));
	      else
		mvwaddstr(desc_pad,i +back, 0, mycopy(data,descriptions[folder->files[i+decalage-folder->nb_folders +back -1].description],desc_pad_size));
	    }
	}
      wbkgd(desc_pad, A_BOLD); 
      if(decalage < folder->nb_folders)
	{
	  prefresh(desc_pad,1,0,4,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size,3+folder->nb_folders -decalage,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size+desc_pad_size);
	}
	wbkgd(desc_pad, A_NORMAL); 
     if((folder->nb_folders < (decalage + hauteur -6))&&(folder->nb_folders > decalage))
	{
	  prefresh(desc_pad,folder->nb_folders -decalage +1,0,4+(folder->nb_folders-decalage),file_pad_size +5+size_pad_size+date_pad_size+cat_pad_size,hauteur -3,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size+desc_pad_size);
	}
      else if(folder->nb_folders < (decalage + hauteur -6)) 
	{
	  prefresh(desc_pad,back -1,0,4,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size,hauteur -3,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size+desc_pad_size);
	}
    }


  //on surligne le fichier slctionn. et on retire l'ancien
  if(last_selected == -1)
    {
      back = 1;
      wbkgd(desc_pad, A_BOLD);
      mvwaddstr(desc_pad,last_selected -decalage +back, 0, " ");
      prefresh(desc_pad,last_selected -decalage +back,0,last_selected -decalage +3 +back,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size,last_selected -decalage+3 +back,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size+desc_pad_size); 
    }
  else if (last_selected < folder->nb_folders)
    {
      back = 1;
      wbkgd(desc_pad, A_BOLD);
      mvwaddstr(desc_pad,last_selected -decalage +back, 0, descriptions[folder->folders[last_selected].description]);
      prefresh(desc_pad,last_selected -decalage +back,0,last_selected -decalage +3 +back,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size,last_selected -decalage+3 +back,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size+desc_pad_size);
    }
  else
    {
      back = 1;
      wbkgd(desc_pad, A_NORMAL);
      if((folder->files[last_selected -folder->nb_folders].description == 0)&&(folder->files[last_selected -folder->nb_folders].information != NULL))
	{
	  mvwaddstr(desc_pad,last_selected -decalage +back, 0, mycopy(data,folder->files[last_selected -folder->nb_folders].information,desc_pad_size));
	}
      else mvwaddstr(desc_pad,last_selected -decalage +back, 0, mycopy(data,descriptions[folder->files[last_selected -folder->nb_folders].description],desc_pad_size));
      prefresh(desc_pad,last_selected -decalage +back,0,last_selected -decalage +3 +back,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size,last_selected -decalage+3 +back,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size+desc_pad_size); 
    }


  if(selected == -1)
    {
      back = 1;
      wbkgd(desc_pad, A_REVERSE);
      mvwaddstr(desc_pad,selected -decalage +back, 0, " ");
      prefresh(desc_pad,selected -decalage +back,0,selected -decalage +3 +back,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size,selected -decalage+3 +back,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size+desc_pad_size); 
    }
  else if (selected < folder->nb_folders)
    {
      back = 1;
      wbkgd(desc_pad, A_REVERSE);
      mvwaddstr(desc_pad,selected -decalage +back, 0,mycopy(data,descriptions[folder->folders[selected].description],desc_pad_size));
      prefresh(desc_pad,selected -decalage +back,0,selected -decalage +3 +back,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size,selected -decalage+3 +back,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size+desc_pad_size);
    }
  else
    {
      back = 1;
      wbkgd(desc_pad, A_REVERSE);
      if((folder->files[selected -folder->nb_folders].description == 0)&&(folder->files[selected -folder->nb_folders].information != NULL))
	{
	  mvwaddstr(desc_pad,selected -decalage +back, 0, mycopy(data,folder->files[selected -folder->nb_folders].information,desc_pad_size));
	}
      else mvwaddstr(desc_pad,selected -decalage +back, 0, mycopy(data,descriptions[folder->files[selected -folder->nb_folders].description],desc_pad_size));
      prefresh(desc_pad,selected -decalage +back,0,selected -decalage +3 +back,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size,selected -decalage+3 +back,file_pad_size+5+size_pad_size+date_pad_size+cat_pad_size+desc_pad_size); 
    }
  last_selected = selected;
}






void update_browser_categorie(WINDOW *parent_pad,Folder *folder,int update)
{
 // WINDOW *pad;
  int i;
  int back;//donne la valeur du decalage si 1, on est a la racine, si 2, on est au moins dans un disque
  int old_decalage; 
  char *data;
 // cat_pad = subpad(parent_pad,hauteur -5,cat_pad_size,3,file_pad_size+3+size_pad_size+date_pad_size);
 
  old_decalage = decalage;
  data = (char *)malloc((cat_pad_size +1)*sizeof(char));

  if(is_racine(folder) != 0)
    {
      back = 2;
      while(selected -decalage +back> hauteur -6) decalage = decalage +5;
      while(selected -decalage <0) decalage = decalage -5; 
      if((decalage + hauteur -6) > (folder->nb_files +folder->nb_folders)) decalage = folder->nb_files +folder->nb_folders -hauteur +6; 
     if(decalage < -1) decalage = -1; 
    }
  else
    {
      back = 1;
      while(selected -decalage +back> hauteur -6) decalage = decalage +5;
      while(selected -decalage <0) decalage = decalage -5; 
      if((decalage + hauteur -6) > (folder->nb_files +folder->nb_folders)) decalage = folder->nb_files +folder->nb_folders -hauteur +6;
      if(decalage < 0) decalage = 0;
    }

  if ((decalage != old_decalage)||(update == 1))
    {
     // wclear (cat_pad);// a faire que quand decalage change. 
      blanck_pad(cat_pad);
      wbkgd(cat_pad, A_REVERSE);
      mvwaddstr(cat_pad,0 , 0, "  Category");
      prefresh(cat_pad,0,0,3,file_pad_size+4+size_pad_size+date_pad_size,3,file_pad_size+4+size_pad_size+date_pad_size+cat_pad_size);

      wbkgd(cat_pad, A_NORMAL);

      for(i=(1 -back);i<hauteur -6;i++)
	{
	  if((i == -1)&&(decalage == -1))
	    {
	      mvwaddstr(cat_pad,i +back, 0, " ");
	      prefresh(cat_pad,i+back,0,i+3+back,file_pad_size+4+size_pad_size+date_pad_size,i+3+back+hauteur -6,file_pad_size+4+size_pad_size+date_pad_size+cat_pad_size);
	    }
	  else if((i+decalage) < (folder->nb_folders +1-back))
	    mvwaddstr(cat_pad,i +back, 0, mycopy(data,categories[folder->folders[i+decalage+back -1].categorie],cat_pad_size));
	  else if((i+decalage) < (folder->nb_folders +folder->nb_files -1))
	    mvwaddstr(cat_pad,i +back, 0, mycopy(data,categories[folder->files[i+decalage-folder->nb_folders +back -1].categorie],cat_pad_size));
	}
        wbkgd(cat_pad, A_BOLD); 
      if(decalage < folder->nb_folders) 
	prefresh(cat_pad,1,0,4,file_pad_size+4+size_pad_size+date_pad_size,3+folder->nb_folders -decalage,file_pad_size+4+size_pad_size+date_pad_size+cat_pad_size);
      wbkgd(cat_pad, A_NORMAL); 
     if((folder->nb_folders < (decalage + hauteur -6))&&(folder->nb_folders > decalage))
	{
	  prefresh(cat_pad,folder->nb_folders -decalage +1,0,4+(folder->nb_folders-decalage),file_pad_size +4+size_pad_size+date_pad_size,hauteur -3,file_pad_size+4+size_pad_size+date_pad_size+cat_pad_size);
	}
      else if(folder->nb_folders < (decalage + hauteur -6)) 
	{
	  prefresh(cat_pad,back -1,0,4,file_pad_size+4+size_pad_size+date_pad_size,hauteur -3,file_pad_size+4+size_pad_size+date_pad_size+cat_pad_size);
	}
    }


  //on surligne le fichier slctionn. et on retire l'ancien
  if(last_selected == -1)
    {
      back = 1;
      wbkgd(cat_pad, A_BOLD);
      mvwaddstr(cat_pad,last_selected -decalage +back, 0, " ");
      prefresh(cat_pad,last_selected -decalage +back,0,last_selected -decalage +3 +back,file_pad_size+4+size_pad_size+date_pad_size,last_selected -decalage+3 +back,file_pad_size+4+size_pad_size+date_pad_size+cat_pad_size); 
    }
  else if (last_selected < folder->nb_folders)
    {
      back = 1;
      wbkgd(cat_pad, A_BOLD);
      mvwaddstr(cat_pad,last_selected -decalage +back, 0, mycopy(data,categories[folder->folders[last_selected].categorie],cat_pad_size));
      prefresh(cat_pad,last_selected -decalage +back,0,last_selected -decalage +3 +back,file_pad_size+4+size_pad_size+date_pad_size,last_selected -decalage+3 +back,file_pad_size+4+size_pad_size+date_pad_size+cat_pad_size);
    }
  else
    {
      back = 1;
      wbkgd(cat_pad, A_NORMAL);
      mvwaddstr(cat_pad,last_selected -decalage +back, 0, mycopy(data,categories[folder->files[last_selected -folder->nb_folders].categorie],cat_pad_size));
      prefresh(cat_pad,last_selected -decalage +back,0,last_selected -decalage +3 +back,file_pad_size+4+size_pad_size+date_pad_size,last_selected -decalage+3 +back,file_pad_size+4+size_pad_size+date_pad_size+cat_pad_size); 
    }


  if(selected == -1)
    {
      back = 1;
      wbkgd(cat_pad, A_REVERSE);
      mvwaddstr(cat_pad,selected -decalage +back, 0, " ");
      prefresh(cat_pad,selected -decalage +back,0,selected -decalage +3 +back,file_pad_size+4+size_pad_size+date_pad_size,selected -decalage+3 +back,file_pad_size+4+size_pad_size+date_pad_size+cat_pad_size); 
    }
  else if (selected < folder->nb_folders)
    {
      back = 1;
      wbkgd(cat_pad, A_REVERSE);
      mvwaddstr(cat_pad,selected -decalage +back, 0,mycopy(data,categories[folder->folders[selected].categorie],cat_pad_size));
      prefresh(cat_pad,selected -decalage +back,0,selected -decalage +3 +back,file_pad_size+4+size_pad_size+date_pad_size,selected -decalage+3 +back,file_pad_size+4+size_pad_size+date_pad_size+cat_pad_size);
    }
  else
    {
      back = 1;
      wbkgd(cat_pad, A_REVERSE);
      mvwaddstr(cat_pad,selected -decalage +back, 0, mycopy(data,categories[folder->files[selected -folder->nb_folders].categorie],cat_pad_size));
      prefresh(cat_pad,selected -decalage +back,0,selected -decalage +3 +back,file_pad_size+4+size_pad_size+date_pad_size,selected -decalage+3 +back,file_pad_size+4+size_pad_size+date_pad_size+cat_pad_size); 
    }
  // last_selected = selected;
  decalage = old_decalage;
}





void update_browser_date(WINDOW *parent_pad,Folder *folder,int update)
{
 // WINDOW *pad;
  int i;
  int back;//donne la valeur du decalage si 1, on est a la racine, si 2, on est au moins dans un disque
  int old_decalage; 
  char *data;
 // date_pad = subpad(parent_pad,hauteur -5,date_pad_size,3,file_pad_size+3+size_pad_size+date_pad_size);
 
  old_decalage = decalage;
  data = (char *)malloc((date_pad_size +1)*sizeof(char));
  if(is_racine(folder) != 0)
    {
      back = 2;
      while(selected -decalage +back> hauteur -6) decalage = decalage +5;
      while(selected -decalage <0) decalage = decalage -5; 
      if((decalage + hauteur -6) > (folder->nb_files +folder->nb_folders)) decalage = folder->nb_files +folder->nb_folders -hauteur +6; 
     if(decalage < -1) decalage = -1; 
    }
  else
    {
      back = 1;
      while(selected -decalage +back> hauteur -6) decalage = decalage +5;
      while(selected -decalage <0) decalage = decalage -5; 
      if((decalage + hauteur -6) > (folder->nb_files +folder->nb_folders)) decalage = folder->nb_files +folder->nb_folders -hauteur +6;
      if(decalage < 0) decalage = 0;
    }

  if ((decalage != old_decalage)||(update == 1))
    {
     // wclear (date_pad);// a faire que quand decalage change.
      blanck_pad(date_pad); 
      wbkgd(date_pad, A_REVERSE);
      mvwaddstr(date_pad,0 , 0, "  Date");
      prefresh(date_pad,0,0,3,file_pad_size+3+size_pad_size,3,file_pad_size+3+size_pad_size+date_pad_size);
      wbkgd(date_pad, A_NORMAL);

      for(i=(1 -back);i<hauteur -6;i++)
	{
	  if((i == -1)&&(decalage == -1))
	    {
	      mvwaddstr(date_pad,1, 0, " ");
	      // je laisse la ligne e dessous, sinon mon truc marche pas!
	      prefresh(date_pad,i+back,0,i+3+back,file_pad_size+3+size_pad_size,i+3+back+hauteur -6,file_pad_size+3+size_pad_size+date_pad_size);
	    }
	  else if((i+decalage) < (folder->nb_folders +1-back))
	      mvwaddstr(date_pad,i +back, 0, mycopy(data,get_time(folder->folders[i+decalage+back -1].date),date_pad_size));
	  else if((i+decalage) < (folder->nb_folders +folder->nb_files -1))
	    mvwaddstr(date_pad,i +back, 0, mycopy(data,get_time(folder->files[i+decalage-folder->nb_folders +back -1].date),date_pad_size));
	}
      wbkgd(date_pad, A_BOLD); 
      if(decalage < folder->nb_folders) 
	prefresh(date_pad,1,0,4,file_pad_size+3+size_pad_size,3+folder->nb_folders -decalage,file_pad_size+3+size_pad_size+date_pad_size);
      wbkgd(date_pad, A_NORMAL); 
     if((folder->nb_folders < (decalage + hauteur -6))&&(folder->nb_folders > decalage))
	{
	  prefresh(date_pad,folder->nb_folders -decalage +1 ,0,4+(folder->nb_folders-decalage),file_pad_size +3+size_pad_size,hauteur -3,file_pad_size+3+size_pad_size+date_pad_size);
	}
      else if(folder->nb_folders < (decalage + hauteur -6)) 
	{
	  prefresh(date_pad,back -1,0,4,file_pad_size +3 +size_pad_size,hauteur -3,file_pad_size+3+size_pad_size+date_pad_size);
	}
    }


  //on surligne le fichier slctionn. et on retire l'ancien
  if(last_selected == -1)
    {
      back = 1;
      wbkgd(date_pad, A_BOLD);
      mvwaddstr(date_pad,last_selected -decalage +back, 0, " ");
      prefresh(date_pad,last_selected -decalage +back,0,last_selected -decalage +3 +back,file_pad_size+3+size_pad_size,last_selected -decalage+3 +back,file_pad_size+3+size_pad_size+date_pad_size); 
    }
  else if (last_selected < folder->nb_folders)
    {
      back = 1;
      wbkgd(date_pad, A_BOLD);
      mvwaddstr(date_pad,last_selected -decalage +back, 0, mycopy(data,get_time(folder->folders[last_selected].date),date_pad_size));
      prefresh(date_pad,last_selected -decalage +back,0,last_selected -decalage +3 +back,file_pad_size+3+size_pad_size,last_selected -decalage+3 +back,file_pad_size+3+size_pad_size+date_pad_size);
    }
  else
    {
      back = 1;
      wbkgd(date_pad, A_NORMAL);
      mvwaddstr(date_pad,last_selected -decalage +back, 0, mycopy(data,get_time(folder->files[last_selected -folder->nb_folders].date),date_pad_size));
      prefresh(date_pad,last_selected -decalage +back,0,last_selected -decalage +3 +back,file_pad_size+3+size_pad_size,last_selected -decalage+3 +back,file_pad_size+3+size_pad_size+date_pad_size); 
    }


  if(selected == -1)
    {
      back = 1;
      wbkgd(date_pad, A_REVERSE);
      mvwaddstr(date_pad,selected -decalage +back, 0, " ");
      prefresh(date_pad,selected -decalage +back,0,selected -decalage +3 +back,file_pad_size+3+size_pad_size,selected -decalage+3 +back,file_pad_size+3+size_pad_size+date_pad_size); 
    }
  else if (selected < folder->nb_folders)
    {
      back = 1;
      wbkgd(date_pad, A_REVERSE);
      mvwaddstr(date_pad,selected -decalage +back, 0,mycopy(data,get_time(folder->folders[selected].date),date_pad_size));
      prefresh(date_pad,selected -decalage +back,0,selected -decalage +3 +back,file_pad_size+3+size_pad_size,selected -decalage+3 +back,file_pad_size+3+size_pad_size+date_pad_size);
    }
  else
    {
      back = 1;
      wbkgd(date_pad, A_REVERSE);
      mvwaddstr(date_pad,selected -decalage +back, 0, mycopy(data,get_time(folder->files[selected -folder->nb_folders].date),date_pad_size));
      prefresh(date_pad,selected -decalage +back,0,selected -decalage +3 +back,file_pad_size+3+size_pad_size,selected -decalage+3 +back,file_pad_size+3+size_pad_size+date_pad_size); 
    }
  //last_selected = selected;
  decalage = old_decalage;
}




void update_browser_size(WINDOW *parent_pad,Folder *folder, int update)
{
  //WINDOW *pad;
  int i;
  int back;//donne la valeur du decalage si 1, on est a la racine, si 2, on est au moins dans un disque
  int old_decalage; 
  char size[8];
  char *data;
 

  //size_pad = subpad(parent_pad,hauteur -5,size_pad_size,3,file_pad_size+2+size_pad_size);
 
  data = (char *)malloc((size_pad_size +1)*sizeof(char));
  old_decalage = decalage;
 
  if(is_racine(folder) != 0)
    {
      back = 2;
      while(selected -decalage +back> hauteur -6) decalage = decalage +5;
      while(selected -decalage <0) decalage = decalage -5; 
      if((decalage + hauteur -6) > (folder->nb_files +folder->nb_folders)) decalage = folder->nb_files +folder->nb_folders -hauteur +6; 
     if(decalage < -1) decalage = -1; 
    }
  else
    {
      back = 1;
      while(selected -decalage +back> hauteur -6) decalage = decalage +5;
      while(selected -decalage <0) decalage = decalage -5; 
      if((decalage + hauteur -6) > (folder->nb_files +folder->nb_folders)) decalage = folder->nb_files +folder->nb_folders -hauteur +6;
      if(decalage < 0) decalage = 0;
    }

  if ((decalage != old_decalage)||(update == 1))
    {
     // wclear (size_pad);// a faire que quand decalage change. 
      blanck_pad(size_pad);
      wbkgd(size_pad, A_REVERSE);
      mvwaddstr(size_pad,0 , 0, "  Size");
      prefresh(size_pad,0,0,3,file_pad_size+2,3,file_pad_size+2+size_pad_size);
      wbkgd(size_pad, A_NORMAL);
      
      for(i=(1 -back);i<hauteur -6;i++)
	{
	  if((i == -1)&&(decalage == -1))
	    {
	      mvwaddstr(size_pad,i +back, 0, " ");
	      prefresh(size_pad,i+back,0,i+3+back,file_pad_size+2,i+3+back+hauteur -6,file_pad_size+2+size_pad_size);
	    }
	  else if((i+decalage) < (folder->nb_folders +1-back))
	    mvwaddstr(size_pad,i +back, 0, "0");
	  else if((i+decalage) < (folder->nb_folders +folder->nb_files -1))
	    {
	      if((folder->files[i+decalage-folder->nb_folders +back -1].taille & size_mask) < 10000000) sprintf(size,"%lu",folder->files[i+decalage-folder->nb_folders +back -1].taille & size_mask);
	      else sprintf(size,"%lu k",((folder->files[i+decalage-folder->nb_folders +back -1].taille & size_mask)/1024));
	      mvwaddstr(size_pad,i +back, 0, mycopy(data,size,size_pad_size));
	    }
	}
      wbkgd(size_pad, A_BOLD); 
      if(decalage < folder->nb_folders) 
	prefresh(size_pad,1,0,4,file_pad_size+2,3+folder->nb_folders -decalage,file_pad_size+2+size_pad_size);
      wbkgd(size_pad, A_NORMAL); 
     if((folder->nb_folders < (decalage + hauteur -6))&&(folder->nb_folders > decalage))
	{
	  prefresh(size_pad,folder->nb_folders -decalage +1,0,4+(folder->nb_folders-decalage),file_pad_size +2,hauteur -3,file_pad_size+2+size_pad_size);
	}
      else if(folder->nb_folders < (decalage + hauteur -6)) 
	{
	  prefresh(size_pad,back -1,0,4,file_pad_size +2,hauteur -3,file_pad_size+2+size_pad_size);
	}
    }


  //on surligne le fichier slctionn. et on retire l'ancien
  if(last_selected == -1)
    {
      back = 1;
      wbkgd(size_pad, A_BOLD);
      mvwaddstr(size_pad,last_selected -decalage +back, 0, " ");
      prefresh(size_pad,last_selected -decalage +back,0,last_selected -decalage +3 +back,file_pad_size+2,last_selected -decalage+3 +back,file_pad_size+2+size_pad_size); 
    }
  else if (last_selected < folder->nb_folders)
    {
      back = 1;
      wbkgd(size_pad, A_BOLD);
      mvwaddstr(size_pad,last_selected -decalage +back, 0, "0");
      prefresh(size_pad,last_selected -decalage +back,0,last_selected -decalage +3 +back,file_pad_size+2,last_selected -decalage+3 +back,file_pad_size+2+size_pad_size);
    }
  else
    {
      back = 1;
      wbkgd(size_pad, A_NORMAL);
      if((folder->files[last_selected -folder->nb_folders].taille & size_mask) < 10000000) sprintf(size,"%lu",folder->files[last_selected -folder->nb_folders].taille & size_mask);
      else sprintf(size,"%lu k",((folder->files[last_selected -folder->nb_folders].taille & size_mask)/1024));
      mvwaddstr(size_pad,last_selected -decalage +back, 0, mycopy(data,size,size_pad_size));
      prefresh(size_pad,last_selected -decalage +back,0,last_selected -decalage +3 +back,file_pad_size+2,last_selected -decalage+3 +back,file_pad_size+2+size_pad_size); 
    }

  if(selected == -1)
    {
      back = 1;
      wbkgd(size_pad, A_REVERSE);
      mvwaddstr(size_pad,selected -decalage +back, 0, " ");
      prefresh(size_pad,selected -decalage +back,0,selected -decalage +3 +back,file_pad_size+2,selected -decalage+3 +back,file_pad_size+2+size_pad_size); 
    }
  else if (selected < folder->nb_folders)
    {
      back = 1;
      wbkgd(size_pad, A_REVERSE);
      mvwaddstr(size_pad,selected -decalage +back, 0, "0");
      prefresh(size_pad,selected -decalage +back,0,selected -decalage +3 +back,file_pad_size+2,selected -decalage+3 +back,file_pad_size+2+size_pad_size);
    }
  else
    {
      back = 1;
      wbkgd(size_pad, A_REVERSE);
      if((folder->files[selected -folder->nb_folders].taille & size_mask) < 10000000) sprintf(size,"%lu",folder->files[selected -folder->nb_folders].taille & size_mask);
      else sprintf(size,"%lu k",((folder->files[selected -folder->nb_folders].taille & size_mask)/1024));
      mvwaddstr(size_pad,selected -decalage +back, 0,mycopy(data,size,size_pad_size));
      prefresh(size_pad,selected -decalage +back,0,selected -decalage +3 +back,file_pad_size+2,selected -decalage+3 +back,file_pad_size+2+size_pad_size); 
    }
 // last_selected = selected;
  decalage = old_decalage;
}




void update_browser_file(WINDOW *parent_pad,Folder *folder, int update)
{
//  WINDOW *file_pad;

  int i;
  int back;//donne la valeur du decalage si 1, on est a la racine, si 2, on est au moins dans un disque
  int old_decalage; 
  char *data;

 // file_pad = subpad(parent_pad,hauteur -5,file_pad_size,3,1);

  data = (char *)malloc((file_pad_size +1)*sizeof(char));
  old_decalage = decalage;
 
  if(is_racine(folder) != 0)
    {
      back = 2;
      while(selected -decalage +back> hauteur -6) decalage = decalage+5;
      while(selected -decalage <0) decalage = decalage -5; 
      if((decalage + hauteur -6) > (folder->nb_files +folder->nb_folders)) decalage = folder->nb_files +folder->nb_folders -hauteur +6; 
     if(decalage < -1) decalage = -1; 
    }
  else
    {
      back = 1;
      while(selected -decalage +back> hauteur -6) decalage = decalage + 5;
      while(selected -decalage <0) decalage = decalage - 5; 
      if((decalage + hauteur -6) > (folder->nb_files +folder->nb_folders)) decalage = folder->nb_files +folder->nb_folders -hauteur +6;
      if(decalage < 0) decalage = 0;
    }

  if ((decalage != old_decalage)||(update == 1))
    {
     // wclear (file_pad);// a faire que quand decalage change.
      blanck_pad(file_pad); 
      wbkgd(file_pad, A_REVERSE);
      mvwaddstr(file_pad,0 , 0, "  File");
      prefresh(file_pad,0,0,3,1,3,file_pad_size);
      wbkgd(file_pad, A_NORMAL); 
      for(i=(1 -back);i<hauteur -6;i++)
	{
	  if((i == -1)&&(decalage == -1))
	    {
	      wbkgd(file_pad, A_BOLD);
	      mvwaddstr(file_pad,i +back, 0, "/..");
	      prefresh(file_pad,i+back,0,i+3+back,1,i+3+back+hauteur -6,file_pad_size);
	    }
	  else if((i+decalage) < (folder->nb_folders+1-back))
	    {
	      mvwaddstr(file_pad,i +back, 0, "/");
	      mvwaddstr(file_pad,i +back, 1, mycopy(data,folder->folders[i+decalage+back -1].name,file_pad_size -1));
	    }
	  else if((i+decalage) < (folder->nb_folders +folder->nb_files -1))
	    mvwaddstr(file_pad,i +back, 0, mycopy(data,folder->files[i+decalage-folder->nb_folders +back -1].name,file_pad_size));
	}
      wbkgd(file_pad, A_BOLD); 
      if(decalage < folder->nb_folders) prefresh(file_pad,1,0,4,1,3+folder->nb_folders -decalage,file_pad_size); 
      wbkgd(file_pad, A_NORMAL); 
      if((folder->nb_folders < (decalage + hauteur -6))&&(folder->nb_folders > decalage))
	{
	  prefresh(file_pad,folder->nb_folders -decalage +1,0,4+(folder->nb_folders-decalage),1,hauteur -3,file_pad_size);
	}
      else if(folder->nb_folders < (decalage + hauteur -6)) 
	{
	  prefresh(file_pad,back -1,0,4,1,hauteur -3,file_pad_size);
	}
    }


  //on surligne le fichier slctionn. et on retire l'ancien
  if(last_selected == -1)
    {
      back = 1;
      wbkgd(file_pad, A_BOLD);
      mvwaddstr(file_pad,last_selected -decalage +back, 0, "/..");
      prefresh(file_pad,last_selected -decalage +back,0,last_selected -decalage +3 +back,1,last_selected -decalage+3 +back,file_pad_size); 
    }
  else if (last_selected < folder->nb_folders)
    {
      back = 1;
      wbkgd(file_pad, A_BOLD);
      mvwaddstr(file_pad,last_selected -decalage +back, 0, "/");
      mvwaddstr(file_pad,last_selected -decalage +back, 1, mycopy(data,folder->folders[last_selected].name,file_pad_size -1));
      prefresh(file_pad,last_selected -decalage +back,0,last_selected -decalage +3 +back,1,last_selected -decalage+3 +back,file_pad_size);
    }
  else
    {
      back = 1;
      wbkgd(file_pad, A_NORMAL);
      mvwaddstr(file_pad,last_selected -decalage +back, 0, mycopy(data,folder->files[last_selected -folder->nb_folders].name,file_pad_size));
      prefresh(file_pad,last_selected -decalage +back,0,last_selected -decalage +3 +back,1,last_selected -decalage+3 +back,file_pad_size); 
    }

  if(selected == -1)
    {
      back = 1;
      wbkgd(file_pad, A_REVERSE);
      mvwaddstr(file_pad,selected -decalage +back, 0, "/..");
      prefresh(file_pad,selected -decalage +back,0,selected -decalage +3 +back,1,selected -decalage+3 +back,file_pad_size); 
    }
  else if (selected < folder->nb_folders)
    {
      back = 1;
      wbkgd(file_pad, A_REVERSE);
      mvwaddstr(file_pad,selected -decalage +back, 0, "/");
      mvwaddstr(file_pad,selected -decalage +back, 1, mycopy(data,folder->folders[selected].name,file_pad_size -1));
      prefresh(file_pad,selected -decalage +back,0,selected -decalage +3 +back,1,selected -decalage+3 +back,file_pad_size);
      //prefresh(parent_pad,selected -decalage +back,0,selected -decalage +3 +back,1,selected -decalage+3 +back,largeur -2);
    }
  else
    {
      back = 1;
      wbkgd(file_pad, A_REVERSE);
      mvwaddstr(file_pad,selected -decalage +back, 0, mycopy(data,folder->files[selected -folder->nb_folders].name,file_pad_size));
      prefresh(file_pad,selected -decalage +back,0,selected -decalage +3 +back,1,selected -decalage+3 +back,file_pad_size); 
    }
 // last_selected = selected;//il faut le faire au dernier pad mis ajour, sinon les autres marchent pas!
  decalage = old_decalage; //pour restaurer la config pour l'affichage du pas suivant.
}



void affiche_short_info(WINDOW *pad,Folder *curent_folder,char pad_num)
{
  char *data;
  
  //wclear(pad);
  mvwaddstr(pad, 0, 1, blanck_line); 
  if(selected != -1)
    {
      switch(pad_num)
	{
	case 'f':
	  if(selected < curent_folder->nb_folders) mvwaddstr(pad, 0, 1, curent_folder->folders[selected].name);
	  else mvwaddstr(pad, 0, 1, curent_folder->files[selected -curent_folder->nb_folders].name);
	  break;
	case 's':
	  if(selected < curent_folder->nb_folders) mvwaddstr(pad, 0, 1, "0");
	  else mvwaddstr(pad, 0, 1, get_size(curent_folder->files[selected -curent_folder->nb_folders].taille));
	  break;
	case 'd':
	  if(selected < curent_folder->nb_folders) mvwaddstr(pad, 0, 1, get_time(curent_folder->folders[selected].date));
	  else mvwaddstr(pad, 0, 1, get_time(curent_folder->files[selected -curent_folder->nb_folders].date));
	  break;
	case 'c':
	  if(selected < curent_folder->nb_folders) mvwaddstr(pad, 0, 1, categories[curent_folder->folders[selected].categorie]);
	  else mvwaddstr(pad, 0, 1, categories[curent_folder->files[selected -curent_folder->nb_folders].categorie]);
	  break;
	case 'e':
	  if(selected < curent_folder->nb_folders) mvwaddstr(pad, 0, 1, descriptions[curent_folder->folders[selected].description]);
	  else 
	    {
	      if((curent_folder->files[selected -curent_folder->nb_folders].description == 0) && (curent_folder->files[selected -curent_folder->nb_folders].information != NULL))
		{
		  data = (char *)malloc(largeur*sizeof(char));
		  mvwaddstr(pad, 0, 1, mycopy(data,curent_folder->files[selected -curent_folder->nb_folders].information,largeur));
		}
	      else  mvwaddstr(pad, 0, 1, descriptions[curent_folder->files[selected -curent_folder->nb_folders].description]);
	    }
	  break;
	}      
      prefresh(pad,0,0,hauteur -1,0,hauteur ,largeur);
    }
} 





void open_cat_browser()
{
  WINDOW *pad, *path_pad, *down_pad;
  int key;
  int changedir;
  int update;
  int i;
  Folder *tmp_fold;

  blanck_line = (char *)malloc(largeur+1*sizeof(char));
  for(i=0;i<largeur;i++) blanck_line[i] = ' ';
  blanck_line[i] = '\0';

  path = (char *)malloc(500*sizeof(char));

  file_pad_size = 20;
  size_pad_size = 8;
  date_pad_size = 10;
  cat_pad_size = 18;
  desc_pad_size= largeur-(file_pad_size+size_pad_size+date_pad_size+cat_pad_size+6);
  
  resize_pad = 'f';
  
  pad = newpad(hauteur -1,largeur);
  box(pad,0,0);
  prefresh(pad,0,0,0,0,hauteur,largeur);

  path_pad = newpad(3,largeur);
  box(path_pad,0,0);
  prefresh(path_pad,0,0,0,0,3,largeur);
  wbkgd(file_pad, A_NORMAL);
  mvwaddstr(path_pad, 1, 1," NCatalog v0.02   Press F12 to display some help.");
  prefresh(path_pad,1,1,1,1,1,largeur-2);
  mvwaddstr(path_pad, 1, 1,"                                                   ");
  wbkgd(file_pad, A_NORMAL);
  curent_folder = &racine;
  
  
  down_pad = newpad(1,largeur);
  affiche_short_info(down_pad,curent_folder,resize_pad);
  prefresh(down_pad,0,0,hauteur -1,0,hauteur ,largeur);
  

  put_line(pad,file_pad_size +1);
  put_line(pad,file_pad_size +1+size_pad_size+1); 
  put_line(pad,file_pad_size +1+size_pad_size+1+date_pad_size+1); 
  put_line(pad,file_pad_size +1+size_pad_size+1+date_pad_size+1+cat_pad_size+1); 
  
  decalage = -2;//pour le 1er affichage!
  while(1)
    {
      update = 0;
      if(changedir == 1)
	{
	  selected = -1;
	  last_selected = 0;
	  decalage = -2;
	}
      else if(changedir == 2)
	{
	  last_selected = 0;
	  decalage = -2;
	}
      else if((changedir == -1)&&(desc_pad_size > 1))
	{
	  switch(resize_pad)
	    {
	    case 'f':
	      file_pad_size++;
	      break;
	    case 's':
	      size_pad_size++;
	      break;
	    case 'd':
	      date_pad_size++;
	      break;
	    case 'c':
	      cat_pad_size++;
	      break;
	    }
	  desc_pad_size= largeur-(file_pad_size+size_pad_size+date_pad_size+cat_pad_size+6);
	  put_line(pad,file_pad_size +1);
	  put_line(pad,file_pad_size +1+size_pad_size+1); 
	  put_line(pad,file_pad_size +1+size_pad_size+1+date_pad_size+1); 
	  put_line(pad,file_pad_size +1+size_pad_size+1+date_pad_size+1+cat_pad_size+1); 
	  update = 1;
	}
      else if(changedir == -2)
	{
	  switch(resize_pad)
	    {
	    case 'f':
	      if(file_pad_size > 2)file_pad_size--;
	      break;
	    case 's':
	      if(size_pad_size > 2)size_pad_size--;
	      break;
	    case 'd':
	      if(date_pad_size > 2)date_pad_size--;
	      break;
	    case 'c':
	      if(cat_pad_size > 2)cat_pad_size--;
	      break;
	    }
	  desc_pad_size= largeur-(file_pad_size+size_pad_size+date_pad_size+cat_pad_size+6);
	  put_line(pad,file_pad_size +1);
	  put_line(pad,file_pad_size +1+size_pad_size+1); 
	  put_line(pad,file_pad_size +1+size_pad_size+1+date_pad_size+1); 
	  put_line(pad,file_pad_size +1+size_pad_size+1+date_pad_size+1+cat_pad_size+1);
	  update = 1;
	}

      delwin(file_pad);
      delwin(size_pad);
      delwin(date_pad);
      delwin(cat_pad);
      delwin(desc_pad);

      file_pad = newpad(hauteur -5,file_pad_size);
      size_pad = newpad(hauteur -5,size_pad_size);
      date_pad = newpad(hauteur -5,date_pad_size);
      cat_pad  = newpad(hauteur -5,cat_pad_size);
      desc_pad  = newpad(hauteur -5,desc_pad_size);
 
      changedir = 0;
      while(changedir == 0)
	{
	  update_browser_file(pad,curent_folder,update);
	  update_browser_size(pad,curent_folder,update);
	  update_browser_date(pad,curent_folder,update);
	  update_browser_categorie(pad,curent_folder,update);
	  update_browser_description(pad,curent_folder,update);
	 // prefresh(path_pad,0,0,0,0,3,largeur); 
	  update = 0;
	  noecho();
	  keypad(stdscr,TRUE);
	  raw();
	  key = getch();
	  switch(key)
	    {
	    case KEY_F(1):
	      resize_pad = 'f';
	      affiche_short_info(down_pad,curent_folder,resize_pad);
	      break;
	    case KEY_F(2):
	      resize_pad = 's';
	      affiche_short_info(down_pad,curent_folder,resize_pad);
	      break;
	    case KEY_F(3):
	      resize_pad = 'd';
	      affiche_short_info(down_pad,curent_folder,resize_pad);
	      break;
	    case KEY_F(4):
	      resize_pad = 'c';
	      affiche_short_info(down_pad,curent_folder,resize_pad);
	      break;
	    case KEY_F(5):
	      resize_pad = 'e';
	      affiche_short_info(down_pad,curent_folder,resize_pad);
	      break;
	    case KEY_F(7):
       	      tmp_fold = curent_folder;
	      start_search_function();
	      put_line(pad,file_pad_size +1);
	      put_line(pad,file_pad_size +1+size_pad_size+1); 
	      put_line(pad,file_pad_size +1+size_pad_size+1+date_pad_size+1); 
	      put_line(pad,file_pad_size +1+size_pad_size+1+date_pad_size+1+cat_pad_size+1); 
	      prefresh(path_pad,0,0,0,0,3,largeur);
	      
	      if (tmp_fold != curent_folder)
		{
		  mvwaddstr(path_pad, 1, 2, path);
		  box(path_pad,0,0);
		  prefresh(path_pad,0,0,0,0,3,largeur);
		}
	      update = 1;
	      break; 

	    case 'p':
	    case KEY_RIGHT:
	      changedir = -1;
	      break;
	    case 'm':
	    case KEY_LEFT:
	      changedir = -2;
	      break;
	    case 'q':
	    case KEY_F(10):
	      delwin (pad);
	      delwin (path_pad);
	      delwin (down_pad);
	      endwin();
	      exit(1);
	    case KEY_F(12):
	      display_information(help,"  NCatalog help:");
	      prefresh(pad,0,0,0,0,hauteur-1,largeur);
	      put_line(pad,file_pad_size +1);
	      put_line(pad,file_pad_size +1+size_pad_size+1); 
	      put_line(pad,file_pad_size +1+size_pad_size+1+date_pad_size+1); 
	      put_line(pad,file_pad_size +1+size_pad_size+1+date_pad_size+1+cat_pad_size+1); 
	      prefresh(path_pad,0,0,0,0,3,largeur);
	      changedir = 1;
	      break;
	    case ' ':
	        if(selected == -1)
		{
		  display_information(curent_folder->information,curent_folder->name);
		  prefresh(pad,0,0,0,0,hauteur-1,largeur);
		  put_line(pad,file_pad_size +1);
		  put_line(pad,file_pad_size +1+size_pad_size+1); 
		  put_line(pad,file_pad_size +1+size_pad_size+1+date_pad_size+1); 
		  put_line(pad,file_pad_size +1+size_pad_size+1+date_pad_size+1+cat_pad_size+1); 
		  prefresh(path_pad,0,0,0,0,3,largeur);
		  changedir = 2;  
		}
	     else if (selected < curent_folder->nb_folders)
		{
		  display_information(curent_folder->folders[selected].information,curent_folder->folders[selected].name);
		  prefresh(pad,0,0,0,0,hauteur-1,largeur);
		  put_line(pad,file_pad_size +1);
		  put_line(pad,file_pad_size +1+size_pad_size+1); 
		  put_line(pad,file_pad_size +1+size_pad_size+1+date_pad_size+1); 
		  put_line(pad,file_pad_size +1+size_pad_size+1+date_pad_size+1+cat_pad_size+1); 
		  prefresh(path_pad,0,0,0,0,3,largeur);
		  changedir = 2; 
		}
	      else 
		{
		  display_information(curent_folder->files[selected -curent_folder->nb_folders].information,curent_folder->files[selected -curent_folder->nb_folders].name);
		  prefresh(pad,0,0,0,0,hauteur-1,largeur);
		  put_line(pad,file_pad_size +1);
		  put_line(pad,file_pad_size +1+size_pad_size+1); 
		  put_line(pad,file_pad_size +1+size_pad_size+1+date_pad_size+1); 
		  put_line(pad,file_pad_size +1+size_pad_size+1+date_pad_size+1+cat_pad_size+1); 
		  prefresh(path_pad,0,0,0,0,3,largeur);
		  changedir = 1;
		}	     
	      break;
	    case '\n': 
	      if(selected == -1)
		{
		  path[strlen(path)-(strlen(curent_folder->name) +1)] = '\0';
		  //je recheche le repertoire parent pour le selectionner; 
		  selected = 0;
		  while(strcmp(curent_folder->name,curent_folder->parent->folders[selected].name) != 0) selected++;
		  curent_folder = curent_folder->parent;
		  if(curent_folder == &racine)
		    {
		      path[0] = '\0';
		      wbkgd(file_pad, A_REVERSE);
		    }
		  wclear(path_pad);
		  mvwaddstr(path_pad, 1, 2, path);
		  box(path_pad,0,0);
		  prefresh(path_pad,0,0,0,0,3,largeur);
		  changedir = 2;
		} 
	      else if (selected < curent_folder->nb_folders)
		{
		  if(curent_folder == &racine)
		    {
		      curent_folder = &curent_folder->folders[selected]; 
		      sprintf(path,"[%s]->/",curent_folder->name);
		    }
		  else
		    {
		       curent_folder = &curent_folder->folders[selected];
		       path =  strcat(path,curent_folder->name);
		       path =  strcat(path,"/");
		    }
		  mvwaddstr(path_pad, 1, 2, path);
		  box(path_pad,0,0);
		  prefresh(path_pad,0,0,0,0,3,largeur);
		  changedir = 1;
		}
	      break;          
	    case KEY_UP:
	      if(is_racine(curent_folder) == 0)
		{
		  if(selected > 0)
		    {
		      selected--;
		      affiche_short_info(down_pad,curent_folder,resize_pad);
		    }
		}
	      else if(selected > -1) 
		{
		  selected--;
		  affiche_short_info(down_pad,curent_folder,resize_pad);
		}
	      break;
	    case KEY_DOWN:
	      if(selected < (curent_folder->nb_folders + curent_folder->nb_files -1))
		{
		  selected++;
		  affiche_short_info(down_pad,curent_folder,resize_pad);
		}
	      break;
	    default:
	      break;
	    }
	}
    }
}
