/*  GTKtalog.
 *  Copyright (C) 2000  Yves Mettier
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __CONFIG_STRUCT__
#define __CONFIG_STRUCT__

#include <config.h>
#include <gnome.h>
#include <time.h>

#define USER_CONFIG_DIR "/.gtktalog"
#define USER_CONFIG_FILE "gtktalog.cf"

#define CATEGORY_MAX_LENGTH 64
#define DEFINITION_MAX_LENGTH 1024
#define INFORMATION_MAX_LENGTH 128

#define MAX_STRING_LENGTH 1024

#define CAT_TREE_UP	1
#define CAT_TREE_DOWN	2
#define CAT_TREE_0	0
#define CAT_TREE_END	99

#define THREAD_SCAN_RUNNING_NO		1
#define THREAD_SCAN_RUNNING_YES		2
#define THREAD_SCAN_RUNNING_ENDED	3

#define ERROR_DIALOG(msg, w) gnome_dialog_run_and_close(GNOME_DIALOG(gnome_error_dialog_parented(_(msg), GTK_WINDOW (w))));
#define WARNING_DIALOG(msg, w) gnome_dialog_run_and_close(GNOME_DIALOG(gnome_warning_dialog_parented(_(msg), GTK_WINDOW (w))));



/*********************** structures for the file tree ***********************/
typedef struct
{
  GPtrArray *datas;
  GNode *tree;

  GPtrArray *descriptions;
  GPtrArray *categories;

  GtkWidget *ctree;

  GNode *selected_folder;
  GNode *currently_displayed_gnode;

  gboolean is_modified;

  GString *catalog_filename;
  gboolean catalog_filename_is_valid;
}
FOLDER;

typedef struct
{
  GString *name;		/* name of the file/dir */
  guint32 taille;		/* length of the file/dir */
  guint type;			/* type of the file/dir */
  time_t date;			/*  time_t */
  guint16 categorie;
  guint16 description;
  GString *information;
  GNode *node;			/* gnode associated with this FILE_DATA */
  GtkCTreeNode *ctree_node;	/* ctree_node associated with this FILE_DATA */
}
FILE_DATA;

/************ main structure to be used in nearly all functions **************/
typedef struct
{
  GdkPixmap *pixmap;
  GdkBitmap **mask;
  GString *path;
}
PIX;

typedef struct
{
  GString *extension;
  GString *prog;
  GString *arg;
  GString *viewer;
  GString *viewerarg;
  gboolean state;
}
EXTENSIONS;

typedef struct
{
  GTree *icons;			/* key=extension; value=PIX */
  PIX *default_file_pix;
  PIX *default_dir_pix;
  PIX *default_disk_pix;
  GTree *extensions;

  gboolean getInformation;

  GtkWidget *search_dirtree;
  gboolean update_edit_window;
  gpointer category_widgets;
  gpointer search_widgets;
  gpointer calendar_widgets;

  FOLDER *racine;

  pid_t current_pid;

  GString *mount;
  GString *umount;
  GString *eject_prog;
  GString *mount_point;
  GString *dummy_prog;
  gboolean use_supermount;
  
  /* Options */
  gboolean use_du_s;
  gboolean warn_mount;
  gboolean eject_disk;   

/* What is that? */
  char *fast_name;


}
CONFIG;

/* To use an icon, just look for it with:
mypixmap = ((PIX*)(g_tree_lookup(extension)))->pixmap
*/

/*************** Structure to be used in load/save catalogs ****************/
typedef struct
{
  guint type;
  guint32 taille;
  time_t date;
  guint32 categorie;
  guint32 description;
}
DATAS;

/******************** Structures and funcs for lex/yacc **********************/
typedef struct
{
  GString *key;
  gpointer value;
}
KEY_VALUE;

/* Function headers */
/* config_parser. */
gboolean check_supermount(CONFIG *my_config);
void config_struct_free_1 (GList * gl);
int yyerror (char *s);
void yyrestart (FILE * new_file);
CONFIG *init_config (GString * config_file, GtkWidget * w);

/* config_lex.l */
int yylex (void);

extern GtkWidget *main_window;
extern GtkWidget *path_entry;
extern GtkWidget *clist;

extern CONFIG *my_config;

#endif
