/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>

#define __DEF_CONFIG__
#include "addisk.h"
#include "config_common.h"
#include "exit.h"
#include "interface.h"
#include "io.h"
#include "loadcat.h"
#include "buttonbar.h"

#define P_FILE		100
#define P_GEOMETRY	101
#define P_WINTITLE	102
#define P_VERSION	103

CONFIG *my_config;

static char *popt_filename = NULL;
static char *popt_geometry = NULL;
static char *popt_wintitle = NULL;
struct poptOption command_line[] = {
  {"catalog", 'c', POPT_ARG_STRING || POPT_ARGFLAG_ONEDASH, &popt_filename, P_FILE,
   N_("Catalog file to load."), "filename"},
  {"geometry", 'g', POPT_ARG_STRING || POPT_ARGFLAG_ONEDASH, &popt_geometry, P_GEOMETRY,
   N_("Geometry. See man X for more info.")},
  {"title", 't', POPT_ARG_STRING || POPT_ARGFLAG_ONEDASH, &popt_wintitle, P_WINTITLE,
   N_("Title of the window"), "text"},
  {"version", 'v', POPT_ARGFLAG_ONEDASH, NULL, P_VERSION,
   N_("Prints the version of " PACKAGE)},
  POPT_AUTOHELP {NULL, 0, 0, NULL, 0}
};



GtkWidget *main_window;

int
main (int argc, char *argv[])
{
  GString *conf_file;
  poptContext optCon;
  GString *_title = NULL;
  GString *_filename = NULL;
  GString *_geometry = NULL;
  gint wx, wy, ww, wh;
  gchar c;


  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
  textdomain (PACKAGE);
  gnome_init_with_popt_table (PACKAGE, VERSION, argc, argv, command_line, 0,
			      &optCon);
  optCon = poptGetContext (NULL, argc, argv, command_line, 0);

  /* Processing of arguments */

  while ((c = poptGetNextOpt (optCon)) >= 0)
    {
      switch (c)
	{
	case P_VERSION:
	  printf (_("Gtktalog\nVersion : %s\nLicence : GPL\n"
		    "More infos on http://gtktalog.sourceforge.net\n"),
		  VERSION);
	  exit (0);
	  break;
	case P_FILE:
	  _filename = g_string_new (popt_filename);
	  break;
	case P_GEOMETRY:
	  _geometry = g_string_new (popt_geometry);
	  break;
	case P_WINTITLE:
	  _title = g_string_new (popt_wintitle);
	  break;
	}
    }

  if (c < -1)
    {
      /* an error occurred during option processing */
      fprintf (stderr, "%s: %s\n",
	       poptBadOption (optCon, POPT_BADOPTION_NOALIAS),
	       poptStrerror (c));
      return (-1);
    }

  /*initialisation des differentes variables */

  main_window = gnome_app_new (PACKAGE, "gtktalog");

  if (_title)
    {
      gtk_window_set_title (GTK_WINDOW (main_window), _title->str);
      g_string_free (_title, TRUE);
    }
  else
    {
      gtk_window_set_title (GTK_WINDOW (main_window), "GTKtalog V " VERSION);
    }
  if (_geometry)
    {
      if (gnome_parse_geometry (_geometry->str, &wx, &wy, &ww, &wh) != TRUE)
	{
	  wx = 0;
	  wy = 0;
	  ww = 660;
	  wh = 350;
	}
      g_string_free (_geometry, TRUE);
    }
  else
    {
      wx = 0;
      wy = 0;
      ww = 660;
      wh = 350;
    }
  if (wx < 0)
    wx = 0;
  if (wy < 0)
    wy = 0;
  if (ww < 0)
    ww = 660;
  if (wh < 0)
    wh = 350;
  gtk_widget_set_uposition (GTK_WIDGET (main_window), wx, wy);
  gtk_widget_set_usize (GTK_WIDGET (main_window), ww, wh);

  gtk_widget_realize (main_window);

  conf_file = g_string_new (g_get_home_dir ());
  conf_file =
    g_string_append (conf_file, USER_CONFIG_DIR "/" USER_CONFIG_FILE);
  if (!g_file_test (conf_file->str, G_FILE_TEST_ISFILE))
    {
      g_string_free (conf_file, TRUE);
      conf_file = g_string_new (PREFIX "/share/gtktalog/gtktalog.cf");
      if (!g_file_test (conf_file->str, G_FILE_TEST_ISFILE))
	{
	  ERROR_DIALOG ("Could not find config file", main_window);
	  exit (-1);
	}
    }

  my_config = init_config (conf_file, GTK_WIDGET (main_window));
  my_config->racine = NULL;
  my_config->update_edit_window = FALSE;
  my_config->calendar_widgets = NULL;
  my_config->fast_name = NULL;
  my_config->racine = NULL;
  reinit_thread_status ();

  build_gui ();

  gtk_widget_show (main_window);

  my_config->current_pid = getpid ();

  if (_filename)
    {
      load_cat_from_file (_filename->str, my_config->racine);
      g_node_traverse (my_config->racine->tree,
		       G_PRE_ORDER, G_TRAVERSE_ALL, -1, add_gnode_to_ctree,
		       my_config->racine);
      update_tree (my_config->racine);

      gtk_window_set_title (GTK_WINDOW (main_window),
			    my_config->racine->catalog_filename->str);
      g_string_free (_filename, TRUE);
    }

  gtk_signal_connect (GTK_OBJECT (main_window), "delete_event", cb_quit_prog,
		      my_config);
  gtk_main ();

  return (0);
}
