/*  GTKtalog.
 *  Copyright (C) 2000 Yves Mettier
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <config.h>
#include <gnome.h>
#include <regex.h>
#include <errno.h>

#include "compare.h"

gint
compare (const gchar * pattern, const gchar * string, gboolean regex,
	 gboolean case_sensitive)
{
  regex_t *r;
  int err_no = 0;		/* For regerror() */
  size_t no_sub = 0;
  regmatch_t *result;
  gint cflags;
  gint return_value;
  gchar *my_string = "";

  if (string)
    my_string = (char *) string;

  if (regex == FALSE)
    {
      if (case_sensitive == FALSE)
	{
	  return_value = g_strcasecmp (pattern, my_string);
	}
      else
	{
	  return_value = strcmp (pattern, my_string);
	}
    }
  else
    {
      /* This is code inspired from the Linux Gazette Issue of July 2000 */
      r = (regex_t *) g_malloc (sizeof (regex_t));
      if (case_sensitive == FALSE)
	{
	  cflags = REG_ICASE;
	}
      else
	{
	  cflags = 0;
	}

      if ((err_no = regcomp (r, pattern, 0)) != 0)
	{			/* Compile the regex */
	  size_t length;
	  char *buffer;
	  length = regerror (err_no, r, NULL, 0);
	  buffer = g_malloc (length);
	  regerror (err_no, r, buffer, length);
	  fprintf (stderr, "%s\n", buffer);	/* Print the error */
	  free (buffer);
	  regfree (r);
	  return -1;
	}
      no_sub = r->re_nsub + 1;	/* How many matches are there in a line? */
      result = (regmatch_t *) g_malloc (sizeof (regmatch_t) * no_sub);

      return_value = regexec (r, my_string, no_sub, result, 0);
      regfree (r);
      g_free (r);
      g_free (result);
    }
  return (return_value);
}
