/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <regex.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/mtio.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <pthread.h>
#include <sys/mtio.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>

#include "addisk.h"
#include "config_common.h"
#include "folder.h"
#include "io.h"
#include "interface.h"
#include "fastaddisk.h"
#include "progressbar.h"

#ifdef LIBC5
#define SIGUSR1 SIGSTKFLT
#define SIGUSR2 SIGUNUSED
#endif

GtkWidget *name_entry;

static pthread_t thread1;

int
fad_create_window (gchar ** fast_name)
{
  GtkWidget *name_window;
  GtkWidget *frame;
  int button;

  /* Window */
  name_window = gnome_dialog_new ("Set disk name",
				  GNOME_STOCK_BUTTON_OK,
				  GNOME_STOCK_BUTTON_CANCEL, NULL);

  /* FIXME: Set Parent to help the window manager */
  //gnome_dialog_set_parent(GNOME_DIALOG(dlg), GTK_WINDOW(app));

  gtk_window_set_position (GTK_WINDOW (name_window), GTK_WIN_POS_MOUSE);

  /* Label */
  frame = gtk_frame_new ("Disk Label");
  gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (name_window)->vbox), frame, TRUE,
		      TRUE, 0);
  gtk_widget_show (frame);

  /* Name of the Disk */
  name_entry = gtk_entry_new_with_max_length (50);
  if (*fast_name == NULL)
    gtk_entry_set_text (GTK_ENTRY (name_entry), "");
  else
    gtk_entry_set_text (GTK_ENTRY (name_entry), *fast_name);

  /* get the GtkEntry to bind a "changed" signal to figure out when the
     user changed the entry */
  gtk_entry_select_region (GTK_ENTRY (name_entry), 0,
			   GTK_ENTRY (name_entry)->text_length);
  gtk_container_add (GTK_CONTAINER (frame), name_entry);
  gtk_widget_show (name_entry);

  button = gnome_dialog_run (GNOME_DIALOG (name_window));

  /* Cancel or close the window */
  if ((button == 1) || (button == -1))
    {
      /* close the window */
      gnome_dialog_close (GNOME_DIALOG (name_window));
      return 0;
    }

  if (button == 0)
    {
      gchar *temp;

      /* Get the name of the CD */
      temp = gtk_entry_get_text (GTK_ENTRY (name_entry));

      /* Replace the last name */
      free (*fast_name);
      *fast_name = strdup (temp);

      /* FIXME: And what if fast_name is empty or already exists ? */

      gnome_dialog_close (GNOME_DIALOG (name_window));
      return 1;
    }

  return -1;
}




void
fast_add_disk (FOLDER * racine)
{
  gint name_window_status;


  /* Mount if necessary */
  if ((my_config->use_supermount == FALSE) && (mount_disk (my_config) == FALSE))
    {
      /* Error */
      return;
    }

  /* Fetch the content of the drive meanwhile */
  set_local_disk_name (g_strdup (""));
  set_local_folder_name (g_strdup (my_config->mount_point->str));

  set_thread_status_to_running ();
  progress_timeout (NULL);
  if (my_config->use_du_s == TRUE)
    {
      progress_setTotal (du_s (my_config->mount_point->str));
    }
  else
    {
      progress_setTotal (getStats (my_config->mount_point->str));
    }
  do_not_forget_to_umount (TRUE);
  if (pthread_create (&thread1, NULL, start_thread_scan, racine) < 0)
    {
      reinit_thread_status ();
      ERROR_DIALOG ("Thread failed.\nCheck your number of threads.",
		    main_window);
    }
  else
    {
/* Initialize the status bar */
      /* Create window to enter the name */
      name_window_status = fad_create_window (&(my_config->fast_name));

      if (name_window_status == 1)
	{
	  set_local_disk_name (my_config->fast_name);
	  set_added_disk (TRUE);
	}
      else
	{
	  set_added_disk (FALSE);
	}
      my_timeout (racine);
    }
}
