/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <config.h>
#include <gnome.h>
#include <fnmatch.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include "search.xpm"
#include "search.h"
#include "categories.h"
#include "date.h"
#include "config_common.h"
#include "compare.h"
#include "folder.h"
#include "io.h"
#include "interface.h"

/* Search dialog */
static gchar ALL_CATEGORIES[] = N_("All");
static GtkWidget *search_dialog_window;
static GtkWidget *notebook;
static GtkWidget *simple_search_entry;
static GtkWidget *extended_search_entry;
static GtkWidget *cat_combo;
static GtkWidget *information_entry;
static GtkWidget *desc_entry;
static GtkWidget *disk_combo;
static GtkWidget *s_path_entry;
static GtkWidget *checkdate1;
static GtkWidget *checkdate2;
static GtkWidget *date1;
static GtkWidget *date2;
static time_t date_val1;
static time_t date_val2;
static GtkWidget *checksize1;
static GtkWidget *checksize2;
static GtkWidget *size1;
static GtkWidget *size2;
static GtkWidget *check_search_file;
static GtkWidget *check_search_dir;
static GtkWidget *check_case_sensitive;
static GtkWidget *scrolled_window;
static GtkWidget *search_list;

/* Search options */
static gboolean SEARCH_OPTIONS_case_sensitive;
static gchar *SEARCH_OPTIONS_filename;
static GNode *SEARCH_OPTIONS_search_root;
static gboolean SEARCH_OPTIONS_regex;
static gchar *SEARCH_OPTIONS_infostring;
static gchar *SEARCH_OPTIONS_description;
static gchar *SEARCH_OPTIONS_category;
static gboolean SEARCH_OPTIONS_search_files;
static gboolean SEARCH_OPTIONS_search_dirs;
static gboolean SEARCH_OPTIONS_size1;
static gboolean SEARCH_OPTIONS_size2;
static gint SEARCH_OPTIONS_size_val1;
static gint SEARCH_OPTIONS_size_val2;
static gboolean SEARCH_OPTIONS_date1;
static gboolean SEARCH_OPTIONS_date2;

GNode *
find_node_with_parent (GNode * parent, gchar * name,
		       gboolean case_sensitive, FOLDER * racine)
{
  GNode *gntmp;
  GNode *result;
  FILE_DATA *fd;

  gntmp = g_node_first_sibling (parent);
  result = NULL;
  while ((result == NULL) && (gntmp))
    {
      fd = get_file_data_from_gnode (gntmp);
      if (is_dir (gntmp))
	{
	  if (compare (name, fd->name->str, TRUE, case_sensitive) == 0)
	    {
	      result = gntmp;
	    }
	  else
	    {
	      gntmp = g_node_next_sibling (gntmp);
	    }
	}
      else
	{
	  gntmp = g_node_next_sibling (gntmp);
	}
    }
  return (result);
}

gboolean
find_files (GNode * gn, gpointer data)
{
  FOLDER *racine = data;
  const gchar *result[7];
  gint row;
  char *extension;
  PIX *pix;
  const gchar *tmpstr;
  gchar *nothing = " ";

  FILE_DATA *fd;
  if ((is_dir (gn) && SEARCH_OPTIONS_search_dirs) ||
      ((is_file (gn) || (is_link (gn))) && SEARCH_OPTIONS_search_files))
    {
      fd = get_file_data_from_gnode (gn);
      /* Compare names */
      if (compare
	  (SEARCH_OPTIONS_filename, fd->name->str, SEARCH_OPTIONS_regex,
	   SEARCH_OPTIONS_case_sensitive)) return (FALSE);
      /* Compare categories */
      tmpstr = get_categorie (racine, fd->categorie);
      if (strcmp (SEARCH_OPTIONS_category, ALL_CATEGORIES))
	{
	  if (tmpstr)
	    {
	      if (compare (SEARCH_OPTIONS_category, tmpstr, FALSE, FALSE))
		return (FALSE);
	    }
	  else
	    return (FALSE);
	}
      /* Compare descriptions */
      tmpstr = get_description (racine, fd->description);
      if (strcmp (SEARCH_OPTIONS_description, ".*"))
	{
	  if (tmpstr)
	    {
	      if (compare
		  (SEARCH_OPTIONS_description, tmpstr,
		   SEARCH_OPTIONS_regex, SEARCH_OPTIONS_case_sensitive)) return (FALSE);
	    }
	  else
	    return (FALSE);
	}
      /* Compare information */
      if (fd->information)
	if (strcmp (SEARCH_OPTIONS_infostring, ".*"))
	  if (compare
	      (SEARCH_OPTIONS_infostring, fd->information->str, SEARCH_OPTIONS_regex,
	       SEARCH_OPTIONS_case_sensitive)) return (FALSE);

      /* Compare date */
      if (SEARCH_OPTIONS_size1)
	if (fd->taille < SEARCH_OPTIONS_size_val1)
	  return (FALSE);
      if (SEARCH_OPTIONS_size2)
	if (fd->taille > SEARCH_OPTIONS_size_val2)
	  return (FALSE);

      /* Compare size */
      if (SEARCH_OPTIONS_date1)
	if (fd->date < date_val1)
	  return (FALSE);
      if (SEARCH_OPTIONS_date2)
	if (fd->date > date_val2)
	  return (FALSE);



      result[0] = fd->name->str;
      result[1] = get_disk_from_node (gn);
      result[2] = get_path_from_node (gn)->str;
      result[3] = get_size (fd->taille);
      result[4] = get_time (fd->date);
      result[5] = get_categorie (racine, fd->categorie);
      if (!result[5])
	result[5] = nothing;
      result[6] = get_description (racine, fd->description);
      if (!result[6])
	result[6] = nothing;

      row = gtk_clist_append (GTK_CLIST (search_list), (gchar **) result);
      /* pixmap depending on the extension */

      extension = fd->name->str;
      while (extension[0])
	extension++;
      while ((extension > fd->name->str) && (extension[0] != '.'))
	extension--;

      pix = ((PIX *) g_tree_lookup (my_config->icons, extension));
      if (!pix)
	{
	  pix = my_config->default_file_pix;
	}
      gtk_clist_set_pixtext (GTK_CLIST (search_list), row, 0,
			     fd->name->str, 3, pix->pixmap, *(pix->mask));

      gtk_clist_set_row_data (GTK_CLIST (search_list), row, gn);

    }
  return (FALSE);
}

void
start_search (FOLDER * racine)
{
  gtk_clist_clear (GTK_CLIST (search_list));
  gtk_clist_freeze (GTK_CLIST (search_list));

  g_node_traverse (SEARCH_OPTIONS_search_root, G_PRE_ORDER, G_TRAVERSE_ALL, -1,
		   find_files, racine);

  gtk_clist_sort (GTK_CLIST (search_list));
  gtk_clist_thaw (GTK_CLIST (search_list));
  gtk_notebook_set_page (GTK_NOTEBOOK (notebook), 2);

}


void
start_extended_search (GtkWidget * w, gpointer data)
{
  FOLDER *racine = data;
  gchar *disk;
  gchar *s_path, *spt, *spte, c;
  GNode *gntmp;

  /* read what the user entered */
  SEARCH_OPTIONS_filename = gtk_entry_get_text (GTK_ENTRY (extended_search_entry));
  SEARCH_OPTIONS_infostring = gtk_entry_get_text (GTK_ENTRY (information_entry));
  disk = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (disk_combo)->entry));
  s_path = gtk_entry_get_text (GTK_ENTRY (s_path_entry));
  SEARCH_OPTIONS_search_files = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON
						   (check_search_file));
  SEARCH_OPTIONS_search_dirs = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON
						  (check_search_dir));
  SEARCH_OPTIONS_case_sensitive =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check_case_sensitive));
  SEARCH_OPTIONS_regex = TRUE;

  SEARCH_OPTIONS_size1 = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checksize1));
  SEARCH_OPTIONS_size2 = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checksize2));
  SEARCH_OPTIONS_size_val1 = gtk_spin_button_get_value_as_int ((GtkSpinButton *) size1);
  SEARCH_OPTIONS_size_val2 = gtk_spin_button_get_value_as_int ((GtkSpinButton *) size2);

  SEARCH_OPTIONS_date1 = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkdate1));
  SEARCH_OPTIONS_date2 = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkdate2));

  SEARCH_OPTIONS_category =
    gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (cat_combo)->entry));
  SEARCH_OPTIONS_description = gtk_entry_get_text (GTK_ENTRY (desc_entry));
  /* find root */

  SEARCH_OPTIONS_search_root = NULL;
  if (strcmp (disk, ".*"))
    {
      SEARCH_OPTIONS_search_root =
	find_node_with_parent (racine->tree, disk,
			       SEARCH_OPTIONS_case_sensitive, racine);
    }
  if (SEARCH_OPTIONS_search_root == NULL)
    SEARCH_OPTIONS_search_root = racine->tree;

  /* Find subdir */
  gntmp = NULL;
  if (strcmp (s_path, "/.*"))
    {
      spt = s_path;
      if (spt[0] == '/')
	{
	  gntmp = SEARCH_OPTIONS_search_root;
	  while (gntmp && spt[0])
	    {
	      while (spt[0] == '/')
		spt++;
	      spte = spt;
	      while ((spte[0] != '/') && (spte[0]))
		spte++;
	      c = spte[0];
	      spte[0] = 0;
	      gntmp =
		find_node_with_parent (gntmp, spt, SEARCH_OPTIONS_case_sensitive,
				       racine);
	      spte[0] = c;
	      spt = spte;
	    }
	}
    }
  else
    {
      gntmp = racine->tree;
    }
  if (gntmp == NULL)
    {
      WARNING_DIALOG ("Invalid path.\nRoot directory will be used instead",
		      search_dialog_window);
    }
  else
    {
      SEARCH_OPTIONS_search_root = gntmp;
    }

  start_search (racine);
}


void
start_simple_search (GtkWidget * w, gpointer data)
{
  FOLDER *racine = data;
  gchar *disk;
  gchar *s_path;

  /* read what the user entered */
  SEARCH_OPTIONS_filename = gtk_entry_get_text (GTK_ENTRY (simple_search_entry));
  SEARCH_OPTIONS_infostring = g_strdup (".*");
  disk = g_strdup (".*");
  s_path = g_strdup (".*");
  SEARCH_OPTIONS_search_files = TRUE;
  SEARCH_OPTIONS_search_dirs = TRUE;
  SEARCH_OPTIONS_case_sensitive = FALSE;
  SEARCH_OPTIONS_regex = TRUE;

  SEARCH_OPTIONS_size1 = FALSE;
  SEARCH_OPTIONS_size2 = FALSE;
  SEARCH_OPTIONS_size_val1 = 0;
  SEARCH_OPTIONS_size_val2 = 0;

  SEARCH_OPTIONS_date1 = FALSE;
  SEARCH_OPTIONS_date2 = FALSE;

  SEARCH_OPTIONS_category = g_strdup (ALL_CATEGORIES);
  SEARCH_OPTIONS_description = g_strdup (".*");
  /* find root */

  SEARCH_OPTIONS_search_root = racine->tree;

  start_search (racine);

  g_free (SEARCH_OPTIONS_infostring);
  g_free (disk);
  g_free (s_path);
  g_free (SEARCH_OPTIONS_category);
  g_free (SEARCH_OPTIONS_description);
}

static void
cancel_clicked (GtkWidget * w, gpointer data)
{
  gtk_widget_destroy (search_dialog_window);
  return;
}

static void
destroy_window (GtkWidget * w, GdkEventKey * event, gpointer data)
{
  cancel_clicked (w, data);
}

void
use_calendar1 (GtkWidget * w, gpointer data)
{
  struct tm *d;
  char buffer[256];
  d = open_calendar (GTK_WINDOW (search_dialog_window));
  if (d)
    {
      sprintf (buffer, "%d.%d.%d", d->tm_mday, d->tm_mon + 1, d->tm_year);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (GTK_CHECK_BUTTON (checkdate1)), TRUE);


      date_val1 = mktime (d);
      gtk_label_set (GTK_LABEL (date1), buffer);
      g_free (d);
    }
}

void
use_calendar2 (GtkWidget * w, gpointer data)
{
  struct tm *d;
  char buffer[256];
  d = open_calendar (GTK_WINDOW (search_dialog_window));
  if (d)
    {
      sprintf (buffer, "%d.%d.%d", d->tm_mday, d->tm_mon + 1, d->tm_year);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (GTK_CHECK_BUTTON (checkdate2)), TRUE);


      date_val2 = mktime (d);
      gtk_label_set (GTK_LABEL (date2), buffer);
      g_free (d);
    }
}

static void
selection_made (GtkWidget * clist, gint row, gint column,
		GdkEventButton * event, gpointer data)
{
  FOLDER *racine = data;
  GNode *gn;
  gchar *rep;
  gchar *path;
  gchar *datas;
  gchar *name;
  gint8 pouet;
  GdkPixmap *da_pix;
  GdkBitmap *da_mask;



  if (event != NULL && event->button == 1 && event->type == GDK_2BUTTON_PRESS)
    {
      gtk_clist_get_pixtext (GTK_CLIST (clist), row, 0, &name, &pouet,
			     &da_pix, &da_mask);
      gn = gtk_clist_get_row_data ((GtkCList *) clist, row);

      gtk_clist_get_text (GTK_CLIST (search_list), row, 1, &rep);
      gtk_clist_get_text (GTK_CLIST (search_list), row, 2, &path);
      if (is_dir (gn) == TRUE)
	{
	  datas =
	    (char *)
	    g_malloc ((strlen (rep) + strlen (path) + 5 + strlen (name)) *
		      sizeof (char));
	  sprintf (datas, "[%s]->%s%s/", rep, path, name);
	}
      else
	{
	  datas =
	    (char *) g_malloc ((strlen (rep) + strlen (path) + 5) *
			       sizeof (char));
	  sprintf (datas, "[%s]->%s", rep, path);
	}
      gtk_entry_set_text (GTK_ENTRY (path_entry), datas);
      g_free (datas);
      if (is_file (gn) == FALSE)
	{
	  list_folder (gn);
	}
      else
	{
	  list_folder (gn->parent);
	}
    }
  else
    {
      gn = gtk_clist_get_row_data ((GtkCList *) clist, row);
      racine->selected_folder = gn;
    }
}


static void
unselection_made (GtkWidget * clist, gint row, gint column,
		  GdkEventButton * event, gpointer data)
{
  FOLDER *racine = data;
  racine->selected_folder = NULL;
}


void
sort_list (GtkWidget * wid, gint column, gpointer data)
{
  FOLDER *racine = data;

  racine->selected_folder = NULL;
  /* FIXME: column 3 is numeric, and column 4 is a date. Sorting method is different!!! */
  gtk_clist_set_sort_column (GTK_CLIST (search_list), (gint) column);
  gtk_clist_sort (GTK_CLIST (search_list));
}


void
create_search_dialog (FOLDER * racine)
{
  GtkWidget *frame, *frame2;
  GtkWidget *ok_button;
  GtkWidget *cancel_button;
  GtkWidget *image;
  GtkWidget *vbox;
  GtkWidget *hbox, *hbox2, *hbox3;
  GtkWidget *button;
  GtkAdjustment *adj;
  static GtkStyle *style;
  static GdkPixmap *logo_pixmap;
  static GdkBitmap *logo_mask;
  GList *disk_list, *cat_list;
  gchar *titles[7] =
    { N_("File"), N_("Disk"), N_("Path"), N_("Size"), N_("Date"),
    N_("Category"), N_("Description")
  };


  search_dialog_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize (GTK_WIDGET (search_dialog_window), 650, 330);
  gtk_window_set_position (GTK_WINDOW (search_dialog_window),
			   GTK_WIN_POS_MOUSE);
  gtk_window_set_title (GTK_WINDOW (search_dialog_window), "Search");
  gtk_window_set_policy (GTK_WINDOW (search_dialog_window), FALSE, FALSE,
			 TRUE);
  gtk_container_border_width (GTK_CONTAINER (search_dialog_window), 10);
  gtk_signal_connect (GTK_OBJECT (search_dialog_window), "delete_event",
		      destroy_window, NULL);
  gtk_grab_add (search_dialog_window);

  notebook = gtk_notebook_new ();
  gtk_container_add (GTK_CONTAINER (search_dialog_window), notebook);

  if (logo_pixmap == NULL)
    {
      gtk_widget_realize (search_dialog_window);
      style = gtk_widget_get_style (search_dialog_window);
      logo_pixmap =
	gdk_pixmap_create_from_xpm_d (search_dialog_window->window,
				      &logo_mask,
				      &style->bg[GTK_STATE_NORMAL],
				      (gchar **) search_xpm);
      gtk_widget_unrealize (search_dialog_window);
    }

  vbox = gtk_vbox_new (TRUE, 5);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox,
			    gtk_label_new (_("Search")));
  gtk_widget_show (vbox);


  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);

  frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame), _("Search file"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  hbox3 = gtk_hbox_new (TRUE, 5);
  gtk_container_add (GTK_CONTAINER (frame), hbox3);
  gtk_widget_show (hbox3);


  frame2 = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame2), "File name");
  gtk_frame_set_label_align (GTK_FRAME (frame2), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame2), GTK_SHADOW_ETCHED_OUT);

  gtk_box_pack_start (GTK_BOX (hbox3), frame2, TRUE, TRUE, 0);
  gtk_widget_show (frame2);

  simple_search_entry = gtk_entry_new_with_max_length (100);
  gtk_signal_connect (GTK_OBJECT (simple_search_entry), "activate",
		      GTK_SIGNAL_FUNC (start_simple_search), racine);
  gtk_entry_set_text (GTK_ENTRY (simple_search_entry), ".*");
  gtk_container_add (GTK_CONTAINER (frame2), simple_search_entry);
  gtk_widget_show (simple_search_entry);


  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  ok_button = gtk_button_new_with_label (_("Ok"));
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
		      start_simple_search, racine);
  gtk_box_pack_start (GTK_BOX (hbox), ok_button, TRUE, TRUE, 0);
  gtk_widget_show (ok_button);

  cancel_button = gtk_button_new_with_label (_("Cancel"));
  gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
		      cancel_clicked, NULL);
  gtk_box_pack_start (GTK_BOX (hbox), cancel_button, TRUE, TRUE, 0);
  gtk_widget_show (cancel_button);


  vbox = gtk_vbox_new (TRUE, 5);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox,
			    gtk_label_new (_("Extended search")));
  gtk_widget_show (vbox);


  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);

  frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame), _("Search file"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  hbox3 = gtk_hbox_new (TRUE, 5);
  gtk_container_add (GTK_CONTAINER (frame), hbox3);
  gtk_widget_show (hbox3);


  frame2 = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame2), "File name");
  gtk_frame_set_label_align (GTK_FRAME (frame2), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame2), GTK_SHADOW_ETCHED_OUT);

  gtk_box_pack_start (GTK_BOX (hbox3), frame2, TRUE, TRUE, 0);
  gtk_widget_show (frame2);

  extended_search_entry = gtk_entry_new_with_max_length (100);
  gtk_signal_connect (GTK_OBJECT (extended_search_entry), "activate",
		      GTK_SIGNAL_FUNC (start_extended_search), racine);
  gtk_entry_set_text (GTK_ENTRY (extended_search_entry), ".*");
  gtk_container_add (GTK_CONTAINER (frame2), extended_search_entry);
  gtk_widget_show (extended_search_entry);


  frame2 = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame2), _("Disk"));
  gtk_frame_set_label_align (GTK_FRAME (frame2), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame2), GTK_SHADOW_ETCHED_OUT);

  gtk_box_pack_start (GTK_BOX (hbox3), frame2, TRUE, TRUE, 0);
  gtk_widget_show (frame2);

  disk_combo = gtk_combo_new ();
  gtk_combo_set_value_in_list (GTK_COMBO (disk_combo), FALSE, TRUE);
  gtk_combo_set_use_arrows_always (GTK_COMBO (disk_combo), TRUE);
  gtk_combo_disable_activate (GTK_COMBO (disk_combo));


  disk_list = make_disk_list (racine);
  disk_list = g_list_prepend (disk_list, ".*");

  gtk_combo_set_popdown_strings (GTK_COMBO (disk_combo), disk_list);
  g_list_free (disk_list);
  gtk_container_add (GTK_CONTAINER (frame2), disk_combo);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (disk_combo)->entry), ".*");
  gtk_signal_connect (GTK_OBJECT (GTK_COMBO (disk_combo)->entry),
		      "activate", GTK_SIGNAL_FUNC (start_extended_search),
		      racine);
  gtk_widget_show (disk_combo);

  frame2 = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame2), "Path");
  gtk_frame_set_label_align (GTK_FRAME (frame2), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame2), GTK_SHADOW_ETCHED_OUT);

  gtk_box_pack_start (GTK_BOX (hbox3), frame2, TRUE, TRUE, 0);
  gtk_widget_show (frame2);

  s_path_entry = gtk_entry_new_with_max_length (100);
  gtk_signal_connect (GTK_OBJECT (s_path_entry), "activate",
		      GTK_SIGNAL_FUNC (start_extended_search), racine);
  gtk_entry_set_text (GTK_ENTRY (s_path_entry), "/.*");

  gtk_container_add (GTK_CONTAINER (frame2), s_path_entry);
  gtk_widget_show (s_path_entry);


  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);

  frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame), _("Category"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  cat_combo = gtk_combo_new ();
  gtk_combo_set_value_in_list (GTK_COMBO (cat_combo), FALSE, TRUE);
  gtk_combo_set_use_arrows_always (GTK_COMBO (cat_combo), TRUE);
  gtk_combo_disable_activate (GTK_COMBO (cat_combo));
  cat_list = make_categories_list (racine);
  cat_list = g_list_append (cat_list, ALL_CATEGORIES);
  gtk_combo_set_popdown_strings (GTK_COMBO (cat_combo), cat_list);
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (cat_combo)->entry), FALSE);
  gtk_container_add (GTK_CONTAINER (frame), cat_combo);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (cat_combo)->entry), _("All"));
  gtk_signal_connect (GTK_OBJECT (GTK_COMBO (cat_combo)->entry),
		      "activate", start_extended_search, racine);
  gtk_widget_show (cat_combo);



  frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame), _("Description"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);


  desc_entry = gtk_entry_new_with_max_length (DEFINITION_MAX_LENGTH);
  gtk_signal_connect (GTK_OBJECT (desc_entry), "activate",
		      GTK_SIGNAL_FUNC (start_extended_search), racine);
  gtk_entry_set_text (GTK_ENTRY (desc_entry), ".*");
  gtk_container_add (GTK_CONTAINER (frame), desc_entry);
  gtk_widget_show (desc_entry);


  frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame), _("Information"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  information_entry = gtk_entry_new_with_max_length (INFORMATION_MAX_LENGTH);
  gtk_signal_connect (GTK_OBJECT (information_entry), "activate",
		      GTK_SIGNAL_FUNC (start_extended_search), racine);
  gtk_entry_set_text (GTK_ENTRY (information_entry), ".*");
  gtk_container_add (GTK_CONTAINER (frame), information_entry);
  gtk_widget_show (information_entry);




  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);


  frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame), _("Date"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  hbox2 = gtk_hbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (frame), hbox2);
  gtk_widget_show (hbox2);

  checkdate1 = gtk_check_button_new_with_label (_("From:"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkdate1), FALSE);
  gtk_box_pack_start (GTK_BOX (hbox2), checkdate1, FALSE, FALSE, 0);
  gtk_widget_show (checkdate1);


  button = gtk_button_new ();
  gtk_signal_connect (GTK_OBJECT (button), "clicked", use_calendar1, NULL);
  gtk_box_pack_start (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
  gtk_widget_show (button);


  date1 = gtk_label_new ("--.--.----");
  gtk_container_add (GTK_CONTAINER (button), date1);
  gtk_widget_show (date1);
  date_val1 = 0;


  checkdate2 = gtk_check_button_new_with_label (_("To:"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkdate2), FALSE);
  gtk_box_pack_start (GTK_BOX (hbox2), checkdate2, FALSE, FALSE, 0);
  gtk_widget_show (checkdate2);


  button = gtk_button_new ();
  gtk_signal_connect (GTK_OBJECT (button), "clicked", use_calendar2, NULL);
  gtk_box_pack_start (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
  gtk_widget_show (button);

  date2 = gtk_label_new ("--.--.----");
  gtk_container_add (GTK_CONTAINER (button), date2);
  gtk_widget_show (date2);
  date_val2 = 0;



  frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame), _("Size (in Byte)"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  hbox2 = gtk_hbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (frame), hbox2);
  gtk_widget_show (hbox2);

  checksize1 = gtk_check_button_new_with_label (_("From:"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checksize1), FALSE);
  gtk_box_pack_start (GTK_BOX (hbox2), checksize1, FALSE, FALSE, 0);
  gtk_widget_show (checksize1);

  adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, 1000000000, 10, 100, 0);

  size1 = gtk_spin_button_new (adj, 1.0, 2);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (size1), TRUE);
  gtk_widget_set_usize (size1, 100, 0);
  gtk_box_pack_start (GTK_BOX (hbox2), size1, FALSE, TRUE, 0);
  gtk_spin_button_set_numeric ((GtkSpinButton *) size1, TRUE);
  gtk_spin_button_set_digits (GTK_SPIN_BUTTON (size1), 0);
  gtk_widget_show (size1);


  checksize2 = gtk_check_button_new_with_label (_("To:"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checksize2), FALSE);
  gtk_box_pack_start (GTK_BOX (hbox2), checksize2, FALSE, FALSE, 0);
  gtk_widget_show (checksize2);

  adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, 1000000000, 5, 100, 0);

  size2 = gtk_spin_button_new (adj, 1.0, 2);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (size2), TRUE);
  gtk_widget_set_usize (size2, 100, 0);
  gtk_box_pack_start (GTK_BOX (hbox2), size2, FALSE, TRUE, 0);
  gtk_spin_button_set_numeric ((GtkSpinButton *) size2, TRUE);
  gtk_spin_button_set_digits (GTK_SPIN_BUTTON (size2), 0);
  gtk_widget_show (size2);


  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);


  image = gtk_pixmap_new (logo_pixmap, logo_mask);
  gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);
  gtk_widget_show (image);

  check_search_file = gtk_check_button_new_with_label (_("Search File"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check_search_file), TRUE);
  gtk_box_pack_start (GTK_BOX (hbox), check_search_file, FALSE, FALSE, 0);
  gtk_widget_show (check_search_file);

  check_search_dir = gtk_check_button_new_with_label (_("Search Folder"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check_search_dir), TRUE);
  gtk_box_pack_start (GTK_BOX (hbox), check_search_dir, FALSE, FALSE, 0);
  gtk_widget_show (check_search_dir);

  check_case_sensitive =
    gtk_check_button_new_with_label (_("Case sensitive"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check_case_sensitive),
				FALSE);
  gtk_box_pack_start (GTK_BOX (hbox), check_case_sensitive, FALSE, FALSE, 0);
  gtk_widget_show (check_case_sensitive);

  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  ok_button = gtk_button_new_with_label (_("Ok"));
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
		      start_extended_search, racine);
  gtk_box_pack_start (GTK_BOX (hbox), ok_button, TRUE, TRUE, 0);
  gtk_widget_show (ok_button);

  cancel_button = gtk_button_new_with_label (_("Cancel"));
  gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
		      cancel_clicked, NULL);
  gtk_box_pack_start (GTK_BOX (hbox), cancel_button, TRUE, TRUE, 0);
  gtk_widget_show (cancel_button);

  /* Result part (empty at the beginning) */
  vbox = gtk_vbox_new (FALSE, 5);
  gtk_widget_show (vbox);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox,
			    gtk_label_new (_("Results")));

  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (vbox), scrolled_window, TRUE, TRUE, 0);
  gtk_widget_show (scrolled_window);

  search_list = gtk_clist_new_with_titles (7, titles);
  gtk_signal_connect (GTK_OBJECT (search_list), "select_row",
		      GTK_SIGNAL_FUNC (selection_made), racine);
  gtk_signal_connect (GTK_OBJECT (search_list), "unselect_row",
		      GTK_SIGNAL_FUNC (unselection_made), racine);

  gtk_clist_set_shadow_type (GTK_CLIST (search_list), GTK_SHADOW_OUT);
  gtk_clist_set_column_width (GTK_CLIST (search_list), 0, 165);
  gtk_clist_set_column_width (GTK_CLIST (search_list), 1, 50);
  gtk_clist_set_column_width (GTK_CLIST (search_list), 2, 150);
  gtk_clist_set_column_width (GTK_CLIST (search_list), 3, 50);
  gtk_clist_set_column_width (GTK_CLIST (search_list), 4, 50);
  gtk_clist_set_column_width (GTK_CLIST (search_list), 5, 75);
  gtk_clist_set_column_auto_resize (GTK_CLIST (search_list), 6, TRUE);
  gtk_container_add (GTK_CONTAINER (scrolled_window), search_list);

  gtk_signal_connect (GTK_OBJECT (search_list), "button_press_event",
		      GTK_SIGNAL_FUNC (clist_pressed), racine);
  gtk_signal_connect (GTK_OBJECT (search_list), "click_column",
		      GTK_SIGNAL_FUNC (sort_list), racine);

  cancel_button = gtk_button_new_with_label (_("Cancel"));
  gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
		      cancel_clicked, NULL);
  gtk_box_pack_start (GTK_BOX (vbox), cancel_button, FALSE, TRUE, 0);
  gtk_widget_show (cancel_button);

  gtk_widget_show (search_list);

  gtk_widget_show (notebook);
  gtk_widget_show (search_dialog_window);
  gtk_notebook_set_page (GTK_NOTEBOOK (notebook), 0);
}
