/*  GTKtalog.
 *  Copyright (C) 1999-2000  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __FOLDER_H__
#define __FOLDER_H__

#include <config.h>
#include <gnome.h>
#include "config_common.h"


#define IS_DISK        1
#define IS_DIR         2
#define IS_FILE        3
#define IS_LINK        4
#define IS_ENDOFDIR    12

FILE_DATA *get_file_data_from_gnode (GNode * gn);
FOLDER *get_catalog_from_file_data (FILE_DATA * fd);
FOLDER *get_catalog_from_gnode (GNode * gn);
void catalog_set_selected_folder (GNode * gn);
void catalog_set_currently_displayed_gnode (GNode * gn);
const gchar *get_disk_from_node (GNode * gn);
GString *get_real_path_from_node (GNode * gn);
GString *get_path_from_node (GNode * gn);
FILE_DATA *folder_make_data (char *name, char *information, guint type,
			     guint32 taille, time_t date, guint32 categorie,
			     guint32 description);
GNode *folder_add (FOLDER * fd, GNode * parent, char *name, char *information,
		   guint type, guint32 taille, time_t date, guint32 categorie,
		   guint32 description);
GNode *folder_add_link (FOLDER * fd, GNode * parent, char *linkname,
			char *destname, char *information, guint32 taille,
			time_t date, guint32 categorie, guint32 description);
void change_name (GNode * gn, char *name);
void change_description (GNode * gn, guint i);
void change_category (GNode * gn, guint i);
void change_information (GNode * gn, char *information);
const char *folder_get_name (GNode * gn);
const char *folder_get_informations (GNode * gn);
const char *folder_get_category_from_file_data (FILE_DATA * fd);
const char *folder_get_description_from_file_data (FILE_DATA * fd);
char *get_time (time_t nb_sec);
char *get_size (guint32 nb_octs);
int get_type (guint type_info);
const char *get_categorie (FOLDER * racine, guint16 i);
const char *get_description (FOLDER * racine, guint16 i);
gboolean is_file (GNode * gn);
gboolean is_dir (GNode * gn);
gboolean is_link (GNode * gn);
gboolean is_disk (GNode * gn);
GArray *folder_search_name_in_array (GNode * gn, gchar * name);
void suppress_dir (GNode * dir);
GList *make_disk_list (FOLDER * racine);

#endif
