/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __ADDISK_H__
#define __ADDISK_H__

#include "config_common.h"

guint du_s (gchar * path);
gboolean eject_disk(CONFIG *my_config);
gboolean mount_disk(CONFIG *my_config);
gboolean umount_disk(CONFIG *my_config);

gint get_thread_status ();
void reinit_thread_status ();
void set_thread_status_to_running ();
void set_thread_status_to_ended ();

void do_not_forget_to_umount (gboolean gb);
void do_not_forget_to_mount (gboolean gb);
void set_local_disk_name (gchar * s);
void set_local_folder_name (gchar * s);
void set_added_disk (gboolean gb);

gint my_timeout (gpointer data);

gchar *read_information (gchar * file);
void create_folder_tree (FOLDER * racine, GNode * parent, const gchar * path,
			 gboolean getInformation);
void *start_thread_scan (void *arg);
void finish_normal_scan (int sig);

#endif
