/*
 * GTKtalog. *  Copyright (C) 1999-2000  Mathieu VILLEGAS * *  This program
 * is free software; you can redistribute it and/or modify *  it under the
 * terms of the GNU General Public License as published by *  the Free
 * Software Foundation; either version 2 of the License, or *  (at your
 * option) any later version. * *  This program is distributed in the hope
 * that it will be useful, *  but WITHOUT ANY WARRANTY; without even the
 * implied warranty of *  MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the *  GNU General Public License for more details. * *  You 
 * should have received a copy of the GNU General Public License *  along
 * with this program; if not, write to the Free Software *  Foundation, Inc., 
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 */

#include <config.h>
#include <gnome.h>

#include "config_common.h"
#include "interface.h"
#include "loadcat.h"
#include "savecat.h"
#include "exit.h"
#include "io.h"
#include "folder.h"

static GtkWidget *fs;

/* This traversefunc creates a gtkctree_node with the data given with gn.
 * This gtkctree_node is inserted to data->ctree where data is FOLDER*.
 * It should better be called as a traversefunc with g_node_traverse
 */

gboolean add_gnode_to_ctree (GNode * gn, gpointer data)
{
  FOLDER *racine = data;
  FILE_DATA *fd, *parent_fd, *child_fd;
  GtkCTreeNode *gtkparentnode;
  gboolean is_leaf, is_expanded;
  GNode *gn_child;
  PIX *pix;

  fd = get_file_data_from_gnode (gn);
  if (g_node_depth (gn) != 1)
    {
      gn_child = g_node_first_child (gn);
      is_leaf = TRUE;
      while ((gn_child) && (is_leaf == TRUE))
	{
	  child_fd = get_file_data_from_gnode (gn_child);
	  if (child_fd->type == IS_DIR)
	    is_leaf = FALSE;
	  gn_child = g_node_next_sibling (gn_child);
	}
      if ((racine->tree == gn))
	is_expanded = TRUE;
      else
	is_expanded = FALSE;

      if ((is_disk (gn) == TRUE) || (is_dir (gn) == TRUE))
	{
	  parent_fd = get_file_data_from_gnode (gn->parent);
	  gtkparentnode = parent_fd->ctree_node;
	  if (g_node_depth (gn) == 2)
	    pix = my_config->default_disk_pix;
	  else
	    pix = my_config->default_dir_pix;
	  fd->ctree_node =
	    gtk_ctree_insert_node (GTK_CTREE (racine->ctree),
				   gtkparentnode, NULL, &(fd->name->str), 4,
				   pix->pixmap, *(pix->mask), pix->pixmap,
				   *(pix->mask), is_leaf, is_expanded);
	  gtk_ctree_node_set_row_data (GTK_CTREE (racine->ctree),
				       fd->ctree_node, gn);

	}
    }
  return (FALSE);
}

/*affiche la liste des fichiers quand un repertoire est selectionn */
static void
cb_itemsignal (GtkWidget * widget, GtkCTreeNode * node, gint z,
	       FOLDER * racine)
{
  GNode *gnode_data;
  gnode_data = gtk_ctree_node_get_row_data (GTK_CTREE (widget), node);
  if (G_NODE_IS_ROOT (gnode_data) != TRUE)
    {
      racine->selected_folder = gnode_data;

    }
  else
    {
      racine->selected_folder = NULL;
    }
}

/* quand un repertoire est deselectionne dans l'arbre */
static void
cb_itemsignal2 (GtkWidget * widget, GtkCTreeNode * node, gint i,
		FOLDER * racine)
{
  racine->selected_folder = NULL;
}

static void
expand_cb (GtkWidget * widget, GtkCTreeNode * parent_node, FOLDER * racine)
{
  GNode *parent_gn;
  gboolean is_expanded = FALSE;

  parent_gn = gtk_ctree_node_get_row_data (GTK_CTREE (widget), parent_node);

  gtk_ctree_get_node_info (GTK_CTREE (widget), parent_node,
			   NULL,
			   NULL, NULL, NULL, NULL, NULL, NULL, &is_expanded);
  if (is_expanded == TRUE)
    {
      list_folder (parent_gn);
    }
}


/* Create the folder tree */
void
create_tree (FOLDER * racine)
{

  racine->ctree = gtk_ctree_new (1, 0);
  gtk_clist_set_column_auto_resize (GTK_CLIST (racine->ctree), 0, TRUE);
  gtk_clist_set_selection_mode (GTK_CLIST (racine->ctree),
				GTK_SELECTION_SINGLE);
  gtk_ctree_set_line_style (GTK_CTREE (racine->ctree),
			    GTK_CTREE_LINES_DOTTED);
  gtk_signal_connect (GTK_OBJECT (racine->ctree), "tree_expand",
		      GTK_SIGNAL_FUNC (expand_cb), racine);
  gtk_signal_connect (GTK_OBJECT (racine->ctree), "tree_select_row",
		      GTK_SIGNAL_FUNC (cb_itemsignal), racine);
  gtk_signal_connect (GTK_OBJECT (racine->ctree), "tree_unselect_row",
		      GTK_SIGNAL_FUNC (cb_itemsignal2), racine);

  gtk_signal_connect (GTK_OBJECT (racine->ctree), "button_press_event",
		      GTK_SIGNAL_FUNC (tree_pressed), racine);

  gtk_object_set_user_data (GTK_OBJECT (racine->ctree), racine->tree);
}



FOLDER *
init_folder ()
{
  FILE_DATA *fd;
  FOLDER *racine;

  racine = (FOLDER *) g_malloc (sizeof (FOLDER));
  racine->datas = g_ptr_array_new ();
  fd = (FILE_DATA *) g_malloc (sizeof (FILE_DATA));
  g_ptr_array_add (racine->datas, fd);
  racine->tree = g_node_new (racine);
  fd->name = NULL;
  fd->taille = 0;
  fd->type = 0;
  fd->date = 0;
  fd->categorie = 0;
  fd->description = 0;
  fd->information = NULL;
  fd->ctree_node = NULL;

  racine->categories = g_ptr_array_new ();

  racine->descriptions = g_ptr_array_new ();
  racine->catalog_filename = g_string_new (_("No_name"));
  racine->catalog_filename_is_valid = FALSE;
  racine->selected_folder = NULL;
  racine->currently_displayed_gnode = NULL;
  racine->is_modified = FALSE;

  create_tree (racine);
  fd->node = racine->tree;

  return (racine);
}

void
new_file ()
{
  gboolean new_anyway = TRUE;

  if (my_config->racine)
    {
      if (my_config->racine->is_modified == TRUE)
	{
	  if (yes_no_cancel_dialog
	      (_("New dialog"),
	       _("The catalog has not been saved. Lose it anyway ?")) != 0)
	    {

	      new_anyway = FALSE;
	    }
	}
    }
  if (new_anyway == TRUE)
    {
      if (my_config->racine)
	{
	  gtk_clist_clear ((GtkCList *) clist);
	  clear_folder (my_config->racine);
	}
      gtk_entry_set_text (GTK_ENTRY (path_entry), "");
      my_config->racine = init_folder ();
      add_gnode_to_ctree (my_config->racine->tree, my_config->racine);
      ctree_window_add (my_config->racine->ctree);
      update_tree (my_config->racine);
    }
  /*
   * gtk_statusbar_pop ((GtkStatusbar *) status_bar1, status_context1);
   * gtk_statusbar_push ((GtkStatusbar *) status_bar1, status_context1, ""); 
   */

}

void
clear_folder (FOLDER * racine)
{
  gint i;
  suppress_dir (racine->tree);

  for (i = 0; i < racine->descriptions->len; i++)
    {
      g_string_free (g_ptr_array_index (racine->descriptions, i), TRUE);
    }
  g_ptr_array_free (racine->descriptions, FALSE);

  for (i = 0; i < racine->categories->len; i++)
    {
      g_string_free (g_ptr_array_index (racine->categories, i), TRUE);
    }
  g_ptr_array_free (racine->categories, FALSE);
  g_string_free (racine->catalog_filename, TRUE);
  gtk_widget_destroy (GTK_WIDGET (racine->ctree));
  g_free (racine);
}

/*
 * ouverture d'un catalogue 
 */
void
open_cat_ok_sel (GtkWidget * w, gpointer data)
{
  FOLDER *racine = data;

  gtk_clist_clear ((GtkCList *) clist);
  if (racine != NULL)
    {
      clear_folder (racine);
    }
  gtk_entry_set_text (GTK_ENTRY (path_entry), "");
  racine = init_folder ();
  my_config->racine = racine;

  /*
   * gtk_statusbar_pop ((GtkStatusbar *) status_bar1, status_context1);
   * gtk_statusbar_push ((GtkStatusbar *) status_bar1, status_context1, ""); 
   */
  if (load_cat_from_file
      (gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)),
       racine) == -1)
    {
      return;
    }
  gtk_widget_destroy (GTK_WIDGET (fs));
  g_node_traverse (racine->tree,
		   G_PRE_ORDER, G_TRAVERSE_ALL, -1, add_gnode_to_ctree,
		   racine);
  ctree_window_add (racine->ctree);
  update_tree (racine);

  gtk_window_set_title (GTK_WINDOW (main_window),
			racine->catalog_filename->str);
}



void
open_cat (FOLDER * racine)
{
  if (racine != NULL)
    {
      if (racine->is_modified == TRUE)
	{
	  if (yes_no_cancel_dialog (_("Open dialog"),
				    _
				    ("The catalog has not been saved. Lose it anyway ?"))
	      != 0)
	    {
	      return;
	    }
	}
    }
  fs = gtk_file_selection_new ("File selection");
  gtk_signal_connect (GTK_OBJECT (fs), "destroy",
		      (GtkSignalFunc) gtk_widget_destroy, &(fs));
  gtk_signal_connect (GTK_OBJECT
		      (GTK_FILE_SELECTION
		       (fs)->ok_button), "clicked",
		      (GtkSignalFunc) open_cat_ok_sel, racine);
  gtk_signal_connect_object (GTK_OBJECT
			     (GTK_FILE_SELECTION
			      (fs)->cancel_button), "clicked",
			     (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (fs));
  gtk_widget_show (fs);

}

/*
 * permet d'enregistrer le catalogue courant dans un fichier 
 */
void
save_cat_ok_sel (GtkWidget * w, FOLDER * racine)
{
  if (save_cat_to_file
      (gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)),
       racine) == 0)
    {
      gtk_window_set_title (GTK_WINDOW (main_window),
			    racine->catalog_filename->str);
      /*
       * gtk_statusbar_push ((GtkStatusbar *) status_bar1, status_context1, racine->catalog_filename->str); 
       */
    }
  gtk_widget_destroy (GTK_WIDGET (fs));
}




void
save_cat (FOLDER * racine)
{
  fs = gtk_file_selection_new ("Save catalog to file");
  gtk_signal_connect (GTK_OBJECT (fs), "destroy",
		      (GtkSignalFunc) gtk_widget_destroy, &(fs));
  gtk_signal_connect (GTK_OBJECT
		      (GTK_FILE_SELECTION (fs)->ok_button),
		      "clicked", (GtkSignalFunc) save_cat_ok_sel, racine);
  gtk_signal_connect_object (GTK_OBJECT
			     (GTK_FILE_SELECTION (fs)->cancel_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (fs));
  gtk_widget_show (fs);
}


void
fast_save (FOLDER * racine)
{
  if (racine->catalog_filename_is_valid == FALSE)
    {
      save_cat (racine);
    }
  else
    {
      if (save_cat_to_file (racine->catalog_filename->str, racine) == -1)
	{
	  /*
	   * canceled = 1; 
	   */
	  ERROR_DIALOG ("Can't write file", main_window);
	}
    }
}

/* string_to_index(descriptions, "my own description") will return the index where the
 * description containing the string "my own description" can be reached.
 * id = string_to_index(descriptions, "my own description");
 * each FILE_DATA where the field FILE_dATA->descriptions is id contains the description
 * "my own description".
 * This can be used with categories the same way.
 */
const gint
string_to_index (GPtrArray * a, gchar * s)
{
  gint i;
  gint result = 0;
  i = a->len;

  while (i > 0)
    {
      i--;
      if (strcmp (((GString *) (g_ptr_array_index (a, i)))->str, s) == 0)
	{
	  result = i + 1;
	  break;
	}
    }
  return (result);
}
