/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <stdio.h>
#include <stdlib.h>

#include "folder.h"
#include "report.h"
#include "categories.h"
#include "config_common.h"

static gchar ALL_DISKS[] = N_("All disks");
static gchar ALL_CATEGORIES[] = N_("(All)");
static gchar CATEGORY_NONE[] = N_("(None)");
static GtkWidget *report_dialog_window;
static GtkWidget *disk_combo;
static GtkWidget *cat_combobox;
static GtkWidget *check_disks;
static GtkWidget *check_folders;
static GtkWidget *check_files;
static GtkWidget *check_category;
static GtkWidget *check_location;
static GtkWidget *check_description;
static GtkWidget *check_only_desc;
static GtkWidget *check_only_cat;
static GtkWidget *button_sortbycat;
static GtkWidget *button_sortbyfile;
static GSList *group_sort;
static GtkWidget *output_entry;
static GtkWidget *output_button;
static GtkWidget *report_selector;
static gboolean gb_check_disks;
static gboolean gb_check_folders;
static gboolean gb_check_files;
static gboolean gb_check_category;
static gboolean gb_check_location;
static gboolean gb_check_description;
static gboolean gb_check_only_desc;
static gboolean gb_check_only_cat;
static gint cat_to_report;

struct _FILE_and_int
{
  FILE *s;
  gint i;
};

void
_which_disk (GNode * gn, gpointer data)
{
  GNode **gntmp = data;
  if (strcmp
      (gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (disk_combo)->entry)),
       folder_get_name (gn)))
    {
      *gntmp = gn;
    }
}



void
_report_cats (GNode * gn, gpointer data)
{
  struct _FILE_and_int *si = data;
  FILE *file = si->s;
  gint cat = si->i;
  FILE_DATA *fd = get_file_data_from_gnode (gn);
  GString *gs;
  int i;

  if (((gb_check_folders) && (is_dir (gn) == TRUE))
      || ((gb_check_files == TRUE)
	  && ((is_file (gn) == TRUE) || (is_link (gn) == TRUE))))
    {

      if (((fd->categorie == cat) || (cat == -1))
	  && ((gb_check_only_desc == FALSE)
	      || ((gb_check_only_desc == TRUE) && (fd->description != 0))))
	{
	  fprintf (file, "         %s", fd->name->str);
	  if ((gb_check_description == TRUE) && (fd->description != 0))
	    fprintf (file, " : %s",
		     folder_get_description_from_file_data (fd));
	  if ((gb_check_folders) && (is_dir (gn)))
	    {
	      if (gb_check_location == TRUE)
		{
		  gs = get_path_from_node (gn);
		  fprintf (file, " (%s)", gs->str);
		  g_string_free (gs, TRUE);
		}
	    }
	  fprintf (file, "\n");
	}
    }
  if ((gb_check_folders) && (is_dir (gn)))
    {
      fprintf (file, "      ");
      for (i = 0; i < fd->name->len; i++)
	fprintf (file, "~");
      fprintf (file, "\n");
      g_node_children_foreach (gn, G_TRAVERSE_ALL, _report_cats, si);
    }



}

gboolean generate_cat_report (FOLDER * racine, FILE * file)
{
  gint i;
  gint j;
  gchar *the_cat;
  const gchar *tmpcat;
  GNode *disk_to_report = NULL;
  static struct _FILE_and_int _file_i;

  the_cat =
    g_strdup (gtk_entry_get_text
	      (GTK_ENTRY (GTK_COMBO (cat_combobox)->entry)));
  cat_to_report = -2;
  if (strlen (the_cat) == 0)
    {
      cat_to_report = 0;
    }
  else if (strcmp (the_cat, CATEGORY_NONE) == 0)
    {
      cat_to_report = 0;
    }
  else if (strcmp (the_cat, ALL_CATEGORIES) == 0)
    {
      cat_to_report = -1;
    }
  else
    {
      for (i = 1; i <= racine->categories->len; i++)
	{
	  if (strcmp (the_cat, get_categorie (racine, i)) == 0)
	    cat_to_report = i;
	}
    }
  if (cat_to_report == -2)
    {
      ERROR_DIALOG ("Wrong category", report_dialog_window);
      return (FALSE);
    }

  if (strcmp (gtk_entry_get_text
	      (GTK_ENTRY (GTK_COMBO (disk_combo)->entry)), ALL_DISKS) == 0)
    disk_to_report = racine->tree;
  else
    {
      disk_to_report = NULL;
      g_node_children_foreach (racine->tree, G_TRAVERSE_ALL,
			       _which_disk, &disk_to_report);
    }
  if (disk_to_report == NULL)
    {
      ERROR_DIALOG ("Wrong disk name", report_dialog_window);
      return (FALSE);
    }


  fprintf (file,
	   _
	   ("Categories present in archive\n=============================\n"));
  for (i = 0; i < racine->categories->len; i++)
    fprintf (file, "    %s\n", get_categorie (racine, i + 1));
  fprintf (file, "\n");
  if (cat_to_report == -1)
    {
      for (i = 1; i < racine->categories->len + 1; i++)
	{

	  tmpcat = get_categorie (racine, i);
	  fprintf (file, _("Category: %s\n=========="), tmpcat);
	  for (j = 0; j < strlen (tmpcat); j++)
	    fprintf (file, "=");
	  fprintf (file, "\n");

	  _file_i.i = i;
	  _file_i.s = file;
	  g_node_children_foreach (disk_to_report, G_TRAVERSE_ALL,
				   _report_cats, &_file_i);

	}
      if (gb_check_only_cat == FALSE)
	{
	  fprintf (file, _("Category: None\n==============\n"));
	  _file_i.i = 0;
	  _file_i.s = file;
	  g_node_children_foreach (disk_to_report, G_TRAVERSE_ALL,
				   _report_cats, &_file_i);
	}
    }
  else
    {
      if (cat_to_report != 0)
	{
	  tmpcat = get_categorie (racine, cat_to_report);
	  fprintf (file, _("Category: %s\n=========="), tmpcat);
	  for (j = 0; j < strlen (tmpcat); j++)
	    fprintf (file, "=");
	}
      else
	fprintf (file, _("Category: None\n=============="));
      fprintf (file, "\n");
      _file_i.i = cat_to_report;
      _file_i.s = file;
      g_node_children_foreach (disk_to_report, G_TRAVERSE_ALL, _report_cats,
			       &_file_i);
    }

  return TRUE;
}


void
_report_files (GNode * gn, gpointer data)
{
  FILE *file = data;
  FILE_DATA *fd = get_file_data_from_gnode (gn);
  int i;
  GString *gs;

  if (g_node_depth (gn) == 2)
    {
      if ((gb_check_disks == TRUE)
	  && ((cat_to_report == -1)
	      || (fd->categorie == cat_to_report))
	  && ((gb_check_only_desc == FALSE)
	      || ((gb_check_only_desc == TRUE) && (fd->description != 0))))
	{
	  fprintf (file, "\n%s\n", fd->name->str);
	  for (i = 0; i < fd->name->len; i++)
	    fprintf (file, "-");
	  fprintf (file, "\n");
	}
      g_node_children_foreach (gn, G_TRAVERSE_ALL, _report_files, file);
    }
  else
    {
      if (((gb_check_folders) && (is_dir (gn) == TRUE))
	  || ((gb_check_files)
	      && ((is_file (gn) == TRUE) || (is_link (gn) == TRUE))))
	{
	  if (
	      ((fd->categorie == cat_to_report)
	       || (cat_to_report == -1))
	      && ((gb_check_only_desc == FALSE)
		  || ((gb_check_only_desc == TRUE)
		      && (fd->description != 0)))
	      && ((((gb_check_only_cat == TRUE) && (fd->categorie != 0))
		   || (gb_check_only_cat == FALSE))))
	    {
	      for (i = 0; i < g_node_depth (gn) - 1; i++)
		fprintf (file, "  ");
	      fprintf (file, "%s", fd->name->str);
	      if ((gb_check_category == TRUE) && (fd->categorie != 0))
		fprintf (file, " : %s ",
			 folder_get_category_from_file_data (fd));
	      if ((gb_check_description == TRUE) && (fd->description != 0))
		fprintf (file, " : %s",
			 folder_get_description_from_file_data (fd));
	      if ((gb_check_folders) && (is_dir (gn)))
		{
		  if (gb_check_location == TRUE)
		    {
		      gs = get_path_from_node (gn);
		      fprintf (file, " (%s)", gs->str);
		      g_string_free (gs, TRUE);
		    }
		}
	      fprintf (file, "\n");
	    }
	}
      if ((gb_check_folders) && (is_dir (gn)))
	{
	  for (i = 0; i < g_node_depth (gn) - 1; i++)
	    fprintf (file, "  ");
	  for (i = 0; i < fd->name->len; i++)
	    fprintf (file, "~");
	  fprintf (file, "\n");
	  g_node_children_foreach (gn, G_TRAVERSE_ALL, _report_files, file);
	}
    }
}

gboolean
generate_file_report (FOLDER * racine, FILE * file)
{
  int i;
  char *the_cat;
  GNode *disk_to_report = NULL;

  the_cat =
    g_strdup (gtk_entry_get_text
	      (GTK_ENTRY (GTK_COMBO (cat_combobox)->entry)));
  cat_to_report = -2;
  if (strlen (the_cat) == 0)
    {
      cat_to_report = 0;
    }
  else if (strcmp (the_cat, CATEGORY_NONE) == 0)
    {
      cat_to_report = 0;
    }
  else if (strcmp (the_cat, ALL_CATEGORIES) == 0)
    {
      cat_to_report = -1;
    }
  else
    {
      for (i = 1; i <= racine->categories->len; i++)
	{
	  if (strcmp (the_cat, get_categorie (racine, i)) == 0)
	    cat_to_report = i;
	}
    }
  if (cat_to_report == -2)
    {
      ERROR_DIALOG ("Wrong category", report_dialog_window);
      return (FALSE);
    }

  if (strcmp (gtk_entry_get_text
	      (GTK_ENTRY (GTK_COMBO (disk_combo)->entry)), ALL_DISKS) == 0)
    disk_to_report = racine->tree;
  else
    {
      disk_to_report = NULL;
      g_node_children_foreach (racine->tree, G_TRAVERSE_ALL,
			       _which_disk, &disk_to_report);
    }
  if (disk_to_report == NULL)
    {
      ERROR_DIALOG ("Wrong disk name", report_dialog_window);
      return (FALSE);
    }

  g_node_children_foreach (disk_to_report, G_TRAVERSE_ALL, _report_files,
			   file);

  return (TRUE);
}

void
begin_report (GtkWidget * w, gpointer data)
{
  FOLDER *racine = data;

  char *path;
  FILE *file;
  gboolean result;

  path = gtk_entry_get_text (GTK_ENTRY (output_entry));
  if ((file = fopen (path, "w+")) == NULL)
    {
      ERROR_DIALOG
	("Can't create file. Permission denied, disk full or wrong path.",
	 report_dialog_window);
      return;
    }
  fprintf (file, _("This report was generated by GTKtalog.\n"));
  fprintf (file, "http://gtktalog.sourceforge.net\n\n");

  fprintf (file, _("The report type is: "));
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (button_sortbycat))
      == TRUE)
    {
      fprintf (file, _("Sort by category."));
    }
  else
    {
      fprintf (file, _("Sort by Disk->folder->file."));
    }
  fprintf (file, "\n===================\n");
  fprintf (file, _("  It contain:\n"));
  if (
      (gb_check_disks =
       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check_disks))) ==
      TRUE) fprintf (file, _("           - disk name.\n"));
  if (
      (gb_check_folders =
       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check_folders)))
      == TRUE) fprintf (file, _("           - folder name.\n"));
  if (
      (gb_check_files =
       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check_files))) ==
      TRUE) fprintf (file, _("           - file name.\n"));
  if (
      (gb_check_location =
       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check_location)))
      == TRUE) fprintf (file, _("           - directory location.\n"));
  if (
      (gb_check_description =
       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON
				     (check_description))) == TRUE)
    fprintf (file, _("           - description.\n"));
  if (
      (gb_check_category =
       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check_category)))
      == TRUE) fprintf (file, _("           - category.\n"));
  fprintf (file, "\n");
  if (
      (gb_check_only_cat =
       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check_only_cat)))
      == TRUE) fprintf (file, _("           - Just items with category.\n"));
  if (
      (gb_check_only_desc =
       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check_only_desc)))
      == TRUE)
    fprintf (file, _("           - Just items with description.\n"));
  fprintf (file, "\n");



  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (button_sortbycat))
      == TRUE)
    {
      result = generate_cat_report (racine, file);
    }
  else
    {
      result = generate_file_report (racine, file);
    }

  fclose (file);
  if (result == TRUE)
    WARNING_DIALOG ("Report successful.", report_dialog_window);

  return;
}

void
set_report_file (GtkWidget * w, gpointer data)
{
  gtk_entry_set_text (GTK_ENTRY (output_entry),
		      gtk_file_selection_get_filename (GTK_FILE_SELECTION
						       (report_selector)));
  gtk_widget_destroy (report_selector);
}

void
select_report_file (GtkWidget * w, gpointer data)
{
  report_selector = gtk_file_selection_new (_("File report"));
  gtk_signal_connect (GTK_OBJECT (report_selector), "destroy",
		      (GtkSignalFunc) gtk_widget_destroy, &report_selector);
  gtk_signal_connect (GTK_OBJECT
		      (GTK_FILE_SELECTION (report_selector)->ok_button),
		      "clicked", (GtkSignalFunc) set_report_file, NULL);
  gtk_signal_connect_object (GTK_OBJECT
			     (GTK_FILE_SELECTION
			      (report_selector)->cancel_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (report_selector));
  gtk_widget_show (report_selector);
}

static void
cancel_clicked (GtkWidget * w, gpointer data)
{
  gtk_widget_destroy (report_dialog_window);
  return;
}

static void
destroy_window (GtkWidget * w, GdkEventKey * event, gpointer data)
{
  cancel_clicked (w, data);
}

void
open_report_dialog (FOLDER * racine)
{
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *frame;
  GtkWidget *table;
  GtkWidget *my_button;

  GList *disk_list;
  GList *cat_list;

  report_dialog_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize (GTK_WIDGET (report_dialog_window), 290, 305);
  gtk_container_border_width (GTK_CONTAINER (report_dialog_window), 10);
  gtk_window_set_policy (GTK_WINDOW (report_dialog_window), FALSE, FALSE,
			 TRUE);
  gtk_window_set_title (GTK_WINDOW (report_dialog_window),
			_("Report generator"));
  gtk_signal_connect (GTK_OBJECT (report_dialog_window), "delete_event",
		      destroy_window, NULL);
  gtk_widget_show (report_dialog_window);


  vbox = gtk_vbox_new (FALSE, 4);
  gtk_container_add (GTK_CONTAINER (report_dialog_window), vbox);
  gtk_widget_show (vbox);

  /**************/
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  label = gtk_label_new (_("Disk:"));
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  disk_combo = gtk_combo_new ();
  gtk_combo_set_value_in_list (GTK_COMBO (disk_combo), FALSE, TRUE);
  gtk_combo_set_use_arrows_always (GTK_COMBO (disk_combo), TRUE);
  gtk_combo_disable_activate (GTK_COMBO (disk_combo));

  disk_list = make_disk_list (racine);
  disk_list = g_list_prepend (disk_list, ALL_DISKS);
  gtk_combo_set_popdown_strings (GTK_COMBO (disk_combo), disk_list);
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (disk_combo)->entry), FALSE);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (disk_combo)->entry),
		      _("All disks"));
  /* gtk_signal_connect(GTK_OBJECT(GTK_COMBO(disk_combo)->entry), "activate",
   * start_search,
   * GTK_OBJECT (search_dialog_window)); */
  gtk_box_pack_start (GTK_BOX (hbox), disk_combo, FALSE, FALSE, 0);
  gtk_widget_show (disk_combo);

  /********/


  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  label = gtk_label_new (_("Category:  "));
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  cat_combobox = gtk_combo_new ();
  gtk_combo_set_value_in_list (GTK_COMBO (cat_combobox), FALSE, TRUE);
  gtk_combo_set_use_arrows_always (GTK_COMBO (cat_combobox), TRUE);
  gtk_combo_disable_activate (GTK_COMBO (cat_combobox));

  cat_list = cat_list = make_categories_list (racine);
  cat_list = g_list_append (cat_list, ALL_CATEGORIES);
  cat_list = g_list_append (cat_list, CATEGORY_NONE);

  gtk_combo_set_popdown_strings (GTK_COMBO (cat_combobox), cat_list);
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (cat_combobox)->entry), FALSE);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (cat_combobox)->entry),
		      ALL_CATEGORIES);
  /* gtk_signal_connect(GTK_OBJECT(GTK_COMBO(cat_combobox)->entry), "activate",
   * start_search,
   * GTK_OBJECT (search_dialog_window)); */
  gtk_box_pack_start (GTK_BOX (hbox), cat_combobox, FALSE, FALSE, 0);
  gtk_widget_show (cat_combobox);

  /*********/

  frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame), _("Include to report"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
  gtk_widget_show (frame);

  table = gtk_table_new (3, 2, FALSE);
  gtk_container_add (GTK_CONTAINER (frame), table);
  gtk_widget_show (table);

  check_disks = gtk_check_button_new_with_label (_("Disks"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check_disks), TRUE);
  gtk_table_attach_defaults (GTK_TABLE (table), check_disks, 0, 1, 0, 1);
  gtk_widget_show (check_disks);

  check_folders = gtk_check_button_new_with_label (_("Folders"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check_folders), TRUE);
  gtk_table_attach_defaults (GTK_TABLE (table), check_folders, 0, 1, 1, 2);
  gtk_widget_show (check_folders);

  check_files = gtk_check_button_new_with_label (_("Files"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check_files), TRUE);
  gtk_table_attach_defaults (GTK_TABLE (table), check_files, 0, 1, 2, 3);
  gtk_widget_show (check_files);

  check_category = gtk_check_button_new_with_label (_("Category"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check_category), TRUE);
  gtk_table_attach_defaults (GTK_TABLE (table), check_category, 0, 1, 3, 4);
  gtk_widget_show (check_category);

  check_location = gtk_check_button_new_with_label (_("Location"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check_location), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), check_location, 1, 2, 0, 1);
  gtk_widget_show (check_location);

  check_description = gtk_check_button_new_with_label (_("Descriptions"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check_description), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), check_description, 1, 2,
			     1, 2);
  gtk_widget_show (check_description);

  check_only_desc =
    gtk_check_button_new_with_label (_("Only items with description"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check_only_desc), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), check_only_desc, 1, 2, 2, 3);
  gtk_widget_show (check_only_desc);

  check_only_cat =
    gtk_check_button_new_with_label (_("Only items with category"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check_only_cat), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), check_only_cat, 1, 2, 3, 4);
  gtk_widget_show (check_only_cat);

  /************/
  frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame), _("Sort by"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
  gtk_widget_show (frame);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_container_add (GTK_CONTAINER (frame), hbox);
  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
  gtk_widget_show (hbox);

  button_sortbycat = gtk_radio_button_new_with_label (NULL, _("Category"));
  gtk_box_pack_start (GTK_BOX (hbox), button_sortbycat, TRUE, TRUE, 0);
  gtk_widget_show (button_sortbycat);

  group_sort = gtk_radio_button_group (GTK_RADIO_BUTTON (button_sortbycat));
  button_sortbyfile =
    gtk_radio_button_new_with_label (group_sort, _("Disk->folder->File"));
  gtk_box_pack_start (GTK_BOX (hbox), button_sortbyfile, TRUE, TRUE, 0);
  gtk_widget_show (button_sortbyfile);

  /************/
  frame = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
  gtk_widget_show (frame);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_container_add (GTK_CONTAINER (frame), hbox);
  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
  gtk_widget_show (hbox);

  label = gtk_label_new (_("Output File:"));
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  output_entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (hbox), output_entry, FALSE, FALSE, 0);
  gtk_widget_show (output_entry);

  output_button = gtk_button_new_with_label ("...");
  gtk_signal_connect (GTK_OBJECT (output_button), "clicked",
		      GTK_SIGNAL_FUNC (select_report_file), NULL);
  gtk_box_pack_start (GTK_BOX (hbox), output_button, FALSE, FALSE, 0);
  gtk_widget_show (output_button);

  /*******************/
  /* Et c'est le tour de la petite boite a boutons! */
  hbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbox), 0);
  gtk_button_box_set_child_size (GTK_BUTTON_BOX (hbox), 0, 0);

  gtk_container_border_width (GTK_CONTAINER (hbox), 1);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  my_button = gtk_button_new_with_label (_("Create report"));
  GTK_WIDGET_SET_FLAGS (my_button, GTK_CAN_DEFAULT);
  gtk_window_set_default (GTK_WINDOW (report_dialog_window), my_button);
  gtk_box_pack_start (GTK_BOX (hbox), my_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (my_button), "clicked",
		      GTK_SIGNAL_FUNC (begin_report), racine);
  gtk_widget_show (my_button);

  my_button = gtk_button_new_with_label (_("Exit"));
  GTK_WIDGET_SET_FLAGS (my_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox), my_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (my_button), "clicked", cancel_clicked,
		      NULL);
  gtk_widget_show (my_button);

}
