/*  GTKtalog.
 *  Copyright (C) 1999-2000  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

#include "setup.h"
#include "interface.h"

#include "config_common.h"

#include "on.xpm"
#include "off.xpm"

/* setup dialog */
static GtkWidget *include_list_box;
static GtkWidget *mount_entry;
static GtkWidget *umount_entry;
static GtkWidget *mount_point_entry;
static GtkWidget *eject_entry;
static GtkWidget *checkbutton_dus;
static GtkWidget *checkbutton_warnMount;
static GtkWidget *checkbutton_eject;
static GtkWidget *compression_level;
static GdkPixmap *on_pix;
static GdkPixmap *off_pix;
static GtkStyle *style;
static GdkBitmap *state_mask;
static GtkWidget *window;
static gint selected_row;

/* Add type dialog */
static GtkWidget *include_type_entry;
static GtkWidget *include_prog_entry;
static GtkWidget *include_arg_entry;
static GtkWidget *include_viewer_entry;
static GtkWidget *include_viewer_arg_entry;
static GtkWidget *add_type_window;

EXTENSIONS *selected_extension;

gboolean
extensions_traverse (gpointer key, gpointer value, gpointer data)
{
  EXTENSIONS *e = value;
  gint i;
  gchar *tmp[6] = { "", "", "", "", "", "" };

  tmp[1] = e->extension->str;
  tmp[2] = e->prog->str;
  tmp[3] = e->arg->str;
  tmp[4] = e->viewer->str;
  tmp[5] = e->viewerarg->str;
  i = gtk_clist_append ((GtkCList *) include_list_box, (gchar **) tmp);
  gtk_clist_set_row_data ((GtkCList *) include_list_box, i, e);
  if (e->state == FALSE)
    gtk_clist_set_pixmap ((GtkCList *) include_list_box, i, 0,
			  off_pix, state_mask);
  else
    gtk_clist_set_pixmap ((GtkCList *) include_list_box, i, 0,
			  on_pix, state_mask);
  return (FALSE);
}

gint
pix_tree_printf (gpointer key, gpointer value, gpointer data)
{
  GString *g;
  FILE *f = data;

  g = ((PIX *) value)->path;
  fprintf (f, "AddIcon %s %s\n", g->str, (gchar *) key);
  return (FALSE);
}

gint
extensions_tree_printf (gpointer key, gpointer value, gpointer data)
{
  FILE *f = data;
  EXTENSIONS *e = value;
  gint state = 1;
  if (e->state == FALSE)
    state = 0;

  fprintf (f, "AddExtension '%s' '%s' '%s' '%s' '%s' %d\n",
	   e->extension->str,
	   e->prog->str, e->arg->str, e->viewer->str, e->viewerarg->str,
	   state);
  return (FALSE);
}

void
setup_ok_clicked (GtkWidget * w, gpointer data)
{
  FILE *f;
  GString *conf_file;

  g_string_free (my_config->mount, TRUE);
  g_string_free (my_config->umount, TRUE);
  g_string_free (my_config->eject_prog, TRUE);
  g_string_free (my_config->mount_point, TRUE);

  /* Get Config */
  my_config->mount =
    g_string_new (gtk_entry_get_text (GTK_ENTRY (mount_entry)));
  my_config->umount =
    g_string_new (gtk_entry_get_text (GTK_ENTRY (umount_entry)));
  my_config->eject_prog =
    g_string_new (gtk_entry_get_text (GTK_ENTRY (eject_entry)));
  my_config->mount_point =
    g_string_new (gtk_entry_get_text (GTK_ENTRY (mount_point_entry)));
  my_config->use_supermount = check_supermount(my_config);
  /* Config Options */
  my_config->use_du_s =
    (gboolean) (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON (checkbutton_dus)));
  my_config->eject_disk =
    (gboolean) (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON (checkbutton_eject)));
  my_config->warn_mount =
    (gboolean) (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON (checkbutton_warnMount)));
  my_config->compression_level = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(compression_level));



  conf_file = g_string_new (g_get_home_dir ());
  if (conf_file->len < 1)
    {
      gnome_dialog_run_and_close (GNOME_DIALOG
				  (gnome_warning_dialog_parented
				   (_
				    ("Home directory not found. Setup will not be saved."),
				    GTK_WINDOW (main_window))));
    }
  else
    {
      conf_file = g_string_append (conf_file, USER_CONFIG_DIR);
      if (!g_file_test (conf_file->str, G_FILE_TEST_ISDIR))
	{
	  mkdir (conf_file->str, 493);
	}
      conf_file = g_string_append (conf_file, "/" USER_CONFIG_FILE);

      if (!(f = fopen (conf_file->str, "w+")))
	{
	  ERROR_DIALOG ("Can't save to config file", main_window);
	}
      else
	{
	  fprintf (f, _("# Sample config file for gtktalog\n\n"));
	  fprintf (f,
		   _
		   ("# AddIcon icon_path extension [extension [extension [...]]]\n\n"));
	  g_tree_traverse (my_config->icons, pix_tree_printf, G_PRE_ORDER, f);
	  fprintf (f,
		   _
		   ("\n# AddExtension extension plugin arguments viewer viewer_args state\n"));
	  g_tree_traverse (my_config->extensions, extensions_tree_printf,
			   G_PRE_ORDER, f);
	  fprintf (f, _("\n# DefaultFileIcon icon_path\n"));
	  fprintf (f, "DefaultFileIcon %s\n",
		   my_config->default_file_pix->path->str);
	  fprintf (f, _("# DefaultDiskIcon icon_path\n"));
	  fprintf (f, "DefaultDiskIcon %s\n",
		   my_config->default_disk_pix->path->str);
	  fprintf (f, _("# DefaultDirIcon icon_path\n"));
	  fprintf (f, "DefaultDirIcon %s\n",
		   my_config->default_dir_pix->path->str);
	  fprintf (f, _("\n# MountProgram path\n"));
	  fprintf (f, "MountProgram %s\n", my_config->mount->str);
	  fprintf (f, _("# UmountProgram path\n"));
	  fprintf (f, "UmountProgram %s\n", my_config->umount->str);
	  fprintf (f, _("# EjectProgram path\n"));
	  fprintf (f, "EjectProgram %s\n", my_config->eject_prog->str);
	  fprintf (f, _("# MountPoint path\n"));
	  fprintf (f, "MountPoint %s\n", my_config->mount_point->str);

	  /* Options */
	  fprintf (f, _("\n# Options \n"));
	  fprintf (f, _("# Only use True or False for the following\n"));
	  fprintf (f, _("# Use du -s to get the size of the disk\n"));
	  fprintf (f, "OptionDus %s\n",
		   (my_config->use_du_s ? "True" : "False"));
	  fprintf (f, _("# Warn if a disk is mounted\n"));
	  fprintf (f, "OptionWarnMount %s\n",
		   (my_config->warn_mount ? "True" : "False"));
	  fprintf (f, _("# Eject the disk after a fast scan\n"));
	  fprintf (f, "OptionEject %s\n",
		   (my_config->eject_disk ? "True" : "False"));
	  fprintf (f, _("# Compression level for saving files\n"));
	  fprintf (f, "CompressionLevel %d\n",
		   (my_config->compression_level));

	  fclose (f);
	}

    }


  gtk_widget_destroy (window);
}

void
add_type_ok_clicked (GtkWidget * w, gpointer data)
{
  EXTENSIONS *e2;

  char *temp_type;
  char *temp_prog;
  char *temp_arg;
  char *temp_viewer;
  char *temp_viewerarg;

  temp_type =
    gtk_editable_get_chars (GTK_EDITABLE (include_type_entry), 0, -1);
  e2 = g_tree_lookup (my_config->extensions, temp_type);

  if (e2 && (e2 != selected_extension))
    {
      gnome_dialog_run_and_close (GNOME_DIALOG
				  (gnome_warning_dialog_parented
				   (_
				    ("This extension already exists. Nothing will be done."),
				    GTK_WINDOW (add_type_window))));
      g_free (temp_type);
    }
  else
    {
      if (selected_row >= 0)
	{
	  g_string_free (selected_extension->extension, TRUE);
	  g_string_free (selected_extension->prog, TRUE);
	  g_string_free (selected_extension->arg, TRUE);
	  g_string_free (selected_extension->viewer, TRUE);
	  g_string_free (selected_extension->viewerarg, TRUE);
	  g_tree_remove (my_config->extensions, selected_extension);
	  gtk_clist_remove (GTK_CLIST (include_list_box),
			    selected_row);

	}
      else
	{

	  selected_extension = (EXTENSIONS *) g_malloc (sizeof (EXTENSIONS));
	}
      temp_type =
	gtk_editable_get_chars (GTK_EDITABLE (include_type_entry), 0, -1);
      temp_prog =
	gtk_editable_get_chars (GTK_EDITABLE (include_prog_entry), 0, -1);
      temp_arg =
	gtk_editable_get_chars (GTK_EDITABLE (include_arg_entry), 0, -1);
      temp_viewer =
	gtk_editable_get_chars (GTK_EDITABLE (include_viewer_entry), 0,
				-1);
      temp_viewerarg =
	gtk_editable_get_chars (GTK_EDITABLE (include_viewer_arg_entry),
				0, -1);
      selected_extension->extension = g_string_new (temp_type);
      g_free (temp_type);
      selected_extension->prog = g_string_new (temp_prog);
      g_free (temp_prog);
      selected_extension->arg = g_string_new (temp_arg);
      g_free (temp_arg);
      selected_extension->viewer = g_string_new (temp_viewer);
      g_free (temp_viewer);
      selected_extension->viewerarg = g_string_new (temp_viewerarg);
      g_free (temp_viewerarg);
      g_tree_insert (my_config->extensions, selected_extension->extension->str, selected_extension);

      extensions_traverse (selected_extension->extension->str, selected_extension, NULL);

    }
  gtk_widget_destroy (add_type_window);
}


void
add_type (GtkWidget * w, gpointer data)
{
  GtkWidget *vbox, *hbox, *vbox2;
  GtkWidget *ok, *cancel;
  GtkWidget *frame;
  GtkWidget *label;

  add_type_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_position (GTK_WINDOW (add_type_window),
			   GTK_WIN_POS_MOUSE);
  gtk_widget_set_usize (GTK_WIDGET (add_type_window), 300, 295);
  gtk_window_set_title (GTK_WINDOW (add_type_window), _("File type"));
  gtk_window_set_policy (GTK_WINDOW (add_type_window), FALSE, FALSE,
			 TRUE);
  gtk_container_border_width (GTK_CONTAINER (add_type_window), 10);
  gtk_signal_connect (GTK_OBJECT (add_type_window), "delete_event",
		      GTK_SIGNAL_FUNC (gtk_widget_destroy),
		      GTK_OBJECT (add_type_window));

  gtk_grab_add (add_type_window);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (add_type_window), vbox);
  gtk_widget_show (vbox);
  /***************/
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("File Type"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  include_type_entry = gtk_entry_new_with_max_length (80);

  if (selected_extension)
    gtk_entry_set_text (GTK_ENTRY (include_type_entry),
			selected_extension->extension->str);
  gtk_entry_select_region (GTK_ENTRY (include_type_entry), 0,
			   GTK_ENTRY (include_type_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox2), include_type_entry, FALSE, FALSE,
		      0);
  gtk_widget_show (include_type_entry);

  label = gtk_label_new (_("For example '.rpm'"));
  gtk_box_pack_start (GTK_BOX (vbox2), label, TRUE, FALSE, 0);
  gtk_widget_show (label);

  /***********/
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame),
		       _("Plugin to get information about files"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  include_prog_entry = gtk_entry_new_with_max_length (80);

  if (selected_extension)
    gtk_entry_set_text (GTK_ENTRY (include_prog_entry), selected_extension->prog->str);
  gtk_entry_select_region (GTK_ENTRY (include_prog_entry), 0,
			   GTK_ENTRY (include_prog_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox2), include_prog_entry, FALSE, FALSE,
		      0);
  gtk_widget_show (include_prog_entry);

  label = gtk_label_new (_("Leave blank to include all the file"));
  gtk_box_pack_start (GTK_BOX (vbox2), label, TRUE, FALSE, 0);
  gtk_widget_show (label);

  /***********/
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("Plugin Option"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  include_arg_entry = gtk_entry_new_with_max_length (80);

  if (selected_extension)
    gtk_entry_set_text (GTK_ENTRY (include_arg_entry), selected_extension->arg->str);
  gtk_entry_select_region (GTK_ENTRY (include_arg_entry), 0,
			   GTK_ENTRY (include_arg_entry)->text_length);
  gtk_container_add (GTK_CONTAINER (frame), include_arg_entry);
  gtk_widget_show (include_arg_entry);

  /***********/

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("Viewer"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  include_viewer_entry = gtk_entry_new_with_max_length (80);

  if (selected_extension)
    gtk_entry_set_text (GTK_ENTRY (include_viewer_entry), selected_extension->viewer->str);
  gtk_entry_select_region (GTK_ENTRY (include_viewer_entry), 0,
			   GTK_ENTRY (include_viewer_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox2), include_viewer_entry, FALSE, FALSE,
		      0);
  gtk_widget_show (include_viewer_entry);

  label = gtk_label_new (_("Leave blank to use GTKtalog viewer"));
  gtk_box_pack_start (GTK_BOX (vbox2), label, TRUE, FALSE, 0);
  gtk_widget_show (label);


  /***********/

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("Viewer Option"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  include_viewer_arg_entry = gtk_entry_new_with_max_length (80);

  if (selected_extension)
    gtk_entry_set_text (GTK_ENTRY (include_viewer_arg_entry),
			selected_extension->viewerarg->str);
  gtk_entry_select_region (GTK_ENTRY (include_viewer_arg_entry), 0,
			   GTK_ENTRY (
				      include_viewer_arg_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox2), include_viewer_arg_entry, FALSE,
		      FALSE, 0);
  gtk_widget_show (include_viewer_arg_entry);


/********************************/


  hbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbox), 5);

  ok = gtk_button_new_with_label (_("Ok"));
  GTK_WIDGET_SET_FLAGS (ok, GTK_CAN_DEFAULT);
  gtk_window_set_default (GTK_WINDOW (add_type_window), ok);
  gtk_box_pack_start (GTK_BOX (hbox), ok, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok), "clicked",
		      GTK_SIGNAL_FUNC (add_type_ok_clicked), NULL);
  gtk_widget_show (ok);

  cancel = gtk_button_new_with_label (_("Cancel"));
  GTK_WIDGET_SET_FLAGS (cancel, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox), cancel, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancel), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (add_type_window));
  gtk_widget_show (cancel);

  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  gtk_widget_show (add_type_window);

}



void
include_selection_made (GtkWidget * clist, gint row, gint column,
			GdkEventButton * event, gpointer data)
{
  EXTENSIONS *clrow_data;

  selected_row = row;
  clrow_data = gtk_clist_get_row_data (GTK_CLIST (include_list_box), row);
  selected_extension = clrow_data;

  if (event != NULL && event->button == 1 && event->type == GDK_2BUTTON_PRESS)
    {
      if (clrow_data->state == FALSE)
	{
	  clrow_data->state = TRUE;
	  gtk_clist_set_pixmap ((GtkCList *) include_list_box, row, 0,
				on_pix, state_mask);
	}
      else
	{
	  clrow_data->state = FALSE;
	  gtk_clist_set_pixmap ((GtkCList *) include_list_box, row, 0,
				off_pix, state_mask);
	}
    }
}

void
include_unselection_made (GtkWidget * clist, gint row, gint column,
			  GdkEventButton * event, gpointer data)
{
  selected_extension = NULL;
  selected_row = -1;
}

void
include_edit_button_clicked (GtkWidget * w, gpointer data)
{
  if (selected_extension
      && (selected_row >= 0))
    add_type (w, NULL);
}


void
include_delete_button_clicked (GtkWidget * w, gpointer data)
{
  if (selected_row >= 0)
    {
      g_tree_remove (my_config->extensions,
		           selected_extension );
      g_free (selected_extension);
      selected_extension = NULL;
      gtk_clist_remove (GTK_CLIST (include_list_box), selected_row);
      selected_row = -1;
    }
}
static void
cancel_clicked (GtkWidget * w, gpointer data)
{
  gtk_widget_destroy (window);
  return;
}

static void destroy_window(GtkWidget * w, GdkEventKey *event, gpointer data)
{
  cancel_clicked(w, data);
}

void
run_setup ()
{
  GtkWidget *ok;
  GtkWidget *cancel;
  GtkWidget *notebook;
  GtkWidget *frame;
  GtkWidget *label;
  GtkWidget *hbox;
  GtkWidget *main_vbox;
  GtkWidget *bbox;
  GtkWidget *setup_vbox;
  GtkWidget *add_button;
  GtkWidget *delete_button;
  GtkWidget *edit_button;
  GtkWidget *vbox2, *vbox3;
  GtkWidget *scrolled_window;
  GtkWidget *compression_level_label;
  GtkAdjustment *compression_level_adj;
  gchar *titles[6] = { N_("State"),
    N_("File type"),
    N_("Plugin"),
    N_("Options"),
    N_("Viewer"),
    N_("Viewer Options")
  };

  selected_row = -1;
  selected_extension = NULL;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE,
			 TRUE);
  gtk_window_set_title (GTK_WINDOW (window), _("Setup"));
  gtk_widget_set_usize (GTK_WIDGET (window), 370, 335);
  gtk_signal_connect (GTK_OBJECT (window),
		      "delete_event", destroy_window, NULL);


  gtk_widget_realize (window);

  /* pixmap stuff */
  style = gtk_widget_get_style (window);
  on_pix =
    gdk_pixmap_create_from_xpm_d (window->window,
				  &(state_mask),
				  &(
				    style)->bg[GTK_STATE_NORMAL],
				  (gchar **) on_xpm);
  gtk_widget_unrealize (window);

  gtk_widget_realize (window);
  style = gtk_widget_get_style (window);
  off_pix =
    gdk_pixmap_create_from_xpm_d (window->window,
				  &(state_mask),
				  &(
				    style)->bg[GTK_STATE_NORMAL],
				  (gchar **) off_xpm);
  gtk_widget_unrealize (window);

  gtk_container_set_border_width (GTK_CONTAINER (window), 2);
  gtk_grab_add (window);


  /* The notebook */
  setup_vbox = gtk_vbox_new (FALSE, 4);
  gtk_container_add (GTK_CONTAINER (window), setup_vbox);
  gtk_widget_show (setup_vbox);

  notebook = gtk_notebook_new ();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
  gtk_box_pack_start (GTK_BOX (setup_vbox), notebook, TRUE, TRUE, 0);
  /*gtk_container_add (GTK_CONTAINER (setup_window), notebook); */
  /*gtk_table_attach_defaults(GTK_TABLE(table), notebook, 0,6,0,1); */
  gtk_widget_show (notebook);


  /* first frame */
  frame = gtk_frame_new (_("Cases are not sensitive for files type"));
  gtk_container_set_border_width (GTK_CONTAINER (frame), 3);

  gtk_widget_show (frame);

  label = gtk_label_new (_("Files to include"));
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

  main_vbox = gtk_vbox_new (FALSE, 4);
  gtk_container_add (GTK_CONTAINER (frame), main_vbox);
  gtk_widget_show (main_vbox);


  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  gtk_box_pack_start (GTK_BOX (main_vbox), scrolled_window, TRUE, TRUE, 0);
  gtk_widget_show (scrolled_window);

  /* setup box to associate programs to file extensions */
  include_list_box = gtk_clist_new_with_titles (6, titles);
  gtk_signal_connect (GTK_OBJECT (include_list_box),
		      "select_row", GTK_SIGNAL_FUNC (include_selection_made),
		      NULL);
  gtk_signal_connect (GTK_OBJECT (include_list_box),
		      "unselect_row",
		      GTK_SIGNAL_FUNC (include_unselection_made), NULL);

  gtk_clist_set_shadow_type (GTK_CLIST (include_list_box),
			     GTK_SHADOW_OUT);
  gtk_clist_set_column_width (GTK_CLIST (include_list_box), 0,
			      25);
  gtk_clist_set_column_width (GTK_CLIST (include_list_box), 1,
			      60);
  gtk_clist_set_column_width (GTK_CLIST (include_list_box), 2,
			      60);
  gtk_clist_set_column_width (GTK_CLIST (include_list_box), 3,
			      60);
  gtk_clist_set_column_width (GTK_CLIST (include_list_box), 4,
			      60);
  // gtk_signal_connect(GTK_OBJECT(clist), "button_press_event", GTK_SIGNAL_FUNC(clist_pressed), NULL);
  gtk_clist_set_column_justification (GTK_CLIST
				      (include_list_box), 0,
				      GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_auto_resize (GTK_CLIST
				    (include_list_box), 5,
				    TRUE);

  /* fill the clist */
  g_tree_traverse (my_config->extensions, extensions_traverse, G_PRE_ORDER,
		   NULL);

  /* show the clist */
  gtk_container_add (GTK_CONTAINER (scrolled_window),
		     include_list_box);
  gtk_widget_show (include_list_box);

  hbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbox), 5);

  add_button = gtk_button_new_with_label (_("Add"));
  GTK_WIDGET_SET_FLAGS (add_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox), add_button, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (add_button), "clicked",
		      GTK_SIGNAL_FUNC (add_type), NULL);
  gtk_widget_show (add_button);

  edit_button = gtk_button_new_with_label (_("Edit"));
  GTK_WIDGET_SET_FLAGS (edit_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox), edit_button, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (edit_button), "clicked",
		      GTK_SIGNAL_FUNC (include_edit_button_clicked),
		      NULL);
  gtk_widget_show (edit_button);

  delete_button = gtk_button_new_with_label (_("Delete"));
  GTK_WIDGET_SET_FLAGS (delete_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox), delete_button, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (delete_button), "clicked",
		      GTK_SIGNAL_FUNC (include_delete_button_clicked),
		      NULL);
  gtk_widget_show (delete_button);

  gtk_box_pack_start (GTK_BOX (main_vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show (hbox);


/*******************************************************************************************/
  /* frame for fastaddisk */
  frame = gtk_frame_new (_("Complete informations"));
  gtk_container_set_border_width (GTK_CONTAINER (frame), 3);

  gtk_widget_show (frame);


  label = gtk_label_new (_("Disk setup"));
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

  main_vbox = gtk_vbox_new (FALSE, 4);
  gtk_container_add (GTK_CONTAINER (frame), main_vbox);
  gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 3);
  gtk_widget_show (main_vbox);

	/**************/
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("Mount program"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  mount_entry = gtk_entry_new_with_max_length (200);
  gtk_entry_set_text (GTK_ENTRY (mount_entry),
		      my_config->mount->str);
  gtk_box_pack_start (GTK_BOX (vbox2), mount_entry, FALSE,
		      FALSE, 0);
  gtk_widget_show (mount_entry);

	/*************/

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("Umount program"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  umount_entry = gtk_entry_new_with_max_length (200);
  gtk_entry_set_text (GTK_ENTRY (umount_entry),
		      my_config->umount->str);
  gtk_box_pack_start (GTK_BOX (vbox2), umount_entry, FALSE,
		      FALSE, 0);
  gtk_widget_show (umount_entry);

	/**************/

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("Mount point"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  mount_point_entry = gtk_entry_new_with_max_length (200);
  gtk_entry_set_text (GTK_ENTRY (mount_point_entry),
		      my_config->mount_point->str);
  gtk_box_pack_start (GTK_BOX (vbox2), mount_point_entry,
		      FALSE, FALSE, 0);
  gtk_widget_show (mount_point_entry);

  label =
    gtk_label_new (_
		   ("This has to be the mount point registered in /etc/fstab"));
  gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

/***************/

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("Eject Program"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  eject_entry = gtk_entry_new_with_max_length (200);
  gtk_entry_set_text (GTK_ENTRY (eject_entry), my_config->eject_prog->str);
  gtk_box_pack_start (GTK_BOX (vbox2), eject_entry, FALSE, FALSE, 0);
  gtk_widget_show (eject_entry);

/*****  General Options  *******************************************************************/

  /* Create the frame */
  frame = gtk_frame_new (_("General Options"));
  gtk_container_set_border_width (GTK_CONTAINER (frame), 3);

  gtk_widget_show (frame);

  /* Create the top label */
  label = gtk_label_new (_("Options"));
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

  /* VBox to keep the objects */
  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox3);
  gtk_widget_show (vbox3);

  /* Option to use du -s or statfs */
  /* FIXME : Find another label */
  checkbutton_dus =
    gtk_check_button_new_with_label (_("Use du -s instead of statfs"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_dus),
				my_config->use_du_s);
  gtk_widget_show (checkbutton_dus);
  gtk_box_pack_start (GTK_BOX (vbox3), checkbutton_dus, FALSE, FALSE, 0);

  /* Option to warn if the cd is mounted */
  checkbutton_warnMount =
    gtk_check_button_new_with_label (_("Warn if the CD is mounted"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_warnMount),
				my_config->warn_mount);
  gtk_widget_show (checkbutton_warnMount);
  gtk_box_pack_start (GTK_BOX (vbox3), checkbutton_warnMount, FALSE, FALSE,
		      0);

  /* Option to eject the CD */
  checkbutton_eject =
    gtk_check_button_new_with_label (_("Eject the CD after fast scan"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_eject),
				my_config->eject_disk);
  gtk_widget_show (checkbutton_eject);
  gtk_box_pack_start (GTK_BOX (vbox3), checkbutton_eject, FALSE, FALSE, 0);

  /* Option for compression level */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);
  
  compression_level_label =
    gtk_label_new (_("Compression level"));
  gtk_widget_show (compression_level_label);
  gtk_box_pack_start (GTK_BOX (hbox), compression_level_label, FALSE, FALSE, 0);

  compression_level_adj = (GtkAdjustment *)gtk_adjustment_new (9, 0, 9, 1, 1, 9);
  compression_level = gtk_spin_button_new (GTK_ADJUSTMENT (compression_level_adj), 1, 0);
  gtk_widget_show (compression_level);
  gtk_box_pack_start (GTK_BOX (hbox), compression_level, FALSE, FALSE, 0);


/*******************************************************************************************/
  /* Bottom buttons */
  bbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (bbox), 5);
  gtk_box_pack_start (GTK_BOX (setup_vbox), bbox, FALSE, FALSE, 0);
  gtk_widget_show (bbox);

  ok = gtk_button_new_with_label (_("Save"));
  gtk_object_set_user_data (GTK_OBJECT (ok), window);
  GTK_WIDGET_SET_FLAGS (ok, GTK_CAN_DEFAULT);
  gtk_window_set_default (GTK_WINDOW (window), ok);
  gtk_box_pack_start (GTK_BOX (bbox), ok, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok), "clicked",
		      GTK_SIGNAL_FUNC (setup_ok_clicked), NULL);
  gtk_widget_show (ok);

  cancel = gtk_button_new_with_label (_("Cancel"));
  GTK_WIDGET_SET_FLAGS (cancel, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (bbox), cancel, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (cancel), "clicked", cancel_clicked,
		      NULL);
  gtk_widget_show (cancel);

  gtk_widget_show (window);
}
