/*  NCatalog , the GTKtalog ncurses GUI.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <ncurses.h>

extern int largeur;
extern int hauteur;

void display_information(char *info, char *titre)
{
  unsigned int nb_lignes; 
  int key;
  WINDOW *pad;
  WINDOW *title_pad;
  WINDOW *tmp_pad;
  int local_decalage = 0;
  int pourcent;
  char pourcentage[8];
  int l;
  int tmp;
  int tmp_val;
  char entete[100];

  char *p;

  l = 0;
  nb_lignes = 0;

  tmp = 0;
  tmp_val = 0;
  tmp_pad = newpad(1,1);
  wbkgd(tmp_pad, A_REVERSE);

  p = info;

  while(*p != '\0')
    { 
      if(*p == '\n')
	{
	  nb_lignes++;
	  l = 0;
	}
      else if(l > largeur) 
	{
	  nb_lignes++;
	  l = 0; 
	}
      else l++;
      p++;
    }

  delwin(tmp_pad);
  
  if(nb_lignes < hauteur) pad = newpad(hauteur,largeur);
  else pad = newpad(nb_lignes,largeur); 
  
  sprintf(entete,"%s   %d lines  %u bytes",titre,nb_lignes,strlen(info));
  title_pad = newpad(1,largeur); 
  mvwaddstr(title_pad,0,1,entete);
  if(nb_lignes < (hauteur -1)) pourcent = 100;
  else pourcent = ((local_decalage + hauteur -1)*100)/nb_lignes;
  sprintf(pourcentage,"%d%c  ",pourcent,'%');
  
  mvwaddstr(title_pad,0,largeur -5,pourcentage);
  wbkgd(title_pad, A_REVERSE);
  prefresh(title_pad,0,0,0,0,0,largeur); 

  mvwaddstr(pad,0,0,info);
  prefresh(pad,0,0,1,0,hauteur,largeur); 

  while(1)
    {
      key = getch();
      switch(key)
	{
	case KEY_UP:
	  if(local_decalage > 0) local_decalage--;
	  prefresh(pad,local_decalage,0,1,0,hauteur,largeur);

	  if(nb_lignes < (hauteur -1)) pourcent = 100;
	  else pourcent = ((local_decalage + hauteur -1)*100)/nb_lignes;
	  sprintf(pourcentage,"%d%c  ",pourcent,'%');
	  mvwaddstr(title_pad,0,largeur -5,pourcentage);
	  wbkgd(title_pad, A_REVERSE);
	  prefresh(title_pad,0,0,0,0,0,largeur); 
	  break;
	case KEY_DOWN:
	  if(local_decalage+hauteur -1 < nb_lignes) local_decalage++;
	   prefresh(pad,local_decalage,0,1,0,hauteur,largeur);

	   if(nb_lignes < (hauteur -1)) pourcent = 100;
	   else pourcent = ((local_decalage + hauteur -1)*100)/nb_lignes;
	   sprintf(pourcentage,"%d%c  ",pourcent,'%');
	   mvwaddstr(title_pad,0,largeur -5,pourcentage);
	   wbkgd(title_pad, A_REVERSE);
	   prefresh(title_pad,0,0,0,0,0,largeur); 
	   break;
	case KEY_F(10):
	  delwin(pad);
	  delwin(title_pad);
	  return;
	}
    }
}
