/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <config.h>
#include <gnome.h>
#include "progressbar.h"

static GtkWidget *progress_appbar = NULL;
static gulong progress_currentValue = 0;
static gulong progress_totalValue = 100;
static gboolean progress_INeedReset = TRUE;

void
progress_reset ()
{
  progress_INeedReset = FALSE;
}

gboolean progress_needReset ()
{
  return progress_INeedReset;
}

/* Return the size of the filesystem
   FIXME: Will take the size of the current filesystem.
        That means it won't work if you only try to catalog a part of a drive
*/
glong getStats (char *foldername)
{
  struct statfs statBuf;

  if (statfs (foldername, &statBuf) == -1)
    return -1;


  /* Total size of the CD in Bytes */
  return statBuf.f_blocks * statBuf.f_bsize;
}

void
progress_createTimeout ()
{
  gtk_timeout_add (500, progress_timeout, NULL);
}

/* Update the progress_bar.
   The progress bar must be passed with a gpointer */
gint progress_timeout (gpointer pstru)
{
  gfloat new_val;

  new_val = progress_currentValue / ((float) progress_totalValue);

  /* Set the new value */
  if (new_val > 0.99)
    new_val = 1;
  if (new_val >= 0)
    gnome_appbar_set_progress (GNOME_APPBAR (progress_appbar), new_val);

  /* Stop the timer */
  if (new_val == 1)
    {
      progress_INeedReset = TRUE;
      gnome_appbar_set_progress (GNOME_APPBAR (progress_appbar), 0);
      return (FALSE);
    }

  /* As this is a timeout function, return TRUE so that it
   * continues to get called */
  return (TRUE);
}

void
progress_setTotal (gulong total)
{
  progress_totalValue = total;
}

void
progress_setCurrent (gulong current)
{
  progress_currentValue = current;
}

gulong
progress_getCurrent ()
{
  return progress_currentValue;
}

void
progress_setStatus (gchar * msg)
{
  gnome_appbar_set_status (GNOME_APPBAR (progress_appbar), msg);
  gnome_appbar_refresh (GNOME_APPBAR (progress_appbar));
}

void
progress_setGnomeAppBar (GtkWidget * appbar)
{
  progress_appbar = appbar;
}
