/*  GTKtalog.
 *  Copyright (C) 1999-2000  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

#include "setup.h"
#include "interface.h"

#include "config_common.h"

#include "on.xpm"
#include "off.xpm"

/* setup dialog */
static GtkWidget *include_list_box;
static GtkWidget *vfs_include_list_box;
static GtkWidget *ei_include_list_box;
static GtkWidget *ess_include_list_box;
static GtkWidget *mount_entry;
static GtkWidget *umount_entry;
static GtkWidget *mount_point_entry;
static GtkWidget *eject_entry;
static GtkWidget *checkbutton_useautomount;
static GtkWidget *retry_value;
static GtkWidget *checkbutton_dus;
static GtkWidget *checkbutton_warnMount;
static GtkWidget *checkbutton_eject;
static GtkWidget *compression_level;
static GtkWidget *checkbutton_getinformation;
static GtkWidget *checkbutton_dbclick_on_file;
static GtkWidget *checkbutton_dateislocale;
static GtkWidget *entry_dateislocale;
static GtkWidget *test_vfs_mode;
static GtkWidget *checkbutton_displaydirsize;
static GtkWidget *recentfilesmax;
static GtkWidget *checkbutton_save_cat_mode;
static GtkWidget *checkbutton_save_mainwin_xywh;
static GtkWidget *checkbutton_scan_mime_type;
static GtkWidget *checkbutton_usedefaultinfoplugin;
static GtkWidget *default_information_plugin_entry;
static GtkWidget *default_information_plugin_args_entry;
static GdkPixmap *on_pix;
static GdkPixmap *off_pix;
static GtkStyle *style;
static GdkBitmap *state_mask;
static GtkWidget *window;
static gint selected_row;
static gint vfs_selected_row;
static gint ei_selected_row;
static gint ess_selected_row;

/* Add type dialog */
static GtkWidget *include_type_entry;
static GtkWidget *include_prog_entry;
static GtkWidget *include_arg_entry;
static GtkWidget *add_type_window;

/* Add vfs type dialog */
static GtkWidget *vfs_include_type_entry;
static GtkWidget *vfs_include_prog_entry;
static GtkWidget *vfs_include_arg_entry;
static GtkWidget *vfs_add_type_window;
static GtkWidget *vfs_separator;
static GtkWidget *vfs_field_date;
static GtkWidget *vfs_format_date;
static GtkWidget *vfs_format_date_entry;
static GtkWidget *vfs_field_size;
static GtkWidget *vfs_field_name;

static GtkWidget *ei_include_type_entry;
static GtkWidget *ei_add_type_window;
static PIX *ei_selecting_pix;
static GtkWidget *ei_pentry;
static GtkWidget *ei_button_add;
static GtkWidget *ei_button_edit;
static GtkWidget *ei_button_del;

static GtkWidget *ess_include_type_entry;
static GtkWidget *ess_add_type_window;
static GtkWidget *ess_button_add;
static GtkWidget *ess_button_del;


MIME_EXTENSIONS *selected_extension;
MIME_VFS_EXTENSIONS *vfs_selected_extension;
gchar *ei_selected_extension;
gchar *ess_selected_extension;
GTree *local_extensions;
GTree *local_vfs_extensions;
GTree *local_ei_extensions;
GTree *local_ess_extensions;

gchar *date_format;
gchar *mount_prog;
gchar *umount_prog;

gchar *default_file_pix_string;
gchar *default_dir_pix_string;
gchar *default_disk_pix_string;
gchar *default_unreadable_pix_string;
gchar *default_vfs_pix_string;
gchar *default_opened_dir_pix_string;
gchar *default_opened_disk_pix_string;
gchar *default_opened_vfs_pix_string;
PIX *local_default_file_pix;
PIX *local_default_dir_pix;
PIX *local_default_disk_pix;
PIX *local_default_unreadable_pix;
PIX *local_default_vfs_pix;
PIX *local_default_opened_dir_pix;
PIX *local_default_opened_disk_pix;
PIX *local_default_opened_vfs_pix;

gboolean
is_mime_valid (gchar * mime)
{
/*FIXME: Is there a better way to do this ?
 */
  GList *tmp;
  tmp = gnome_mime_get_keys (mime);
  if (tmp)
    {
      g_list_free (tmp);
      return (TRUE);
    }
  else
    {
      return (FALSE);
    }
}

/**********************************************************************/
/***** Extension pixmaps **********************************************/
/**********************************************************************/

PIX *
new_pix_from_filename (GtkWidget * w, GtkStyle * style,
		       gchar * gs, CONFIG * my_config)
{
  PIX *pix;
  gchar *tmpstr;
  gchar *error_load_pixmap =
    _("Could not load pixmap %s.\nCheck your config file.");

  if ((pix = g_tree_lookup (my_config->pix_paths, gs)))
    {
      return (pix);
    }

  if (g_file_test (gs, G_FILE_TEST_ISFILE))
    {
      pix = (PIX *) g_malloc (sizeof (PIX));
      pix->path = g_string_new (gs);
      pix->mask = (GdkBitmap **) g_malloc (sizeof (GdkBitmap **));
      pix->pixmap =
	gdk_pixmap_create_from_xpm (GTK_WIDGET (w)->window, pix->mask,
				    &style->bg[GTK_STATE_NORMAL],
				    pix->path->str);
      g_tree_insert (my_config->pix_paths, pix->path->str, pix);
#if defined(__DEBUG__)
      GML_malloc_forget (pix);
      GML_malloc_forget (pix->path);
      GML_malloc_forget (pix->mask);
#endif
      return (pix);
    }
  else
    {
      tmpstr =
	(gchar *) g_malloc (sizeof (gchar) * (strlen (error_load_pixmap)) +
			    strlen (gs));
      sprintf (tmpstr, error_load_pixmap, gs);
      gnome_dialog_run_and_close (GNOME_DIALOG
				  (gnome_error_dialog_parented
				   (tmpstr, GTK_WINDOW (w))));
      g_free (tmpstr);
      return (NULL);
    }

}

gboolean
is_default_pix (gchar * extension)
{
  if (strcmp (extension, default_file_pix_string) == 0)
    return (TRUE);
  if (strcmp (extension, default_dir_pix_string) == 0)
    return (TRUE);
  if (strcmp (extension, default_disk_pix_string) == 0)
    return (TRUE);
  if (strcmp (extension, default_unreadable_pix_string) == 0)
    return (TRUE);
  if (strcmp (extension, default_vfs_pix_string) == 0)
    return (TRUE);
  if (strcmp (extension, default_opened_dir_pix_string) == 0)
    return (TRUE);
  if (strcmp (extension, default_opened_disk_pix_string) == 0)
    return (TRUE);
  if (strcmp (extension, default_opened_vfs_pix_string) == 0)
    return (TRUE);
  return (FALSE);
}

void
eip_split_default_pix (PIX ** pix, gchar * default_pix_string)
{
  *pix = (PIX *) g_tree_lookup (my_config->mime_icons, default_pix_string);
  g_tree_remove (my_config->mime_icons, default_pix_string);
}

gint
_pix_gc_set (gpointer key, gpointer value, gpointer data)
{
  PIX *pix = value;
  pix->used = GPOINTER_TO_INT (data);
  return (FALSE);
}

gint
_pix_gc_free (gpointer key, gpointer value, gpointer data)
{
  PIX *pix = value;
  GList *node_to_free = *((GList **) data);

  if (pix->used == FALSE)
    {
      node_to_free = g_list_append (node_to_free, key);
      g_free (pix->pixmap);
      g_free (pix->mask);
      g_string_free (pix->path, TRUE);
    }
  *((GList **) data) = node_to_free;
  return (FALSE);
}

void
pix_garbage_collection ()
{
  GList *node_to_free = NULL;
  GList *n;
  g_tree_traverse (my_config->pix_paths, _pix_gc_set, G_IN_ORDER,
		   GINT_TO_POINTER (FALSE));
  my_config->default_file_pix->used = TRUE;
  my_config->default_dir_pix->used = TRUE;
  my_config->default_disk_pix->used = TRUE;
  my_config->default_unreadable_pix->used = TRUE;
  my_config->default_vfs_pix->used = TRUE;
  my_config->default_opened_dir_pix->used = TRUE;
  my_config->default_opened_disk_pix->used = TRUE;
  my_config->default_opened_vfs_pix->used = TRUE;
  g_tree_traverse (my_config->mime_icons, _pix_gc_set, G_IN_ORDER,
		   GINT_TO_POINTER (TRUE));
  g_tree_traverse (my_config->pix_paths, _pix_gc_free, G_IN_ORDER,
		   &node_to_free);
  n = node_to_free;
  while (n)
    {
      g_tree_remove (my_config->pix_paths, n->data);
      g_free (n->data);
      n->data = NULL;
      n = g_list_next (n);
    }
  g_list_free (node_to_free);
}

gint _ei_free_traverse (gpointer key, gpointer value, gpointer data)
{
  PIX *eip = value;
  gint row;

  row = gtk_clist_find_row_from_data (GTK_CLIST (ei_include_list_box), eip);
  gtk_clist_set_row_data (GTK_CLIST (ei_include_list_box), row, NULL);
  return (FALSE);
}

void
ei_free (GTree * ei)
{
  g_tree_traverse (ei, _ei_free_traverse, G_IN_ORDER, NULL);
  g_tree_destroy (ei);
}

gboolean ei_extensions_traverse (gpointer key, gpointer value, gpointer data)
{
  PIX *ie = value;
  gint i;
  gchar *tmp[3] = { "", "", "" };

  tmp[1] = key;
  tmp[2] = ie->path->str;

  i = gtk_clist_append (GTK_CLIST (ei_include_list_box), (gchar **) tmp);
  gtk_clist_set_pixtext (GTK_CLIST (ei_include_list_box), i, 0,
			 "", 3, ie->pixmap, *(ie->mask));

  gtk_clist_set_row_data (GTK_CLIST (ei_include_list_box), i, key);
  return (FALSE);
}

gint
pix_tree_printf (gpointer key, gpointer value, gpointer data)
{
  gchar *iconpath = key;
  gchar *mime_list = value;
  FILE *f = data;

  fprintf (f, "AddMimeIcon %s %s\n", iconpath, mime_list);
  free(mime_list);
  return (FALSE);
}

gint
pix_make_addicon_tree (gpointer key, gpointer value, gpointer data)
{
  GString *g;
  gchar *mime_list;
  gchar *strtmp;
  GTree *addicons = data;

  g = ((PIX *) value)->path;
  strtmp = g_tree_lookup (addicons, g->str);
  if (strtmp)
    {
      mime_list = g_strconcat (" ", (gchar *) key, strtmp, NULL);
      g_free (strtmp);
    }
  else
    {
      mime_list = g_strconcat (" ", (gchar *) key, NULL);
    }
  g_tree_insert (addicons, g->str, mime_list);
  return (FALSE);
}

void
ei_add_type_ok_clicked (GtkWidget * w, gpointer data)
{
  PIX *e2;
  gint ei_add_edit_mode = GPOINTER_TO_INT (data);

  char *temp_icon_path;
  char *temp_extension;
  PIX *pix;

  temp_extension =
    gtk_editable_get_chars (GTK_EDITABLE (ei_include_type_entry), 0, -1);

  if (!is_mime_valid (temp_extension))
    {
      ERROR_DIALOG (_
		    ("The specified MIME is not valid. Nothing will be done."),
		    main_window);
    }
  else
    {

      e2 = g_tree_lookup (local_ei_extensions, temp_extension);

      if (e2 && (ei_add_edit_mode != EDIT_MODE))
	{
	  gnome_dialog_run_and_close (GNOME_DIALOG
				      (gnome_warning_dialog_parented
				       (_
					("This MIME type already exists. Nothing will be done."),
					GTK_WINDOW (ei_add_type_window))));
	}
      else
	{
	  temp_icon_path =
	    gnome_pixmap_entry_get_filename (GNOME_PIXMAP_ENTRY (ei_pentry));
	  pix = new_pix_from_filename (w, style, temp_icon_path, my_config);
	  if (pix)
	    {
	      if ((ei_add_edit_mode == EDIT_MODE)
		  || (is_default_pix (temp_extension)))
		{
		  g_tree_remove (local_ei_extensions, ei_selected_extension);
		  g_free (ei_selected_extension);
		  gtk_clist_remove (GTK_CLIST (ei_include_list_box),
				    ei_selected_row);

		}


	      temp_extension = g_strdup (temp_extension);
	      g_tree_insert (local_ei_extensions, temp_extension, pix);
	      ei_extensions_traverse (temp_extension, pix, NULL);
	      gtk_clist_sort (GTK_CLIST (ei_include_list_box));
	      ei_selected_extension = NULL;
	      ei_selected_row = -1;
	    }
	}
    }
  gtk_widget_destroy (ei_add_type_window);
}


void
ei_add_type (GtkWidget * w, gpointer data)
{
  GtkWidget *vbox, *hbox, *vbox2, *hbox2;
  GtkWidget *ok, *cancel;
  GtkWidget *frame;
  GtkWidget *label, *guess_button;
  gint ei_add_edit_mode = GPOINTER_TO_INT (data);

  ei_add_type_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_window_set_transient_for (GTK_WINDOW (ei_add_type_window),
				GTK_WINDOW (main_window));

  gtk_window_set_position (GTK_WINDOW (ei_add_type_window),
			   GTK_WIN_POS_MOUSE);
  gtk_widget_set_usize (GTK_WIDGET (ei_add_type_window), 450, 450);
  gtk_window_set_title (GTK_WINDOW (ei_add_type_window),
			_("MIME type icons"));
  gtk_window_set_policy (GTK_WINDOW (ei_add_type_window), TRUE, TRUE, TRUE);
  gtk_container_border_width (GTK_CONTAINER (ei_add_type_window), 10);
  gtk_signal_connect (GTK_OBJECT (ei_add_type_window), "delete_event",
		      GTK_SIGNAL_FUNC (gtk_widget_destroy),
		      GTK_OBJECT (ei_add_type_window));

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (ei_add_type_window), vbox);
  gtk_widget_show (vbox);
  /*** extension ************/
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("MIME type"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  ei_include_type_entry = gtk_entry_new_with_max_length (80);
  if (ei_add_edit_mode == EDIT_MODE)
    {
      if (ei_selected_extension)
	{
	  gtk_entry_set_text (GTK_ENTRY (ei_include_type_entry),
			      ei_selected_extension);
	  if (is_default_pix (ei_selected_extension))
	    gtk_entry_set_editable (GTK_ENTRY (ei_include_type_entry), FALSE);
	}
    }
  gtk_entry_select_region (GTK_ENTRY (ei_include_type_entry), 0,
			   GTK_ENTRY (ei_include_type_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox2), ei_include_type_entry, FALSE, FALSE,
		      0);
  gtk_widget_show (ei_include_type_entry);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (vbox2), hbox2);
  gtk_widget_show (hbox2);

  label = gtk_label_new (_("For example `image/jpeg'"));
  gtk_box_pack_start (GTK_BOX (hbox2), label, TRUE, FALSE, 0);
  gtk_widget_show (label);

  guess_button = gtk_button_new_with_label (_("Guess from an extension"));
  gtk_box_pack_start (GTK_BOX (hbox2), guess_button, TRUE, FALSE, 0);

  gtk_signal_connect (GTK_OBJECT (guess_button), "clicked",
		      GTK_SIGNAL_FUNC (extension_to_mime_GUI),
		      ei_include_type_entry);
  gtk_widget_show (guess_button);

  /*** icon ********/
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("Icon"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);




  ei_pentry =
    gnome_pixmap_entry_new ("ei_history_id", _("Select a pixmap"), TRUE);
  ei_selecting_pix = NULL;

  if (ei_add_edit_mode == EDIT_MODE)
    {
      if (ei_selected_extension)
	{
	  ei_selecting_pix =
	    g_tree_lookup (local_ei_extensions, ei_selected_extension);

	  gtk_entry_set_text (GTK_ENTRY
			      (gnome_pixmap_entry_gtk_entry
			       (GNOME_PIXMAP_ENTRY (ei_pentry))),
			      ei_selecting_pix->path->str);
	}
    }
  gtk_widget_show (ei_pentry);
  gtk_container_add (GTK_CONTAINER (frame), ei_pentry);


/********************************/

  hbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbox), 5);

  ok = gnome_stock_button (GNOME_STOCK_BUTTON_OK);
  GTK_WIDGET_SET_FLAGS (ok, GTK_CAN_DEFAULT);
  gtk_window_set_default (GTK_WINDOW (ei_add_type_window), ok);
  gtk_box_pack_start (GTK_BOX (hbox), ok, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok), "clicked",
		      GTK_SIGNAL_FUNC (ei_add_type_ok_clicked), data);
  gtk_widget_show (ok);

  cancel = gnome_stock_button (GNOME_STOCK_BUTTON_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancel, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox), cancel, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancel), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (ei_add_type_window));
  gtk_widget_show (cancel);

  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  gtk_widget_show (ei_add_type_window);

}

void
ei_include_selection_made (GtkWidget * clist, gint row, gint column,
			   GdkEventButton * event, gpointer data)
{
  gchar *clrow_data;

  ei_selected_row = row;
  clrow_data = gtk_clist_get_row_data (GTK_CLIST (ei_include_list_box), row);
  ei_selected_extension = clrow_data;
  if (is_default_pix (ei_selected_extension))
    {
      gtk_widget_set_sensitive (GTK_WIDGET (ei_button_edit), TRUE);
      gtk_widget_set_sensitive (GTK_WIDGET (ei_button_del), FALSE);
    }
  else
    {
      gtk_widget_set_sensitive (GTK_WIDGET (ei_button_edit), TRUE);
      gtk_widget_set_sensitive (GTK_WIDGET (ei_button_del), TRUE);
    }

}

static gint
_ei_clist_g_strcasecmp (GtkCList * clist, gconstpointer ptr1,
			gconstpointer ptr2)
{
  char *text1 = NULL;
  char *text2 = NULL;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  switch (row1->cell[clist->sort_column].type)
    {
    case GTK_CELL_TEXT:
      text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
      break;
    case GTK_CELL_PIXTEXT:
      text1 = GTK_CELL_PIXTEXT (row1->cell[clist->sort_column])->text;
      break;
    default:
      break;
    }

  switch (row2->cell[clist->sort_column].type)
    {
    case GTK_CELL_TEXT:
      text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;
      break;
    case GTK_CELL_PIXTEXT:
      text2 = GTK_CELL_PIXTEXT (row2->cell[clist->sort_column])->text;
      break;
    default:
      break;
    }

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;
  if ((is_default_pix (text1)) && (!(is_default_pix (text2))))
    return (-1);
  if ((is_default_pix (text2)) && (!(is_default_pix (text1))))
    return (1);

  return g_strcasecmp (text1, text2);
}

void
ei_include_unselection_made (GtkWidget * clist, gint row, gint column,
			     GdkEventButton * event, gpointer data)
{
  ei_selected_extension = NULL;
  ei_selected_row = -1;
  gtk_widget_set_sensitive (GTK_WIDGET (ei_button_edit), FALSE);
  gtk_widget_set_sensitive (GTK_WIDGET (ei_button_del), FALSE);
}

void
ei_include_edit_button_clicked (GtkWidget * w, gpointer data)
{
  if (ei_selected_extension && (ei_selected_row >= 0))
    ei_add_type (w, GINT_TO_POINTER (EDIT_MODE));
}

void
ei_include_delete_button_clicked (GtkWidget * w, gpointer data)
{
  if (ei_selected_row >= 0)
    {
      g_tree_remove (local_ei_extensions, ei_selected_extension);
      g_free (ei_selected_extension);
      gtk_clist_remove (GTK_CLIST (ei_include_list_box), ei_selected_row);
      ei_selected_extension = NULL;
      gtk_clist_remove (GTK_CLIST (ei_include_list_box), ei_selected_row);
      ei_selected_row = -1;
    }
}

gint
_duplicate_ei_extensions_traverse (gpointer key, gpointer value,
				   gpointer data)
{
  PIX *ei = value;

  g_tree_insert (data, g_strdup (key), ei);

  return (FALSE);
}

GTree *
duplicate_ei_extensions ()
{
  GTree *r;

  r = g_tree_new ((GCompareFunc) strcmp);
  g_tree_traverse (my_config->mime_icons,
		   _duplicate_ei_extensions_traverse, G_IN_ORDER, r);

  return (r);
}

/**********************************************************************/
/***** Extension plugins **********************************************/
/**********************************************************************/

gint _extensions_free_traverse (gpointer key, gpointer value, gpointer data)
{
  MIME_EXTENSIONS *v = value;
  gint row;

  row = gtk_clist_find_row_from_data (GTK_CLIST (include_list_box), v);
  gtk_clist_set_row_data (GTK_CLIST (include_list_box), row, NULL);
  g_string_free (v->mime, TRUE);
  g_string_free (v->prog, TRUE);
  g_string_free (v->arg, TRUE);
  g_free (v);
  return (FALSE);
}

void
extensions_free (GTree * ext)
{
  g_tree_traverse (ext, _extensions_free_traverse, G_IN_ORDER, NULL);
  g_tree_destroy (ext);
}

gboolean extensions_traverse (gpointer key, gpointer value, gpointer data)
{
  MIME_EXTENSIONS *m = value;
  gint i;
  gchar *tmp[4] = { "", "", "", "" };

  tmp[1] = m->mime->str;
  tmp[2] = m->prog->str;
  tmp[3] = m->arg->str;
  i = gtk_clist_append (GTK_CLIST (include_list_box), (gchar **) tmp);
  gtk_clist_set_row_data (GTK_CLIST (include_list_box), i, m);
  if (m->state == FALSE)
    gtk_clist_set_pixmap (GTK_CLIST (include_list_box), i, 0,
			  off_pix, state_mask);
  else
    gtk_clist_set_pixmap (GTK_CLIST (include_list_box), i, 0,
			  on_pix, state_mask);
  gtk_clist_unselect_row (GTK_CLIST (include_list_box), i, 0);
  return (FALSE);
}

gint extensions_tree_printf (gpointer key, gpointer value, gpointer data)
{
  FILE *f = data;
  MIME_EXTENSIONS *m = value;
  gint state = 1;
  if (m->state == FALSE)
    state = 0;

  fprintf (f, "AddMimeInformation '%s' '%s' '%s' %d\n",
	   m->mime->str, m->prog->str, m->arg->str, state);
  return (FALSE);
}

void
add_type_ok_clicked (GtkWidget * w, gpointer data)
{
  MIME_EXTENSIONS *m2;
  gint add_edit_mode = GPOINTER_TO_INT (data);

  char *temp_type;
  char *temp_prog;
  char *temp_arg;

  temp_type =
    gtk_editable_get_chars (GTK_EDITABLE (include_type_entry), 0, -1);

  if (!is_mime_valid (temp_type))
    {
      ERROR_DIALOG (_
		    ("The specified MIME is not valid. Nothing will be done."),
		    main_window);
      g_free (temp_type);
    }
  else
    {

      m2 = g_tree_lookup (local_extensions, temp_type);

      if (m2 && (m2 != selected_extension))
	{
	  gnome_dialog_run_and_close (GNOME_DIALOG
				      (gnome_warning_dialog_parented
				       (_
					("This MIME type already exists. Nothing will be done."),
					GTK_WINDOW (add_type_window))));
	  g_free (temp_type);
	}
      else
	{
	  if (add_edit_mode == EDIT_MODE)
	    {
	      g_string_free (selected_extension->mime, TRUE);
	      g_string_free (selected_extension->prog, TRUE);
	      g_string_free (selected_extension->arg, TRUE);
	      g_tree_remove (local_extensions, selected_extension);
	      g_free (selected_extension);
	      gtk_clist_remove (GTK_CLIST (include_list_box), selected_row);

	    }
	  selected_extension =
	    (MIME_EXTENSIONS *) g_malloc (sizeof (MIME_EXTENSIONS));

	  temp_type =
	    gtk_editable_get_chars (GTK_EDITABLE (include_type_entry), 0, -1);
	  temp_prog =
	    gtk_editable_get_chars (GTK_EDITABLE (include_prog_entry), 0, -1);
	  temp_arg =
	    gtk_editable_get_chars (GTK_EDITABLE (include_arg_entry), 0, -1);
	  selected_extension->mime = g_string_new (temp_type);
	  g_free (temp_type);
	  selected_extension->prog = g_string_new (temp_prog);
	  g_free (temp_prog);
	  selected_extension->arg = g_string_new (temp_arg);
	  g_free (temp_arg);
	  selected_extension->state = TRUE;
	  g_tree_insert (local_extensions,
			 g_strdup (selected_extension->mime->str),
			 selected_extension);

	  extensions_traverse (selected_extension->mime->str,
			       selected_extension, NULL);

	}
    }
  gtk_widget_destroy (add_type_window);
}


void
add_type (GtkWidget * w, gpointer data)
{
  GtkWidget *vbox, *hbox, *vbox2, *hbox2;
  GtkWidget *ok, *cancel;
  GtkWidget *frame;
  GtkWidget *label, *guess_button;
  gint add_edit_mode = GPOINTER_TO_INT (data);

  if ((selected_row == -1) && (add_edit_mode == EDIT_MODE))
    return;

  add_type_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_window_set_transient_for (GTK_WINDOW (add_type_window),
				GTK_WINDOW (main_window));

  gtk_window_set_position (GTK_WINDOW (add_type_window), GTK_WIN_POS_MOUSE);
//  gtk_widget_set_usize (GTK_WIDGET (add_type_window), 300, 295);
  gtk_window_set_title (GTK_WINDOW (add_type_window), _("File type"));
  gtk_window_set_policy (GTK_WINDOW (add_type_window), TRUE, TRUE, TRUE);
  gtk_container_border_width (GTK_CONTAINER (add_type_window), 10);
  gtk_signal_connect (GTK_OBJECT (add_type_window), "delete_event",
		      GTK_SIGNAL_FUNC (gtk_widget_destroy),
		      GTK_OBJECT (add_type_window));

  vbox = gtk_vbox_new (FALSE, 10);
  gtk_container_add (GTK_CONTAINER (add_type_window), vbox);
  gtk_widget_show (vbox);
  /***************/
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("File Type"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  include_type_entry = gtk_entry_new_with_max_length (80);

  if (selected_extension)
    gtk_entry_set_text (GTK_ENTRY (include_type_entry),
			selected_extension->mime->str);
  gtk_entry_select_region (GTK_ENTRY (include_type_entry), 0,
			   GTK_ENTRY (include_type_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox2), include_type_entry, FALSE, FALSE, 0);
  gtk_widget_show (include_type_entry);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (vbox2), hbox2);
  gtk_widget_show (hbox2);

  label = gtk_label_new (_("For example `image/jpeg'"));
  gtk_box_pack_start (GTK_BOX (hbox2), label, TRUE, FALSE, 0);
  gtk_widget_show (label);

  guess_button = gtk_button_new_with_label (_("Guess from an extension"));
  gtk_box_pack_start (GTK_BOX (hbox2), guess_button, TRUE, FALSE, 0);

  gtk_signal_connect (GTK_OBJECT (guess_button), "clicked",
		      GTK_SIGNAL_FUNC (extension_to_mime_GUI),
		      include_type_entry);
  gtk_widget_show (guess_button);

  /***********/
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame),
		       _("Plugin to get information about files"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  include_prog_entry = gtk_entry_new_with_max_length (80);

  if (selected_extension)
    gtk_entry_set_text (GTK_ENTRY (include_prog_entry),
			selected_extension->prog->str);
  gtk_entry_select_region (GTK_ENTRY (include_prog_entry), 0,
			   GTK_ENTRY (include_prog_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox2), include_prog_entry, FALSE, FALSE, 0);
  gtk_widget_show (include_prog_entry);

  label = gtk_label_new (_("Leave blank to include all the file"));
  gtk_box_pack_start (GTK_BOX (vbox2), label, TRUE, FALSE, 0);
  gtk_widget_show (label);

  /***********/
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("Plugin Option"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  include_arg_entry = gtk_entry_new_with_max_length (80);

  if (selected_extension)
    gtk_entry_set_text (GTK_ENTRY (include_arg_entry),
			selected_extension->arg->str);
  gtk_entry_select_region (GTK_ENTRY (include_arg_entry), 0,
			   GTK_ENTRY (include_arg_entry)->text_length);
  gtk_container_add (GTK_CONTAINER (frame), include_arg_entry);
  gtk_widget_show (include_arg_entry);

/********************************/


  hbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbox), 5);

  ok = gnome_stock_button (GNOME_STOCK_BUTTON_OK);
  GTK_WIDGET_SET_FLAGS (ok, GTK_CAN_DEFAULT);
  gtk_window_set_default (GTK_WINDOW (add_type_window), ok);
  gtk_box_pack_start (GTK_BOX (hbox), ok, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok), "clicked",
		      GTK_SIGNAL_FUNC (add_type_ok_clicked), data);
  gtk_widget_show (ok);

  cancel = gnome_stock_button (GNOME_STOCK_BUTTON_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancel, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox), cancel, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancel), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (add_type_window));
  gtk_widget_show (cancel);

  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  gtk_widget_show (add_type_window);

}

void
include_selection_made (GtkWidget * clist, gint row, gint column,
			GdkEventButton * event, gpointer data)
{
  MIME_EXTENSIONS *clrow_data;

  selected_row = row;
  clrow_data = gtk_clist_get_row_data (GTK_CLIST (include_list_box), row);
  selected_extension = clrow_data;

  if (event != NULL && event->button == 1 && event->type == GDK_2BUTTON_PRESS)
    {
      if (clrow_data->state == FALSE)
	{
	  clrow_data->state = TRUE;
	  gtk_clist_set_pixmap (GTK_CLIST (include_list_box), row, 0,
				on_pix, state_mask);
	}
      else
	{
	  clrow_data->state = FALSE;
	  gtk_clist_set_pixmap (GTK_CLIST (include_list_box), row, 0,
				off_pix, state_mask);
	}
    }
}

void
include_unselection_made (GtkWidget * clist, gint row, gint column,
			  GdkEventButton * event, gpointer data)
{
  selected_extension = NULL;
  selected_row = -1;
}

void
include_edit_button_clicked (GtkWidget * w, gpointer data)
{
  if (selected_extension && (selected_row >= 0))
    add_type (w, GINT_TO_POINTER (EDIT_MODE));
}


void
include_delete_button_clicked (GtkWidget * w, gpointer data)
{
  if (selected_row >= 0)
    {
      g_tree_remove (local_extensions, selected_extension->mime->str);
      g_string_free (selected_extension->mime, TRUE);
      g_string_free (selected_extension->prog, TRUE);
      g_string_free (selected_extension->arg, TRUE);
/* FIXME: Memory leak here. The key is not freed. */
      g_free (selected_extension);
      selected_extension = NULL;
      gtk_clist_remove (GTK_CLIST (include_list_box), selected_row);
      selected_row = -1;
      gtk_clist_sort (GTK_CLIST (ei_include_list_box));
    }
}

gint
_duplicate_extensions_traverse (gpointer key, gpointer value, gpointer data)
{
  MIME_EXTENSIONS *dup_value;
  MIME_EXTENSIONS *v = value;

  dup_value = (MIME_EXTENSIONS *) malloc (sizeof (MIME_EXTENSIONS));
  dup_value->mime = g_string_new (v->mime->str);
  dup_value->prog = g_string_new (v->prog->str);
  dup_value->arg = g_string_new (v->arg->str);
  dup_value->state = v->state;

  g_tree_insert (data, g_strdup (dup_value->mime->str), dup_value);

  return (FALSE);
}

GTree *
duplicate_extensions (GTree * ext)
{
  GTree *r;

  r = g_tree_new ((GCompareFunc) strcmp);
  g_tree_traverse (my_config->mime_extensions, _duplicate_extensions_traverse,
		   G_IN_ORDER, r);

  return (r);
}

/**********************************************************************/
/***** VFS Extensions *************************************************/
/**********************************************************************/

gint
_duplicate_vfs_extensions_traverse (gpointer key, gpointer value,
				    gpointer data)
{
  MIME_VFS_EXTENSIONS *dup_value;
  MIME_VFS_EXTENSIONS *ve = value;

  dup_value = (MIME_VFS_EXTENSIONS *) malloc (sizeof (MIME_VFS_EXTENSIONS));
  dup_value->mime = g_string_new (ve->mime->str);
  dup_value->prog = g_string_new (ve->prog->str);
  dup_value->args = g_string_new (ve->args->str);
  dup_value->separator = g_string_new (ve->separator->str);
  dup_value->date = ve->date;
  dup_value->date_format = g_string_new (ve->date_format->str);
  dup_value->size = ve->size;
  dup_value->name = ve->name;
  dup_value->state = ve->state;

  g_tree_insert (data, g_strdup (dup_value->mime->str), dup_value);

  return (FALSE);
}

GTree *
duplicate_vfs_extensions (GTree * vfsext)
{
  GTree *r;
  r = g_tree_new ((GCompareFunc) strcmp);
  g_tree_traverse (my_config->mime_vfs_extensions,
		   _duplicate_vfs_extensions_traverse, G_IN_ORDER, r);

  return (r);
}

gint
_vfs_extensions_free_traverse (gpointer key, gpointer value, gpointer data)
{
  MIME_VFS_EXTENSIONS *v = value;
  gint row;

  row = gtk_clist_find_row_from_data (GTK_CLIST (vfs_include_list_box), v);
  gtk_clist_set_row_data (GTK_CLIST (vfs_include_list_box), row, NULL);
  g_string_free (v->mime, TRUE);
  g_string_free (v->prog, TRUE);
  g_string_free (v->args, TRUE);
  g_string_free (v->separator, TRUE);
  g_string_free (v->date_format, TRUE);
  g_free (v);
  return (FALSE);
}

void
vfs_extensions_free (GTree * vfsext)
{
  g_tree_traverse (vfsext, _vfs_extensions_free_traverse, G_IN_ORDER, NULL);
  g_tree_destroy (vfsext);
}

gboolean vfs_extensions_traverse (gpointer key, gpointer value, gpointer data)
{
  MIME_VFS_EXTENSIONS *ve = value;
  gint i;
  gchar *tmp[4] = { "", "", "", "" };

  tmp[1] = ve->mime->str;
  tmp[2] = ve->prog->str;
  tmp[3] = ve->args->str;
  i = gtk_clist_append (GTK_CLIST (vfs_include_list_box), (gchar **) tmp);
  gtk_clist_set_row_data (GTK_CLIST (vfs_include_list_box), i, ve);
  if (ve->state == FALSE)
    gtk_clist_set_pixmap (GTK_CLIST (vfs_include_list_box), i, 0,
			  off_pix, state_mask);
  else
    gtk_clist_set_pixmap (GTK_CLIST (vfs_include_list_box), i, 0,
			  on_pix, state_mask);
  gtk_clist_unselect_row (GTK_CLIST (vfs_include_list_box), i, 0);
  return (FALSE);
}

gint
vfs_extensions_tree_printf (gpointer key, gpointer value, gpointer data)
{
  FILE *f = data;
  MIME_VFS_EXTENSIONS *vm = value;
  gint state = 1;

  if (vm->state == FALSE)
    state = 0;

  fprintf (f, "AddVfsMime '%s' '%s' '%s' '%s' %d '%s' %d %d %d\n",
	   vm->mime->str,
	   vm->prog->str, vm->args->str, vm->separator->str, vm->date,
	   vm->date_format->str, vm->size, vm->name, state);
  return (FALSE);
}

void
vfs_add_type_ok_clicked (GtkWidget * w, gpointer data)
{
  MIME_VFS_EXTENSIONS *e2;
  gint vfs_add_edit_mode = GPOINTER_TO_INT (data);

  char *temp_type;
  char *temp_prog;
  char *temp_args;
  char *temp_separator;
  char *temp_date_format;
  gint size, date, name;

  temp_type =
    gtk_editable_get_chars (GTK_EDITABLE (vfs_include_type_entry), 0, -1);

  if (!is_mime_valid (temp_type))
    {
      ERROR_DIALOG (_
		    ("The specified MIME is not valid. Nothing will be done."),
		    main_window);
      g_free (temp_type);
    }
  else
    {


      e2 = g_tree_lookup (local_vfs_extensions, temp_type);

      if (e2 && (e2 != vfs_selected_extension))
	{
	  gnome_dialog_run_and_close (GNOME_DIALOG
				      (gnome_warning_dialog_parented
				       (_
					("This MIME type already exists. Nothing will be done."),
					GTK_WINDOW (vfs_add_type_window))));
	  g_free (temp_type);
	}
      else
	{
	  if (vfs_add_edit_mode == EDIT_MODE)
	    {
	      g_string_free (vfs_selected_extension->mime, TRUE);
	      g_string_free (vfs_selected_extension->prog, TRUE);
	      g_string_free (vfs_selected_extension->args, TRUE);
	      g_string_free (vfs_selected_extension->separator, TRUE);
	      g_string_free (vfs_selected_extension->date_format, TRUE);
	      g_tree_remove (local_vfs_extensions, vfs_selected_extension);
	      g_free (vfs_selected_extension);
	      gtk_clist_remove (GTK_CLIST (vfs_include_list_box),
				vfs_selected_row);

	    }
	  vfs_selected_extension =
	    (MIME_VFS_EXTENSIONS *) g_malloc (sizeof (MIME_VFS_EXTENSIONS));

	  temp_type =
	    gtk_editable_get_chars (GTK_EDITABLE (vfs_include_type_entry), 0,
				    -1);
	  temp_prog =
	    gtk_editable_get_chars (GTK_EDITABLE (vfs_include_prog_entry), 0,
				    -1);
	  temp_args =
	    gtk_editable_get_chars (GTK_EDITABLE (vfs_include_arg_entry), 0,
				    -1);
	  temp_separator =
	    gtk_editable_get_chars (GTK_EDITABLE (vfs_separator), 0, -1);
	  temp_date_format =
	    gtk_editable_get_chars (GTK_EDITABLE
				    ((GTK_COMBO (vfs_format_date))->entry), 0,
				    -1);
	  date =
	    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON
					      (vfs_field_date));
	  size =
	    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON
					      (vfs_field_size));
	  name =
	    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON
					      (vfs_field_name));




	  vfs_selected_extension->mime = g_string_new (temp_type);
	  g_free (temp_type);
	  vfs_selected_extension->prog = g_string_new (temp_prog);
	  g_free (temp_prog);
	  vfs_selected_extension->args = g_string_new (temp_args);
	  g_free (temp_args);
	  vfs_selected_extension->separator = g_string_new (temp_separator);
	  g_free (temp_separator);
	  vfs_selected_extension->date_format =
	    g_string_new (temp_date_format);
	  g_free (temp_date_format);
	  vfs_selected_extension->date = date;
	  vfs_selected_extension->size = size;
	  vfs_selected_extension->name = name;
	  g_tree_insert (local_vfs_extensions,
			 g_strdup (vfs_selected_extension->mime->str),
			 vfs_selected_extension);
	  vfs_selected_extension->state = TRUE;
	  vfs_extensions_traverse (vfs_selected_extension->mime->str,
				   vfs_selected_extension, NULL);
	  gtk_clist_sort (GTK_CLIST (vfs_include_list_box));

	}
    }
  gtk_widget_destroy (vfs_add_type_window);
}


void
vfs_add_type (GtkWidget * w, gpointer data)
{
  GtkWidget *vbox, *hbox, *vbox2, *hbox2;
  GtkWidget *ok, *cancel;
  GtkWidget *frame;
  GtkWidget *label;
  GtkWidget *guess_button;
  GtkWidget *table;
  GtkObject *spinbutton_adj;
  GList *combo_items = NULL;

  vfs_add_type_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_window_set_transient_for (GTK_WINDOW (vfs_add_type_window),
				GTK_WINDOW (main_window));

  gtk_window_set_position (GTK_WINDOW (vfs_add_type_window),
			   GTK_WIN_POS_MOUSE);
/*  gtk_widget_set_usize (GTK_WIDGET (vfs_add_type_window), 450, 450);*/
  gtk_window_set_title (GTK_WINDOW (vfs_add_type_window), _("File type"));
  gtk_window_set_policy (GTK_WINDOW (vfs_add_type_window), TRUE, TRUE, TRUE);
  gtk_container_border_width (GTK_CONTAINER (vfs_add_type_window), 10);
  gtk_signal_connect (GTK_OBJECT (vfs_add_type_window), "delete_event",
		      GTK_SIGNAL_FUNC (gtk_widget_destroy),
		      GTK_OBJECT (vfs_add_type_window));

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (vfs_add_type_window), vbox);
  gtk_widget_show (vbox);
  /*** extension ************/
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("File Type"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  vfs_include_type_entry = gtk_entry_new_with_max_length (80);

  if (vfs_selected_extension)
    gtk_entry_set_text (GTK_ENTRY (vfs_include_type_entry),
			vfs_selected_extension->mime->str);
  gtk_entry_select_region (GTK_ENTRY (vfs_include_type_entry), 0,
			   GTK_ENTRY (vfs_include_type_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox2), vfs_include_type_entry, FALSE, FALSE,
		      0);
  gtk_widget_show (vfs_include_type_entry);

  hbox2 = gtk_hbox_new (FALSE, 2);
  gtk_container_add (GTK_CONTAINER (vbox2), hbox2);
  gtk_widget_show (hbox2);

  label = gtk_label_new (_("For example `application/x-compressed-tar'"));
  gtk_box_pack_start (GTK_BOX (hbox2), label, TRUE, FALSE, 0);
  gtk_widget_show (label);

  guess_button = gtk_button_new_with_label (_("Guess from an extension"));
  gtk_box_pack_start (GTK_BOX (hbox2), guess_button, TRUE, FALSE, 0);

  gtk_signal_connect (GTK_OBJECT (guess_button), "clicked",
		      GTK_SIGNAL_FUNC (extension_to_mime_GUI),
		      vfs_include_type_entry);
  gtk_widget_show (guess_button);


  /*** plugin ********/
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame),
		       _
		       ("Plugin to read the files contained into the vfs file"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  vfs_include_prog_entry = gtk_entry_new_with_max_length (80);

  if (vfs_selected_extension)
    gtk_entry_set_text (GTK_ENTRY (vfs_include_prog_entry),
			vfs_selected_extension->prog->str);
  gtk_entry_select_region (GTK_ENTRY (vfs_include_prog_entry), 0,
			   GTK_ENTRY (vfs_include_prog_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox2), vfs_include_prog_entry, FALSE, FALSE,
		      0);
  gtk_widget_show (vfs_include_prog_entry);

  label = gtk_label_new (_("Leave blank to include all the file"));
  gtk_box_pack_start (GTK_BOX (vbox2), label, TRUE, FALSE, 0);
  gtk_widget_show (label);

  /*** plugin options ********/
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("Plugin Option"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vfs_include_arg_entry = gtk_entry_new_with_max_length (80);

  if (vfs_selected_extension)
    gtk_entry_set_text (GTK_ENTRY (vfs_include_arg_entry),
			vfs_selected_extension->args->str);
  gtk_entry_select_region (GTK_ENTRY (vfs_include_arg_entry), 0,
			   GTK_ENTRY (vfs_include_arg_entry)->text_length);
  gtk_container_add (GTK_CONTAINER (frame), vfs_include_arg_entry);
  gtk_widget_show (vfs_include_arg_entry);

  /*** options ********/
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame),
		       _("Fields in plugin output (first one is 0)"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (TRUE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  table = gtk_table_new (5, 2, FALSE);
  gtk_widget_show (table);
  gtk_container_add (GTK_CONTAINER (vbox2), table);

  label = gtk_label_new (_("Separator characters"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  label = gtk_label_new (_("Date field"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  label = gtk_label_new (_("Date format"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  label = gtk_label_new (_("Size field"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 3, 4,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  label = gtk_label_new (_("Name field"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 4, 5,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  vfs_separator = gtk_entry_new ();
  gtk_widget_show (vfs_separator);
  gtk_table_attach (GTK_TABLE (table), vfs_separator, 1, 2, 0, 1,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  if (vfs_selected_extension)
    gtk_entry_set_text (GTK_ENTRY (vfs_separator),
			vfs_selected_extension->separator->str);

  if (vfs_selected_extension)
    spinbutton_adj =
      gtk_adjustment_new (vfs_selected_extension->date, 0, 100, 1, 10, 10);
  else
    spinbutton_adj = gtk_adjustment_new (1, 0, 100, 1, 10, 10);
  vfs_field_date =
    gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_adj), 1, 0);
  gtk_widget_show (vfs_field_date);
  gtk_table_attach (GTK_TABLE (table), vfs_field_date, 1, 2, 1, 2,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  vfs_format_date = gtk_combo_new ();
  gtk_widget_show (vfs_format_date);
  gtk_table_attach (GTK_TABLE (table), vfs_format_date, 1, 2, 2, 3,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  if (vfs_selected_extension)
    combo_items =
      g_list_append (combo_items, vfs_selected_extension->date_format->str);
  combo_items = g_list_append (combo_items, "YYYY-MM-DD");
  combo_items = g_list_append (combo_items, "DD-MM-YYYY");
  combo_items = g_list_append (combo_items, "SSSSSSSSSS");
  gtk_combo_set_popdown_strings (GTK_COMBO (vfs_format_date), combo_items);
  g_list_free (combo_items);

  vfs_format_date_entry = GTK_COMBO (vfs_format_date)->entry;
  gtk_widget_show (vfs_format_date_entry);

  if (vfs_selected_extension)
    spinbutton_adj =
      gtk_adjustment_new (vfs_selected_extension->size, 0, 100, 1, 10, 10);
  else
    spinbutton_adj = gtk_adjustment_new (2, 0, 100, 1, 10, 10);
  vfs_field_size =
    gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_adj), 1, 0);
  gtk_widget_show (vfs_field_size);
  gtk_table_attach (GTK_TABLE (table), vfs_field_size, 1, 2, 3, 4,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  if (vfs_selected_extension)
    spinbutton_adj =
      gtk_adjustment_new (vfs_selected_extension->name, 0, 100, 1, 10, 10);
  else
    spinbutton_adj = gtk_adjustment_new (1, 0, 100, 1, 10, 10);
  vfs_field_name =
    gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_adj), 1, 0);
  gtk_widget_show (vfs_field_name);
  gtk_table_attach (GTK_TABLE (table), vfs_field_name, 1, 2, 4, 5,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  label = gtk_text_new (NULL, NULL);
  gtk_widget_show (label);
  gtk_text_insert (GTK_TEXT (label), NULL, NULL, NULL,
		   _("tar tvzf gtktalog.tar.gz\n"
		     "drwxrwxrwx 501/502           0 2000-08-22 18:33:51 gtktalog/\n"
		     "-rw-r--r-- 501/502       14362 2000-08-22 18:33:49 gtktalog/Makefile.in\n"
		     "drwxr-xr-x 501/502           0 2000-08-22 18:33:49 gtktalog/Docs/\n"
		     "...\n"
		     "Separator characters = ` \\t\'\n"
		     "Date field: 3\n"
		     "Date format: `YYYY-MM-DD'\n"
		     "Size field: 2\n" "Name field: 5\n"), -1);
  gtk_text_set_editable (GTK_TEXT (label), FALSE);
  gtk_container_add (GTK_CONTAINER (vbox2), label);



/********************************/

  hbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbox), 5);

  ok = gnome_stock_button (GNOME_STOCK_BUTTON_OK);
  GTK_WIDGET_SET_FLAGS (ok, GTK_CAN_DEFAULT);
  gtk_window_set_default (GTK_WINDOW (vfs_add_type_window), ok);
  gtk_box_pack_start (GTK_BOX (hbox), ok, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok), "clicked",
		      GTK_SIGNAL_FUNC (vfs_add_type_ok_clicked), data);
  gtk_widget_show (ok);

  cancel = gnome_stock_button (GNOME_STOCK_BUTTON_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancel, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox), cancel, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancel), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (vfs_add_type_window));
  gtk_widget_show (cancel);

  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  gtk_widget_show (vfs_add_type_window);

}

void
vfs_include_selection_made (GtkWidget * clist, gint row, gint column,
			    GdkEventButton * event, gpointer data)
{
  MIME_VFS_EXTENSIONS *clrow_data;

  vfs_selected_row = row;
  clrow_data = gtk_clist_get_row_data (GTK_CLIST (vfs_include_list_box), row);
  vfs_selected_extension = clrow_data;

  if (event != NULL && event->button == 1 && event->type == GDK_2BUTTON_PRESS)
    {
      if (clrow_data->state == FALSE)
	{
	  clrow_data->state = TRUE;
	  gtk_clist_set_pixmap (GTK_CLIST (vfs_include_list_box), row, 0,
				on_pix, state_mask);
	}
      else
	{
	  clrow_data->state = FALSE;
	  gtk_clist_set_pixmap (GTK_CLIST (vfs_include_list_box), row, 0,
				off_pix, state_mask);
	}
    }
}

void
vfs_include_unselection_made (GtkWidget * clist, gint row, gint column,
			      GdkEventButton * event, gpointer data)
{
  vfs_selected_extension = NULL;
  vfs_selected_row = -1;
}

void
vfs_include_edit_button_clicked (GtkWidget * w, gpointer data)
{
  if (vfs_selected_extension && (vfs_selected_row >= 0))
    vfs_add_type (w, GINT_TO_POINTER (EDIT_MODE));
}

void
vfs_include_delete_button_clicked (GtkWidget * w, gpointer data)
{
  if (vfs_selected_row >= 0)
    {
      g_tree_remove (local_vfs_extensions, vfs_selected_extension->mime->str);
      g_string_free (vfs_selected_extension->mime, TRUE);
      g_string_free (vfs_selected_extension->prog, TRUE);
      g_string_free (vfs_selected_extension->args, TRUE);
      g_string_free (vfs_selected_extension->separator, TRUE);
      g_string_free (vfs_selected_extension->date_format, TRUE);
/* FIXME: Memory leak here. The key is not freed. */
      g_free (vfs_selected_extension);
      vfs_selected_extension = NULL;
      gtk_clist_remove (GTK_CLIST (vfs_include_list_box), vfs_selected_row);
      vfs_selected_row = -1;
      gtk_clist_sort (GTK_CLIST (vfs_include_list_box));
    }
}

/**********************************************************************/
/***** Mimes to skip during a scan ************************************/
/**********************************************************************/

gboolean ess_extensions_traverse (gpointer key, gpointer value, gpointer data)
{
  gint state = GPOINTER_TO_INT (value);
  gint i;
  gchar *tmp[2] = { "", "" };

  tmp[1] = key;

  i = gtk_clist_append (GTK_CLIST (ess_include_list_box), (gchar **) tmp);
  if (state)
    gtk_clist_set_pixmap (GTK_CLIST (ess_include_list_box), i, 0,
			  on_pix, state_mask);
  else
    gtk_clist_set_pixmap (GTK_CLIST (ess_include_list_box), i, 0,
			  off_pix, state_mask);
  gtk_clist_unselect_row (GTK_CLIST (ess_include_list_box), i, 0);
  gtk_clist_set_row_data (GTK_CLIST (ess_include_list_box), i, key);
  return (FALSE);
}

gint
ess_tree_printf (gpointer key, gpointer value, gpointer data)
{
  gchar *mime = key;
  gint state = GPOINTER_TO_INT (value);
  FILE *f = data;

  fprintf (f, "AddMimeToSkip '%s' %d\n", mime, state);
  return (FALSE);
}

gint _ess_free_traverse (gpointer key, gpointer value, gpointer data)
{
  PIX *essp = value;
  gint row;

  row = gtk_clist_find_row_from_data (GTK_CLIST (ess_include_list_box), essp);
  gtk_clist_set_row_data (GTK_CLIST (ess_include_list_box), row, NULL);
  return (FALSE);
}

void
ess_free (GTree * ess)
{
  g_tree_traverse (ess, _ess_free_traverse, G_IN_ORDER, NULL);
  g_tree_destroy (ess);
}

void
ess_add_type_ok_clicked (GtkWidget * w, gpointer data)
{
  PIX *e2;

  char *temp_extension;

  temp_extension =
    gtk_editable_get_chars (GTK_EDITABLE (ess_include_type_entry), 0, -1);

  if (!is_mime_valid (temp_extension))
    {
      ERROR_DIALOG (_
		    ("The specified MIME is not valid. Nothing will be done."),
		    main_window);
    }
  else
    {

      e2 = g_tree_lookup (local_ess_extensions, temp_extension);

      if (e2)
	{
	  gnome_dialog_run_and_close (GNOME_DIALOG
				      (gnome_warning_dialog_parented
				       (_
					("This MIME type already exists. Nothing will be done."),
					GTK_WINDOW (ess_add_type_window))));
	}
      else
	{
	  temp_extension = g_strdup (temp_extension);
	  g_tree_insert (local_ess_extensions, temp_extension,
			 GINT_TO_POINTER (1));
	  ess_extensions_traverse (temp_extension, GINT_TO_POINTER (1), NULL);
	  gtk_clist_sort (GTK_CLIST (ess_include_list_box));
	  ess_selected_extension = NULL;
	  ess_selected_row = -1;
	}
    }
  gtk_widget_destroy (ess_add_type_window);
}


void
ess_add_type (GtkWidget * w, gpointer data)
{
  GtkWidget *vbox, *hbox, *vbox2, *hbox2;
  GtkWidget *ok, *cancel;
  GtkWidget *frame;
  GtkWidget *label, *guess_button;
  gint ess_add_edit_mode = GPOINTER_TO_INT (data);

  ess_add_type_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_window_set_transient_for (GTK_WINDOW (ess_add_type_window),
				GTK_WINDOW (main_window));

  gtk_window_set_position (GTK_WINDOW (ess_add_type_window),
			   GTK_WIN_POS_MOUSE);
  gtk_widget_set_usize (GTK_WIDGET (ess_add_type_window), 450, 450);
  gtk_window_set_title (GTK_WINDOW (ess_add_type_window),
			_("MIME types to skip during a scan"));
  gtk_window_set_policy (GTK_WINDOW (ess_add_type_window), TRUE, TRUE, TRUE);
  gtk_container_border_width (GTK_CONTAINER (ess_add_type_window), 10);
  gtk_signal_connect (GTK_OBJECT (ess_add_type_window), "delete_event",
		      GTK_SIGNAL_FUNC (gtk_widget_destroy),
		      GTK_OBJECT (ess_add_type_window));

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (ess_add_type_window), vbox);
  gtk_widget_show (vbox);
  /*** extension ************/
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("MIME type"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  ess_include_type_entry = gtk_entry_new_with_max_length (80);
  if (ess_add_edit_mode == EDIT_MODE)
    {
      if (ess_selected_extension)
	{
	  gtk_entry_set_text (GTK_ENTRY (ess_include_type_entry),
			      ess_selected_extension);
	  if (is_default_pix (ess_selected_extension))
	    gtk_entry_set_editable (GTK_ENTRY (ess_include_type_entry),
				    FALSE);
	}
    }
  gtk_entry_select_region (GTK_ENTRY (ess_include_type_entry), 0,
			   GTK_ENTRY (ess_include_type_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox2), ess_include_type_entry, FALSE, FALSE,
		      0);
  gtk_widget_show (ess_include_type_entry);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (vbox2), hbox2);
  gtk_widget_show (hbox2);

  label = gtk_label_new (_("For example `image/jpeg'"));
  gtk_box_pack_start (GTK_BOX (hbox2), label, TRUE, FALSE, 0);
  gtk_widget_show (label);

  guess_button = gtk_button_new_with_label (_("Guess from an extension"));
  gtk_box_pack_start (GTK_BOX (hbox2), guess_button, TRUE, FALSE, 0);

  gtk_signal_connect (GTK_OBJECT (guess_button), "clicked",
		      GTK_SIGNAL_FUNC (extension_to_mime_GUI),
		      ess_include_type_entry);
  gtk_widget_show (guess_button);


/********************************/

  hbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbox), 5);

  ok = gnome_stock_button (GNOME_STOCK_BUTTON_OK);
  GTK_WIDGET_SET_FLAGS (ok, GTK_CAN_DEFAULT);
  gtk_window_set_default (GTK_WINDOW (ess_add_type_window), ok);
  gtk_box_pack_start (GTK_BOX (hbox), ok, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok), "clicked",
		      GTK_SIGNAL_FUNC (ess_add_type_ok_clicked), data);
  gtk_widget_show (ok);

  cancel = gnome_stock_button (GNOME_STOCK_BUTTON_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancel, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox), cancel, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancel), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (ess_add_type_window));
  gtk_widget_show (cancel);

  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  gtk_widget_show (ess_add_type_window);

}

void
ess_include_selection_made (GtkWidget * clist, gint row, gint column,
			    GdkEventButton * event, gpointer data)
{
  gchar *clrow_data;
  gint state;
  gpointer *ptrtmp;

  ess_selected_row = row;
  clrow_data = gtk_clist_get_row_data (GTK_CLIST (ess_include_list_box), row);
  ess_selected_extension = clrow_data;
  gtk_widget_set_sensitive (GTK_WIDGET (ess_button_del), TRUE);

  if (event != NULL && event->button == 1 && event->type == GDK_2BUTTON_PRESS)
    {
      ptrtmp = g_tree_lookup (local_ess_extensions, clrow_data);
      state = GPOINTER_TO_INT (ptrtmp);
      if (state)
	{
	  g_tree_insert (local_ess_extensions, clrow_data,
			 GINT_TO_POINTER (0));
	  gtk_clist_set_pixmap (GTK_CLIST (ess_include_list_box), row, 0,
				off_pix, state_mask);
	}
      else
	{
	  g_tree_insert (local_ess_extensions, clrow_data,
			 GINT_TO_POINTER (1));
	  gtk_clist_set_pixmap (GTK_CLIST (ess_include_list_box), row, 0,
				on_pix, state_mask);
	}
    }
}

static gint
_ess_clist_g_strcasecmp (GtkCList * clist, gconstpointer ptr1,
			 gconstpointer ptr2)
{
  char *text1 = NULL;
  char *text2 = NULL;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  switch (row1->cell[clist->sort_column].type)
    {
    case GTK_CELL_TEXT:
      text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
      break;
    case GTK_CELL_PIXTEXT:
      text1 = GTK_CELL_PIXTEXT (row1->cell[clist->sort_column])->text;
      break;
    default:
      break;
    }

  switch (row2->cell[clist->sort_column].type)
    {
    case GTK_CELL_TEXT:
      text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;
      break;
    case GTK_CELL_PIXTEXT:
      text2 = GTK_CELL_PIXTEXT (row2->cell[clist->sort_column])->text;
      break;
    default:
      break;
    }

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  return g_strcasecmp (text1, text2);
}

void
ess_include_unselection_made (GtkWidget * clist, gint row, gint column,
			      GdkEventButton * event, gpointer data)
{
  ess_selected_extension = NULL;
  ess_selected_row = -1;
  gtk_widget_set_sensitive (GTK_WIDGET (ess_button_del), FALSE);
}

void
ess_include_edit_button_clicked (GtkWidget * w, gpointer data)
{
  if (ess_selected_extension && (ess_selected_row >= 0))
    ess_add_type (w, GINT_TO_POINTER (EDIT_MODE));
}

void
ess_include_delete_button_clicked (GtkWidget * w, gpointer data)
{
  if (ess_selected_row >= 0)
    {
      g_tree_remove (local_ess_extensions, ess_selected_extension);
      g_free (ess_selected_extension);
      gtk_clist_remove (GTK_CLIST (ess_include_list_box), ess_selected_row);
      ess_selected_extension = NULL;
      gtk_clist_remove (GTK_CLIST (ess_include_list_box), ess_selected_row);
      ess_selected_row = -1;
    }
}

gint
_duplicate_ess_extensions_traverse (gpointer key, gpointer value,
				    gpointer data)
{
  g_tree_insert (data, g_strdup (key), value);

  return (FALSE);
}

GTree *
duplicate_ess_extensions ()
{
  GTree *r;

  r = g_tree_new ((GCompareFunc) strcmp);
  g_tree_traverse (my_config->mime_to_skip_during_a_scan,
		   _duplicate_ess_extensions_traverse, G_IN_ORDER, r);

  return (r);
}



/**********************************************************************/
/***** GUI ************************************************************/
/**********************************************************************/

void
setup_ok_clicked (GtkWidget * w, gpointer data)
{
  GtkWidget *testvfs_widget;
  gboolean dateislocale;
  gboolean automount_is_used;

  g_string_free (my_config->mount, TRUE);
  g_string_free (my_config->umount, TRUE);
  g_string_free (my_config->eject_prog, TRUE);
  g_string_free (my_config->mount_point, TRUE);

  /* Get Config */
  automount_is_used = (gboolean) (gtk_toggle_button_get_active
				  (GTK_TOGGLE_BUTTON
				   (checkbutton_useautomount)));
  if (!automount_is_used)
    {
      g_free (mount_prog);
      g_free (umount_prog);
      mount_prog = g_strdup (gtk_entry_get_text (GTK_ENTRY (mount_entry)));
      umount_prog = g_strdup (gtk_entry_get_text (GTK_ENTRY (umount_entry)));
    }
  my_config->mount = g_string_new (mount_prog);
  g_free (mount_prog);
  my_config->umount = g_string_new (umount_prog);
  g_free (umount_prog);
  my_config->eject_prog =
    g_string_new (gtk_entry_get_text (GTK_ENTRY (eject_entry)));
  my_config->mount_point =
    g_string_new (gtk_entry_get_text (GTK_ENTRY (mount_point_entry)));
  my_config->use_supermount = check_supermount (my_config);
  /* Config Options */
  my_config->use_automount = automount_is_used;
  my_config->mount_retry =
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (retry_value));
  my_config->use_du_s =
    (gboolean) (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON (checkbutton_dus)));
  my_config->eject_disk =
    (gboolean) (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON (checkbutton_eject)));
  my_config->warn_mount =
    (gboolean) (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON (checkbutton_warnMount)));
  my_config->compression_level =
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (compression_level));
  my_config->getInformation =
    (gboolean) (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON (checkbutton_getinformation)));
  my_config->dbclick_opens_info =
    (gboolean) (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON (checkbutton_dbclick_on_file)));

  dateislocale = (gboolean) (gtk_toggle_button_get_active
			     (GTK_TOGGLE_BUTTON (checkbutton_dateislocale)));
  my_config->display_dir_size =
    (gboolean) (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON (checkbutton_displaydirsize)));

  if (!dateislocale)
    my_config->date_format =
      g_strdup (gtk_entry_get_text (GTK_ENTRY (entry_dateislocale)));
  else
    my_config->date_format = NULL;
  g_free (date_format);

  my_config->save_only_used_categories =
    (gboolean) (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON (checkbutton_save_cat_mode)));

  testvfs_widget =
    gtk_menu_get_active (GTK_MENU
			 (gtk_option_menu_get_menu
			  (GTK_OPTION_MENU (test_vfs_mode))));
  my_config->testvfs =
    GPOINTER_TO_INT (gtk_object_get_user_data (GTK_OBJECT (testvfs_widget)));
  my_config->nb_max_recent_files =
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (recentfilesmax));

  extensions_free (my_config->mime_extensions);
  vfs_extensions_free (my_config->mime_vfs_extensions);
  ei_free (my_config->mime_icons);
  ess_free (my_config->mime_to_skip_during_a_scan);

  my_config->mime_extensions = local_extensions;
  my_config->mime_vfs_extensions = local_vfs_extensions;
  my_config->mime_icons = local_ei_extensions;
  my_config->mime_to_skip_during_a_scan = local_ess_extensions;

  eip_split_default_pix (&(my_config->default_file_pix),
			 default_file_pix_string);
  eip_split_default_pix (&(my_config->default_dir_pix),
			 default_dir_pix_string);
  eip_split_default_pix (&(my_config->default_disk_pix),
			 default_disk_pix_string);
  eip_split_default_pix (&(my_config->default_unreadable_pix),
			 default_unreadable_pix_string);
  eip_split_default_pix (&(my_config->default_vfs_pix),
			 default_vfs_pix_string);
  eip_split_default_pix (&(my_config->default_opened_dir_pix),
			 default_opened_dir_pix_string);
  eip_split_default_pix (&(my_config->default_opened_disk_pix),
			 default_opened_disk_pix_string);
  eip_split_default_pix (&(my_config->default_opened_vfs_pix),
			 default_opened_vfs_pix_string);
  pix_garbage_collection ();
  if (my_config->eject_prog)
    {
      if (my_config->eject_prog->len <= 0)
	{
	  my_config->eject_disk = FALSE;
	}
    }
  else
    {
      my_config->eject_disk = FALSE;
    }

  g_string_free (my_config->default_information_plugin->prog, TRUE);
  my_config->default_information_plugin->prog =
    g_string_new (gtk_entry_get_text
		  (GTK_ENTRY (default_information_plugin_entry)));
  g_string_free (my_config->default_information_plugin->arg, TRUE);
  my_config->default_information_plugin->arg =
    g_string_new (gtk_entry_get_text
		  (GTK_ENTRY (default_information_plugin_args_entry)));

  my_config->scan_mime_types =
    (gboolean) (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON (checkbutton_scan_mime_type)));

  my_config->use_default_information_plugin =
    (gboolean) (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON (checkbutton_usedefaultinfoplugin)));

  my_config->mainwindow_save_xywh =
    (gboolean) (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON (checkbutton_save_mainwin_xywh)));




  save_myconfig ();
  g_free (default_file_pix_string);
  g_free (default_dir_pix_string);
  g_free (default_disk_pix_string);
  g_free (default_unreadable_pix_string);
  g_free (default_vfs_pix_string);
  g_free (default_opened_dir_pix_string);
  g_free (default_opened_disk_pix_string);
  g_free (default_opened_vfs_pix_string);
  gtk_widget_destroy (window);
}

void
save_myconfig ()
{
  GString *conf_file;
  FILE *f;
  RECENT_FILE *rf;
  GList *gl;
  GTree *addicons;

  conf_file = g_string_new (g_get_home_dir ());
  if (conf_file->len < 1)
    {
      gnome_dialog_run_and_close (GNOME_DIALOG
				  (gnome_warning_dialog_parented
				   (_
				    ("Home directory not found. Setup will not be saved."),
				    GTK_WINDOW (main_window))));
    }
  else
    {
      conf_file = g_string_append (conf_file, USER_CONFIG_DIR);
      if (!g_file_test (conf_file->str, G_FILE_TEST_ISDIR))
	{
	  mkdir (conf_file->str, 493);
	}
      conf_file = g_string_append (conf_file, "/" USER_CONFIG_FILE);

      if (!(f = fopen (conf_file->str, "w+")))
	{
	  ERROR_DIALOG (_("Can't save to config file"), main_window);
	}
      else
	{
	  /* TO TRANSLATORS: Those strings used to be translated.
	   * However, many bugs could happen here, depending on the translation.
	   * As this is a config file that nobody will try to read, I think that it does
	   * not matter if we do not translate it any more.
	   * Yves Mettier <ymettier@libertysurf.fr>
	   * 20001221
	   */
	  fprintf (f, "# Sample config file for gtktalog\n\n");
	  fprintf (f, "# AddMimeIcon icon_path mime [mime [mime [...]]]\n\n");
	  addicons = g_tree_new ((GCompareFunc) strcmp);
	  g_tree_traverse (my_config->mime_icons, pix_make_addicon_tree,
			   G_PRE_ORDER, addicons);
	  g_tree_traverse (addicons, pix_tree_printf, G_PRE_ORDER, f);
	  g_tree_destroy(addicons);
	  fprintf (f, "\n# AddMimeInformation mime plugin arguments state\n");
	  g_tree_traverse (my_config->mime_extensions, extensions_tree_printf,
			   G_PRE_ORDER, f);
	  fprintf (f,
		   "\n# AddVfsMime vfs_mime plugin arguments separator date_field date_format size_field name_field state\n");
	  g_tree_traverse (my_config->mime_vfs_extensions,
			   vfs_extensions_tree_printf, G_PRE_ORDER, f);

	  fprintf (f, "\n# DefaultFileIcon icon_path\n");
	  fprintf (f, "DefaultFileIcon %s\n",
		   my_config->default_file_pix->path->str);
	  fprintf (f, "# DefaultDiskIcon icon_path\n");
	  fprintf (f, "DefaultDiskIcon %s\n",
		   my_config->default_disk_pix->path->str);
	  fprintf (f, "# DefaultDirIcon icon_path\n");
	  fprintf (f, "DefaultDirIcon %s\n",
		   my_config->default_dir_pix->path->str);
	  fprintf (f, "# DefaultUnreadableIcon icon_path\n");
	  fprintf (f, "DefaultUnreadableIcon %s\n",
		   my_config->default_unreadable_pix->path->str);
	  fprintf (f, "# DefaultVfsIcon icon_path\n");
	  fprintf (f, "DefaultVfsIcon %s\n",
		   my_config->default_vfs_pix->path->str);
	  fprintf (f, "# DefaultOpenedDiskIcon icon_path\n");
	  fprintf (f, "DefaultOpenedDiskIcon %s\n",
		   my_config->default_opened_disk_pix->path->str);
	  fprintf (f, "# DefaultOpenedDirIcon icon_path\n");
	  fprintf (f, "DefaultOpenedDirIcon %s\n",
		   my_config->default_opened_dir_pix->path->str);
	  fprintf (f, "# DefaultOpenedVfsIcon icon_path\n");
	  fprintf (f, "DefaultOpenedVfsIcon %s\n",
		   my_config->default_opened_vfs_pix->path->str);
	  fprintf (f, "# MountProgram path\n");
	  fprintf (f, "MountProgram '%s'\n", my_config->mount->str);
	  fprintf (f, "# UmountProgram path\n");
	  fprintf (f, "UmountProgram '%s'\n", my_config->umount->str);
	  fprintf (f, "# EjectProgram path\n");
	  fprintf (f, "EjectProgram '%s'\n", my_config->eject_prog->str);
	  fprintf (f, "# MountPoint path\n");
	  fprintf (f, "MountPoint '%s'\n", my_config->mount_point->str);

	  /* Options */
	  fprintf (f, "\n# Options \n");
	  fprintf (f, "# Only use True or False for the following\n");
	  fprintf (f, "# Use automount?\n");
	  fprintf (f, "UseAutomount %s\n",
		   (my_config->use_automount ? "True" : "False"));
	  fprintf (f, "MountRetry %d\n", (my_config->mount_retry));
	  fprintf (f, "# Use du -s to get the size of the disk\n");
	  fprintf (f, "OptionDus %s\n",
		   (my_config->use_du_s ? "True" : "False"));
	  fprintf (f, "# Warn if a disk is mounted\n");
	  fprintf (f, "OptionWarnMount %s\n",
		   (my_config->warn_mount ? "True" : "False"));
	  fprintf (f, "# Eject the disk after a fast scan\n");
	  fprintf (f, "OptionEject %s\n",
		   (my_config->eject_disk ? "True" : "False"));
	  fprintf (f, "# Compression level for saving files\n");
	  fprintf (f, "CompressionLevel %d\n",
		   (my_config->compression_level));

	  fprintf (f,
		   "# Previous search mode for the extended search filename\n");
	  fprintf (f, "PreviousSearchMode %d\n",
		   (my_config->previous_search_mode));

	  fprintf (f,
		   "# Scan VFS (Virtual File System) Normal/Extended/Ignored\n");
	  switch (my_config->testvfs)
	    {
	    case TEST_VFS_NO:
	      fprintf (f, "VFSMode Ignored\n");
	      break;
	    case TEST_VFS_YES:
	      fprintf (f, "VFSMode Normal\n");
	      break;
	    case TEST_VFS_EXTENDED:
	      fprintf (f, "VFSMode Extended\n");
	      break;
	    }
	  fprintf (f, "# Retrieve information about files\n");
	  fprintf (f, "ReadInformation %s\n",
		   (my_config->getInformation ? "True" : "False"));
	  fprintf (f, "# Get Mime type from files\n");
	  fprintf (f, "ScanMimeTypes %s\n",
		   (my_config->scan_mime_types ? "True" : "False"));

	  fprintf (f, "\n# AddMimeToSkip mime state\n");
	  g_tree_traverse (my_config->mime_to_skip_during_a_scan,
			   ess_tree_printf, G_PRE_ORDER, f);



	  fprintf (f, "\n# Use default information plugin\n");
	  fprintf (f, "UseDefaultMimePlugin %s\n",
		   (my_config->use_default_information_plugin ? "True" :
		    "False"));
	  fprintf (f, "\n");
	  fprintf (f, "# Default information plugin\n");
	  fprintf (f, "# DefaultMimeInformation 'prog' 'args'\n");
	  fprintf (f, "DefaultMimeInformation '%s' '%s'\n",
		   my_config->default_information_plugin->prog->str,
		   my_config->default_information_plugin->arg->str);
	  fprintf (f, "# Double click on a file to see information\n");
	  fprintf (f, "DbClickFileForInfo %s\n",
		   (my_config->dbclick_opens_info ? "True" : "False"));
	  fprintf (f, "# DateFormat Locale or \"format (man strftime)\"\n");
	  if (my_config->date_format)
	    {
	      fprintf (f, "DateFormat \"%s\"\n", my_config->date_format);
	    }
	  else
	    {
	      fprintf (f, "DateFormat Locale\n");
	    }
	  fprintf (f, "# Display directories sizes?\n");
	  fprintf (f, "DisplayDirSize %s\n",
		   (my_config->display_dir_size ? "True" : "False"));


	  fprintf (f, "\n# Recent files\n");
	  fprintf (f, "# Nb max of recent files\n");
	  fprintf (f, "RecentFilesMax %d\n", my_config->nb_max_recent_files);
	  fprintf (f, "\n");
	  fprintf (f, "# Save only used categories\n");
	  fprintf (f, "SaveOnlyUsedCategories %s\n",
		   (my_config->save_only_used_categories ? "True" : "False"));
	  fprintf (f, "\n");
	  fprintf (f, "# Save main window position and size\n");
	  fprintf (f, "# MainWindowPosition X Y W H use\n");
	  fprintf (f, "MainWindowPosition %d %d %d %d %s\n",
		   my_config->mainwindow_x, my_config->mainwindow_y,
		   my_config->mainwindow_w, my_config->mainwindow_h,
		   (my_config->mainwindow_save_xywh ? "True" : "False"));
	  fprintf (f, "\n");
	  gl = my_config->recent_files;
	  /* Search for existing same entries */
	  while (gl)
	    {
	      rf = gl->data;
	      fprintf (f, "RecentFile '%s'\n", rf->fullname);
	      gl = g_list_next (gl);
	    }



	  fclose (f);
	}
g_string_free(conf_file, TRUE);
    }
}

static void
cancel_clicked (GtkWidget * w, gpointer data)
{
  g_free (mount_prog);
  g_free (umount_prog);
  extensions_free (local_extensions);
  vfs_extensions_free (local_vfs_extensions);
  ei_free (local_ei_extensions);
  ess_free (local_ess_extensions);
  gtk_widget_destroy (window);
  pix_garbage_collection ();
  g_free (default_file_pix_string);
  g_free (default_dir_pix_string);
  g_free (default_disk_pix_string);
  g_free (default_unreadable_pix_string);
  g_free (default_vfs_pix_string);
  g_free (default_opened_dir_pix_string);
  g_free (default_opened_disk_pix_string);
  g_free (default_opened_vfs_pix_string);
  return;
}

static void
destroy_window (GtkWidget * w, GdkEventKey * event, gpointer data)
{
  cancel_clicked (w, data);
}

static void
switch_entry_date (GtkWidget * w, gpointer data)
{
  gboolean dateislocale;
  dateislocale = (gboolean) (gtk_toggle_button_get_active
			     (GTK_TOGGLE_BUTTON (checkbutton_dateislocale)));
  gtk_entry_set_editable (GTK_ENTRY (entry_dateislocale), !dateislocale);
  if (!dateislocale)
    {
      gtk_entry_set_text (GTK_ENTRY (entry_dateislocale), date_format);
    }
  else
    {
      date_format =
	g_strdup (gtk_entry_get_text (GTK_ENTRY (entry_dateislocale)));
      gtk_entry_set_text (GTK_ENTRY (entry_dateislocale), "");
    }

}

static void
automount_clicked (GtkWidget * w, gpointer data)
{
  gboolean ua;
  ua = (gboolean) (gtk_toggle_button_get_active
		   (GTK_TOGGLE_BUTTON (checkbutton_useautomount)));
  gtk_entry_set_editable (GTK_ENTRY (mount_entry), !ua);
  gtk_entry_set_editable (GTK_ENTRY (umount_entry), !ua);
  gtk_widget_set_sensitive (GTK_WIDGET (mount_entry), !ua);
  gtk_widget_set_sensitive (GTK_WIDGET (umount_entry), !ua);
  gtk_widget_set_sensitive (GTK_WIDGET (retry_value), !ua);
  if (!ua)
    {
      gtk_entry_set_text (GTK_ENTRY (mount_entry), mount_prog);
      gtk_entry_set_text (GTK_ENTRY (umount_entry), umount_prog);
    }
  else
    {
      g_free (mount_prog);
      g_free (umount_prog);
      mount_prog = g_strdup (gtk_entry_get_text (GTK_ENTRY (mount_entry)));
      gtk_entry_set_text (GTK_ENTRY (mount_entry), "");
      umount_prog = g_strdup (gtk_entry_get_text (GTK_ENTRY (umount_entry)));
      gtk_entry_set_text (GTK_ENTRY (umount_entry), "");
    }

}

static gint
_clist_g_strcasecmp (GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2)
{
  char *text1 = NULL;
  char *text2 = NULL;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  switch (row1->cell[clist->sort_column].type)
    {
    case GTK_CELL_TEXT:
      text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
      break;
    case GTK_CELL_PIXTEXT:
      text1 = GTK_CELL_PIXTEXT (row1->cell[clist->sort_column])->text;
      break;
    default:
      break;
    }

  switch (row2->cell[clist->sort_column].type)
    {
    case GTK_CELL_TEXT:
      text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;
      break;
    case GTK_CELL_PIXTEXT:
      text2 = GTK_CELL_PIXTEXT (row2->cell[clist->sort_column])->text;
      break;
    default:
      break;
    }

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  return g_strcasecmp (text1, text2);
}

void
extension_to_mime_GUI (GtkWidget * w, gpointer data)
{
  GtkWidget *dialog, *label, *entry;
  GtkWidget *mime_entry = data;
  gchar *extension, *e;
  const gchar *mime;
  gint pos = 0;

  int button;
  dialog =
    gnome_dialog_new (_("Convert extension to MIME"),
		      GNOME_STOCK_BUTTON_APPLY, GNOME_STOCK_BUTTON_CANCEL,
		      NULL);
  gnome_dialog_set_parent (GNOME_DIALOG (dialog), GTK_WINDOW (main_window));
  label = gtk_label_new (_("Enter an extension"));
  gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), label, TRUE,
		      TRUE, 0);
  gtk_widget_show (label);

  entry = gtk_entry_new ();
  gtk_entry_set_editable (GTK_ENTRY (entry), TRUE);
  gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), entry, TRUE,
		      TRUE, 0);

  gtk_widget_show (entry);
  gnome_dialog_editable_enters (GNOME_DIALOG (dialog), GTK_EDITABLE (entry));
  button = gnome_dialog_run (GNOME_DIALOG (dialog));

  if (button == 0)
    {
      extension = g_strconcat (".", e =
			       gtk_editable_get_chars (GTK_EDITABLE (entry),
						       0, -1), NULL);
      mime = gnome_mime_type_or_default (extension, NULL);
      g_free (e);
      g_free (extension);
      if (mime)
	{
	  gtk_editable_delete_text (GTK_EDITABLE (mime_entry), 0, -1);
	  gtk_editable_insert_text (GTK_EDITABLE (mime_entry), mime,
				    strlen (mime), &pos);
	}
    }
  gnome_dialog_close (GNOME_DIALOG (dialog));
}

void
run_setup ()
{
  GtkWidget *ok;
  GtkWidget *cancel;
  GtkWidget *notebook;
  GtkWidget *frame;
  GtkWidget *label;
  GtkWidget *hbox;
  GtkWidget *main_vbox;
  GtkWidget *bbox;
  GtkWidget *setup_vbox;
  GtkWidget *add_button;
  GtkWidget *delete_button;
  GtkWidget *edit_button;
  GtkWidget *vbox;
  GtkWidget *retry_label;
  GtkWidget *vfs_vbox;
  GtkWidget *vbox3;
  GtkWidget *scrolled_window;
  GtkWidget *compression_level_label;
  GtkAdjustment *compression_level_adj;
  GtkAdjustment *mount_retry_adj;
  GtkWidget *test_vfs_mode_label;
  GtkWidget *test_vfs_mode_menuitem;
  GtkWidget *test_vfs_mode_menu;
  GtkWidget *label_dateislocale;
  GtkWidget *recentfilesmax_label;
  GtkAdjustment *recentfilesmax_adj;
  GtkWidget *table;
  gchar *titles[4] = { _("State"),
    _("File type"),
    _("Plugin"),
    _("Options")
  };
  gchar *eititles[3] = { _("Icon"), _("MIME type"), _("Path") };
  gchar *esstitles[2] = { _("State"), _("MIME type") };
  gboolean dateislocale;

  default_file_pix_string = g_strconcat ("[", _("Default file"), "]", NULL);
  default_dir_pix_string = g_strconcat ("[", _("Default dir"), "]", NULL);
  default_disk_pix_string = g_strconcat ("[", _("Default disk"), "]", NULL);
  default_unreadable_pix_string =
    g_strconcat ("[", _("Default unreadable"), "]", NULL);
  default_vfs_pix_string = g_strconcat ("[", _("Default vfs"), "]", NULL);
  default_opened_dir_pix_string =
    g_strconcat ("[", _("Default current dir"), "]", NULL);
  default_opened_disk_pix_string =
    g_strconcat ("[", _("Default current disk"), "]", NULL);
  default_opened_vfs_pix_string =
    g_strconcat ("[", _("Default current vfs"), "]", NULL);

  local_extensions = duplicate_extensions (my_config->mime_extensions);
  local_vfs_extensions =
    duplicate_vfs_extensions (my_config->mime_vfs_extensions);
  local_ei_extensions = duplicate_ei_extensions ();
  local_ess_extensions = duplicate_ess_extensions ();

  local_default_file_pix = my_config->default_file_pix;
  g_tree_insert (local_ei_extensions, g_strdup (default_file_pix_string),
		 local_default_file_pix);
  local_default_dir_pix = my_config->default_dir_pix;
  g_tree_insert (local_ei_extensions, g_strdup (default_dir_pix_string),
		 local_default_dir_pix);
  local_default_disk_pix = my_config->default_disk_pix;
  g_tree_insert (local_ei_extensions, g_strdup (default_disk_pix_string),
		 local_default_disk_pix);
  local_default_unreadable_pix = my_config->default_unreadable_pix;
  g_tree_insert (local_ei_extensions,
		 g_strdup (default_unreadable_pix_string),
		 local_default_unreadable_pix);
  local_default_vfs_pix = my_config->default_vfs_pix;
  g_tree_insert (local_ei_extensions, g_strdup (default_vfs_pix_string),
		 local_default_vfs_pix);
  local_default_opened_dir_pix = my_config->default_opened_dir_pix;
  g_tree_insert (local_ei_extensions,
		 g_strdup (default_opened_dir_pix_string),
		 local_default_opened_dir_pix);
  local_default_opened_disk_pix = my_config->default_opened_disk_pix;
  g_tree_insert (local_ei_extensions,
		 g_strdup (default_opened_disk_pix_string),
		 local_default_opened_disk_pix);
  local_default_opened_vfs_pix = my_config->default_opened_vfs_pix;
  g_tree_insert (local_ei_extensions,
		 g_strdup (default_opened_vfs_pix_string),
		 local_default_opened_vfs_pix);

  mount_prog = g_strdup (my_config->mount->str);
  umount_prog = g_strdup (my_config->umount->str);

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_realize (window);

  gtk_window_set_transient_for (GTK_WINDOW (window),
				GTK_WINDOW (main_window));

  gtk_window_set_policy (GTK_WINDOW (window), TRUE, TRUE, TRUE);
  gtk_window_set_title (GTK_WINDOW (window), _("Setup"));
  gtk_signal_connect (GTK_OBJECT (window),
		      "delete_event", destroy_window, NULL);



  /* pixmap stuff */
  style = gtk_widget_get_style (window);
  on_pix =
    gdk_pixmap_create_from_xpm_d (window->window,
				  &(state_mask),
				  &(style)->bg[GTK_STATE_NORMAL],
				  (gchar **) on_xpm);
  style = gtk_widget_get_style (window);
  off_pix =
    gdk_pixmap_create_from_xpm_d (window->window,
				  &(state_mask),
				  &(style)->bg[GTK_STATE_NORMAL],
				  (gchar **) off_xpm);
  gtk_container_set_border_width (GTK_CONTAINER (window), 2);


  /* The notebook */
  setup_vbox = gtk_vbox_new (FALSE, 4);
  gtk_container_add (GTK_CONTAINER (window), setup_vbox);
  gtk_widget_show (setup_vbox);

  notebook = gtk_notebook_new ();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
  gtk_box_pack_start (GTK_BOX (setup_vbox), notebook, TRUE, TRUE, 0);
  gtk_widget_show (notebook);


/*******************************************************************************************/

/*** frame for fastaddisk **********************************************************************/
  main_vbox = gtk_vbox_new (FALSE, 2);
  gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 3);
  gtk_widget_show (main_vbox);

  label = gtk_label_new (_("Disk setup"));
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), main_vbox, label);


  frame = gtk_frame_new (_("Mount method"));
  gtk_container_set_border_width (GTK_CONTAINER (frame), 3);
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, FALSE, 0);

  table = gtk_table_new (4, 2, FALSE);
  gtk_widget_show (table);
  gtk_container_add (GTK_CONTAINER (frame), table);

  /* Option to know if autmount is used */
  checkbutton_useautomount =
    gtk_check_button_new_with_label (_("Use automount (or supermount)"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_useautomount),
				my_config->use_automount);
  gtk_signal_connect (GTK_OBJECT (checkbutton_useautomount), "clicked",
		      GTK_SIGNAL_FUNC (automount_clicked), NULL);
  gtk_widget_show (checkbutton_useautomount);
  gtk_table_attach (GTK_TABLE (table), checkbutton_useautomount, 0, 2, 0, 1,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  /* For slow/laptop cdroms */
  retry_label = gtk_label_new (_("Number of mount retries"));
  gtk_widget_show (retry_label);
  gtk_table_attach (GTK_TABLE (table), retry_label, 0, 1, 1, 2,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  mount_retry_adj =
    (GtkAdjustment *) gtk_adjustment_new (my_config->mount_retry,
					  0, 5, 1, 1, 5);
  retry_value = gtk_spin_button_new (GTK_ADJUSTMENT (mount_retry_adj), 1, 0);
  gtk_widget_show (retry_value);
  gtk_table_attach (GTK_TABLE (table), retry_value, 1, 2, 1, 2,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

	/**************/
  label = gtk_label_new (_("Mount program"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  mount_entry = gtk_entry_new_with_max_length (200);
  if (my_config->use_automount)
    gtk_entry_set_text (GTK_ENTRY (mount_entry), "");
  else
    gtk_entry_set_text (GTK_ENTRY (mount_entry), my_config->mount->str);
  gtk_table_attach (GTK_TABLE (table), mount_entry, 1, 2, 2, 3,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (mount_entry);

	/*************/

  label = gtk_label_new (_("Umount program"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 3, 4,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  umount_entry = gtk_entry_new_with_max_length (200);
  if (my_config->use_automount)
    gtk_entry_set_text (GTK_ENTRY (umount_entry), "");
  else
    gtk_entry_set_text (GTK_ENTRY (umount_entry), my_config->umount->str);
  gtk_table_attach (GTK_TABLE (table), umount_entry, 1, 2, 3, 4,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (umount_entry);

	/*************/

  frame = gtk_frame_new (_("Cdrom options"));
  gtk_container_set_border_width (GTK_CONTAINER (frame), 3);
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, FALSE, 0);

  table = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table);
  gtk_container_add (GTK_CONTAINER (frame), table);

  label = gtk_label_new (_("Mount point"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  mount_point_entry = gtk_entry_new_with_max_length (200);
  gtk_entry_set_text (GTK_ENTRY (mount_point_entry),
		      my_config->mount_point->str);
  gtk_table_attach (GTK_TABLE (table), mount_point_entry, 1, 2, 0, 1,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (mount_point_entry);

/***************/

  label = gtk_label_new (_("Eject Program"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  eject_entry = gtk_entry_new_with_max_length (200);
  gtk_entry_set_text (GTK_ENTRY (eject_entry), my_config->eject_prog->str);
  gtk_table_attach (GTK_TABLE (table), eject_entry, 1, 2, 1, 2,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);
  gtk_widget_show (eject_entry);


/*****  General Options  *******************************************************************/
  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show (scrolled_window);


  /* Create the frame */
  frame = gtk_frame_new (_("General Options"));
  gtk_container_set_border_width (GTK_CONTAINER (frame), 3);
  gtk_widget_show (frame);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW
					 (scrolled_window), frame);

  /* Create the top label */
  label = gtk_label_new (_("Options"));
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), scrolled_window, label);

  /* VBox to keep the objects */
  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox3);
  gtk_widget_show (vbox3);

  /* Option to use du -s or statfs */
  /* FIXME : Find another label */
  checkbutton_dus =
    gtk_check_button_new_with_label (_("Use du -s instead of statfs"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_dus),
				my_config->use_du_s);
  gtk_widget_show (checkbutton_dus);
  gtk_box_pack_start (GTK_BOX (vbox3), checkbutton_dus, FALSE, FALSE, 0);

  /* Option to warn if the cd is mounted */
  checkbutton_warnMount =
    gtk_check_button_new_with_label (_("Warn if the CD is mounted"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_warnMount),
				my_config->warn_mount);
  gtk_widget_show (checkbutton_warnMount);
  gtk_box_pack_start (GTK_BOX (vbox3), checkbutton_warnMount, FALSE, FALSE,
		      0);

  /* Option to eject the CD */
  checkbutton_eject =
    gtk_check_button_new_with_label (_("Eject the CD after fast scan"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_eject),
				my_config->eject_disk);
  gtk_widget_show (checkbutton_eject);
  gtk_box_pack_start (GTK_BOX (vbox3), checkbutton_eject, FALSE, FALSE, 0);

  /* Option for compression level */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  compression_level_label = gtk_label_new (_("Compression level"));
  gtk_widget_show (compression_level_label);
  gtk_box_pack_start (GTK_BOX (hbox), compression_level_label, FALSE, FALSE,
		      0);

  compression_level_adj =
    (GtkAdjustment *) gtk_adjustment_new (my_config->compression_level, 0, 9,
					  1, 1, 9);
  compression_level =
    gtk_spin_button_new (GTK_ADJUSTMENT (compression_level_adj), 1, 0);
  gtk_widget_show (compression_level);
  gtk_box_pack_start (GTK_BOX (hbox), compression_level, FALSE, FALSE, 0);

  /* Option to know what to do when there is a db_click on a file */
  checkbutton_dbclick_on_file =
    gtk_check_button_new_with_label (_
				     ("Double click on a file to see information"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(checkbutton_dbclick_on_file),
				my_config->dbclick_opens_info);
  gtk_widget_show (checkbutton_dbclick_on_file);
  gtk_box_pack_start (GTK_BOX (vbox3), checkbutton_dbclick_on_file, FALSE,
		      FALSE, 0);

  /* Option about the date format */
  checkbutton_dateislocale =
    gtk_check_button_new_with_label (_("Date format is locale"));
  if (my_config->date_format)
    dateislocale = FALSE;
  else
    dateislocale = TRUE;
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(checkbutton_dateislocale), dateislocale);
  gtk_widget_show (checkbutton_dateislocale);
  gtk_box_pack_start (GTK_BOX (vbox3), checkbutton_dateislocale, FALSE,
		      FALSE, 0);
  entry_dateislocale = gtk_entry_new_with_max_length (255);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  label_dateislocale = gtk_label_new (_("Date format: "));
  gtk_widget_show (label_dateislocale);
  gtk_box_pack_start (GTK_BOX (hbox), label_dateislocale, FALSE, FALSE, 0);

  if (my_config->date_format)
    {
      gtk_entry_set_text (GTK_ENTRY (entry_dateislocale),
			  my_config->date_format);
      date_format = g_strdup (my_config->date_format);
    }
  else
    date_format = g_strdup ("");
  gtk_entry_set_editable (GTK_ENTRY (entry_dateislocale), !dateislocale);
  gtk_box_pack_start (GTK_BOX (hbox), entry_dateislocale, FALSE, FALSE, 0);
  gtk_widget_show (entry_dateislocale);
  gtk_signal_connect (GTK_OBJECT (checkbutton_dateislocale), "clicked",
		      GTK_SIGNAL_FUNC (switch_entry_date), NULL);

  /* Option to know whether to display the dir size or not */
  checkbutton_displaydirsize =
    gtk_check_button_new_with_label (_("Display directory sizes"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(checkbutton_displaydirsize),
				my_config->display_dir_size);
  gtk_widget_show (checkbutton_displaydirsize);
  gtk_box_pack_start (GTK_BOX (vbox3), checkbutton_displaydirsize, FALSE,
		      FALSE, 0);

  /* Option for the number of recent files */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  recentfilesmax_label = gtk_label_new (_("Max nb of recent files"));
  gtk_widget_show (recentfilesmax_label);
  gtk_box_pack_start (GTK_BOX (hbox), recentfilesmax_label, FALSE, FALSE, 0);

  recentfilesmax_adj =
    (GtkAdjustment *) gtk_adjustment_new (my_config->nb_max_recent_files, 0,
					  50, 1, 1, 50);
  recentfilesmax =
    gtk_spin_button_new (GTK_ADJUSTMENT (recentfilesmax_adj), 1, 0);
  gtk_widget_show (recentfilesmax);
  gtk_box_pack_start (GTK_BOX (hbox), recentfilesmax, FALSE, FALSE, 0);

  /* Option to know if we save all the categories on only the used ones */
  checkbutton_save_cat_mode =
    gtk_check_button_new_with_label (_("Save only used categories"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(checkbutton_save_cat_mode),
				my_config->save_only_used_categories);
  gtk_widget_show (checkbutton_save_cat_mode);
  gtk_box_pack_start (GTK_BOX (vbox3), checkbutton_save_cat_mode, FALSE,
		      FALSE, 0);

  /* Option to know if we save the dimensions and position of the main window */
  checkbutton_save_mainwin_xywh =
    gtk_check_button_new_with_label (_
				     ("Save the main window position and size"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(checkbutton_save_mainwin_xywh),
				my_config->mainwindow_save_xywh);
  gtk_widget_show (checkbutton_save_mainwin_xywh);
  gtk_box_pack_start (GTK_BOX (vbox3), checkbutton_save_mainwin_xywh, FALSE,
		      FALSE, 0);


/***** frame for scan options *************************************************************/
  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show (scrolled_window);

  label = gtk_label_new (_("Scan options"));
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), scrolled_window, label);

  main_vbox = gtk_vbox_new (FALSE, 4);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW
					 (scrolled_window), main_vbox);
  gtk_widget_show (main_vbox);

  frame = gtk_frame_new (_("Mime"));
  gtk_container_set_border_width (GTK_CONTAINER (frame), 3);
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  vfs_vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vfs_vbox);
  gtk_widget_show (vfs_vbox);

  /* Option to know if we scan mime types or not */
  checkbutton_scan_mime_type =
    gtk_check_button_new_with_label (_("Try to get the MIME"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(checkbutton_scan_mime_type),
				my_config->scan_mime_types);
  gtk_widget_show (checkbutton_scan_mime_type);
  gtk_box_pack_start (GTK_BOX (vfs_vbox), checkbutton_scan_mime_type, FALSE,
		      TRUE, 0);


  /* Option to scan vfs */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vfs_vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show (hbox);

  test_vfs_mode_label = gtk_label_new (_("Virtual File System scan mode: "));
  gtk_widget_show (test_vfs_mode_label);
  gtk_box_pack_start (GTK_BOX (hbox), test_vfs_mode_label, FALSE, TRUE, 0);

  test_vfs_mode = gtk_option_menu_new ();
  gtk_widget_show (test_vfs_mode);
  gtk_box_pack_start (GTK_BOX (hbox), test_vfs_mode, TRUE, TRUE, 0);
  test_vfs_mode_menu = gtk_menu_new ();
  gtk_widget_show (test_vfs_mode_menu);
  test_vfs_mode_menuitem =
    gtk_menu_item_new_with_label (_("Do not scan VFS"));
  gtk_object_set_user_data (GTK_OBJECT (test_vfs_mode_menuitem),
			    GINT_TO_POINTER (TEST_VFS_NO));
  gtk_widget_show (test_vfs_mode_menuitem);
  gtk_menu_append (GTK_MENU (test_vfs_mode_menu), test_vfs_mode_menuitem);
  test_vfs_mode_menuitem = gtk_menu_item_new_with_label (_("Scan VFS"));
  gtk_object_set_user_data (GTK_OBJECT (test_vfs_mode_menuitem),
			    GINT_TO_POINTER (TEST_VFS_YES));
  gtk_widget_show (test_vfs_mode_menuitem);
  gtk_menu_append (GTK_MENU (test_vfs_mode_menu), test_vfs_mode_menuitem);
  test_vfs_mode_menuitem = gtk_menu_item_new_with_label (_("Full scan VFS"));
  gtk_object_set_user_data (GTK_OBJECT (test_vfs_mode_menuitem),
			    GINT_TO_POINTER (TEST_VFS_EXTENDED));
  gtk_widget_show (test_vfs_mode_menuitem);
  gtk_menu_append (GTK_MENU (test_vfs_mode_menu), test_vfs_mode_menuitem);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (test_vfs_mode),
			    test_vfs_mode_menu);
  switch (my_config->testvfs)
    {
    case TEST_VFS_NO:
      gtk_option_menu_set_history (GTK_OPTION_MENU (test_vfs_mode), 0);
      break;
    case TEST_VFS_YES:
      gtk_option_menu_set_history (GTK_OPTION_MENU (test_vfs_mode), 1);
      break;
    case TEST_VFS_EXTENDED:
      gtk_option_menu_set_history (GTK_OPTION_MENU (test_vfs_mode), 2);
      break;
    }


  /* Option to read the information about files */
  checkbutton_getinformation =
    gtk_check_button_new_with_label (_("Retrieve information about files"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(checkbutton_getinformation),
				my_config->getInformation);
  gtk_widget_show (checkbutton_getinformation);
  gtk_box_pack_start (GTK_BOX (vfs_vbox), checkbutton_getinformation, FALSE,
		      TRUE, 0);


  /* The default information plugin */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vfs_vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show (hbox);

  checkbutton_usedefaultinfoplugin =
    gtk_check_button_new_with_label (_("Use the default information plugin"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(checkbutton_usedefaultinfoplugin),
				my_config->use_default_information_plugin);
  gtk_widget_show (checkbutton_usedefaultinfoplugin);
  gtk_box_pack_start (GTK_BOX (hbox), checkbutton_usedefaultinfoplugin, TRUE,
		      TRUE, 0);

  label = gtk_label_new (_("Program:"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  default_information_plugin_entry = gtk_entry_new_with_max_length (200);
  gtk_entry_set_text (GTK_ENTRY (default_information_plugin_entry),
		      my_config->default_information_plugin->prog->str);
  gtk_box_pack_start (GTK_BOX (hbox), default_information_plugin_entry, TRUE,
		      TRUE, 0);
  gtk_widget_show (default_information_plugin_entry);

  label = gtk_label_new (_("Args:"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);

  default_information_plugin_args_entry = gtk_entry_new_with_max_length (200);
  gtk_entry_set_text (GTK_ENTRY (default_information_plugin_args_entry),
		      my_config->default_information_plugin->arg->str);
  gtk_box_pack_start (GTK_BOX (hbox), default_information_plugin_args_entry,
		      FALSE, FALSE, 0);
  gtk_widget_show (default_information_plugin_args_entry);



  /* The vfs plugin list */
  frame = gtk_frame_new (_("Virtual File Systems"));
  gtk_container_set_border_width (GTK_CONTAINER (frame), 3);
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), hbox);
  gtk_widget_show (hbox);

  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  gtk_box_pack_start (GTK_BOX (hbox), scrolled_window, TRUE, TRUE, 0);
  gtk_widget_show (scrolled_window);

  /* setup box to associate vfs plugins to mimes */
  vfs_include_list_box = gtk_clist_new_with_titles (4, titles);
  gtk_signal_connect (GTK_OBJECT (vfs_include_list_box),
		      "select_row",
		      GTK_SIGNAL_FUNC (vfs_include_selection_made), NULL);
  gtk_signal_connect (GTK_OBJECT (vfs_include_list_box), "unselect_row",
		      GTK_SIGNAL_FUNC (vfs_include_unselection_made), NULL);

  gtk_clist_set_shadow_type (GTK_CLIST (vfs_include_list_box),
			     GTK_SHADOW_OUT);
  gtk_clist_set_column_width (GTK_CLIST (vfs_include_list_box), 0, 25);
  gtk_clist_set_column_width (GTK_CLIST (vfs_include_list_box), 1, 200);
  gtk_clist_set_column_width (GTK_CLIST (vfs_include_list_box), 2, 150);

  gtk_clist_set_column_justification (GTK_CLIST
				      (vfs_include_list_box), 0,
				      GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_auto_resize (GTK_CLIST (vfs_include_list_box), 3,
				    TRUE);
  gtk_clist_set_compare_func (GTK_CLIST (vfs_include_list_box),
			      _clist_g_strcasecmp);
  gtk_clist_set_sort_column (GTK_CLIST (vfs_include_list_box), 1);
  gtk_clist_set_sort_type (GTK_CLIST (vfs_include_list_box),
			   GTK_SORT_ASCENDING);

  /* fill the clist */
  g_tree_traverse (local_vfs_extensions, vfs_extensions_traverse, G_PRE_ORDER,
		   NULL);
  gtk_clist_sort (GTK_CLIST (vfs_include_list_box));

  /* show the clist */
  gtk_container_add (GTK_CONTAINER (scrolled_window), vfs_include_list_box);
  gtk_widget_show (vfs_include_list_box);

  vbox = gtk_vbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (vbox), GTK_BUTTONBOX_START);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (vbox), 0);
  gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, TRUE, 0);

  add_button = gtk_button_new_with_label (_("Add"));
  GTK_WIDGET_SET_FLAGS (add_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (vbox), add_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (add_button), "clicked",
		      GTK_SIGNAL_FUNC (vfs_add_type),
		      GINT_TO_POINTER (ADD_MODE));
  gtk_widget_show (add_button);

  edit_button = gtk_button_new_with_label (_("Edit"));
  GTK_WIDGET_SET_FLAGS (edit_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (vbox), edit_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (edit_button), "clicked",
		      GTK_SIGNAL_FUNC (vfs_include_edit_button_clicked),
		      NULL);
  gtk_widget_show (edit_button);

  delete_button = gtk_button_new_with_label (_("Delete"));
  GTK_WIDGET_SET_FLAGS (delete_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (vbox), delete_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (delete_button), "clicked",
		      GTK_SIGNAL_FUNC (vfs_include_delete_button_clicked),
		      NULL);
  gtk_widget_show (delete_button);
  gtk_widget_show (vbox);

  /**** information plugins ****/

  frame = gtk_frame_new (_("Information plugins"));
  gtk_container_set_border_width (GTK_CONTAINER (frame), 3);
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  /* The info plugin list */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), hbox);
  gtk_widget_show (hbox);

  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  gtk_box_pack_start (GTK_BOX (hbox), scrolled_window, TRUE, TRUE, 0);
  gtk_widget_show (scrolled_window);

  /* setup box to associate programs to file extensions */
  include_list_box = gtk_clist_new_with_titles (4, titles);
  gtk_signal_connect (GTK_OBJECT (include_list_box),
		      "select_row", GTK_SIGNAL_FUNC (include_selection_made),
		      NULL);
  gtk_signal_connect (GTK_OBJECT (include_list_box),
		      "unselect_row",
		      GTK_SIGNAL_FUNC (include_unselection_made), NULL);

  gtk_clist_set_shadow_type (GTK_CLIST (include_list_box), GTK_SHADOW_OUT);
  gtk_clist_set_column_width (GTK_CLIST (include_list_box), 0, 25);
  gtk_clist_set_column_width (GTK_CLIST (include_list_box), 1, 200);
  gtk_clist_set_column_width (GTK_CLIST (include_list_box), 2, 150);

  gtk_clist_set_column_justification (GTK_CLIST
				      (include_list_box), 0,
				      GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_auto_resize (GTK_CLIST (include_list_box), 3, TRUE);

  /* fill the clist */
  g_tree_traverse (local_extensions, extensions_traverse, G_PRE_ORDER, NULL);

  /* show the clist */
  gtk_container_add (GTK_CONTAINER (scrolled_window), include_list_box);
  gtk_widget_show (include_list_box);

  vbox = gtk_vbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (vbox), GTK_BUTTONBOX_START);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (vbox), 0);

  add_button = gtk_button_new_with_label (_("Add"));
  GTK_WIDGET_SET_FLAGS (add_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (vbox), add_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (add_button), "clicked",
		      GTK_SIGNAL_FUNC (add_type), GINT_TO_POINTER (ADD_MODE));
  gtk_widget_show (add_button);

  edit_button = gtk_button_new_with_label (_("Edit"));
  GTK_WIDGET_SET_FLAGS (edit_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (vbox), edit_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (edit_button), "clicked",
		      GTK_SIGNAL_FUNC (include_edit_button_clicked), NULL);
  gtk_widget_show (edit_button);

  delete_button = gtk_button_new_with_label (_("Delete"));
  GTK_WIDGET_SET_FLAGS (delete_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (vbox), delete_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (delete_button), "clicked",
		      GTK_SIGNAL_FUNC (include_delete_button_clicked), NULL);
  gtk_widget_show (delete_button);

  gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, TRUE, 0);
  gtk_widget_show (vbox);

  /**** Files to skip ****/

  frame = gtk_frame_new (_("MIME types to skip during a scan"));
  gtk_container_set_border_width (GTK_CONTAINER (frame), 3);
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_container_add (GTK_CONTAINER (frame), hbox);
  gtk_widget_show (hbox);


  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  gtk_box_pack_start (GTK_BOX (hbox), scrolled_window, TRUE, TRUE, 0);
  gtk_widget_show (scrolled_window);

  /* setup box to associate icons to file extensions */
  ess_include_list_box = gtk_clist_new_with_titles (2, esstitles);
  gtk_clist_set_shadow_type (GTK_CLIST (ess_include_list_box),
			     GTK_SHADOW_OUT);
  gtk_clist_set_column_width (GTK_CLIST (ess_include_list_box), 0, 25);

  gtk_clist_set_column_justification (GTK_CLIST
				      (ess_include_list_box), 0,
				      GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_auto_resize (GTK_CLIST (ess_include_list_box), 1,
				    TRUE);

  gtk_clist_set_compare_func (GTK_CLIST (ess_include_list_box),
			      _ess_clist_g_strcasecmp);
  gtk_clist_set_sort_column (GTK_CLIST (ess_include_list_box), 1);
  gtk_clist_set_sort_type (GTK_CLIST (ess_include_list_box),
			   GTK_SORT_ASCENDING);
  /* fill the clist */
  g_tree_traverse (local_ess_extensions, ess_extensions_traverse, G_PRE_ORDER,
		   NULL);
  gtk_clist_sort (GTK_CLIST (ess_include_list_box));

  gtk_signal_connect (GTK_OBJECT (ess_include_list_box),
		      "select_row",
		      GTK_SIGNAL_FUNC (ess_include_selection_made), NULL);
  gtk_signal_connect (GTK_OBJECT (ess_include_list_box), "unselect_row",
		      GTK_SIGNAL_FUNC (ess_include_unselection_made), NULL);

  /* show the clist */
  gtk_container_add (GTK_CONTAINER (scrolled_window), ess_include_list_box);
  gtk_widget_show (ess_include_list_box);

  vbox = gtk_vbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (vbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (vbox), 5);

  ess_button_add = gtk_button_new_with_label (_("Add"));
  GTK_WIDGET_SET_FLAGS (ess_button_add, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (vbox), ess_button_add, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (ess_button_add), "clicked",
		      GTK_SIGNAL_FUNC (ess_add_type),
		      GINT_TO_POINTER (ADD_MODE));

  gtk_widget_show (ess_button_add);

  ess_button_del = gtk_button_new_with_label (_("Delete"));
  GTK_WIDGET_SET_FLAGS (ess_button_del, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (vbox), ess_button_del, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (ess_button_del), "clicked",
		      GTK_SIGNAL_FUNC (ess_include_delete_button_clicked),
		      NULL);

  gtk_widget_set_sensitive (GTK_WIDGET (ess_button_del), FALSE);
  gtk_widget_show (ess_button_del);

  gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, TRUE, 0);
  gtk_widget_show (vbox);

/***** frame for icons *************************************************************/
  frame = gtk_frame_new (_("Mime type icons"));
  gtk_container_set_border_width (GTK_CONTAINER (frame), 3);

  gtk_widget_show (frame);

  label = gtk_label_new (_("MIME type icons"));
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

  main_vbox = gtk_vbox_new (FALSE, 2);
  gtk_container_add (GTK_CONTAINER (frame), main_vbox);
  gtk_widget_show (main_vbox);


  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  gtk_box_pack_start (GTK_BOX (main_vbox), scrolled_window, TRUE, TRUE, 0);
  gtk_widget_show (scrolled_window);

  /* setup box to associate icons to file extensions */
  ei_include_list_box = gtk_clist_new_with_titles (3, eititles);
  gtk_clist_set_shadow_type (GTK_CLIST (ei_include_list_box), GTK_SHADOW_OUT);
  gtk_clist_set_column_width (GTK_CLIST (ei_include_list_box), 0, 25);
  gtk_clist_set_column_width (GTK_CLIST (ei_include_list_box), 1, 200);

  gtk_clist_set_column_justification (GTK_CLIST
				      (ei_include_list_box), 0,
				      GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_auto_resize (GTK_CLIST (ei_include_list_box), 2, TRUE);

  gtk_clist_set_compare_func (GTK_CLIST (ei_include_list_box),
			      _ei_clist_g_strcasecmp);
  gtk_clist_set_sort_column (GTK_CLIST (ei_include_list_box), 1);
  gtk_clist_set_sort_type (GTK_CLIST (ei_include_list_box),
			   GTK_SORT_ASCENDING);
  /* fill the clist */
  g_tree_traverse (local_ei_extensions, ei_extensions_traverse, G_PRE_ORDER,
		   NULL);
  gtk_clist_sort (GTK_CLIST (ei_include_list_box));

  gtk_signal_connect (GTK_OBJECT (ei_include_list_box),
		      "select_row",
		      GTK_SIGNAL_FUNC (ei_include_selection_made), NULL);
  gtk_signal_connect (GTK_OBJECT (ei_include_list_box), "unselect_row",
		      GTK_SIGNAL_FUNC (ei_include_unselection_made), NULL);

  /* show the clist */
  gtk_container_add (GTK_CONTAINER (scrolled_window), ei_include_list_box);
  gtk_widget_show (ei_include_list_box);

  hbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbox), 5);

  ei_button_add = gtk_button_new_with_label (_("Add"));
  GTK_WIDGET_SET_FLAGS (ei_button_add, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox), ei_button_add, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (ei_button_add), "clicked",
		      GTK_SIGNAL_FUNC (ei_add_type),
		      GINT_TO_POINTER (ADD_MODE));

  gtk_widget_show (ei_button_add);

  ei_button_edit = gtk_button_new_with_label (_("Edit"));
  GTK_WIDGET_SET_FLAGS (ei_button_edit, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox), ei_button_edit, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (ei_button_edit), "clicked",
		      GTK_SIGNAL_FUNC (ei_include_edit_button_clicked), NULL);

  gtk_widget_set_sensitive (GTK_WIDGET (ei_button_edit), FALSE);
  gtk_widget_show (ei_button_edit);

  ei_button_del = gtk_button_new_with_label (_("Delete"));
  GTK_WIDGET_SET_FLAGS (ei_button_del, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox), ei_button_del, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (ei_button_del), "clicked",
		      GTK_SIGNAL_FUNC (ei_include_delete_button_clicked),
		      NULL);

  gtk_widget_set_sensitive (GTK_WIDGET (ei_button_del), FALSE);
  gtk_widget_show (ei_button_del);

  gtk_box_pack_start (GTK_BOX (main_vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show (hbox);

/*******************************************************************************************/
  /* Bottom buttons */
  bbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (bbox), 5);
  gtk_box_pack_start (GTK_BOX (setup_vbox), bbox, FALSE, FALSE, 0);
  gtk_widget_show (bbox);

  ok = gnome_stock_button (GNOME_STOCK_PIXMAP_SAVE);
  gtk_object_set_user_data (GTK_OBJECT (ok), window);
  GTK_WIDGET_SET_FLAGS (ok, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (bbox), ok, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok), "clicked",
		      GTK_SIGNAL_FUNC (setup_ok_clicked), NULL);
  gtk_widget_show (ok);

  cancel = gnome_stock_button (GNOME_STOCK_BUTTON_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancel, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (bbox), cancel, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (cancel), "clicked", cancel_clicked, NULL);
  gtk_widget_show (cancel);

  gtk_widget_show (window);
  gtk_widget_set_usize (window, 850, 500);


  selected_row = -1;
  selected_extension = NULL;

  vfs_selected_row = -1;
  vfs_selected_extension = NULL;

  ei_selected_row = -1;
  ei_selected_extension = NULL;

}
