/*  GTKtalog.
 *  Copyright (C) 1999-2000  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <stdlib.h>
#include <stdio.h>

#include "edit.h"
#include "interface.h"
#include "config_common.h"
#include "categories.h"
#include "folder.h"
#include "io.h"
#include "exit.h"
#include "categories.h"
#include "loadcat.h"

static GtkWidget *cat_window;
static GtkWidget *cat_clist;
static GtkWidget *import_selector;
static gint selected_row;
static guint cat_id;

static void
cancel_clicked (GtkWidget * w, gpointer data)
{
  FOLDER *racine = data;
  gtk_widget_destroy (cat_window);
  if (my_config->update_edit_window == TRUE)
    update_category_combo (racine);
  return;
}

static void
destroy_window (GtkWidget * w, GdkEventKey * event, gpointer data)
{
  cancel_clicked (w, data);
}

void
_set_category_name (gchar * string, gpointer category_name)
{
  if (string)
    *(GString **) category_name = g_string_new (string);
  else
    *(GString **) category_name = NULL;
  return;
}

void
add_the_categorie (GtkWidget * w, FOLDER * racine)
{
  char *tmp[2] = { "", "0" };
  GString *category_name;

  gnome_dialog_run_and_close (GNOME_DIALOG (gnome_request_dialog
					    (FALSE,
					     _("New category name"),
					     "",
					     CATEGORY_MAX_LENGTH,
					     _set_category_name,
					     &category_name,
					     GTK_WINDOW (cat_window))));



  if (category_name)
    {
      g_ptr_array_add (racine->categories, category_name);
      tmp[0] = ((GString *) category_name)->str;
      gtk_clist_append ((GtkCList *) cat_clist, tmp);
      racine->is_modified = TRUE;
    }
  return;
}

void
edit_the_categorie (GtkWidget * w, FOLDER * racine)
{
  gint i;
  char *tmp[2] = { "", "0" };
  GString *category_name;

  if (selected_row >= 0)
    {
      gtk_clist_get_text ((GtkCList *) cat_clist, selected_row, 0, &(tmp[0]));
      i = string_to_index (racine->categories, tmp[0]) - 1;

      gnome_dialog_run_and_close (GNOME_DIALOG (gnome_request_dialog
						(FALSE,
						 _("New category name"),
						 tmp[0],
						 CATEGORY_MAX_LENGTH,
						 _set_category_name,
						 &category_name,
						 GTK_WINDOW (cat_window))));



      if (category_name)
	{
	  g_string_free (g_ptr_array_index (racine->categories, i), TRUE);
	  tmp[0] = ((GString *) category_name)->str;
	  g_ptr_array_index (racine->categories, i) = g_string_new (tmp[0]);
	  gtk_clist_set_text ((GtkCList *) cat_clist, selected_row, 0,
			      tmp[0]);
	  racine->is_modified = TRUE;
	}
      else
	{
	  WARNING_DIALOG (_("Empty string. No change"), cat_window);
	}
    }
  return;
}

void
del_the_categorie (GtkWidget * w, FOLDER * racine)
{
  gint id_cat, i;
  char *tmp[2] = { "", "0" };
  FILE_DATA *fd;

  if (selected_row >= 0)
    {
      if (yes_no_cancel_dialog
	  (_("Delete confirmation"),
	   _("Do you really want to delete this category?")) == 0)
	{
	  gtk_clist_get_text ((GtkCList *) cat_clist, selected_row, 0,
			      &(tmp[0]));
	  id_cat = string_to_index (racine->categories, tmp[0]) - 1;

	  g_string_free (g_ptr_array_index (racine->categories, id_cat),
			 TRUE);
	  g_ptr_array_remove_index (racine->categories, id_cat);
	  gtk_clist_remove ((GtkCList *) cat_clist, selected_row);
	  for (i = 1; i < racine->datas->len; i++)
	    {
	      fd = g_ptr_array_index (racine->datas, i);
	      if (fd->categorie == id_cat + 1)
		fd->categorie = 0;
	      if (fd->categorie > id_cat + 1)
		fd->categorie--;
	    }
	  list_folder (racine->tree, TRUE);
	  racine->is_modified = TRUE;
	}
    }
  return;
}

void
import_clicked_ok (GtkWidget * widget, gpointer data)
{
  GString *disk_path;
  gchar *p;
  gint i;
  FOLDER *racine, *racine2;
  GString *tmpcatstr1, *tmpcatstr2;
  char *tmp[2] = { "", "0" };

  racine = (FOLDER *) data;

  disk_path =
    g_string_new (gtk_file_selection_get_filename
		  (GTK_FILE_SELECTION (import_selector)));
  g_free (my_config->working_path);
  my_config->working_path = g_strdup (disk_path->str);
  p = my_config->working_path;
  while (p[0])
    p++;
  while (p[0] != '/')
    p--;
  p[1] = 0;
  gtk_widget_destroy (GTK_WIDGET (import_selector));
  racine2 = init_folder ();
  load_only_categories_from_file (disk_path->str, racine2);
  g_string_free (disk_path, TRUE);

  for (i = 0; i < racine2->categories->len; i++)
    {
      tmpcatstr1 = ((GString *) g_ptr_array_index (racine2->categories, i));
      if (category_id (racine, tmpcatstr1) == -1)
	{
	  tmpcatstr2 = g_string_new (tmpcatstr1->str);
	  g_ptr_array_add (racine->categories, tmpcatstr2);
	  tmp[0] = ((GString *) tmpcatstr2)->str;
	  gtk_clist_append ((GtkCList *) cat_clist, tmp);
	  racine->is_modified = TRUE;

	}
    }
  clear_folder (racine2);
}

void
import_clicked (GtkWidget * w, gpointer data)
{

  import_selector = gtk_file_selection_new (_("Select Disk location"));
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (import_selector),
				   my_config->working_path);

  gtk_signal_connect (GTK_OBJECT (import_selector), "destroy",
		      GTK_SIGNAL_FUNC (gtk_widget_destroy), &import_selector);
  gtk_signal_connect (GTK_OBJECT
		      (GTK_FILE_SELECTION (import_selector)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC (import_clicked_ok), data);
  gtk_signal_connect_object (GTK_OBJECT
			     (GTK_FILE_SELECTION
			      (import_selector)->cancel_button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (import_selector));
  gtk_window_set_modal (GTK_WINDOW (import_selector), TRUE);
  gtk_widget_show (import_selector);
}

gboolean
is_category_empty (GNode * gn, gpointer data)
{
  FILE_DATA *fd;
  guint *tmpcount = data;

  if (G_NODE_IS_ROOT (gn))
    return (FALSE);
  fd = get_file_data_from_gnode (gn);
  if (fd->categorie == cat_id)
    {
      (*tmpcount)++;
      return (TRUE);
    }
  return (FALSE);
}

void
remove_unused_categories (FOLDER * racine)
{
  gint i, j, id_cat;
  static guint tmpcount;
  GList *empty_cats, *tmplist;
  FILE_DATA *fd;

  empty_cats = NULL;
  for (i = 0; i < racine->categories->len; i++)
    {
      cat_id = i + 1;
      tmpcount = 0;
      g_node_traverse (racine->tree, G_PRE_ORDER, G_TRAVERSE_ALL,
		       -1, is_category_empty, &tmpcount);
      if (tmpcount == 0)
	empty_cats =
	  g_list_insert_sorted (empty_cats, GUINT_TO_POINTER (i),
				_cmp_intptrs);
    }

  while (empty_cats)
    {
      tmplist = g_list_last (empty_cats);
      id_cat = GPOINTER_TO_UINT (tmplist->data);

      g_string_free (g_ptr_array_index (racine->categories, id_cat), TRUE);
      g_ptr_array_remove_index (racine->categories, id_cat);
      gtk_clist_remove ((GtkCList *) cat_clist, id_cat);
      for (j = 1; j < racine->datas->len; j++)
	{
	  fd = g_ptr_array_index (racine->datas, j);
	  if (fd->categorie == id_cat + 1)
	    fd->categorie = 0;
	  if (fd->categorie > id_cat + 1)
	    fd->categorie--;
	}
      empty_cats = g_list_remove (empty_cats, tmplist->data);
    }
  racine->is_modified = TRUE;

}

void
remove_unused_clicked (GtkWidget * w, FOLDER * racine)
{
  remove_unused_categories (racine);
  list_folder (racine->tree, TRUE);


}

void
cat_selected (GtkWidget * clist, gint row, gint column,
	      GdkEventButton * event, gpointer data)
{
  selected_row = row;
  return;
}


void
cat_unselected (GtkWidget * clist, gint row, gint column,
		GdkEventButton * event, gpointer data)
{
  selected_row = -1;
  return;
}

gboolean
category_count (GNode * gn, gpointer data)
{
  FILE_DATA *fd;
  guint *tmpcount = data;

  if (G_NODE_IS_ROOT (gn))
    return (FALSE);
  fd = get_file_data_from_gnode (gn);
  if (fd->categorie == cat_id)
    (*tmpcount)++;
  return (FALSE);
}

GList *
make_categories_list (FOLDER * racine)
{
  GList *cat_list = NULL;
  gint i;

  for (i = 0; i < racine->categories->len; i++)
    cat_list =
      g_list_append (cat_list,
		     ((GString *)
		      g_ptr_array_index (racine->categories, i))->str);
  return (cat_list);
}

void
edit_categories (FOLDER * racine)
{
  GtkWidget *scrolled_window;
  GtkWidget *vbox, *hbox, *vbox1, *hbox1;
  GtkWidget *button_add, *button_edit, *button_delete;
  GtkWidget *button_import, *button_remove_unused, *button_exit;
  gchar *titles[2] = { _("Name"), _("Use") };
  gchar count[] = "      ";
  static guint tmpcount;
  gint i;

  cat_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_window_set_transient_for (GTK_WINDOW (cat_window),
				GTK_WINDOW (main_window));

  gtk_window_set_position (GTK_WINDOW (cat_window), GTK_WIN_POS_MOUSE);
  gtk_widget_set_usize (GTK_WIDGET (cat_window), 300, 150);

  gtk_window_set_title (GTK_WINDOW (cat_window), _("Category editor"));
  gtk_signal_connect (GTK_OBJECT (cat_window),
		      "delete_event", destroy_window, racine);
  gtk_window_set_policy (GTK_WINDOW (cat_window), FALSE, TRUE, TRUE);

  gtk_widget_show (cat_window);


  vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
  gtk_container_add (GTK_CONTAINER (cat_window), vbox);
  gtk_widget_show (vbox);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 0);
  gtk_container_add (GTK_CONTAINER (vbox), hbox);
  gtk_widget_show (hbox);

  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (hbox), scrolled_window, TRUE, TRUE, 0);
  gtk_widget_show (scrolled_window);

  cat_clist = gtk_clist_new_with_titles (2, titles);

  gtk_clist_set_selection_mode ((GtkCList *) cat_clist, GTK_SELECTION_SINGLE);

  gtk_signal_connect (GTK_OBJECT (cat_clist), "select_row",
		      GTK_SIGNAL_FUNC (cat_selected), NULL);

  gtk_signal_connect (GTK_OBJECT (cat_clist), "unselect_row",
		      GTK_SIGNAL_FUNC (cat_unselected), NULL);

  gtk_clist_set_shadow_type (GTK_CLIST (cat_clist), GTK_SHADOW_OUT);

  gtk_clist_set_column_width (GTK_CLIST (cat_clist), 0, 150);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW
					 (scrolled_window), cat_clist);

  for (i = 0; i < racine->categories->len; i++)
    {
      titles[0] = g_strdup (get_categorie (racine, i + 1));
      cat_id = i + 1;
      tmpcount = 0;
      g_node_traverse (racine->tree, G_PRE_ORDER, G_TRAVERSE_ALL,
		       -1, category_count, &tmpcount);
      strcpy (count, "      ");
      snprintf (count, 6, "%d", tmpcount);
      titles[1] = count;
      gtk_clist_append ((GtkCList *) cat_clist, (gchar **) titles);
      g_free (titles[0]);

    }

  gtk_widget_show (cat_clist);


  vbox1 = gtk_vbox_new (FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (vbox1), 2);
  gtk_box_pack_start (GTK_BOX (hbox), vbox1, FALSE, TRUE, 0);
  gtk_widget_show (vbox1);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox1), 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox1, FALSE, TRUE, 0);
  gtk_widget_show (hbox1);


  button_import = gtk_button_new_with_label (_("Import"));
  gtk_box_pack_start (GTK_BOX (hbox1), button_import, TRUE, TRUE, 0);
  gtk_widget_show (button_import);
  gtk_signal_connect (GTK_OBJECT (button_import), "clicked",
		      GTK_SIGNAL_FUNC (import_clicked), racine);


  button_remove_unused = gtk_button_new_with_label (_("Remove unused"));
  gtk_box_pack_start (GTK_BOX (hbox1), button_remove_unused, TRUE, TRUE, 0);
  gtk_widget_show (button_remove_unused);
  gtk_signal_connect (GTK_OBJECT (button_remove_unused), "clicked",
		      GTK_SIGNAL_FUNC (remove_unused_clicked), racine);


  button_add = gnome_stock_or_ordinary_button ("Add");
  gtk_box_pack_start (GTK_BOX (vbox1), button_add, TRUE, FALSE, 0);
  gtk_widget_show (button_add);
  gtk_signal_connect (GTK_OBJECT (button_add), "clicked",
		      GTK_SIGNAL_FUNC (add_the_categorie), racine);


  button_edit = gtk_button_new_with_label (_("Edit"));
  gtk_box_pack_start (GTK_BOX (vbox1), button_edit, TRUE, FALSE, 0);
  gtk_widget_show (button_edit);
  gtk_signal_connect (GTK_OBJECT (button_edit), "clicked",
		      GTK_SIGNAL_FUNC (edit_the_categorie), racine);


  button_delete = gnome_stock_or_ordinary_button ("Remove");
  gtk_box_pack_start (GTK_BOX (vbox1), button_delete, TRUE, FALSE, 0);
  gtk_widget_show (button_delete);
  gtk_signal_connect (GTK_OBJECT (button_delete), "clicked",
		      GTK_SIGNAL_FUNC (del_the_categorie), racine);


  button_exit = gnome_stock_or_ordinary_button ("Quit");
  gtk_box_pack_start (GTK_BOX (hbox1), button_exit, TRUE, TRUE, 0);
  gtk_widget_show (button_exit);
  gtk_signal_connect (GTK_OBJECT (button_exit), "clicked",
		      GTK_SIGNAL_FUNC (cancel_clicked), racine);


}
