/*  GTKtalog.
 *  Copyright (C) 2000  Yves Mettier
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>

#include "config_common.h"
#include "progressbar.h"

static gint _thread_status;

#if !defined(USE_PTHREADS)
void
gui_update (void)
{
  while (gtk_events_pending ())
    gtk_main_iteration ();
}
#endif

gint
get_thread_status ()
{
  return (_thread_status);
}

void
reinit_thread_status ()
{
  _thread_status = THREAD_SCAN_RUNNING_NO;
}

void
set_thread_status_to_running ()
{
  _thread_status = THREAD_SCAN_RUNNING_YES;
}

void
set_thread_status_to_ended ()
{
  _thread_status = THREAD_SCAN_RUNNING_ENDED;
}

gint thread_gtk_timeout_with_progress_bar (gpointer data)
{
gint reg = GPOINTER_TO_INT(data);
  if (get_thread_status () == THREAD_SCAN_RUNNING_ENDED)
    {
      progress_setCurrent (0, reg);
      progress_timeout (data);

      reinit_thread_status (reg);

    }
  else
    {
      progress_timeout (data);
      gtk_timeout_add (PROGRESS_BAR_TIMEOUT, thread_gtk_timeout_with_progress_bar, data);
    }
  return (0);
}
