/*  GTKtalog.
 *  Copyright (C) 1999-2000  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#ifdef CATALOG3
#include <gnome.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <zlib.h>

#include "folder.h"
#include "loadcat.h"
#include "loadcat3gz.h"
#include "interface.h"

FILE_DATA *
read_filedata_3gz (gzFile gzfh)
{
  FILE_DATA *d;
  guint32 le32;
  guint16 le16;
  guint le;

  d = (FILE_DATA *) g_malloc (sizeof (FILE_DATA));
  d->name = read_gstring (gzfh);
  gzread (gzfh, &le32, sizeof (guint32));
  d->taille = GUINT32_FROM_LE (le32);
  gzread (gzfh, &le, sizeof (guint));
  d->type = GUINT_FROM_LE (le);
  gzread (gzfh, &le32, sizeof (guint32));
  d->date = GUINT32_FROM_LE (le32);
  gzread (gzfh, &le16, sizeof (guint16));
  d->categorie = GUINT16_FROM_LE (le16);
  gzread (gzfh, &le16, sizeof (guint16));
  d->description = GUINT16_FROM_LE (le16);
  d->information = read_gstring (gzfh);
  d->a_parent_node_is_vfs = d->type;
  d->mime = NULL;
  return (d);
}

FILE_DATA *
new_filedata_with_only_name_3gz (gzFile gzfh)
{
  FILE_DATA *d;
  guint le;
  d = (FILE_DATA *) g_malloc (sizeof (FILE_DATA));
  d->name = read_gstring (gzfh);
  gzread (gzfh, &le, sizeof (guint));
  d->type = GUINT_FROM_LE (le);
  d->taille = 0;
  d->date = 0;
  d->mime = NULL;
  d->categorie = 0;
  d->description = 0;
  d->information = NULL;
  d->a_parent_node_is_vfs = IS_VFS;
  return (d);
}

void
load_folder_vfs_3gz (FOLDER * racine, GNode * prev_node, gzFile gzcatalog)
{
  gchar id = CAT_TREE_0;
  FILE_DATA *fd;

  gzread (gzcatalog, &id, sizeof (gchar));
  while (id != CAT_TREE_END)
    {
      switch (id)
	{
	case CAT_TREE_0:
	  fd = new_filedata_with_only_name_3gz (gzcatalog);
	  prev_node = g_node_append_data (prev_node->parent, fd);
	  fd->node = prev_node;
	  g_ptr_array_add (racine->datas, fd);
	  break;
	case CAT_TREE_UP:
	  prev_node = prev_node->parent;
	  break;
	case CAT_TREE_DOWN:
	  gzread (gzcatalog, &id, sizeof (gchar));
	  if (id != CAT_TREE_UP)
	    {
	      g_assert (id == CAT_TREE_0);
	      fd = new_filedata_with_only_name_3gz (gzcatalog);
	      prev_node = g_node_append_data (prev_node, fd);
	      fd->node = prev_node;
	      g_ptr_array_add (racine->datas, fd);
	    }
	  break;
	}
      gzread (gzcatalog, &id, sizeof (gchar));
    }
}

void
load_folder_tree_3gz (FOLDER * racine, gzFile gzcatalog)
{
  gchar id = CAT_TREE_0;
  GNode *prev_node;
  FILE_DATA *fd;

  prev_node = racine->tree;

  gzread (gzcatalog, &id, sizeof (gchar));
  while (id != CAT_TREE_END)
    {
      switch (id)
	{
	case CAT_TREE_0:
	  fd = read_filedata_3gz (gzcatalog);
	  prev_node = g_node_append_data (prev_node->parent, fd);
	  fd->node = prev_node;
	  g_ptr_array_add (racine->datas, fd);
	  if (fd->type == IS_VFS)
	    load_folder_vfs_3gz (racine, prev_node, gzcatalog);
	  break;
	case CAT_TREE_UP:
	  prev_node = prev_node->parent;
	  break;
	case CAT_TREE_DOWN:
	  gzread (gzcatalog, &id, sizeof (gchar));
	  if (id != CAT_TREE_UP)
	    {
	      g_assert (id == CAT_TREE_0);
	      fd = read_filedata_3gz (gzcatalog);
	      prev_node = g_node_append_data (prev_node, fd);
	      fd->node = prev_node;
	      g_ptr_array_add (racine->datas, fd);
	      if (fd->type == IS_VFS)
		load_folder_vfs_3gz (racine, prev_node, gzcatalog);
	    }
	  break;
	}
      gzread (gzcatalog, &id, sizeof (gchar));
    }
  g_node_traverse (racine->tree, G_PRE_ORDER, G_TRAVERSE_ALL, -1,
		   update_vfs_fd, NULL);
}
#endif
