#!/usr/bin/env python

# Copyright (c) 2009 Ludwig Ortmann <ludwig@spline.de>
#
# This file is part of gtranscribe.
#
# gtranscribe is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# gtranscribe is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with gtranscribe.  If not, see <http://www.gnu.org/licenses/>.

from gui import mainWindow
from gstplayer import player

import gtk

# drop in for gettext
def _(s):
    return s

class config:
    def __init__(self):
        # default configuration
        self.playAccelKey = gtk.keysyms.F4
        self.playAccelMod = 0
        self.rewindAccelKey = gtk.keysyms.F3
        self.rewindAccelMod = 0
        self.forwardAccelKey = gtk.keysyms.F5
        self.forwardAccelMod = 0
        self.timestampAccelKey = gtk.keysyms.F2
        self.timestampAccelMod = 0
        self.jumpLength = 10
        self.timestampText = " # %s # "

    def load(self):
        #TODO: implement
        pass

    def save(self):
        #TODO: implement
        pass



class gtranscribe:
    def __init__(self):
        self.player = player()
        self.filename = None
        self.mediaFilename = None
        self.unsaved = False
        #TODO: proper allocation of resources (ie systemwide)
        self.gladefile = "resources/gtranscribe.glade"
        self.config = config()
        self.config.load()
        self.mediaMimeTypes = ["audio/mpeg", "audio/x-vorbis",
                "audio/x-wav", "audio/x-flac", "audio/x-m4a",
                "audio/x-au", "video/x-ms-asf", "video/x-msvideo",
                "video/x-cdxa", "video/x-vcd", "video/mpeg-sys",
                "video/x-matroska", "video/x-flv", "video/quicktime",
                "video/x-h264", "video/mpeg4", "audio/x-ms-wma",
                "video/mpeg", "application/ogg", "audio/ogg"]
        self.textMimeTypes = ["text/plain"]

def main():
    print _("""
    gtranscribe  Copyright (C) 2009  Ludwig Ortmann <ludwig@spline.de>
    This program comes with ABSOLUTELY NO WARRANTY; for details see
    the about dialog (from the menu open: Help -> About -> License).
    This is free software, and you are welcome to redistribute it
    under certain conditions; see the about dialog for details.
    """)
    gt = gtranscribe()
    window = mainWindow(gt)
    gtk.gdk.threads_init()
    gtk.main()
