;; gzochi/private/task.scm: Private infrastructure for gzochi task API
;; Copyright (C) 2012 Julian Graham
;;
;; gzochi is free software: you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

#!r6rs

(library (gzochi private task)
  (export gzochi:run-task
	  gzochi:schedule-task)

  (import (guile)
	  (gzochi app)
	  (gzochi private reflect)
	  (rnrs base)
	  (rnrs conditions)
	  (rnrs exceptions))

  (define primitive-schedule-task #f)
  
  (define (gzochi:run-task callback)
    (let ((procedure (gzochi:resolve-procedure 
		      (gzochi:callback-procedure callback)
		      (gzochi:callback-module callback))))
      (procedure (gzochi:callback-data callback))))

  (define (gzochi:schedule-task callback . args)
    (or (gzochi:callback? callback)
	(raise (condition (make-assertion-violation)
			  (make-irritants-condition callback))))

    (if (null? args)
	(primitive-schedule-task callback 0)
	(or (and (eqv? (length args) 1)
		 (let ((x (car args))) 
		   (and (integer? x) 
			(>= x 0) 
			(primitive-schedule-task callback x))))
	    (raise (condition (make-assertion-violation)
			      (make-irritants-condition args))))))
)
