/* test-scheme.c: Test routines for scheme.c in gzochid.
 * Copyright (C) 2015 Julian Graham
 *
 * gzochi is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <libguile.h>
#include <stddef.h>
#include <stdlib.h>

#include "app.h"
#include "scheme.h"

static void
test_serialization_exception ()
{
  gzochid_application_context *context = gzochid_application_context_new ();
  GString *str = g_string_new ("");
  GError *err = NULL;

  context->descriptor = calloc (1, sizeof (gzochid_application_descriptor));
  context->deployment_root = "/";

  gzochid_util_serialize_string ("test-unknown-type", str);

  g_assert
    (scm_is_false
     (gzochid_scheme_data_serialization.deserializer (context, str, &err)));

  g_assert_error (err, GZOCHID_SCHEME_ERROR, GZOCHID_SCHEME_ERROR_FAILED);
  g_clear_error (&err);

  free (context->descriptor);
  gzochid_application_context_free (context);
  g_string_free (str, TRUE);
}

static void
test_serialization_corrupt ()
{
  gzochid_application_context *context = gzochid_application_context_new ();
  GString *str = g_string_new ("");
  GError *err = NULL;
  
  gzochid_util_serialize_int (16, str);  

  g_assert
    (scm_is_false
     (gzochid_scheme_data_serialization.deserializer (context, str, &err)));

  g_assert_error (err, GZOCHID_SCHEME_ERROR, GZOCHID_SCHEME_ERROR_SERIAL);
  g_clear_error (&err);

  free (context->descriptor);
  gzochid_application_context_free (context);
  g_string_free (str, TRUE);
}

static void
inner_main (void *data, int argc, char *argv[])
{
  g_test_init (&argc, &argv, NULL);

  g_test_add_func
    ("/scheme/serialization/exception", test_serialization_exception);
  g_test_add_func ("/scheme/serialization/corrupt", test_serialization_corrupt);

  gzochid_guile_init ();
  gzochid_scheme_initialize_bindings ();
  exit (g_test_run ());
}

int
main (int argc, char *argv[])
{
  scm_boot_guile (argc, argv, inner_main, NULL);

  return 0;
}
