#!/usr/bin/env python2
# -*- coding: utf-8 -*-
# Copyright (C) 2011  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Script used to install h-client.
"""


from setuptools import setup, find_packages


VERSION = "0.0"
RELEASE = "0.0b0"


setup(
  # basic metadata
	name     = "hclient"       ,
	version  = RELEASE         ,
	packages = find_packages() ,

	# optional Pymetadata
	package_data     = { "": ["*.png", "*.mo"] , }             ,
	zip_safe         = True                                    ,
	install_requires =
	(
		#"pygtk"  ,
		#"pycurl" ,
	)                                                          ,
	entry_points     =
	{
		"console_scripts": "h-client = hclient.gtkclient:main" ,
	}                                                          ,
	test_suite       = "tests_hclient.__init__"                ,

	# PyPI metadata
	author       = "Antonio Gallo and the h-source team"                       ,
	author_email = "h-client-devel@nongnu.org"                                 ,
	description  = "A client for an h-source server (eg: https://h-node.org/)" ,
	license      = "GNU General Public License v3 or later"                    ,
	keywords     = "fsdg h-source h-node hardware libre client"                ,
	url          = "https://savannah.nongnu.org/projects/h-client/"            ,
	classifiers  =
	[
		"Development Status :: 4 - Beta"                           ,
		"Environment :: X11 Applications :: GTK"                   ,
		"Intended Audience :: End Users/Desktop"                   ,
		"License :: DFSG approved"                                 ,
		"License :: OSI Approved :: GNU General Public License v3" ,
		"Natural Language :: English"                              ,
		"Natural Language :: Esperanto"                            ,
		"Natural Language :: German"                               ,
		"Natural Language :: Italian"                              ,
		"Natural Language :: Polish"                               ,
		"Operating System :: POSIX :: Linux"                       ,
		"Operating System :: POSIX :: GNU Hurd"                    ,
		"Programming Language :: Python :: 3 :: Only"              ,
		"Topic :: Database :: Front-Ends"                          ,
		"Topic :: System :: Benchmark"                             ,
		"Topic :: System :: Hardware"                              ,
		"Topic :: System :: Hardware :: Hardware Drivers"          ,
	]                                                                          ,
)
