/*****
 *       xhackometer - part of the Hackometer project
 *                                                                   
 * xhackometer records keyboard and mouse and cache files
 * for later delivery to hackometer server
 *                                                                   
 *        Copyright (C) 2009 Henrik Sandklef      
 *                                                                   
 * This program is free software; you can redistribute it and/or     
 * modify it under the terms of the GNU General Public License       
 * as published by the Free Software Foundation; either version 3    
 * of the License, or any later version.                             
 *                                                                   
 *                                                                   
 * This program is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of    
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     
 * GNU General Public License for more details.                      
 *                                                                   
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software       
 * Foundation, Inc., 51 Franklin Street, Boston,            
 * MA  02110-1301, USA.                                              
 ****/


#ifndef XHM_PROTO_H
#define XHM_PROTO_H




/*
 *  XHM Protocol meta data
 *
 */
#define HACKOMETER_PROTOCOL_NAME    "HMP"
#define HACKOMETER_PROTOCOL_VERSION "1.0"




/*
 *  XHM Protocol meassure data
 *
 */
#define XHM_PUT               "PUT "
#define XHM_UIN               "Uin:"
#define XHM_PASSWORD          "Password:"
#define XHM_KEY_PRESS         "Key-Presses:"
#define XHM_KEY_RELEASE       "Key-Releases:"
#define XHM_PASTED_CHARACTERS "Pasted-Characters:"
#define XHM_COPIED_CHARACTERS "Copied-Characters:"
#define XHM_CUT_CHARACTERS    "Cut-Characters:"
#define XHM_BUTTON_PRESS      "Button-Presses:"
#define XHM_BUTTON_RELEASE    "Button-Releases:"
#define XHM_X_PIXELS          "X-Pixels:"
#define XHM_Y_PIXELS          "Y-Pixels:"
#define XHM_SAMPLE_TIME_START "Start-Time:"
#define XHM_SAMPLE_TIME_STOP  "Stop-Time:"



/*
 *  XHM Protocol user data
 *
 */
#define XHM_REGISTER          "REGISTER" 
#define XHM_REAL_NAME         "Real-Name:"
#define XHM_NICK_NAME         "Nick-Name:"
#define XHM_MAIL              "Email-Address:"
#define XHM_HOME_URL          "Home-Page:"
#define XHM_OS                "Operating-System:"
#define XHM_WIN_ENV           "Window-Environment:"
#define XHM_HOST_IP           "Host-IP:"




/*
 *  XHM resource data
 *
 */
#define XHM_SERVER          "Server:"
#define XHM_SERVER_PORT     "Server-port:"
#define XHM_SEND_INTERVAL   "Send-interval:"
#define XHM_USE_RECORD      "Use-record:"


#endif
