/*****
 *       xhackometer - part of the Hackometer project
 *                                                                   
 * xhackometer records keyboard and mouse and cache files
 * for later delivery to hackometer server
 *                                                                   
 *        Copyright (C) 2009 Henrik Sandklef      
 *                                                                   
 * This program is free software; you can redistribute it and/or     
 * modify it under the terms of the GNU General Public License       
 * as published by the Free Software Foundation; either version 3    
 * of the License, or any later version.                             
 *                                                                   
 *                                                                   
 * This program is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of    
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     
 * GNU General Public License for more details.                      
 *                                                                   
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software       
 * Foundation, Inc., 51 Franklin Street, Boston,            
 * MA  02110-1301, USA.                                              
 ****/


/*
 Xhackometer 
*/


/* Standard includes */
#include <stdio.h>
#include <unistd.h>

/* X11 includes */
#include <X11/Xlib.h>
#include <X11/Xmd.h>
#include <X11/Xproto.h>
#include <X11/Xos.h>
#include <X11/Xlibint.h>  /* Warning, there be dragons here.... */

/* X11 extensions includes */
#include <X11/extensions/record.h> 

/* xhm includes */
#include "xhm/xhm.h"
#include "cache/cache.h"
#include "collect/record.h"


void
xhm_handle_event2 ( XPointer xdptr, XRecordInterceptData *xrecintd);

int protocol_error;	/* error code of error caught by error handler */
int protocol_error_major;	/* major op code of error caught */
int protocol_error_minor;	/* minor op code of error caught */

int
handle_xerr(Display *dpy, XErrorEvent *errevent)
{
    protocol_error = errevent->error_code;
    protocol_error_major = errevent->request_code;
    protocol_error_minor = errevent->minor_code;
    printf ("Error recevied....\n");
    return 1;
}


static int  nr_of_calls=0;


int
start_record (xhm_data *xd)
{
  struct xhm_record_data *xrd;
  
  xrd = (struct xhm_record_data*) 
    calloc (1,sizeof (struct xhm_record_data));
  
  
  xrd->range            = XRecordAllocRange();
  xrd->range_Array      = (XRecordRange**)  calloc (1, sizeof(XRecordRange));
  xrd->rState           = (XRecordState **) calloc (1, sizeof(XRecordState)); 
  xrd->xids             = (XID *)           calloc (2, sizeof(XID)); 
  xrd->data_flags = XRecordFromServerTime | XRecordFromClientTime | XRecordFromClientSequence; 

  xd->xhm_collect_data = (char *)xrd; 

  xhm_set_protocol    (xrd->range);
  nr_of_calls=0;

  xrd->control = XOpenDisplay (xd->xhm_ctrl->display);
  if (!xrd->control) 
    {
      (void)fprintf(stderr, "Failed to open display");
      return 0;
    }
  XSynchronize(xrd->control, True); /* so we get errors at convenient times */
  XSetErrorHandler(handle_xerr);

  
  xrd->data = XOpenDisplay (xd->xhm_ctrl->display);
  if (!xrd->data) 
    {
      (void)fprintf(stderr, "Failed to open display");
      return 0;
    }

  XSynchronize(xrd->control,True);
  if(!XRecordQueryVersion(xrd->control, &xrd->major_return, &xrd->minor_return) )
      return 0;

  xhm_verbose (xd,
	       "\t  XRecord-\n\t  Release         %d.%d\n", xrd->major_return, xrd->minor_return);  
  
  xhm_verbose (xd,
	       "\t  Intercepting    XRecordAllClients\n");             
  
  xrd->xids[0] = XRecordAllClients; 
  xrd->xids[0] = XGContextFromGC(DefaultGC(xrd->control, 0));
  xrd->range_Array[0] = xrd->range; 
  xrd->rContext = XRecordCreateContext(xrd->control, 
				       xrd->data_flags, 
				       xrd->xids,1, 
				       xrd->range_Array, 1);
  xhm_verbose (xd,
	  "\t  CreateContext   0x%lx\n", xrd->rContext);  
  /*
    XRecordRegisterClients   (xrd->control,xrd->rContext,xrd->data_flags, xrd->xids,1,xrd->range_Array,1);    
    
    xrd->xids[0] = xhm_client_id (xrd->control);
    xrd->xids[1] = xhm_client_id (xrd->data);
    
    XRecordUnregisterClients( xrd->control, 
    xrd->rContext,
    xrd->xids,
    2);
    
    
    if(!XRecordGetContext(xrd->control, xrd->rContext, (XRecordState **) xrd->rState))
    xhm_verbose (xd,
    "\n Couldn't get the context information for Display %d\n", (int) xrd->control) ;
  */


  /* set start time */
  time ( &xd->sample_time_start );

  /*  XSync  (xrd->control, True); 
  XFlush (xrd->control); 
  printf ("====================================================================================================\n");
  XHM_SLEEP;
  free(xrd->range            );
  free(xrd->range_Array      );
  free(xrd->rState           );
  free(xrd->xids             );
  free(xrd             );
  printf ("====================================================================================================\n");
  XHM_SLEEP;
  printf ("====================================================================================================\n");
  XHM_SLEEP;
  */

  XSynchronize(xrd->control, True);  
  XRecordEnableContext (xrd->data, 
			xrd->rContext, 
			xhm_handle_event, 
			(XPointer) (xd) /* closure passed to Dispatch */);

  
  /* set start time */
  time ( &xd->sample_time_stop );
  xhm_verbose (xd, " recording finished\n");
  xhm_verbose (xd, " freeing allocated stuff\n");
  XFree(xrd->range);
  XFree(xrd->range_Array);
  XFree(xrd->rState);
  XFree(xrd->xids);
  
  free((struct xhm_record_data *)xd->xhm_collect_data);
  xd->xhm_collect_data=NULL;  
  
  return 1;
}



int 
stop_record(xhm_data* xd)
{
  struct xhm_record_data *xrd;

  xhm_verbose (xd, " ---> stop_record\n");
  xrd =  (struct xhm_record_data *) xd->xhm_collect_data;
  xhm_verbose (xd, " ---  stop_record 0\n");

  XRecordDisableContext(xrd->control, 
			xrd->rContext);

  xhm_verbose (xd, " ---  stop_record 1\n");
  //  XRecordFreeContext (xrd->control, xrd->rContext);

  xhm_verbose (xd, " ---  stop_record 2\n");
  //  XRecordFreeState(xrd->rState[0]); 


  xhm_verbose (xd, " ---  stop_record 3\n");
  xhm_verbose (xd, " <--- stop_record\n");
  return 0;
}




/* ******************** */

void
xhm_handle_event2 ( XPointer xdptr, XRecordInterceptData *xrecintd)
{
  xhm_data * xd  = ( xhm_data*) xdptr;
  if (nr_of_calls++==10)
    stop_record(xd);
  printf ("."); 
  fflush(stdout);
  XRecordFreeData (xrecintd);
}



void
xhm_handle_event ( XPointer xdptr, XRecordInterceptData *xrecintd)
{
  XRecordDatum *xrec_data  = (XRecordDatum *) (xrecintd->data) ;
  int           event_type ;
  xhm_data * xd  = ( xhm_data*) xdptr;
  int ret = 0;

  static int last_x=-100;
  static int last_y=-100;
  int this_x;
  int this_y;
  xhm_verbose (xd, " ---> xhm_handle_event\n");

 /* if NOT XRECORDEndOffData or XRECORDClientDied  set data_type */  
  if(xrecintd->data_len) 
    {
      event_type = xrec_data->type;
    }
  else 
    {
      XRecordFreeData (xrecintd);
      return;
    }
  xhm_verbose (xd  ,
		     "Key: %d/%d   Button: %d/%d Motion: %d (%lld/%lld)  type %d\n",
		     xd->nr_of_kpress,
		     xd->nr_of_krelease,
		     xd->nr_of_bpress,
		     xd->nr_of_brelease,
		     xd->nr_of_motions,
		     xd->nr_of_xpix,
		     xd->nr_of_ypix,
		     event_type);
  switch(event_type)
    {	  
    case KeyPress:
      xd->nr_of_kpress++;
      break;
    case KeyRelease:
      xd->nr_of_krelease++;
      break;
    case ButtonPress:
      xd->nr_of_bpress++;
      break;
    case ButtonRelease:
      xd->nr_of_brelease++;
      break;
    case MotionNotify:  
      this_x = xrec_data->event.u.keyButtonPointer.rootX;
      this_y = xrec_data->event.u.keyButtonPointer.rootY;

      xd->nr_of_motions++;

      if ( last_x != -100 ) 
	{
	  xd->nr_of_xpix += XHM_ABS(last_x -  this_x ) ;
	}
      if ( last_y != -100 ) 
	{
	  xd->nr_of_ypix += XHM_ABS(last_y -  this_y ) ;
	}
      last_x = this_x;
      last_y = this_y;
      break;
    default:
      break;
    }

  
  xhm_verbose (xd, " --- xhm_handle_event\n");


  
  /*  xhm_verbose (xd,"for those about to send ....NULL\n");
  ret=send_fun (xd, NULL, XHM_SEND_DATA);
  xhm_verbose (xd," ...WE SALUTE YOU!\n");
  switch (ret)
    {
    case SEND_OK:
      xhm_verbose (xd, "Cleaning up struct\n");
      xhm_null_struct(xd);
      break;
    case TO_LESS_DATA:
      xhm_verbose (xd, "Keeping struct\n");
      break;
    case SEND_FAILED:
      break;
    default:
      xhm_verbose (xd, ".. default branch reached after sending data\n");
    }
  */

  if (!xhm_continue_collect (xd, nr_of_calls++))
    {
      xhm_verbose (xd,"for those about to CACHE ....NULL\n");
      xhm_verbose (xd, "Caching data for later deliverance --->\n");
      ret=cache_fun (xd);
      xhm_verbose (xd, "Caching data for later deliverance --- %d\n", ret);
      xhm_null_struct(xd);
      xhm_verbose (xd, "Caching data for later deliverance <---\n");
      stop_record(xd);
      nr_of_calls=0;
      XRecordFreeData (xrecintd);
      return;
    }


  XRecordFreeData (xrecintd);
  xhm_verbose (xd, " <--- xhm_handle_event\n");
}


 

void 
xhm_set_protocol (XRecordRange *range_array)
{
  /*  range_array->delivered_events.first = 0L;
  range_array->delivered_events.last  = 0L; 
  */
  range_array->device_events.first    = KeyPress;
  range_array->device_events.last     = MotionNotify;  
  /*  range_array->core_requests.first    = 0L;
  range_array->core_requests.last     = 0L; 
  range_array->core_replies.first     = 0L; 
  range_array->core_replies.last      = 0L; 
  range_array->errors.first           = 0L;
  range_array->errors.last            = 0L;

  range_array->ext_requests.ext_major.first = 0L;
  range_array->ext_requests.ext_major.last = 0L;
  range_array->ext_requests.ext_minor.first = 0L;
  range_array->ext_requests.ext_minor.last = 0L;

  range_array->ext_replies.ext_major.first = 0L;
  range_array->ext_replies.ext_major.last = 0L;
  range_array->ext_replies.ext_minor.first = 0L;
  range_array->ext_replies.ext_minor.last = 0L;

  
  range_array->client_started = True;
  range_array->client_died = True; 
  */
} 


XID xhm_client_id (Display *dpy) 
{
  return dpy->resource_base ;
}
