Name:           halevt
Version:        0.0.2
Release:        1%{?dist}
Summary:        Generic handler for HAL events

Group:          Applications/System
License:        GPL
URL:            http://www.environnement.ens.fr/perso/dumas/halevt.html
Source0:        http://www.environnement.ens.fr/perso/dumas/halevt-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:  dbus-glib-devel hal-devel libxml2-devel boolstuff-devel
BuildRequires:  gettext pkgconfig
Requires(post): /sbin/chkconfig
Requires(preun): /sbin/chkconfig
Requires(preun): /sbin/service
Requires(pre): /usr/sbin/useradd

%description
Halevts is a daemon that executes arbitrary commands when a device with 
certain properties is added to the system and when device properties 
change. Ivman uses HAL to monitor the state of your system's hardware.
With the default config file and script, it can handle the mounting of
media as they are inserted/attached to the system.

For automounting to work well, it is advisable to have either
gome-mount or pmount installed for user mount, and pmount
installed for system-wide mounts.

%prep
%setup -q


%build
%configure
make %{?_smp_mflags}


%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/rc.d/init.d

install -m 0755 -p halevt-initscript $RPM_BUILD_ROOT%{_sysconfdir}/rc.d/init.d/halevt

%find_lang %{name}

%clean
rm -rf $RPM_BUILD_ROOT


%pre
if [ "$1" = "1" ]
then
  /usr/sbin/useradd -r -M -c "Halevt system user" -d %{_localstatedir}/lib/halevt -s '/bin/false' halevt &>/dev/null || :
fi

%post
# This adds the proper /etc/rc*.d links for the script
/sbin/chkconfig --add halevt

%preun
if [ $1 = 0 ]; then
        /sbin/service halevt stop >/dev/null 2>&1 || :
        /sbin/chkconfig --del halevt
fi

%files -f %{name}.lang
%defattr(-,root,root,-)
%doc COPYING AUTHORS README NEWS
%dir %{_sysconfdir}/halevt
%{_sysconfdir}/rc.d/init.d/halevt
%{_bindir}/halevt
%{_bindir}/hvmount
%{_bindir}/hvumount
%dir %{_datadir}/halevt
%{_datadir}/halevt/halevt.xml
%dir %attr(750,halevt,halevt) %{_localstatedir}/run/halevt
%dir %attr(755,halevt,halevt) %{_localstatedir}/lib/halevt

%changelog
* Sun Feb  4 2007 Patrice Dumas <pertusus@free.fr> 0.0.2-1
- initial release
