/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.table.Table;
import org.h2.util.ClassUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class FunctionAlias
extends DbObjectBase {
    private boolean hasConnectionParam;
    private String className;
    private String methodName;
    private Method javaMethod;
    private int paramCount;
    private int dataType;
    static /* synthetic */ Class class$java$sql$Connection;

    public FunctionAlias(Database database, int n, String string, String string2, boolean bl) throws SQLException {
        block3: {
            this.initDbObjectBase(database, n, string, "function");
            int n2 = string2.indexOf(40);
            int n3 = string2.lastIndexOf(46, n2 < 0 ? string2.length() : n2);
            if (n3 < 0) {
                throw Message.getSQLException(42000, string2);
            }
            this.className = string2.substring(0, n3);
            this.methodName = string2.substring(n3 + 1);
            try {
                this.load();
            }
            catch (SQLException sQLException) {
                if (bl) break block3;
                throw sQLException;
            }
        }
    }

    private synchronized void load() throws SQLException {
        GenericDeclaration genericDeclaration;
        if (this.javaMethod != null) {
            return;
        }
        Class clazz = ClassUtils.loadUserClass(this.className);
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            genericDeclaration = methodArray[i];
            if (!Modifier.isStatic(genericDeclaration.getModifiers())) continue;
            if (genericDeclaration.getName().equals(this.methodName)) {
                this.javaMethod = genericDeclaration;
                break;
            }
            if (!this.getMethodSignature((Method)genericDeclaration).equals(this.methodName)) continue;
            this.javaMethod = genericDeclaration;
            break;
        }
        if (this.javaMethod == null) {
            throw Message.getSQLException(90087, this.methodName + " (" + this.className + ")");
        }
        Class<?>[] classArray = this.javaMethod.getParameterTypes();
        this.paramCount = classArray.length;
        if (this.paramCount > 0 && (class$java$sql$Connection == null ? (class$java$sql$Connection = FunctionAlias.class$("java.sql.Connection")) : class$java$sql$Connection).isAssignableFrom((Class<?>)(genericDeclaration = classArray[0]))) {
            this.hasConnectionParam = true;
            --this.paramCount;
        }
        genericDeclaration = this.javaMethod.getReturnType();
        this.dataType = DataType.getTypeFromClass((Class)genericDeclaration);
    }

    private String getMethodSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(method.getName());
        stringBuffer.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz;
            if (i > 0) {
                stringBuffer.append(", ");
            }
            if ((clazz = classArray[i]).isArray()) {
                stringBuffer.append(clazz.getComponentType().getName());
                stringBuffer.append("[]");
                continue;
            }
            stringBuffer.append(clazz.getName());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public Class[] getColumnClasses() throws SQLException {
        this.load();
        return this.javaMethod.getParameterTypes();
    }

    public int getDataType() {
        return this.dataType;
    }

    public String getCreateSQLForCopy(Table table, String string) {
        throw Message.getInternalError();
    }

    public String getDropSQL() {
        return "DROP ALIAS IF EXISTS " + this.getSQL();
    }

    public String getCreateSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE FORCE ALIAS ");
        stringBuffer.append(this.getSQL());
        stringBuffer.append(" FOR ");
        stringBuffer.append(Parser.quoteIdentifier(this.className + "." + this.methodName));
        return stringBuffer.toString();
    }

    public int getType() {
        return 9;
    }

    public synchronized void removeChildrenAndResources(Session session) throws SQLException {
        this.database.removeMeta(session, this.getId());
        this.methodName = null;
        this.className = null;
        this.javaMethod = null;
        this.invalidate();
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Value getValue(Session session, Expression[] expressionArray, boolean bl) throws SQLException {
        Value value;
        Object object;
        int n;
        this.load();
        Class<?>[] classArray = this.javaMethod.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        int n2 = 0;
        if (this.hasConnectionParam && objectArray.length > 0) {
            objectArray[n2++] = session.createConnection(bl);
        }
        for (n = 0; n < expressionArray.length && n2 < objectArray.length; ++n, ++n2) {
            object = classArray[n2];
            int n3 = DataType.getTypeFromClass(object);
            value = expressionArray[n].getValue(session);
            Object object2 = (value = value.convertTo(n3)).getObject();
            if (object2 == null) {
                if (((Class)object).isPrimitive()) {
                    if (!bl) return ValueNull.INSTANCE;
                    object2 = DataType.getDefaultForPrimitiveType((Class)object);
                }
            } else if (!((Class)object).isAssignableFrom(object2.getClass()) && !((Class)object).isPrimitive()) {
                object2 = DataType.convertTo(session, session.createConnection(false), value, (Class)object);
            }
            objectArray[n2] = object2;
        }
        n = session.getAutoCommit() ? 1 : 0;
        try {
            block13: {
                session.setAutoCommit(false);
                try {
                    object = this.javaMethod.invoke(null, objectArray);
                    if (object != null) break block13;
                    ValueNull valueNull = ValueNull.INSTANCE;
                    return valueNull;
                }
                catch (Exception exception) {
                    throw Message.convert(exception);
                }
            }
            Value value2 = DataType.convertToValue(session, object, this.dataType);
            value = value2.convertTo(this.dataType);
            return value;
        }
        finally {
            session.setAutoCommit(n != 0);
        }
    }

    public int getParameterCount() throws SQLException {
        this.load();
        return this.paramCount;
    }

    public String getJavaClassName() {
        return this.className;
    }

    public String getJavaMethodName() {
        return this.methodName;
    }

    public boolean hasConnectionParam() {
        return this.hasConnectionParam;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

