/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

public class MemoryUtils {
    private static long lastGC;
    private static final int GC_DELAY = 50;
    private static final int MAX_GC = 8;

    public static int getMemoryUsed() {
        MemoryUtils.collectGarbage();
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() - runtime.freeMemory();
        return (int)(l >> 10);
    }

    public static int getMemoryFree() {
        MemoryUtils.collectGarbage();
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        return (int)(l >> 10);
    }

    private static synchronized void collectGarbage() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        long l2 = System.currentTimeMillis();
        if (lastGC + 50L < l2) {
            for (int i = 0; i < 8; ++i) {
                runtime.gc();
                long l3 = runtime.totalMemory();
                if (l3 == l) {
                    lastGC = System.currentTimeMillis();
                    break;
                }
                l = l3;
            }
        }
    }
}

