/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import org.h2.constant.SysProperties;
import org.h2.util.JdbcDriverUtils;
import org.h2.util.Resources;
import org.h2.util.StringCache;

public class MemoryUtils {
    private static long lastGC;
    private static final int GC_DELAY = 50;
    private static final int MAX_GC = 8;
    private static volatile byte[] reserveMemory;

    private MemoryUtils() {
    }

    public static int getMemoryUsed() {
        MemoryUtils.collectGarbage();
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() - runtime.freeMemory();
        return (int)(l >> 10);
    }

    public static int getMemoryFree() {
        MemoryUtils.collectGarbage();
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        return (int)(l >> 10);
    }

    private static synchronized void collectGarbage() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        long l2 = System.currentTimeMillis();
        if (lastGC + 50L < l2) {
            for (int i = 0; i < 8; ++i) {
                runtime.gc();
                long l3 = runtime.totalMemory();
                if (l3 == l) {
                    lastGC = System.currentTimeMillis();
                    break;
                }
                l = l3;
            }
        }
    }

    public static void allocateReserveMemory() {
        if (reserveMemory == null) {
            reserveMemory = new byte[SysProperties.RESERVE_MEMORY];
        }
    }

    public static void freeReserveMemory() {
        reserveMemory = null;
    }

    public static boolean isShutdown() {
        return StringCache.isShutdown() || JdbcDriverUtils.isShutdown() || Resources.isShutdown();
    }
}

