/*
 * Decompiled with CFR 0.152.
 */
package hanzitrainer;

import hanzitrainer.HanziApplicationUpdater;
import hanzitrainer.HanziDB;
import hanzitrainer.HanziTrainerApp;
import hanzitrainer.PinyinParser;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class ChineseWordTestPanel
extends JPanel {
    private JLabel ChineseGuessLabel;
    private JTextField ChineseGuessTextField;
    private JLabel CorrectChineseLabel;
    private JButton DoneButton;
    private JButton EditGuess;
    private JButton EditPreviousWordButton;
    private JLabel EnglishLabel;
    private JLabel GuessLabel;
    private JLabel MeaningLabel;
    private JLabel PinyinLabel;
    private JLabel PreviousChineseLabel;
    private JLabel PreviousLabel;
    private JLabel PreviousMeaningLabel;
    private JLabel PreviousTranslationLabel;
    private JLabel PreviouspinyinLabel;
    private JLabel TranslationLabel;
    private JLabel YourguessLabel;
    private HanziDB main_database;
    private HanziApplicationUpdater parent_app;
    private ArrayList<String> chinese_word_history;
    private String current_translation;
    private String current_pinyin;
    private String current_chinese;
    private String previous_chinese_guess;
    private String previous_correct_chinese;
    private String previous_pinyin;
    private String previous_translation;
    private String previous_meaning_from_guess;

    public ChineseWordTestPanel(HanziDB database, HanziApplicationUpdater updater) {
        this.main_database = database;
        this.parent_app = updater;
        this.initComponents();
        this.chinese_word_history = new ArrayList();
    }

    public void ChineseWordTestUpdateDB() {
        this.set_new_word_guess();
    }

    private void set_new_word_guess() {
        int index;
        int id;
        ArrayList<String> word_information;
        int num_words = this.main_database.get_number_words();
        if (num_words == 0) {
            return;
        }
        while (this.chinese_word_history.contains((word_information = this.main_database.get_word_details(id = this.main_database.get_word_id(index = (int)(HanziDB.random_low() * (double)num_words)))).get(0))) {
        }
        this.chinese_word_history.add(word_information.get(0));
        if (this.chinese_word_history.size() > num_words / 2) {
            this.chinese_word_history.remove(0);
        }
        this.current_translation = word_information.get(2);
        this.current_pinyin = word_information.get(1);
        this.current_chinese = word_information.get(0);
        this.TranslationLabel.setText(this.current_translation);
        this.ChineseGuessTextField.setText("");
    }

    private void check_old_data() {
        this.previous_correct_chinese = this.current_chinese;
        this.previous_pinyin = this.current_pinyin;
        this.previous_translation = this.current_translation;
        this.previous_chinese_guess = this.ChineseGuessTextField.getText();
        this.PreviousTranslationLabel.setText(this.previous_translation);
        this.PreviousChineseLabel.setText(this.previous_correct_chinese);
        this.PreviouspinyinLabel.setText(PinyinParser.convert_to_printed_version(this.previous_pinyin));
        this.GuessLabel.setText(this.previous_chinese_guess);
        if (this.previous_chinese_guess.equals(this.previous_correct_chinese)) {
            this.GuessLabel.setForeground(Color.green);
            this.PreviousMeaningLabel.setText("");
            this.main_database.change_word_score(this.main_database.get_word_id(this.previous_correct_chinese), true, 1);
        } else {
            this.GuessLabel.setForeground(Color.red);
            this.main_database.change_word_score(this.main_database.get_word_id(this.previous_correct_chinese), false, 2);
            int id = this.main_database.get_word_id(this.previous_chinese_guess);
            if (id != -1) {
                this.PreviousMeaningLabel.setText(this.main_database.get_word_details(id).get(2));
                this.main_database.change_word_score(id, false, 2);
            }
        }
    }

    private void initComponents() {
        this.EnglishLabel = new JLabel();
        this.ChineseGuessLabel = new JLabel();
        this.ChineseGuessTextField = new JTextField();
        this.TranslationLabel = new JLabel();
        this.DoneButton = new JButton();
        this.PreviousLabel = new JLabel();
        this.PreviousTranslationLabel = new JLabel();
        this.CorrectChineseLabel = new JLabel();
        this.PreviousChineseLabel = new JLabel();
        this.YourguessLabel = new JLabel();
        this.GuessLabel = new JLabel();
        this.MeaningLabel = new JLabel();
        this.PreviousMeaningLabel = new JLabel();
        this.PinyinLabel = new JLabel();
        this.PreviouspinyinLabel = new JLabel();
        this.EditPreviousWordButton = new JButton();
        this.EditGuess = new JButton();
        this.setName("Form");
        ResourceMap resourceMap = Application.getInstance(HanziTrainerApp.class).getContext().getResourceMap(ChineseWordTestPanel.class);
        this.EnglishLabel.setText(resourceMap.getString("EnglishLabel.text", new Object[0]));
        this.EnglishLabel.setName("EnglishLabel");
        this.ChineseGuessLabel.setText(resourceMap.getString("ChineseGuessLabel.text", new Object[0]));
        this.ChineseGuessLabel.setName("ChineseGuessLabel");
        this.ChineseGuessTextField.setText(resourceMap.getString("ChineseGuessTextField.text", new Object[0]));
        this.ChineseGuessTextField.setName("ChineseGuessTextField");
        this.ChineseGuessTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChineseWordTestPanel.this.DoneButtonActionPerformed(evt);
            }
        });
        this.ChineseGuessTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ChineseWordTestPanel.this.ChineseGuessTextFieldFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                ChineseWordTestPanel.this.ChineseGuessTextFieldFocusLost(evt);
            }
        });
        this.TranslationLabel.setText(resourceMap.getString("TranslationLabel.text", new Object[0]));
        this.TranslationLabel.setName("TranslationLabel");
        this.DoneButton.setText(resourceMap.getString("DoneButton.text", new Object[0]));
        this.DoneButton.setName("DoneButton");
        this.DoneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChineseWordTestPanel.this.DoneButtonActionPerformed(evt);
            }
        });
        this.PreviousLabel.setText(resourceMap.getString("PreviousLabel.text", new Object[0]));
        this.PreviousLabel.setName("PreviousLabel");
        this.PreviousTranslationLabel.setText(resourceMap.getString("PreviousTranslationLabel.text", new Object[0]));
        this.PreviousTranslationLabel.setName("PreviousTranslationLabel");
        this.CorrectChineseLabel.setText(resourceMap.getString("CorrectChineseLabel.text", new Object[0]));
        this.CorrectChineseLabel.setName("CorrectChineseLabel");
        this.PreviousChineseLabel.setText(resourceMap.getString("PreviousChineseLabel.text", new Object[0]));
        this.PreviousChineseLabel.setName("PreviousChineseLabel");
        this.YourguessLabel.setText(resourceMap.getString("YourguessLabel.text", new Object[0]));
        this.YourguessLabel.setName("YourguessLabel");
        this.GuessLabel.setText(resourceMap.getString("GuessLabel.text", new Object[0]));
        this.GuessLabel.setName("GuessLabel");
        this.MeaningLabel.setText(resourceMap.getString("MeaningLabel.text", new Object[0]));
        this.MeaningLabel.setName("MeaningLabel");
        this.PreviousMeaningLabel.setText(resourceMap.getString("PreviousMeaningLabel.text", new Object[0]));
        this.PreviousMeaningLabel.setName("PreviousMeaningLabel");
        this.PinyinLabel.setText(resourceMap.getString("PinyinLabel.text", new Object[0]));
        this.PinyinLabel.setName("PinyinLabel");
        this.PreviouspinyinLabel.setText(resourceMap.getString("PreviouspinyinLabel.text", new Object[0]));
        this.PreviouspinyinLabel.setName("PreviouspinyinLabel");
        this.EditPreviousWordButton.setText(resourceMap.getString("EditPreviousWordButton.text", new Object[0]));
        this.EditPreviousWordButton.setName("EditPreviousWordButton");
        this.EditPreviousWordButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChineseWordTestPanel.this.EditPreviousWordButtonActionPerformed(evt);
            }
        });
        this.EditGuess.setText(resourceMap.getString("EditGuess.text", new Object[0]));
        this.EditGuess.setName("EditGuess");
        this.EditGuess.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChineseWordTestPanel.this.EditGuessActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ChineseGuessLabel, GroupLayout.Alignment.TRAILING).addComponent(this.EnglishLabel, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.TranslationLabel, -1, 389, Short.MAX_VALUE).addGap(10, 10, 10)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.MeaningLabel).addComponent(this.YourguessLabel).addComponent(this.PinyinLabel).addComponent(this.CorrectChineseLabel).addComponent(this.PreviousLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.EditPreviousWordButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.EditGuess)).addComponent(this.PreviousTranslationLabel, -1, 384, Short.MAX_VALUE).addComponent(this.ChineseGuessTextField, -1, 384, Short.MAX_VALUE).addComponent(this.PreviousChineseLabel, -1, 384, Short.MAX_VALUE).addComponent(this.PreviouspinyinLabel, -1, 384, Short.MAX_VALUE).addComponent(this.GuessLabel, -1, 384, Short.MAX_VALUE).addComponent(this.PreviousMeaningLabel, -1, 384, Short.MAX_VALUE)).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(210, 210, 210).addComponent(this.DoneButton).addContainerGap(242, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.EnglishLabel).addComponent(this.TranslationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ChineseGuessLabel).addComponent(this.ChineseGuessTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DoneButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.PreviousTranslationLabel).addComponent(this.PreviousLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.PreviousChineseLabel).addComponent(this.CorrectChineseLabel)).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.PreviouspinyinLabel).addComponent(this.PinyinLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.GuessLabel).addComponent(this.YourguessLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.PreviousMeaningLabel).addComponent(this.MeaningLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.EditPreviousWordButton).addComponent(this.EditGuess)).addContainerGap(41, Short.MAX_VALUE)));
    }

    private void ChineseGuessTextFieldFocusGained(FocusEvent evt) {
        this.ChineseGuessTextField.getInputContext().selectInputMethod(Locale.CHINA);
    }

    private void ChineseGuessTextFieldFocusLost(FocusEvent evt) {
        this.ChineseGuessTextField.getInputContext().selectInputMethod(Locale.getDefault());
    }

    private void DoneButtonActionPerformed(ActionEvent evt) {
        this.check_old_data();
        this.set_new_word_guess();
    }

    private void EditGuessActionPerformed(ActionEvent evt) {
        this.parent_app.edit_word(this.previous_chinese_guess);
    }

    private void EditPreviousWordButtonActionPerformed(ActionEvent evt) {
        this.parent_app.edit_word(this.previous_correct_chinese);
    }
}

