/*
 * Decompiled with CFR 0.152.
 */
package hanzitrainer;

import hanzitrainer.HanziDB;
import hanzitrainer.PinyinParser;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class DBTableFiller
extends AbstractTableModel {
    HanziDB db;
    String hanzi;
    ArrayList<ArrayList<String>> table_for_character;
    table_mode_t table_mode = table_mode_t.TMODE_ALL;

    public DBTableFiller(HanziDB database) {
        this.db = database;
        this.hanzi = new String("");
    }

    public void set_filter(String hanzi) {
        this.hanzi = hanzi;
        this.table_for_character = this.db.get_words_with_character(hanzi);
        if (this.table_for_character.size() == 0) {
            System.out.println("No DBTableFiller.set_character : no word for this char");
        }
        this.table_mode = table_mode_t.TMODE_CHARACTER;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Chinese";
            }
            case 1: {
                return "Pinyin";
            }
            case 2: {
                return "Translation";
            }
            case 3: {
                return "Score";
            }
        }
        return "column " + column + "???";
    }

    public int getRowCount() {
        int res = this.table_mode == table_mode_t.TMODE_ALL ? this.db.get_number_words() : this.table_for_character.size();
        return res;
    }

    public int getColumnCount() {
        return 4;
    }

    public Object getValueAt(int row, int column) {
        if (this.table_mode == table_mode_t.TMODE_ALL) {
            if (this.getRowCount() == 0) {
                return "";
            }
            int id = this.db.get_word_id(row, 0);
            ArrayList<String> word_details = this.db.get_word_details(id);
            switch (column) {
                case 0: {
                    return word_details.get(0);
                }
                case 1: {
                    return PinyinParser.convert_to_printed_version(word_details.get(1));
                }
                case 2: {
                    return word_details.get(2);
                }
                case 3: {
                    return word_details.get(3);
                }
            }
            return "(" + row + "," + column + ") ?";
        }
        String result = this.table_for_character.get(row).get(column);
        if (column == 1) {
            result = PinyinParser.convert_to_printed_version(result);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum table_mode_t {
        TMODE_ALL,
        TMODE_CHARACTER,
        TMODE_WORD;

    }
}

