/*
 * Decompiled with CFR 0.152.
 */
package hanzitrainer;

import hanzitrainer.CharacterDatabasePanel;
import hanzitrainer.CharacterReviewPanel;
import hanzitrainer.CharacterTestPanel;
import hanzitrainer.ChineseWordTestPanel;
import hanzitrainer.HanziApplicationUpdater;
import hanzitrainer.HanziDB;
import hanzitrainer.HanziTrainerApp;
import hanzitrainer.Pinyin;
import hanzitrainer.PinyinChooserFrame;
import hanzitrainer.WordDatabasePanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;

public class HanziTrainerView
extends FrameView
implements HanziApplicationUpdater {
    HanziDB main_database;
    private Preferences my_preferences = Preferences.userRoot();
    CharacterReviewPanel char_review;
    WordDatabasePanel word_database;
    CharacterTestPanel char_test;
    ChineseWordTestPanel chinese_test;
    CharacterDatabasePanel char_database;
    private JRadioButton AddNewWordButton;
    private JLabel ChineseLabel;
    private JTextField ChineseTextField;
    private JOptionPane ChoicePane;
    private JRadioButton DeleteWordButton;
    private JRadioButton EditWordButton;
    private JLabel EnglishLabel;
    private JTextField EnglishTextField;
    private JComboBox EnglishTranslations;
    private JMenuItem OpenDBMenuItem;
    private JLabel PinyinLabel;
    private JScrollPane PinyinScroll;
    private JButton ResetButton;
    private JButton SaveButton;
    private JMenuItem SaveDBAsMenuItem;
    private JMenuItem SaveDBMenuItem;
    private JTabbedPane Tabs;
    private JPanel VocabularyBuilderPanel;
    private JMenuItem jMenuItem1;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private ButtonGroup vocabularyEditorButtonGroup;
    private PinyinChooserFrame PinyinChooser;
    private JFileChooser DBFileChooser;

    public HanziTrainerView(SingleFrameApplication app) {
        super(app);
        this.main_database = new HanziDB();
        String database_file = this.my_preferences.get("database_filename", "");
        if (!database_file.equals("")) {
            this.main_database.HanziDB_open(database_file);
        }
        this.initComponents();
        this.word_database = new WordDatabasePanel(this.main_database, this);
        this.Tabs.addTab("Word Database", this.word_database);
        this.char_review = new CharacterReviewPanel(this.main_database, this);
        this.Tabs.addTab("Character Review", this.char_review);
        this.char_test = new CharacterTestPanel(this.main_database, this);
        this.Tabs.addTab("Character Test", this.char_test);
        this.chinese_test = new ChineseWordTestPanel(this.main_database, this);
        this.Tabs.addTab("Chinese Test", this.chinese_test);
        this.char_database = new CharacterDatabasePanel(this.main_database, this);
        this.Tabs.addTab("Character Database", this.char_database);
        this.update_panel_databases();
    }

    public void HanziTrainerViewKill() {
        String database_file = this.main_database.HanziDB_get_filename();
        if (this.main_database.get_database_changed()) {
            Object[] options = new Object[]{"Save", "Do no save"};
            if (JOptionPane.showOptionDialog(this.getFrame(), "You did not save the database, do you want to save now ?", "Save?", 0, 2, null, options, options[1]) == 0) {
                if (database_file.equals("")) {
                    this.save_database_as(new ActionEvent(this, 1001, "Save on quit"));
                } else {
                    this.main_database.HanziDB_save();
                }
            }
        }
        this.my_preferences.put("database_filename", database_file);
        this.main_database.shutdown();
    }

    private void update_panel_databases() {
        this.char_review.CharacterReviewUpdateDB();
        this.word_database.WordDatabaseUpdateDB();
        this.char_test.CharacterTestUpdateDB();
        this.chinese_test.ChineseWordTestUpdateDB();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.Tabs = new JTabbedPane();
        this.VocabularyBuilderPanel = new JPanel();
        this.ChineseLabel = new JLabel();
        this.PinyinLabel = new JLabel();
        this.EnglishLabel = new JLabel();
        this.ChineseTextField = new JTextField();
        this.EnglishTextField = new JTextField();
        this.SaveButton = new JButton();
        this.ResetButton = new JButton();
        this.PinyinScroll = new JScrollPane();
        this.EnglishTranslations = new JComboBox();
        this.AddNewWordButton = new JRadioButton();
        this.EditWordButton = new JRadioButton();
        this.DeleteWordButton = new JRadioButton();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.OpenDBMenuItem = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.SaveDBMenuItem = new JMenuItem();
        this.SaveDBAsMenuItem = new JMenuItem();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        this.vocabularyEditorButtonGroup = new ButtonGroup();
        this.ChoicePane = new JOptionPane();
        this.mainPanel.setName("mainPanel");
        this.Tabs.setName("Tabs");
        this.VocabularyBuilderPanel.setName("VocabularyBuilderPanel");
        ResourceMap resourceMap = Application.getInstance(HanziTrainerApp.class).getContext().getResourceMap(HanziTrainerView.class);
        this.ChineseLabel.setText(resourceMap.getString("ChineseLabel.text", new Object[0]));
        this.ChineseLabel.setName("ChineseLabel");
        this.PinyinLabel.setText(resourceMap.getString("PinyinLabel.text", new Object[0]));
        this.PinyinLabel.setName("PinyinLabel");
        this.EnglishLabel.setText(resourceMap.getString("EnglishLabel.text", new Object[0]));
        this.EnglishLabel.setName("EnglishLabel");
        this.ChineseTextField.setText(resourceMap.getString("ChineseTextField.text", new Object[0]));
        this.ChineseTextField.setName("ChineseTextField");
        this.PinyinChooser = new PinyinChooserFrame(this.PinyinScroll, this.main_database);
        this.ChineseTextField.getDocument().addDocumentListener(this.PinyinChooser);
        this.ChineseTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                HanziTrainerView.this.ChineseTextFieldFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                HanziTrainerView.this.ChineseTextFieldFocusLost(evt);
            }
        });
        this.EnglishTextField.setText(resourceMap.getString("EnglishTextField.text", new Object[0]));
        this.EnglishTextField.setName("EnglishTextField");
        this.EnglishTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HanziTrainerView.this.SaveButtonActionPerformed(evt);
            }
        });
        this.SaveButton.setText(resourceMap.getString("SaveButton.text", new Object[0]));
        this.SaveButton.setName("SaveButton");
        this.SaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HanziTrainerView.this.SaveButtonActionPerformed(evt);
            }
        });
        this.ResetButton.setText(resourceMap.getString("ResetButton.text", new Object[0]));
        this.ResetButton.setDefaultCapable(false);
        this.ResetButton.setName("ResetButton");
        this.ResetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HanziTrainerView.this.ResetButtonActionPerformed(evt);
            }
        });
        this.PinyinScroll.setName("PinyinScroll");
        this.EnglishTranslations.setEnabled(false);
        this.EnglishTranslations.setName("EnglishTranslations");
        this.vocabularyEditorButtonGroup.add(this.AddNewWordButton);
        this.AddNewWordButton.setText(resourceMap.getString("AddNewWordButton.text", new Object[0]));
        this.AddNewWordButton.setEnabled(false);
        this.AddNewWordButton.setName("AddNewWordButton");
        this.vocabularyEditorButtonGroup.add(this.EditWordButton);
        this.EditWordButton.setText(resourceMap.getString("EditWordButton.text", new Object[0]));
        this.EditWordButton.setEnabled(false);
        this.EditWordButton.setName("EditWordButton");
        this.vocabularyEditorButtonGroup.add(this.DeleteWordButton);
        this.DeleteWordButton.setText(resourceMap.getString("DeleteWordButton.text", new Object[0]));
        this.DeleteWordButton.setEnabled(false);
        this.DeleteWordButton.setName("DeleteWordButton");
        GroupLayout VocabularyBuilderPanelLayout = new GroupLayout(this.VocabularyBuilderPanel);
        this.VocabularyBuilderPanel.setLayout(VocabularyBuilderPanelLayout);
        VocabularyBuilderPanelLayout.setHorizontalGroup(VocabularyBuilderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(VocabularyBuilderPanelLayout.createSequentialGroup().addGroup(VocabularyBuilderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(VocabularyBuilderPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ChineseLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ChineseTextField, -1, 491, Short.MAX_VALUE)).addGroup(VocabularyBuilderPanelLayout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.PinyinLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.PinyinScroll, -1, 491, Short.MAX_VALUE)).addGroup(VocabularyBuilderPanelLayout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.EnglishLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(VocabularyBuilderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.EnglishTextField, -1, 386, Short.MAX_VALUE).addComponent(this.EnglishTranslations, 0, 386, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(VocabularyBuilderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.EditWordButton).addComponent(this.AddNewWordButton).addComponent(this.DeleteWordButton))).addGroup(GroupLayout.Alignment.TRAILING, VocabularyBuilderPanelLayout.createSequentialGroup().addContainerGap(417, Short.MAX_VALUE).addComponent(this.ResetButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SaveButton, -2, 59, -2))).addContainerGap()));
        VocabularyBuilderPanelLayout.setVerticalGroup(VocabularyBuilderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(VocabularyBuilderPanelLayout.createSequentialGroup().addContainerGap().addGroup(VocabularyBuilderPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ChineseLabel).addComponent(this.ChineseTextField, -2, 34, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(VocabularyBuilderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.PinyinScroll, -2, 64, -2).addComponent(this.PinyinLabel)).addGap(13, 13, 13).addGroup(VocabularyBuilderPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(VocabularyBuilderPanelLayout.createSequentialGroup().addGroup(VocabularyBuilderPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.EnglishLabel).addComponent(this.EnglishTranslations, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.EnglishTextField, -2, -1, -2).addGap(35, 35, 35)).addGroup(VocabularyBuilderPanelLayout.createSequentialGroup().addComponent(this.AddNewWordButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.EditWordButton).addGap(3, 3, 3).addComponent(this.DeleteWordButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED))).addGroup(VocabularyBuilderPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ResetButton).addComponent(this.SaveButton, -2, 23, -2)).addGap(40, 40, 40)));
        this.ChineseLabel.getAccessibleContext().setAccessibleName(resourceMap.getString("jLabel1.AccessibleContext.accessibleName", new Object[0]));
        this.Tabs.addTab(resourceMap.getString("VocabularyBuilderPanel.TabConstraints.tabTitle", new Object[0]), this.VocabularyBuilderPanel);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.Tabs, GroupLayout.Alignment.TRAILING, -1, 558, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.Tabs, -1, 286, Short.MAX_VALUE));
        this.Tabs.getAccessibleContext().setAccessibleName(resourceMap.getString("jTabbedPane1.AccessibleContext.accessibleName", new Object[0]));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        fileMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                HanziTrainerView.this.FileMenuSelected(evt);
            }
        });
        this.OpenDBMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.OpenDBMenuItem.setMnemonic('O');
        this.OpenDBMenuItem.setText(resourceMap.getString("OpenDBMenuItem.text", new Object[0]));
        this.OpenDBMenuItem.setName("OpenDBMenuItem");
        this.OpenDBMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HanziTrainerView.this.open_database(evt);
            }
        });
        fileMenu.add(this.OpenDBMenuItem);
        this.OpenDBMenuItem.getAccessibleContext().setAccessibleDescription(resourceMap.getString("OpenDBItem1.AccessibleContext.accessibleDescription", new Object[0]));
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.jMenuItem1.setText(resourceMap.getString("jMenuItem1.text", new Object[0]));
        this.jMenuItem1.setName("jMenuItem1");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HanziTrainerView.this.close_database(evt);
            }
        });
        fileMenu.add(this.jMenuItem1);
        this.SaveDBMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.SaveDBMenuItem.setText(resourceMap.getString("SaveDBMenuItem.text", new Object[0]));
        this.SaveDBMenuItem.setName("SaveDBMenuItem");
        this.SaveDBMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HanziTrainerView.this.save_database(evt);
            }
        });
        fileMenu.add(this.SaveDBMenuItem);
        this.SaveDBMenuItem.getAccessibleContext().setAccessibleDescription(resourceMap.getString("SaveDBMenuItem.AccessibleContext.accessibleDescription", new Object[0]));
        this.SaveDBAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(123, 2));
        this.SaveDBAsMenuItem.setText(resourceMap.getString("SaveDBAsMenuItem.text", new Object[0]));
        this.SaveDBAsMenuItem.setName("SaveDBAsMenuItem");
        this.SaveDBAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HanziTrainerView.this.save_database_as(evt);
            }
        });
        fileMenu.add(this.SaveDBAsMenuItem);
        ApplicationActionMap actionMap = Application.getInstance(HanziTrainerApp.class).getContext().getActionMap(HanziTrainerView.class, this);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        this.menuBar.add(helpMenu);
        this.ChoicePane.setName("ChoicePane");
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
    }

    private void init_file_chooser() {
        if (this.DBFileChooser == null) {
            this.DBFileChooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Hanzi Trainer DB files", "ktdb");
            this.DBFileChooser.setFileFilter(filter);
        }
    }

    private int open_dialog() {
        this.init_file_chooser();
        return this.DBFileChooser.showOpenDialog(this.mainPanel);
    }

    private int save_dialog() {
        this.init_file_chooser();
        return this.DBFileChooser.showSaveDialog(this.mainPanel);
    }

    private void open_database(ActionEvent evt) {
        int returnVal = this.open_dialog();
        if (returnVal == 0) {
            File file = this.DBFileChooser.getSelectedFile();
            System.out.println("Opening: " + file.getPath());
            this.main_database.HanziDB_open(file.getPath());
            this.update_panel_databases();
        } else {
            System.out.println("Open command cancelled by user.");
        }
    }

    private void save_database_as(ActionEvent evt) {
        int returnVal = this.save_dialog();
        if (returnVal == 0) {
            File file = this.DBFileChooser.getSelectedFile();
            System.out.println("Saving as: " + file.getPath());
            this.main_database.HanziDB_set_filename(file.getPath());
            this.main_database.HanziDB_save();
        } else {
            System.out.println("Open command cancelled by user.");
        }
    }

    private void save_database(ActionEvent evt) {
        this.main_database.HanziDB_save();
    }

    private void close_database(ActionEvent evt) {
        this.main_database.HanziDB_close();
        this.update_panel_databases();
    }

    private void FileMenuSelected(MenuEvent evt) {
        System.out.println("whether to enable save db ? file name is [" + this.main_database.HanziDB_get_filename() + "]");
        if (this.main_database.HanziDB_get_filename().equals("")) {
            this.SaveDBMenuItem.setEnabled(false);
        } else {
            this.SaveDBMenuItem.setEnabled(true);
        }
    }

    private void ResetButtonActionPerformed(ActionEvent evt) {
        this.ChineseTextField.setText("");
        this.EnglishTextField.setText("");
    }

    private void SaveButtonActionPerformed(ActionEvent evt) {
        int i;
        String english = this.EnglishTextField.getText();
        ArrayList<String> pinyin = this.PinyinChooser.get_pinyins();
        String hanzi_string = this.ChineseTextField.getText();
        ArrayList<String> hanzi = new ArrayList<String>();
        for (i = 0; i < pinyin.size(); ++i) {
            if (Pinyin.verify_pinyin(pinyin.get(i))) continue;
            return;
        }
        for (i = 0; i < hanzi_string.codePointCount(0, hanzi_string.length()); ++i) {
            int from = hanzi_string.offsetByCodePoints(0, i);
            int to = i == hanzi_string.codePointCount(0, hanzi_string.length()) - 1 ? hanzi_string.length() : hanzi_string.offsetByCodePoints(0, i + 1);
            hanzi.add(hanzi_string.substring(from, to));
        }
        if (!this.AddNewWordButton.isEnabled() || this.AddNewWordButton.isSelected()) {
            if (english.length() == 0) {
                return;
            }
            this.main_database.add_translation(english, pinyin, hanzi);
        } else if (this.DeleteWordButton.isSelected()) {
            if (this.EnglishTranslations.getSelectedIndex() == 0) {
                return;
            }
            this.main_database.delete_translation((String)this.EnglishTranslations.getSelectedItem(), hanzi);
        } else if (this.EditWordButton.isSelected()) {
            if (this.EnglishTranslations.getSelectedIndex() == 0) {
                return;
            }
            if (english.length() == 0) {
                return;
            }
            this.main_database.delete_translation((String)this.EnglishTranslations.getSelectedItem(), hanzi);
            this.main_database.add_translation(english, pinyin, hanzi);
        }
        this.update_panel_databases();
        this.EnglishTranslations.removeAllItems();
        this.ChineseTextField.setText("");
        this.EnglishTextField.setText("");
        this.ChineseTextField.requestFocus();
    }

    private void ChineseTextFieldFocusLost(FocusEvent evt) {
        String hanzi_string = this.ChineseTextField.getText();
        ArrayList<Object> translations = new ArrayList();
        this.ChineseTextField.getInputContext().selectInputMethod(Locale.getDefault());
        translations = this.main_database.get_chinese_word_translation(hanzi_string);
        if (translations.size() == 0) {
            return;
        }
        this.EnglishTranslations.addItem("[new]");
        for (int i = 0; i < translations.size(); ++i) {
            this.EnglishTranslations.addItem(translations.get(i));
        }
        this.EnglishTranslations.setEnabled(true);
        this.AddNewWordButton.setEnabled(true);
        this.EditWordButton.setEnabled(true);
        this.DeleteWordButton.setEnabled(true);
        this.AddNewWordButton.setSelected(true);
    }

    private void ChineseTextFieldFocusGained(FocusEvent evt) {
        this.ChineseTextField.getInputContext().selectInputMethod(Locale.CHINA);
        this.EnglishTranslations.removeAllItems();
        this.EnglishTranslations.setEnabled(false);
        this.AddNewWordButton.setEnabled(false);
        this.EditWordButton.setEnabled(false);
        this.DeleteWordButton.setEnabled(false);
        this.AddNewWordButton.setSelected(false);
        this.EditWordButton.setSelected(false);
        this.DeleteWordButton.setSelected(false);
    }

    public void edit_word(String to_edit) {
        this.ChineseTextField.setText(to_edit);
        this.Tabs.setSelectedIndex(0);
    }
}

