/*
 * Decompiled with CFR 0.152.
 */
package hanzitrainer;

public class Pinyin {
    private String radical = "";
    private int tone = 0;
    private String print = "";
    private String entry = "";
    private static final String[] allowed_pinyin = new String[]{"a", "ba", "pa", "ma", "fa", "da", "ta", "na", "la", "za", "ca", "sa", "zha", "cha", "sha", "ga", "ka", "ha", "o", "bo", "po", "mo", "fo", "me", "de", "te", "ne", "le", "ze", "ce", "se", "zhe", "che", "she", "re", "ge", "ke", "he", "zi", "ci", "si", "zhi", "chi", "shi", "ri", "er", "r", "ai", "bai", "pai", "mai", "dai", "tai", "nai", "lai", "zai", "cai", "sai", "zhai", "chai", "shai", "gai", "kai", "hai", "ei", "bei", "pei", "mei", "fei", "dei", "nei", "lei", "zei", "zhei", "shei", "gei", "kei", "hei", "ao", "bao", "pao", "mao", "dao", "tao", "nao", "lao", "zao", "cao", "sao", "zhao", "chao", "shao", "rao", "gao", "kao", "hao", "ou", "pou", "mou", "fou", "dou", "tou", "nou", "lou", "zou", "cou", "sou", "zhou", "chou", "shou", "rou", "gou", "kou", "hou", "an", "ban", "pan", "man", "fan", "dan", "tan", "nan", "lan", "zan", "can", "san", "zhan", "chan", "shan", "ran", "gan", "kan", "han", "en", "ben", "pen", "men", "fen", "den", "nen", "zen", "cen", "sen", "zhen", "chen", "shen", "ren", "gen", "ken", "hen", "ang", "bang", "pang", "mang", "fang", "dang", "tang", "nang", "lang", "zang", "cang", "sang", "zhang", "chang", "shang", "rang", "gang", "kang", "hang", "eng", "beng", "peng", "meng", "feng", "deng", "teng", "neng", "leng", "zeng", "ceng", "seng", "zheng", "cheng", "sheng", "reng", "geng", "keng", "heng", "dong", "tong", "nong", "long", "zong", "cong", "song", "zhong", "chong", "rong", "gong", "kong", "hong", "yi", "bi", "pi", "mi", "di", "ti", "ni", "li", "ji", "qi", "xi", "ya", "lia", "jia", "qia", "xia", "yao", "biao", "piao", "miao", "diao", "tiao", "niao", "liao", "jiao", "qiao", "xiao", "ye", "bie", "pie", "mie", "die", "tie", "nie", "lie", "jie", "qie", "xie", "you", "miu", "diu", "niu", "liu", "jiu", "qiu", "xiu", "yan", "bian", "pian", "mian", "dian", "tian", "nian", "lian", "jian", "qian", "xian", "yin", "bin", "pin", "min", "nin", "lin", "jin", "qin", "xin", "yang", "niang", "liang", "jiang", "qiang", "xiang", "ying", "bing", "ping", "ming", "ding", "ting", "ning", "ling", "jing", "qing", "xing", "yong", "jiong", "qiong", "xiong", "wu", "bu", "pu", "mu", "fu", "du", "tu", "nu", "lu", "zu", "cu", "su", "zhu", "chu", "shu", "ru", "gu", "ku", "hu", "wa", "zhua", "chua", "shua", "rua", "gua", "kua", "hua", "wo", "duo", "tuo", "nuo", "luo", "zuo", "cuo", "suo", "zhuo", "chuo", "shuo", "ruo", "guo", "kuo", "huo", "wai", "zhuai", "chuai", "shuai", "guai", "kuai", "huai", "wei", "dui", "tui", "zui", "cui", "sui", "zhui", "chui", "shui", "rui", "gui", "kui", "hui", "wan", "duan", "tuan", "nuan", "luan", "zuan", "cuan", "suan", "zhuan", "chuan", "shuan", "ruan", "guan", "kuan", "huan", "wen", "dun", "tun", "lun", "zun", "cun", "sun", "zhun", "chun", "shun", "run", "gun", "kun", "hun", "wang", "zhuang", "chuang", "shuang", "guang", "kuang", "huang", "weng", "yu", "nv", "lv", "ju", "qu", "xu", "yue", "nve", "lve", "jue", "que", "xue", "yuan", "juan", "quan", "xuan", "yun", "jun", "qun", "xun"};
    private static final String[] allowed_pinyin_tone1 = new String[]{"\u0101", "b\u0101", "p\u0101", "m\u0101", "f\u0101", "d\u0101", "t\u0101", "n\u0101", "l\u0101", "z\u0101", "c\u0101", "s\u0101", "zh\u0101", "ch\u0101", "sh\u0101", "g\u0101", "k\u0101", "h\u0101", "\u014d", "b\u014d", "p\u014d", "m\u014d", "f\u014d", "m\u0113", "d\u0113", "t\u0113", "n\u0113", "l\u0113", "z\u0113", "c\u0113", "s\u0113", "zh\u0113", "ch\u0113", "sh\u0113", "r\u0113", "g\u0113", "k\u0113", "h\u0113", "z\u012b", "c\u012b", "s\u012b", "zh\u012b", "ch\u012b", "sh\u012b", "r\u012b", "\u0113r", "r", "\u0101i", "b\u0101i", "p\u0101i", "m\u0101i", "d\u0101i", "t\u0101i", "n\u0101i", "l\u0101i", "z\u0101i", "c\u0101i", "s\u0101i", "zh\u0101i", "ch\u0101i", "sh\u0101i", "g\u0101i", "k\u0101i", "h\u0101i", "\u0113i", "b\u0113i", "p\u0113i", "m\u0113i", "f\u0113i", "d\u0113i", "n\u0113i", "l\u0113i", "z\u0113i", "zh\u0113i", "sh\u0113i", "g\u0113i", "k\u0113i", "h\u0113i", "\u0101o", "b\u0101o", "p\u0101o", "m\u0101o", "d\u0101o", "t\u0101o", "n\u0101o", "l\u0101o", "z\u0101o", "c\u0101o", "s\u0101o", "zh\u0101o", "ch\u0101o", "sh\u0101o", "r\u0101o", "g\u0101o", "k\u0101o", "h\u0101o", "\u014du", "p\u014du", "m\u014du", "f\u014du", "d\u014du", "t\u014du", "n\u014du", "l\u014du", "z\u014du", "c\u014du", "s\u014du", "zh\u014du", "ch\u014du", "sh\u014du", "r\u014du", "g\u014du", "k\u014du", "h\u014du", "\u0101n", "b\u0101n", "p\u0101n", "m\u0101n", "f\u0101n", "d\u0101n", "t\u0101n", "n\u0101n", "l\u0101n", "z\u0101n", "c\u0101n", "s\u0101n", "zh\u0101n", "ch\u0101n", "sh\u0101n", "r\u0101n", "g\u0101n", "k\u0101n", "h\u0101n", "\u0113n", "b\u0113n", "p\u0113n", "m\u0113n", "f\u0113n", "d\u0113n", "n\u0113n", "z\u0113n", "c\u0113n", "s\u0113n", "zh\u0113n", "ch\u0113n", "sh\u0113n", "r\u0113n", "g\u0113n", "k\u0113n", "h\u0113n", "\u0101ng", "b\u0101ng", "p\u0101ng", "m\u0101ng", "f\u0101ng", "d\u0101ng", "t\u0101ng", "n\u0101ng", "l\u0101ng", "z\u0101ng", "c\u0101ng", "s\u0101ng", "zh\u0101ng", "ch\u0101ng", "sh\u0101ng", "r\u0101ng", "g\u0101ng", "k\u0101ng", "h\u0101ng", "\u0113ng", "b\u0113ng", "p\u0113ng", "m\u0113ng", "f\u0113ng", "d\u0113ng", "t\u0113ng", "n\u0113ng", "l\u0113ng", "z\u0113ng", "c\u0113ng", "s\u0113ng", "zh\u0113ng", "ch\u0113ng", "sh\u0113ng", "r\u0113ng", "g\u0113ng", "k\u0113ng", "h\u0113ng", "d\u014dng", "t\u014dng", "n\u014dng", "l\u014dng", "z\u014dng", "c\u014dng", "s\u014dng", "zh\u014dng", "ch\u014dng", "r\u014dng", "g\u014dng", "k\u014dng", "h\u014dng", "y\u012b", "b\u012b", "p\u012b", "m\u012b", "d\u012b", "t\u012b", "n\u012b", "l\u012b", "j\u012b", "q\u012b", "x\u012b", "y\u0101", "li\u0101", "ji\u0101", "qi\u0101", "xi\u0101", "y\u0101o", "bi\u0101o", "pi\u0101o", "mi\u0101o", "di\u0101o", "ti\u0101o", "ni\u0101o", "li\u0101o", "ji\u0101o", "qi\u0101o", "xi\u0101o", "y\u0113", "bi\u0113", "pi\u0113", "mi\u0113", "di\u0113", "ti\u0113", "ni\u0113", "li\u0113", "ji\u0113", "qi\u0113", "xi\u0113", "y\u014du", "mi\u016b", "di\u016b", "ni\u016b", "li\u016b", "ji\u016b", "qi\u016b", "xi\u016b", "y\u0101n", "bi\u0101n", "pi\u0101n", "mi\u0101n", "di\u0101n", "ti\u0101n", "ni\u0101n", "li\u0101n", "ji\u0101n", "qi\u0101n", "xi\u0101n", "y\u012bn", "b\u012bn", "p\u012bn", "m\u012bn", "n\u012bn", "l\u012bn", "j\u012bn", "q\u012bn", "x\u012bn", "y\u0101ng", "ni\u0101ng", "li\u0101ng", "ji\u0101ng", "qi\u0101ng", "xi\u0101ng", "y\u012bng", "b\u012bng", "p\u012bng", "m\u012bng", "d\u012bng", "t\u012bng", "n\u012bng", "l\u012bng", "j\u012bng", "q\u012bng", "x\u012bng", "y\u014dng", "ji\u014dng", "qi\u014dng", "xi\u014dng", "w\u016b", "b\u016b", "p\u016b", "m\u016b", "f\u016b", "d\u016b", "t\u016b", "n\u016b", "l\u016b", "z\u016b", "c\u016b", "s\u016b", "zh\u016b", "ch\u016b", "sh\u016b", "r\u016b", "g\u016b", "k\u016b", "h\u016b", "w\u0101", "zhu\u0101", "chu\u0101", "shu\u0101", "ru\u0101", "gu\u0101", "ku\u0101", "hu\u0101", "w\u014d", "du\u014d", "tu\u014d", "nu\u014d", "lu\u014d", "zu\u014d", "cu\u014d", "su\u014d", "zhu\u014d", "chu\u014d", "shu\u014d", "ru\u014d", "gu\u014d", "ku\u014d", "hu\u014d", "w\u0101i", "zhu\u0101i", "chu\u0101i", "shu\u0101i", "gu\u0101i", "ku\u0101i", "hu\u0101i", "w\u0113i", "du\u012b", "tu\u012b", "zu\u012b", "cu\u012b", "su\u012b", "zhu\u012b", "chu\u012b", "shu\u012b", "ru\u012b", "gu\u012b", "ku\u012b", "hu\u012b", "w\u0101n", "du\u0101n", "tu\u0101n", "nu\u0101n", "lu\u0101n", "zu\u0101n", "cu\u0101n", "su\u0101n", "zhu\u0101n", "chu\u0101n", "shu\u0101n", "ru\u0101n", "gu\u0101n", "ku\u0101n", "hu\u0101n", "w\u0113n", "d\u016bn", "t\u016bn", "l\u016bn", "z\u016bn", "c\u016bn", "s\u016bn", "zh\u016bn", "ch\u016bn", "sh\u016bn", "r\u016bn", "g\u016bn", "k\u016bn", "h\u016bn", "w\u0101ng", "zhu\u0101ng", "chu\u0101ng", "shu\u0101ng", "gu\u0101ng", "ku\u0101ng", "hu\u0101ng", "w\u0113ng", "y\u016b", "n\u01d6", "l\u01d6", "j\u016b", "q\u016b", "x\u016b", "yu\u0113", "nv\u0113", "lv\u0113", "ju\u0113", "qu\u0113", "xu\u0113", "yu\u0101n", "ju\u0101n", "qu\u0101n", "xu\u0101n", "y\u016bn", "j\u016bn", "q\u016bn", "x\u016bn"};
    private static final String[] allowed_pinyin_tone2 = new String[]{"\u00e1", "b\u00e1", "p\u00e1", "m\u00e1", "f\u00e1", "d\u00e1", "t\u00e1", "n\u00e1", "l\u00e1", "z\u00e1", "c\u00e1", "s\u00e1", "zh\u00e1", "ch\u00e1", "sh\u00e1", "g\u00e1", "k\u00e1", "h\u00e1", "\u00f3", "b\u00f3", "p\u00f3", "m\u00f3", "f\u00f3", "m\u00e9", "d\u00e9", "t\u00e9", "n\u00e9", "l\u00e9", "z\u00e9", "c\u00e9", "s\u00e9", "zh\u00e9", "ch\u00e9", "sh\u00e9", "r\u00e9", "g\u00e9", "k\u00e9", "h\u00e9", "z\u00ed", "c\u00ed", "s\u00ed", "zh\u00ed", "ch\u00ed", "sh\u00ed", "r\u00ed", "\u00e9r", "r", "\u00e1i", "b\u00e1i", "p\u00e1i", "m\u00e1i", "d\u00e1i", "t\u00e1i", "n\u00e1i", "l\u00e1i", "z\u00e1i", "c\u00e1i", "s\u00e1i", "zh\u00e1i", "ch\u00e1i", "sh\u00e1i", "g\u00e1i", "k\u00e1i", "h\u00e1i", "\u00e9i", "b\u00e9i", "p\u00e9i", "m\u00e9i", "f\u00e9i", "d\u00e9i", "n\u00e9i", "l\u00e9i", "z\u00e9i", "zh\u00e9i", "sh\u00e9i", "g\u00e9i", "k\u00e9i", "h\u00e9i", "\u00e1o", "b\u00e1o", "p\u00e1o", "m\u00e1o", "d\u00e1o", "t\u00e1o", "n\u00e1o", "l\u00e1o", "z\u00e1o", "c\u00e1o", "s\u00e1o", "zh\u00e1o", "ch\u00e1o", "sh\u00e1o", "r\u00e1o", "g\u00e1o", "k\u00e1o", "h\u00e1o", "\u00f3u", "p\u00f3u", "m\u00f3u", "f\u00f3u", "d\u00f3u", "t\u00f3u", "n\u00f3u", "l\u00f3u", "z\u00f3u", "c\u00f3u", "s\u00f3u", "zh\u00f3u", "ch\u00f3u", "sh\u00f3u", "r\u00f3u", "g\u00f3u", "k\u00f3u", "h\u00f3u", "\u00e1n", "b\u00e1n", "p\u00e1n", "m\u00e1n", "f\u00e1n", "d\u00e1n", "t\u00e1n", "n\u00e1n", "l\u00e1n", "z\u00e1n", "c\u00e1n", "s\u00e1n", "zh\u00e1n", "ch\u00e1n", "sh\u00e1n", "r\u00e1n", "g\u00e1n", "k\u00e1n", "h\u00e1n", "\u00e9n", "b\u00e9n", "p\u00e9n", "m\u00e9n", "f\u00e9n", "d\u00e9n", "n\u00e9n", "z\u00e9n", "c\u00e9n", "s\u00e9n", "zh\u00e9n", "ch\u00e9n", "sh\u00e9n", "r\u00e9n", "g\u00e9n", "k\u00e9n", "h\u00e9n", "\u00e1ng", "b\u00e1ng", "p\u00e1ng", "m\u00e1ng", "f\u00e1ng", "d\u00e1ng", "t\u00e1ng", "n\u00e1ng", "l\u00e1ng", "z\u00e1ng", "c\u00e1ng", "s\u00e1ng", "zh\u00e1ng", "ch\u00e1ng", "sh\u00e1ng", "r\u00e1ng", "g\u00e1ng", "k\u00e1ng", "h\u00e1ng", "\u00e9ng", "b\u00e9ng", "p\u00e9ng", "m\u00e9ng", "f\u00e9ng", "d\u00e9ng", "t\u00e9ng", "n\u00e9ng", "l\u00e9ng", "z\u00e9ng", "c\u00e9ng", "s\u00e9ng", "zh\u00e9ng", "ch\u00e9ng", "sh\u00e9ng", "r\u00e9ng", "g\u00e9ng", "k\u00e9ng", "h\u00e9ng", "d\u00f3ng", "t\u00f3ng", "n\u00f3ng", "l\u00f3ng", "z\u00f3ng", "c\u00f3ng", "s\u00f3ng", "zh\u00f3ng", "ch\u00f3ng", "r\u00f3ng", "g\u00f3ng", "k\u00f3ng", "h\u00f3ng", "y\u00ed", "b\u00ed", "p\u00ed", "m\u00ed", "d\u00ed", "t\u00ed", "n\u00ed", "l\u00ed", "j\u00ed", "q\u00ed", "x\u00ed", "y\u00e1", "li\u00e1", "ji\u00e1", "qi\u00e1", "xi\u00e1", "y\u00e1o", "bi\u00e1o", "pi\u00e1o", "mi\u00e1o", "di\u00e1o", "ti\u00e1o", "ni\u00e1o", "li\u00e1o", "ji\u00e1o", "qi\u00e1o", "xi\u00e1o", "y\u00e9", "bi\u00e9", "pi\u00e9", "mi\u00e9", "di\u00e9", "ti\u00e9", "ni\u00e9", "li\u00e9", "ji\u00e9", "qi\u00e9", "xi\u00e9", "y\u00f3u", "mi\u00fa", "di\u00fa", "ni\u00fa", "li\u00fa", "ji\u00fa", "qi\u00fa", "xi\u00fa", "y\u00e1n", "bi\u00e1n", "pi\u00e1n", "mi\u00e1n", "di\u00e1n", "ti\u00e1n", "ni\u00e1n", "li\u00e1n", "ji\u00e1n", "qi\u00e1n", "xi\u00e1n", "y\u00edn", "b\u00edn", "p\u00edn", "m\u00edn", "n\u00edn", "l\u00edn", "j\u00edn", "q\u00edn", "x\u00edn", "y\u00e1ng", "ni\u00e1ng", "li\u00e1ng", "ji\u00e1ng", "qi\u00e1ng", "xi\u00e1ng", "y\u00edng", "b\u00edng", "p\u00edng", "m\u00edng", "d\u00edng", "t\u00edng", "n\u00edng", "l\u00edng", "j\u00edng", "q\u00edng", "x\u00edng", "y\u00f3ng", "ji\u00f3ng", "qi\u00f3ng", "xi\u00f3ng", "w\u00fa", "b\u00fa", "p\u00fa", "m\u00fa", "f\u00fa", "d\u00fa", "t\u00fa", "n\u00fa", "l\u00fa", "z\u00fa", "c\u00fa", "s\u00fa", "zh\u00fa", "ch\u00fa", "sh\u00fa", "r\u00fa", "g\u00fa", "k\u00fa", "h\u00fa", "w\u00e1", "zhu\u00e1", "chu\u00e1", "shu\u00e1", "ru\u00e1", "gu\u00e1", "ku\u00e1", "hu\u00e1", "w\u00f3", "du\u00f3", "tu\u00f3", "nu\u00f3", "lu\u00f3", "zu\u00f3", "cu\u00f3", "su\u00f3", "zhu\u00f3", "chu\u00f3", "shu\u00f3", "ru\u00f3", "gu\u00f3", "ku\u00f3", "hu\u00f3", "w\u00e1i", "zhu\u00e1i", "chu\u00e1i", "shu\u00e1i", "gu\u00e1i", "ku\u00e1i", "hu\u00e1i", "w\u00e9i", "du\u00ed", "tu\u00ed", "zu\u00ed", "cu\u00ed", "su\u00ed", "zhu\u00ed", "chu\u00ed", "shu\u00ed", "ru\u00ed", "gu\u00ed", "ku\u00ed", "hu\u00ed", "w\u00e1n", "du\u00e1n", "tu\u00e1n", "nu\u00e1n", "lu\u00e1n", "zu\u00e1n", "cu\u00e1n", "su\u00e1n", "zhu\u00e1n", "chu\u00e1n", "shu\u00e1n", "ru\u00e1n", "gu\u00e1n", "ku\u00e1n", "hu\u00e1n", "w\u00e9n", "d\u00fan", "t\u00fan", "l\u00fan", "z\u00fan", "c\u00fan", "s\u00fan", "zh\u00fan", "ch\u00fan", "sh\u00fan", "r\u00fan", "g\u00fan", "k\u00fan", "h\u00fan", "w\u00e1ng", "zhu\u00e1ng", "chu\u00e1ng", "shu\u00e1ng", "gu\u00e1ng", "ku\u00e1ng", "hu\u00e1ng", "w\u00e9ng", "y\u00fa", "n\u01d8", "l\u01d8", "j\u00fa", "q\u00fa", "x\u00fa", "yu\u00e9", "n\u00fc\u00e9", "l\u00fc\u00e9", "ju\u00e9", "qu\u00e9", "xu\u00e9", "yu\u00e1n", "ju\u00e1n", "qu\u00e1n", "xu\u00e1n", "y\u00fan", "j\u00fan", "q\u00fan", "x\u00fan"};
    private static final String[] allowed_pinyin_tone3 = new String[]{"\u01ce", "b\u01ce", "p\u01ce", "m\u01ce", "f\u01ce", "d\u01ce", "t\u01ce", "n\u01ce", "l\u01ce", "z\u01ce", "c\u01ce", "s\u01ce", "zh\u01ce", "ch\u01ce", "sh\u01ce", "g\u01ce", "k\u01ce", "h\u01ce", "\u01d2", "b\u01d2", "p\u01d2", "m\u01d2", "f\u01d2", "m\u011b", "d\u011b", "t\u011b", "n\u011b", "l\u011b", "z\u011b", "c\u011b", "s\u011b", "zh\u011b", "ch\u011b", "sh\u011b", "r\u011b", "g\u011b", "k\u011b", "h\u011b", "z\u01d0", "c\u01d0", "s\u01d0", "zh\u01d0", "ch\u01d0", "sh\u01d0", "r\u01d0", "\u011br", "r", "\u01cei", "b\u01cei", "p\u01cei", "m\u01cei", "d\u01cei", "t\u01cei", "n\u01cei", "l\u01cei", "z\u01cei", "c\u01cei", "s\u01cei", "zh\u01cei", "ch\u01cei", "sh\u01cei", "g\u01cei", "k\u01cei", "h\u01cei", "\u011bi", "b\u011bi", "p\u011bi", "m\u011bi", "f\u011bi", "d\u011bi", "n\u011bi", "l\u011bi", "z\u011bi", "zh\u011bi", "sh\u011bi", "g\u011bi", "k\u011bi", "h\u011bi", "\u01ceo", "b\u01ceo", "p\u01ceo", "m\u01ceo", "d\u01ceo", "t\u01ceo", "n\u01ceo", "l\u01ceo", "z\u01ceo", "c\u01ceo", "s\u01ceo", "zh\u01ceo", "ch\u01ceo", "sh\u01ceo", "r\u01ceo", "g\u01ceo", "k\u01ceo", "h\u01ceo", "\u01d2u", "p\u01d2u", "m\u01d2u", "f\u01d2u", "d\u01d2u", "t\u01d2u", "n\u01d2u", "l\u01d2u", "z\u01d2u", "c\u01d2u", "s\u01d2u", "zh\u01d2u", "ch\u01d2u", "sh\u01d2u", "r\u01d2u", "g\u01d2u", "k\u01d2u", "h\u01d2u", "\u01cen", "b\u01cen", "p\u01cen", "m\u01cen", "f\u01cen", "d\u01cen", "t\u01cen", "n\u01cen", "l\u01cen", "z\u01cen", "c\u01cen", "s\u01cen", "zh\u01cen", "ch\u01cen", "sh\u01cen", "r\u01cen", "g\u01cen", "k\u01cen", "h\u01cen", "\u011bn", "b\u011bn", "p\u011bn", "m\u011bn", "f\u011bn", "d\u011bn", "n\u011bn", "z\u011bn", "c\u011bn", "s\u011bn", "zh\u011bn", "ch\u011bn", "sh\u011bn", "r\u011bn", "g\u011bn", "k\u011bn", "h\u011bn", "\u01ceng", "b\u01ceng", "p\u01ceng", "m\u01ceng", "f\u01ceng", "d\u01ceng", "t\u01ceng", "n\u01ceng", "l\u01ceng", "z\u01ceng", "c\u01ceng", "s\u01ceng", "zh\u01ceng", "ch\u01ceng", "sh\u01ceng", "r\u01ceng", "g\u01ceng", "k\u01ceng", "h\u01ceng", "\u011bng", "b\u011bng", "p\u011bng", "m\u011bng", "f\u011bng", "d\u011bng", "t\u011bng", "n\u011bng", "l\u011bng", "z\u011bng", "c\u011bng", "s\u011bng", "zh\u011bng", "ch\u011bng", "sh\u011bng", "r\u011bng", "g\u011bng", "k\u011bng", "h\u011bng", "d\u01d2ng", "t\u01d2ng", "n\u01d2ng", "l\u01d2ng", "z\u01d2ng", "c\u01d2ng", "s\u01d2ng", "zh\u01d2ng", "ch\u01d2ng", "r\u01d2ng", "g\u01d2ng", "k\u01d2ng", "h\u01d2ng", "y\u01d0", "b\u01d0", "p\u01d0", "m\u01d0", "d\u01d0", "t\u01d0", "n\u01d0", "l\u01d0", "j\u01d0", "q\u01d0", "x\u01d0", "y\u01ce", "li\u01ce", "ji\u01ce", "qi\u01ce", "xi\u01ce", "y\u01ceo", "bi\u01ceo", "pi\u01ceo", "mi\u01ceo", "di\u01ceo", "ti\u01ceo", "ni\u01ceo", "li\u01ceo", "ji\u01ceo", "qi\u01ceo", "xi\u01ceo", "y\u011b", "bi\u011b", "pi\u011b", "mi\u011b", "di\u011b", "ti\u011b", "ni\u011b", "li\u011b", "ji\u011b", "qi\u011b", "xi\u011b", "y\u01d2u", "mi\u01d4", "di\u01d4", "ni\u01d4", "li\u01d4", "ji\u01d4", "qi\u01d4", "xi\u01d4", "y\u01cen", "bi\u01cen", "pi\u01cen", "mi\u01cen", "di\u01cen", "ti\u01cen", "ni\u01cen", "li\u01cen", "ji\u01cen", "qi\u01cen", "xi\u01cen", "y\u01d0n", "b\u01d0n", "p\u01d0n", "m\u01d0n", "n\u01d0n", "l\u01d0n", "j\u01d0n", "q\u01d0n", "x\u01d0n", "y\u01ceng", "ni\u01ceng", "li\u01ceng", "ji\u01ceng", "qi\u01ceng", "xi\u01ceng", "y\u01d0ng", "b\u01d0ng", "p\u01d0ng", "m\u01d0ng", "d\u01d0ng", "t\u01d0ng", "n\u01d0ng", "l\u01d0ng", "j\u01d0ng", "q\u01d0ng", "x\u01d0ng", "y\u01d2ng", "ji\u01d2ng", "qi\u01d2ng", "xi\u01d2ng", "w\u01d4", "b\u01d4", "p\u01d4", "m\u01d4", "f\u01d4", "d\u01d4", "t\u01d4", "n\u01d4", "l\u01d4", "z\u01d4", "c\u01d4", "s\u01d4", "zh\u01d4", "ch\u01d4", "sh\u01d4", "r\u01d4", "g\u01d4", "k\u01d4", "h\u01d4", "w\u01ce", "zhu\u01ce", "chu\u01ce", "shu\u01ce", "ru\u01ce", "gu\u01ce", "ku\u01ce", "hu\u01ce", "w\u01d2", "du\u01d2", "tu\u01d2", "nu\u01d2", "lu\u01d2", "zu\u01d2", "cu\u01d2", "su\u01d2", "zhu\u01d2", "chu\u01d2", "shu\u01d2", "ru\u01d2", "gu\u01d2", "ku\u01d2", "hu\u01d2", "w\u01cei", "zhu\u01cei", "chu\u01cei", "shu\u01cei", "gu\u01cei", "ku\u01cei", "hu\u01cei", "w\u011bi", "du\u01d0", "tu\u01d0", "zu\u01d0", "cu\u01d0", "su\u01d0", "zhu\u01d0", "chu\u01d0", "shu\u01d0", "ru\u01d0", "gu\u01d0", "ku\u01d0", "hu\u01d0", "w\u01cen", "du\u01cen", "tu\u01cen", "nu\u01cen", "lu\u01cen", "zu\u01cen", "cu\u01cen", "su\u01cen", "zhu\u01cen", "chu\u01cen", "shu\u01cen", "ru\u01cen", "gu\u01cen", "ku\u01cen", "hu\u01cen", "w\u011bn", "d\u01d4n", "t\u01d4n", "l\u01d4n", "z\u01d4n", "c\u01d4n", "s\u01d4n", "zh\u01d4n", "ch\u01d4n", "sh\u01d4n", "r\u01d4n", "g\u01d4n", "k\u01d4n", "h\u01d4n", "w\u01ceng", "zhu\u01ceng", "chu\u01ceng", "shu\u01ceng", "gu\u01ceng", "ku\u01ceng", "hu\u01ceng", "w\u011bng", "y\u01d4", "n\u01da", "l\u01da", "j\u01d4", "q\u01d4", "x\u01d4", "yu\u011b", "n\u00fc\u011b", "l\u00fc\u011b", "ju\u011b", "qu\u011b", "xu\u011b", "yu\u01cen", "ju\u01cen", "qu\u01cen", "xu\u01cen", "y\u01d4n", "j\u01d4n", "q\u01d4n", "x\u01d4n"};
    private static final String[] allowed_pinyin_tone4 = new String[]{"\u00e0", "b\u00e0", "p\u00e0", "m\u00e0", "f\u00e0", "d\u00e0", "t\u00e0", "n\u00e0", "l\u00e0", "z\u00e0", "c\u00e0", "s\u00e0", "zh\u00e0", "ch\u00e0", "sh\u00e0", "g\u00e0", "k\u00e0", "h\u00e0", "\u00f2", "b\u00f2", "p\u00f2", "m\u00f2", "f\u00f2", "m\u00e8", "d\u00e8", "t\u00e8", "n\u00e8", "l\u00e8", "z\u00e8", "c\u00e8", "s\u00e8", "zh\u00e8", "ch\u00e8", "sh\u00e8", "r\u00e8", "g\u00e8", "k\u00e8", "h\u00e8", "z\u00ec", "c\u00ec", "s\u00ec", "zh\u00ec", "ch\u00ec", "sh\u00ec", "r\u00ec", "\u00e8r", "r", "\u00e0i", "b\u00e0i", "p\u00e0i", "m\u00e0i", "d\u00e0i", "t\u00e0i", "n\u00e0i", "l\u00e0i", "z\u00e0i", "c\u00e0i", "s\u00e0i", "zh\u00e0i", "ch\u00e0i", "sh\u00e0i", "g\u00e0i", "k\u00e0i", "h\u00e0i", "\u00e8i", "b\u00e8i", "p\u00e8i", "m\u00e8i", "f\u00e8i", "d\u00e8i", "n\u00e8i", "l\u00e8i", "z\u00e8i", "zh\u00e8i", "sh\u00e8i", "g\u00e8i", "k\u00e8i", "h\u00e8i", "\u00e0o", "b\u00e0o", "p\u00e0o", "m\u00e0o", "d\u00e0o", "t\u00e0o", "n\u00e0o", "l\u00e0o", "z\u00e0o", "c\u00e0o", "s\u00e0o", "zh\u00e0o", "ch\u00e0o", "sh\u00e0o", "r\u00e0o", "g\u00e0o", "k\u00e0o", "h\u00e0o", "\u00f2u", "p\u00f2u", "m\u00f2u", "f\u00f2u", "d\u00f2u", "t\u00f2u", "n\u00f2u", "l\u00f2u", "z\u00f2u", "c\u00f2u", "s\u00f2u", "zh\u00f2u", "ch\u00f2u", "sh\u00f2u", "r\u00f2u", "g\u00f2u", "k\u00f2u", "h\u00f2u", "\u00e0n", "b\u00e0n", "p\u00e0n", "m\u00e0n", "f\u00e0n", "d\u00e0n", "t\u00e0n", "n\u00e0n", "l\u00e0n", "z\u00e0n", "c\u00e0n", "s\u00e0n", "zh\u00e0n", "ch\u00e0n", "sh\u00e0n", "r\u00e0n", "g\u00e0n", "k\u00e0n", "h\u00e0n", "\u00e8n", "b\u00e8n", "p\u00e8n", "m\u00e8n", "f\u00e8n", "d\u00e8n", "n\u00e8n", "z\u00e8n", "c\u00e8n", "s\u00e8n", "zh\u00e8n", "ch\u00e8n", "sh\u00e8n", "r\u00e8n", "g\u00e8n", "k\u00e8n", "h\u00e8n", "\u00e0ng", "b\u00e0ng", "p\u00e0ng", "m\u00e0ng", "f\u00e0ng", "d\u00e0ng", "t\u00e0ng", "n\u00e0ng", "l\u00e0ng", "z\u00e0ng", "c\u00e0ng", "s\u00e0ng", "zh\u00e0ng", "ch\u00e0ng", "sh\u00e0ng", "r\u00e0ng", "g\u00e0ng", "k\u00e0ng", "h\u00e0ng", "\u00e8ng", "b\u00e8ng", "p\u00e8ng", "m\u00e8ng", "f\u00e8ng", "d\u00e8ng", "t\u00e8ng", "n\u00e8ng", "l\u00e8ng", "z\u00e8ng", "c\u00e8ng", "s\u00e8ng", "zh\u00e8ng", "ch\u00e8ng", "sh\u00e8ng", "r\u00e8ng", "g\u00e8ng", "k\u00e8ng", "h\u00e8ng", "d\u00f2ng", "t\u00f2ng", "n\u00f2ng", "l\u00f2ng", "z\u00f2ng", "c\u00f2ng", "s\u00f2ng", "zh\u00f2ng", "ch\u00f2ng", "r\u00f2ng", "g\u00f2ng", "k\u00f2ng", "h\u00f2ng", "y\u00ec", "b\u00ec", "p\u00ec", "m\u00ec", "d\u00ec", "t\u00ec", "n\u00ec", "l\u00ec", "j\u00ec", "q\u00ec", "x\u00ec", "y\u00e0", "li\u00e0", "ji\u00e0", "qi\u00e0", "xi\u00e0", "y\u00e0o", "bi\u00e0o", "pi\u00e0o", "mi\u00e0o", "di\u00e0o", "ti\u00e0o", "ni\u00e0o", "li\u00e0o", "ji\u00e0o", "qi\u00e0o", "xi\u00e0o", "y\u00e8", "bi\u00e8", "pi\u00e8", "mi\u00e8", "di\u00e8", "ti\u00e8", "ni\u00e8", "li\u00e8", "ji\u00e8", "qi\u00e8", "xi\u00e8", "y\u00f2u", "mi\u00f9", "di\u00f9", "ni\u00f9", "li\u00f9", "ji\u00f9", "qi\u00f9", "xi\u00f9", "y\u00e0n", "bi\u00e0n", "pi\u00e0n", "mi\u00e0n", "di\u00e0n", "ti\u00e0n", "ni\u00e0n", "li\u00e0n", "ji\u00e0n", "qi\u00e0n", "xi\u00e0n", "y\u00ecn", "b\u00ecn", "p\u00ecn", "m\u00ecn", "n\u00ecn", "l\u00ecn", "j\u00ecn", "q\u00ecn", "x\u00ecn", "y\u00e0ng", "ni\u00e0ng", "li\u00e0ng", "ji\u00e0ng", "qi\u00e0ng", "xi\u00e0ng", "y\u00ecng", "b\u00ecng", "p\u00ecng", "m\u00ecng", "d\u00ecng", "t\u00ecng", "n\u00ecng", "l\u00ecng", "j\u00ecng", "q\u00ecng", "x\u00ecng", "y\u00f2ng", "ji\u00f2ng", "qi\u00f2ng", "xi\u00f2ng", "w\u00f9", "b\u00f9", "p\u00f9", "m\u00f9", "f\u00f9", "d\u00f9", "t\u00f9", "n\u00f9", "l\u00f9", "z\u00f9", "c\u00f9", "s\u00f9", "zh\u00f9", "ch\u00f9", "sh\u00f9", "r\u00f9", "g\u00f9", "k\u00f9", "h\u00f9", "w\u00e0", "zhu\u00e0", "chu\u00e0", "shu\u00e0", "ru\u00e0", "gu\u00e0", "ku\u00e0", "hu\u00e0", "w\u00f2", "du\u00f2", "tu\u00f2", "nu\u00f2", "lu\u00f2", "zu\u00f2", "cu\u00f2", "su\u00f2", "zhu\u00f2", "chu\u00f2", "shu\u00f2", "ru\u00f2", "gu\u00f2", "ku\u00f2", "hu\u00f2", "w\u00e0i", "zhu\u00e0i", "chu\u00e0i", "shu\u00e0i", "gu\u00e0i", "ku\u00e0i", "hu\u00e0i", "w\u00e8i", "du\u00ec", "tu\u00ec", "zu\u00ec", "cu\u00ec", "su\u00ec", "zhu\u00ec", "chu\u00ec", "shu\u00ec", "ru\u00ec", "gu\u00ec", "ku\u00ec", "hu\u00ec", "w\u00e0n", "du\u00e0n", "tu\u00e0n", "nu\u00e0n", "lu\u00e0n", "zu\u00e0n", "cu\u00e0n", "su\u00e0n", "zhu\u00e0n", "chu\u00e0n", "shu\u00e0n", "ru\u00e0n", "gu\u00e0n", "ku\u00e0n", "hu\u00e0n", "w\u00e8n", "d\u00f9n", "t\u00f9n", "l\u00f9n", "z\u00f9n", "c\u00f9n", "s\u00f9n", "zh\u00f9n", "ch\u00f9n", "sh\u00f9n", "r\u00f9n", "g\u00f9n", "k\u00f9n", "h\u00f9n", "w\u00e0ng", "zhu\u00e0ng", "chu\u00e0ng", "shu\u00e0ng", "gu\u00e0ng", "ku\u00e0ng", "hu\u00e0ng", "w\u00e8ng", "y\u01dc", "n\u01dc", "l\u01dc", "j\u01dc", "q\u00f9", "x\u00f9", "yu\u00e8", "n\u00fc\u00e8", "l\u00fc\u00e8", "ju\u00e8", "qu\u00e8", "xu\u00e8", "yu\u00e0n", "ju\u00e0n", "qu\u00e0n", "xu\u00e0n", "y\u01dcn", "j\u01dcn", "q\u01dcn", "x\u01dcn"};

    public Pinyin() {
    }

    public Pinyin(String pinyin_string) {
        if (!Pinyin.verify_pinyin(pinyin_string)) {
            return;
        }
        this.entry = pinyin_string;
        if (this.entry.codePointAt(this.entry.length() - 1) > 48 && this.entry.codePointAt(this.entry.length() - 1) < 53) {
            this.tone = this.entry.codePointAt(this.entry.length() - 1) - 48;
            this.radical = this.entry.substring(0, this.entry.length() - 1);
        } else {
            this.radical = this.entry;
            this.tone = 0;
            this.print = this.entry;
        }
        if (this.tone != 0) {
            int i;
            for (i = 0; i < allowed_pinyin.length && !this.radical.equals(allowed_pinyin[i]); ++i) {
            }
            switch (this.tone) {
                case 1: {
                    this.print = allowed_pinyin_tone1[i];
                    break;
                }
                case 2: {
                    this.print = allowed_pinyin_tone2[i];
                    break;
                }
                case 3: {
                    this.print = allowed_pinyin_tone3[i];
                    break;
                }
                case 4: {
                    this.print = allowed_pinyin_tone4[i];
                    break;
                }
                default: {
                    this.print = "error in tone !";
                }
            }
        }
    }

    public String get_print_version() {
        return this.print;
    }

    public static boolean verify_pinyin(String entry) {
        for (String try_pinyin : allowed_pinyin) {
            if (entry.equals(try_pinyin)) {
                return true;
            }
            for (int i = 1; i < 5; ++i) {
                String temp = try_pinyin + i;
                if (!entry.equals(temp)) continue;
                return true;
            }
        }
        return false;
    }

    public static int pinyin_tone(String entry) {
        for (String try_pinyin : allowed_pinyin) {
            if (entry.equals(try_pinyin)) {
                return 0;
            }
            for (int i = 1; i < 5; ++i) {
                String temp = try_pinyin + i;
                if (!entry.equals(temp)) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean pinyins_are_same_radical(String entry1, String entry2) {
        String try_pinyin1 = "";
        String try_pinyin2 = "";
        for (String try_pinyin : allowed_pinyin) {
            if (entry1.equals(try_pinyin)) {
                try_pinyin1 = try_pinyin;
            }
            if (entry2.equals(try_pinyin)) {
                try_pinyin2 = try_pinyin;
            }
            for (int i = 1; i < 5; ++i) {
                String temp = try_pinyin + i;
                if (entry1.equals(temp)) {
                    try_pinyin1 = try_pinyin;
                }
                if (!entry2.equals(temp)) continue;
                try_pinyin2 = try_pinyin;
            }
        }
        return try_pinyin1.equals(try_pinyin2);
    }
}

