

#include <gtk/gtkgl.h>
#include <GL/gl.h>
#include <GL/glut.h>

GdkGLConfig *configure_gl(void)
{
	GdkGLConfig *glconfig;
 
	/* Try double-buffered visual */
	glconfig = gdk_gl_config_new_by_mode (GDK_GL_MODE_RGB    |
					      GDK_GL_MODE_DEPTH  |
					      GDK_GL_MODE_DOUBLE);
	if (glconfig == NULL)
	{
		g_print("\n*** Cannot find the double-buffered visual.\n");
		g_print("\n*** Trying single-buffered visual.\n");
 
		/* Try single-buffered visual */
		glconfig = gdk_gl_config_new_by_mode (GDK_GL_MODE_RGB   |
						      GDK_GL_MODE_DEPTH);
		if (glconfig == NULL)
		{
			g_print("*** No appropriate OpenGL-capable visual found.\n");
			exit (1);
		}
	}
	return glconfig;
}


void draw(void)

{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	glColor3f(0.2, 0.1, 0.5);
	glEnable(GL_POLYGON_OFFSET_FILL);
	glPolygonOffset(1.0, 1.0);
	_draw();

	glDisable(GL_POLYGON_OFFSET_FILL);
	glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
	glColor3f(1.0, 1.0, 1.0);
	_draw();

	glPolygonMode(GL_FRONT_AND_BACK, GL_POINT);
	_draw();
}



void _draw(void)
{
	glLoadIdentity();

	glTranslatef(-2.5, 0.0, 0.0);
	glRotatef(-30, 1.0, 0.0, 0.0);
	glRotatef( 30, 0.0, 1.0, 0.0);
	glRotatef( 30, 0.0, 0.0, 1.0);


	glBegin(GL_TRIANGLE_FAN);
	glVertex3d(0, 4, 0);
	glVertex3d(0, -4, -4);
	glVertex3d(-4, -4, 4);
	glVertex3d(4, -4, 4);
	glVertex3d(0, -4, -4);
	glEnd();

	glBegin(GL_TRIANGLES);
	glVertex3d(0, -4, -4);
	glVertex3d(-4, -4, 4);
	glVertex3d(4, -4, 4);
	glEnd();


	glLoadIdentity();
	glTranslatef(2.5, 0.0, 0.0);
	glRotatef(45, 1.0, 0.0, 0.0);
	glRotatef(45, 0.0, 1.0, 0.0);
	glRotatef(45, 0.0, 0.0, 1.0);

	glBegin(GL_QUAD_STRIP);
	glVertex3d(3, 3, -3);
	glVertex3d(3, -3, -3);
	glVertex3d(-3, 3, -3);
	glVertex3d(-3, -3, -3);
	glVertex3d(-3, 3, 3);
	glVertex3d(-3, -3, 3);
	glVertex3d(3, 3, 3);
	glVertex3d(3, -3, 3);
	glVertex3d(3, 3, -3);
	glVertex3d(3, -3, -3);
	glEnd();

	glBegin(GL_QUADS);
	glVertex3d(-3, -3, -3);
	glVertex3d(3, -3, -3);
	glVertex3d(3, -3, 3);
	glVertex3d(-3, -3, 3);

	glVertex3d(-3, 3, -3);
	glVertex3d(3, 3, -3);
	glVertex3d(3, 3, 3);
	glVertex3d(-3, 3, 3);
	glEnd();

	return;
}
