/*
 * $Id: builtin.h,v 1.10 2003/12/01 09:50:14 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */

#ifndef __HAPLO_HAPLO_BUILTIN_H__
#define __HAPLO_HAPLO_BUILTIN_H__

#include <haplo/defs.h>
#include <haplo/object.h>

__HAPLO_BEGIN_DECLS


/*-----------------------------------------------------------------------------
                           H A P L O _ L I S T _ T 
-----------------------------------------------------------------------------*/

typedef void haplo_list_t;


/*-----------------------------------------------------------------------------
                             P R O T O T Y P E S 
-----------------------------------------------------------------------------*/

extern double *haplo_float(double value);
extern haplo_list_t * haplo_list_new(void *data, haplo_type_t type);
extern int haplo_list_grow(haplo_list_t *list, void *data, haplo_type_t type);
extern unsigned long  haplo_list_size(const haplo_list_t *list);
extern void haplo_list_start(haplo_list_t *list);
extern haplo_type_t haplo_list_type(const haplo_list_t *list);
extern haplo_type_t haplo_list_type_homogeneous(const haplo_list_t *list);
extern void *haplo_list_arg(haplo_list_t *list);
extern void *haplo_list_arg_type(haplo_list_t *list, const haplo_type_t type);

__HAPLO_END_DECLS

#endif /* __HAPLO_HAPLO_BUILTIN_H__ */
