/*
 * $Id: help.c,v 1.5 2003/12/01 09:50:15 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */

#include "extensions.h"
#ifdef HAVE_CONFIG_H
#	include "config.h"
#endif
#include "version.h"

#include <errno.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "func.h"
#include "help.h"
#include "utils.h"


/*-----------------------------------------------------------------------------
                             P R O T O T Y P E S 
-----------------------------------------------------------------------------*/



/*-----------------------------------------------------------------------------
                         I M P L E M E N T A T I O N 
-----------------------------------------------------------------------------*/


static const char header[]=""
"<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n"
"<html>\n"
"  <head>\n"
"    <meta http-equiv=\"content-type\" content=\"text/html; charset=ISO-8859-1\">\n"
"    <meta name=\"Keywords\" content=\"finite element, fem, element finis, code, calcul, mecanique, logiciel, haplo, GPL, free software\">\n"
"    <meta name=\"Classification\" content=\"scientific software, logiciel scientifique, free software, logiciel libre\">\n"
"    <title>Haplo</title>\n"
"    <meta name=\"author\" content=\"Nicolas LAURENT\">\n"
"    <link rel=\"stylesheet\" type=\"text/css\" href=\"../style.css\" title=\"Haplo style sheet\">\n"
"    <link rel=\"icon\" href=\"../images/haplo.ico\" type=\"image/x-icon\">\n"
"    <link rel=\"shortcut icon\" href=\"../images/haplo.ico\" type=\"image/x-icon\">\n"
"  </head>\n"
"  <body>\n"
"    <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" class=\"menu\">\n"
"        <tr>\n"
"          <td align=\"left\" valign=\"top\">\n"
"            <img src=\"../images/tl.png\" height=20 width=20>\n"
"          </td>\n"
"          <td align=\"center\">\n"
"            <a href=\"../index.html\" class=\"menu\">Accueil</a>\n"
"          </td>\n"
"          <td align=\"center\">\n"
"            <a href=\"../devel/index.html\" class=\"menu\">Dveloppement</a>\n"
"          </td>\n"
"          <td align=\"center\">\n"
"            <a href=\"../resources/index.html\" class=\"menu\">Ressources</a>\n"
"          </td>\n"
"          <td align=\"center\">\n"
"            <a href=\"../download/index.html\" class=\"menu\">Tlchargement</a>\n"
"          </td>\n"
"          <td align=\"center\">\n"
"            <a href=\"index.html\" class=\"menu\">Support</a>\n"
"          </td>\n"
"\n"
"          <td align=\"right\" valign=\"top\">\n"
"            <img src=\"../images/tr.png\" height=20 width=20>\n"
"          </td>\n"
"        </tr>\n"
"    </table>\n"
"    <h1>\n";



static const char footer[]=""
"        <table class=\"modified\">\n"
"          <tr>\n"
"            <td style=\"text-align:left\">\n"
"              Dernire modification: $Date$<br>\n"
"              Page cre par haplo-0.7.1\n"
"            </td>\n"
"            <td style=\"text-align:right\">\n"
"              <a href=\"http://www.xiti.com/xiti.asp?s=134991\" TARGET=\"_top\">\n"
"                <script language=\"JavaScript1.1\">\n"
"                  <!--\n"
"                  hsh = new Date();\n"
"                  hsd = document;\n"
"                  hsr = hsd.referrer.replace(/[<>]/g, '');\n"
"                  hsi = '<img width=\"39\" height=\"25\" border=0 ';\n"
"                  hsi += 'src=\"http://logv24.xiti.com/hit.xiti?s=134991';\n"
"                  hsi += '&p=';\n"
"                  hsi += '&hl=' + hsh.getHours() + 'x' + hsh.getMinutes() + 'x' + hsh.getSeconds();\n"
"                  if(parseFloat(navigator.appVersion)>=4)\n"
"                  {Xiti_s=screen;hsi += '&r=' + Xiti_s.width + 'x' + Xiti_s.height + 'x' + Xiti_s.pixelDepth + 'x' + Xiti_s.colorDepth;}\n"
"                  hsd.writeln(hsi + '&ref=' + hsr.replace(/&/g, '$') + '\" title=\"Mesurez votre audience\"><\\!--');\n"
"                  //-->\n"
"                </script>\n"
"              <noscript>\n"
"                <img width=\"39\" height=\"25\" border=0 src=\"http://logv24.xiti.com/hit.xiti?s=134991&p=&\" title=\"Mesurez votre audience\">\n"
"             </noscript><!--//--></a>\n"
"            </td>\n"
"          </tr>\n"
"      </table>\n"
"\n"
"    </div>\n"
"    <table border=0 cellspacing=0 cellpadding=0 width=\"100%\" bgcolor=\"#99A2D9\">\n"
"        <tr>\n"
"          <td align=\"left\" valign=\"bottom\">\n"
"            <img src=\"../images/bl.png\" height=20 width=20>\n"
"          </td>\n"
"          <td align=\"right\">\n"
"            <a href=\"../copyright.html\" class=\"copy\">Copyright &copy; 1999-2004 Nicolas LAURENT</a>\n"
"          </td>\n"
"          <td align=\"right\" valign=\"bottom\">\n"
"            <img src=\"../images/br.png\" height=20 width=20>\n"
"          </td>\n"
"        </tr>\n"
"    </table>\n"
"  </body>\n"
"</html>\n";


/**
 *
 */
static void htmlify(char *s)
{
	size_t i;

	const char sub[]="!&*+-/<>=^|~";
	
	for(i=0; i<strlen(s); i++)
	{
		size_t j;
		
		for(j=0; j<sizeof(sub); j++)	
			if (s[i] == sub[j])
				s[i] = 'A' + j;
	}
	
	return;
}


/**
 *
 */
static void help_func_prototype(FILE *fp, const func_t *f, const char *a)
{
	unsigned int i;
	
	if (f->args[0])
		fprintf(fp, "<a href=\"type_%s.html\" class=\"type\">%s</a> ",
			f->args[0]->name, f->args[0]->name);

	fprintf(fp, "<a %s class=\"function\">%s</a>(", a, f->name.constant);

	for(i=1; i<=f->n; i++)
	{
		if (i>1)
			fprintf(fp, ", ");
		
		if ((f->args_flags[i-1] & FUNC_ARG_OUT) == 0)
			fprintf(fp, "<span class=\"key\">const </span>");
		
		if ((f->args_flags[i-1] & FUNC_ARG_PROTECT) != 0)
			fprintf(fp, "<span class=\"key\">protect </span>");
			
		fprintf(fp, "<a href=\"type_%s.html\" class=\"type\">%s</a> ",
			f->args[i]->name, f->args[i]->name);
		fprintf(fp, "<span class=\"formal\">arg%d</span>", i);
	}
	fprintf(fp, ");</tt>");
	
	return;
}


/**
 *
 */
static void help_func_prototypes(FILE *fp,  func_t *l)
{
	func_t *f;
	unsigned int j=1;

	fprintf(fp, "      <h4>Prototypes</h4>\n");
	fprintf(fp, "      <div class=\"section\">\n");
	fprintf(fp, "	<ul class=\"proto\">\n");
	
	for(f=l; f; f=f->next, j++)
	{
		char link[128];
		
		if (strcmp(f->name.constant, l->name.constant))
			break;
		fprintf(fp, "	  <li><tt>");
		snprintf(link, 127, "href=\"#%d\"", j);
		help_func_prototype(fp, f, link);
		fprintf(fp, "</li>\n");
	}
	fprintf(fp, "	</ul>\n");
	fprintf(fp, "      </div>\n");
}


/**
 *
 */
static void help_func_detail(FILE *fp, const func_t *f, unsigned int j)
{
	unsigned int i;
	char link[128];

	fprintf(fp, "      <center>\n");
	fprintf(fp, "	     <table class=\"descr\" border=\"1\">\n");
	fprintf(fp, "          <tr>\n");
	fprintf(fp, "            <th colspan=\"2\" class=\"descr\">\n");
	snprintf(link, 127, "name=\"%d\"", j);
	help_func_prototype(fp, f, link);
	fprintf(fp, "            </th>\n");
	fprintf(fp, "	       </tr>\n");

	if (f->args[0])
	{
		fprintf(fp, "          <tr>\n");
		fprintf(fp, "            <td class=\"descr1\"><span class=\"small\">"
			"Valeur retour</span></td>\n");
		fprintf(fp, "            <td class=\"descr\" ><span class=\"small\"><i>(documentation en cours)</i></span></td>\n");
		fprintf(fp, "          </tr>\n");
	}

	for(i=1; i<=f->n; i++)
	{
		fprintf(fp, "          <tr>\n");
		fprintf(fp, "            <td class=\"descr1\"><span class=\"formal\">"
			"arg%d</span></td>\n", i);
		fprintf(fp, "            <td class=\"descr\" ><span class=\"small\"><i>(documentation en cours)</i></span></td>\n");
		fprintf(fp, "          </tr>\n");
	}

	fprintf(fp, "          <tr>\n");
	fprintf(fp, "            <td class=\"descr1\"><span class=\"small\">"
		"Module</span></td>\n");
	if (f->plugin)
		fprintf(fp, "            <td class=\"descr\" >"
			"<span class=\"small\"><b>%s</b></span></td>\n",
			f->plugin->name);
	else
		fprintf(fp, "            <td class=\"descr\" >"
			"<span class=\"small\"><i>nant</i></td>\n");
	fprintf(fp, "          </tr>\n");
	fprintf(fp, "          <tr>\n");
	fprintf(fp, "            <td class=\"descr1\"><span class=\"small\">"
		"Traitement</span></td>\n");
	fprintf(fp, "            <td class=\"descr\" ><tt>%s</tt></td>\n", f->symbol);
	fprintf(fp, "          </tr>\n");
	fprintf(fp, "          <tr>\n");
	fprintf(fp, "            <td class=\"descr1\"><span class=\"small\">"
		"Validation</span></td>\n");
	fprintf(fp, "            <td class=\"descr\" ><span class=\"small\"><i>(validation en cours)</i></span></td>\n");
	fprintf(fp, "          </tr>\n");

	
	fprintf(fp, "        </table>\n");
	fprintf(fp, "      </center>\n");


}


/**
 *
 */
static void help_func_details(FILE *fp, func_t *l)
{
	func_t *f;
	unsigned int j=1;

	fprintf(fp, "      <h4>Dtails</h4>\n");
	fprintf(fp, "      <div class=\"section\">\n");
	
	for(f=l; f; f=f->next, j++)
	{
		if (strcmp(f->name.constant, l->name.constant))
			break;

		help_func_detail(fp, f, j);
	}

	return;
}

/**
 *
 */
static FILE *help_func_open(const char *name, const char *dir)
{
	FILE *fp;
	char *filename;
	char *f;
	
	f=haplo_strdup(name);
	htmlify(f);
	
	HAPLO_ALLOC(filename, strlen(name)+strlen(dir)+
		    strlen("/function_.html")+1);
	
	strcpy(filename, dir);
	strcat(filename, "/function_");
	strcat(filename, f);
	strcat(filename, ".html");

	fp=fopen(filename, "wt");
	if (!fp)
		haplo_error("Cannot open `%s': %s", filename, strerror(errno));
	
	HAPLO_FREE(filename);
	HAPLO_FREE(f);
	
	return(fp);
}


/**
 *
 */
static void help_func(func_t *l, const char *dir)
{
	FILE *out;
	
	out=help_func_open(l->name.constant, dir);
	
	if (out)
	{
		fputs(header, out);
		fputs("      Description de fonction\n", out);
		fputs("    </h1>\n", out);
		fputs("    <div class=\"support\">\n", out);
		fputs("\n", out);
		fprintf(out, "      <h3>%s</h3>\n", l->name.constant);
		fprintf(out, "<h4>Description</h4>\n");
		fprintf(out, "<div class=\"section\"><i>(Documentation en cours)</i></div>\n");
		
		help_func_prototypes(out, l);
		help_func_details(out, l);
		fprintf(out, "      </div>\n");
		fputs(footer, out);
		fclose(out);
	}
	
	return;
	
}

static void help_func_index_f(func_t *l, FILE *out)
{
	char *s=haplo_strdup(l->name.constant);
	
	htmlify(s);
	
	fprintf(out, "<li><a href=\"function_%s.html\" class=\"function\">"
		"%s</a></li>\n", s, l->name.constant);
	
	HAPLO_FREE(s);
	
	return;
}

static void help_func_index(const char *dir)
{
	FILE *out;
	
	out=help_func_open("_index", dir);
	
	if (out)
	{
		fputs(header, out);
		fputs("      Liste des fonctions\n", out);
		fputs("    </h1>\n", out);
		fputs("    <div class=\"content\">\n", out);
		fputs("\n", out);
		
		fputs("<ul>\n", out);
		__haplo_func_loop((func_loop_t)help_func_index_f, (void *)out);
		fputs("</ul>\n", out);

		fputs(footer, out);		
		fclose(out);
	}
	
	return;
}






/**
 *
 */
static FILE *help_type_open(const char *name, const char *dir)
{
	FILE *fp;
	char *filename;
	
	HAPLO_ALLOC(filename, strlen(name)+strlen(dir)+
		    strlen("/type_.html")+1);
	
	strcpy(filename, dir);
	strcat(filename, "/type_");
	strcat(filename, name);
	strcat(filename, ".html");

	fp=fopen(filename, "wt");
	if (!fp)
		haplo_error("Cannot open `%s': %s", filename, strerror(errno));
	
	HAPLO_FREE(filename);
	
	return(fp);
}



/**
 *
 */
static void help_type_detail(FILE *fp, const object_type_t *t)
{
	fprintf(fp, "      <center>\n");
	fprintf(fp, "	     <table class=\"descr\" border=\"1\">\n");
	
	fprintf(fp, "          <tr>\n");
	fprintf(fp, "            <td class=\"descr1\"><span class=\"small\">"
		"Module</span></td>\n");
	if (t->plugin)
		fprintf(fp, "            <td class=\"descr\" >"
			"<span class=\"small\"><b>%s</b></span></td>\n",
			t->plugin->name);
	else
		fprintf(fp, "            <td class=\"descr\" >"
			"<span class=\"small\"><i>nant</i></td>\n");
	fprintf(fp, "          </tr>\n");

	fprintf(fp, "          <tr>\n");
	fprintf(fp, "            <td class=\"descr1\"><span class=\"small\">"
		"Copie</span></td>\n");

	if (t->copy)
		fprintf(fp, "            <td class=\"descr\" ><tt>"
			"%s</tt></td>\n", t->copy_symbol);
	else
		fprintf(fp, "            <td class=\"descr\" >"
			"<span class=\"small\"<i>action par dfaut</i>"
			"</span></td>\n");		

	fprintf(fp, "          </tr>\n");

	fprintf(fp, "          <tr>\n");
	fprintf(fp, "            <td class=\"descr1\"><span class=\"small\">"
		"Destruction</span></td>\n");
	if (t->free)
		fprintf(fp, "            <td class=\"descr\" ><tt>"
			"%s</tt></td>\n", t->free_symbol);
	else
		fprintf(fp, "            <td class=\"descr\" >"
			"<span class=\"small\"<i>action par dfaut</i>"
			"</span></td>\n");		
	fprintf(fp, "          </tr>\n");

	fprintf(fp, "          <tr>\n");
	fprintf(fp, "            <td class=\"descr1\"><span class=\"small\">"
		"Affichage</span></td>\n");
	if (t->display)
		fprintf(fp, "            <td class=\"descr\" ><tt>"
			"%s</tt></td>\n", t->display_symbol);
	else
		fprintf(fp, "            <td class=\"descr\" >"
			"<span class=\"small\"<i>action par dfaut</i>"
			"</span></td>\n");

	fprintf(fp, "          </tr>\n");



	fprintf(fp, "          <tr>\n");
	fprintf(fp, "            <td class=\"descr1\"><span class=\"small\">"
		"Validation</span></td>\n");
	fprintf(fp, "            <td class=\"descr\" ><span class=\"small\"><i>(validation en cours)</i></span></td>\n");
	fprintf(fp, "          </tr>\n");
	
	fprintf(fp, "        </table>\n");
	fprintf(fp, "      </center>\n");


}


struct help
{
	FILE *out;
	const object_type_t *type;
};


static void help_type_construct_f(func_t *f, struct help *h)
{
	if (f->args[0] == h->type)
		help_func_index_f(f, h->out);

	return;
}



/**
 *
 */
static void help_type_construct(FILE *out, const object_type_t *t)
{
	struct help h;
	
	h.out=out;
	h.type=t;
	
	fprintf(out, "<ul>\n");
	__haplo_func_loop((func_loop_t)help_type_construct_f, (void *)&h);
	fprintf(out, "</ul>\n");
	
	return;
}



/**
 *
 */
static void help_type(object_type_t *l, const char *dir)
{
	FILE *out;
	
	out=help_type_open(l->name, dir);
	
	if (out)
	{
		fputs(header, out);
		fputs("      Description de type\n", out);
		fputs("    </h1>\n", out);
		fputs("    <div class=\"support\">\n", out);
		fputs("\n", out);
		fprintf(out, "      <h3>%s</h3>\n", l->name);
		fprintf(out, "<h4>Description</h4>\n");
		fprintf(out, "<div class=\"section\"><i>(Documentation en cours)</i></div>\n");

		fprintf(out, "<h4>Cration</h4>\n");
		help_type_construct(out, l);
		fprintf(out, "<h4>Dtails</h4>\n");	
		fprintf(out, "      <div class=\"section\">\n");
		help_type_detail(out, l);
		fprintf(out, "      </div>\n");
		fputs(footer, out);
		fclose(out);
	}
	
	return;
	
}



static void help_type_index_t(object_type_t *l, FILE *out)
{
	fprintf(out,
		"<li><a href=\"type_%s.html\" class=\"type\">"
		"%s</a></li>\n", l->name, l->name);
	
	return;
}

static void help_type_index(const char *dir)
{
	FILE *out;
	
	out=help_type_open("_index", dir);
	
	if (out)
	{
		fputs(header, out);
		fputs("      Liste des types\n", out);
		fputs("    </h1>\n", out);
		fputs("    <div class=\"content\">\n", out);
		fputs("\n", out);
		
		fputs("<ul>\n", out);
		__haplo_object_type_loop(
			(object_type_loop_t)help_type_index_t, (void *)out);
		fputs("</ul>\n", out);

		fputs(footer, out);		
		fclose(out);
	}
	
	return;
}


void __haplo_help_html(const char *out)
{
	__haplo_func_loop((func_loop_t)help_func, (void *)out);
	help_func_index(out);

	__haplo_object_type_loop((object_type_loop_t)help_type, (void *)out);
	help_type_index(out);
	
	
	return;
}


