/*
 * $Id: plugins.h,v 1.8 2003/12/01 09:50:15 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */

#ifndef __HAPLO_PLUGINS_H__
#define __HAPLO_PLUGINS_H__

#include <haplo/plugins.h>
#include <haplo/module.h>

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif /* HAVE_CONFIG_H */
#include <version.h>

#if HAPLO_PLUGINS_IMPL != HAPLO_PLUGINS_IMPL_NONE

#ifdef HAVE_DL_H
#	include <dl.h>
#endif /* HAVE_DL_H */


/*-----------------------------------------------------------------------------
                         P L U G I N S _ H A N D L E _ T
-----------------------------------------------------------------------------*/

typedef
#if HAPLO_PLUGINS_IMPL == HAPLO_PLUGINS_IMPL_DLD
shl_t	/* see shl_load(3) */
#else
void *	/* opaque handle (see dlopen(3)) */
#endif
plugins_handle_t;


/*-----------------------------------------------------------------------------
                           P L U G I N S _ F U N C _ T
-----------------------------------------------------------------------------*/

typedef void (*plugins_func_t)(void);


/*-----------------------------------------------------------------------------
                              P L U G I N S _ T
-----------------------------------------------------------------------------*/

typedef struct plugins_t
{
	char			*name;		/* nom */
	char			*path;		/* FQ path of library */
	plugins_handle_t	handle;		/* opaque handle */
	const haplo_module_t	*module;
	unsigned int		types;		/* nb of registred type */
	unsigned int		functions;	/* nb of registred func */
} plugins_t;


/*-----------------------------------------------------------------------------
                                 M A C R O S 
-----------------------------------------------------------------------------*/

#define PLUGINS(x)	((plugins_t *)(x))


/*-----------------------------------------------------------------------------
                              P R O T O T Y P E S
-----------------------------------------------------------------------------*/

extern plugins_handle_t * __haplo_plugins_library_load(const char *filename);
extern void * __haplo_plugins_symbol_get(plugins_handle_t handle,
					 const char *symbol);
extern void __haplo_plugins_status(void);
extern int  __haplo_plugins_load(const char *name);
extern void __haplo_plugins_unload_all(void);

#endif /* HAPLO_PLUGINS_IMPL != HAPLO_PLUGINS_IMPL_NONE */
#endif /* __HAPLO_PLUGINS_H__ */
