/*
 * $Id: bc.h,v 1.7 2003/10/05 20:08:54 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */

#ifndef __HAPLO_FEM_BC_H__
#define __HAPLO_FEM_BC_H__

#include <haplo/module.h>
#include <haplo.h>

#include <fem/group.h>

__HAPLO_BEGIN_DECLS

/*-----------------------------------------------------------------------------
                               F E M _ B C _ T
-----------------------------------------------------------------------------*/

typedef void fem_bc_t;



/*-----------------------------------------------------------------------------
                                P R O T O T Y P E S
-----------------------------------------------------------------------------*/

__haplo_type_free
extern void fem_bc_free(fem_bc_t *bc);

__haplo_type_display
extern void fem_bc_display(const fem_bc_t *bc);

__haplo_type_copy
extern fem_bc_t *fem_bc_copy(const fem_bc_t *bc);

__haplo_function(conditions)
extern fem_bc_t *fem_bc_new(void);

__haplo_function(print)
void fem_bc_print(const fem_bc_t *bc);

__haplo_function(block)
extern void fem_bc_block(fem_bc_t *bc, const double *node, const char *dof);

__haplo_function(block)
extern void fem_bc_block_group(fem_bc_t *bc, const fem_group_t *group,
			       const char *dof);

__haplo_function(set)
extern void fem_bc_set(fem_bc_t *bc, const double *node, const char *dof,
		       const double *value);

__haplo_function(set)
extern void fem_bc_set_group(fem_bc_t *bc, const fem_group_t *group,
			     const char *dof, double *value);

__haplo_function(relation)
void fem_bc_relation(fem_bc_t *bc, haplo_list_t *list, const double *value);

__HAPLO_END_DECLS

#endif /* __HAPLO_FEM_BC_H__ */
