/*
 * $Id: element.h,v 1.3 2003/03/29 13:32:11 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */

#ifndef __HAPLO_FEM_ELEMENT_H__
#define __HAPLO_FEM_ELEMENT_H__

#include <haplo/module.h>

#include <fem/integration.h>
#include <fem/model.h>
#include <fem/matrix.h>

__HAPLO_BEGIN_DECLS


/*-----------------------------------------------------------------------------
                         F E M _ E L E M E N T _ T
-----------------------------------------------------------------------------*/

typedef struct fem_element_t
{
	const double		*p;
	const double		**x;
	const double		*material;
	const double		*property;
} fem_element_t;


/*-----------------------------------------------------------------------------
                           F E M _ E V A L _ J _ T
-----------------------------------------------------------------------------*/

typedef double (*fem_eval_j_t)(const double [], const double *[]);


/*-----------------------------------------------------------------------------
                         F E M _ E V A L _ E S M _ T
-----------------------------------------------------------------------------*/

typedef void (*fem_eval_esm_t)(const fem_element_t *, double []);


/*-----------------------------------------------------------------------------
                    F E M _ E L E M E N T _ T Y P E _ T
-----------------------------------------------------------------------------*/

typedef struct fem_element_type_t
{
	const char		*name;
	const char		*dofset;
	unsigned short		nb_node;
	unsigned short		dim;
	fem_model_type_t	type;
	fem_integration_t	integration;
	fem_eval_j_t		j;
	fem_eval_esm_t		esm;
	const char		*material;
	const char		*property;
} fem_element_type_t;


/*-----------------------------------------------------------------------------
                           P R O T O T Y P E S
-----------------------------------------------------------------------------*/

void fem_element_type_register(const fem_element_type_t *et);

__HAPLO_END_DECLS

#endif /* __HAPLO_FEM_ELEMENT_H__ */
